//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "emulator.h"
#include "storage.h"

#include "cpudefs.h"
#include "hledefs.h"

#include <sys/file.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/******************************************************************************/
static RbPSe_Emulator *Emulator;
static RbPSe_Plugin Plugin;
static RbPSe_Storage Storage;
/******************************************************************************/
static cpuWriteDataType cpuWriteData;
static cpuHookAddrType cpuHookAddr;
/******************************************************************************/
/******************************************************************************/
static void MapFunctionsLoad( char *name, long size )
{
	char map_line[84];
	char func_name[32];
	char psx_func_name[36];
	FILE *map_file;
	long psx_func_start;
	printf("Map Functions Load ( %s , %li )\n", name, size );
	map_file = (FILE*)Emulator->Interface->MapOpen( name , size );
	if( !map_file ) return;
	printf("Loaded...\n");

	while( fgets( map_line, 128, map_file ) )
	{
		if( !strncmp( map_line, "//", 2 ) ) continue;
		sscanf( map_line, "%lx %s", &psx_func_start, func_name );
		sprintf( psx_func_name, "psx%s", func_name );
		if(STORAGE_GET(psx_func_name))
		{
			printf("%s - not found\n", psx_func_name );
			continue;
		}
		printf( "%s%lx\n%s\n", map_line, psx_func_start, func_name );
		cpuHookAddr( STORAGE_FUNC, psx_func_start );
	}
}
/******************************************************************************/
static long hleopen(char *devname, int flag)//bfc0d890
{
	printf("open(%s,%x)\n",devname,flag);
	switch( flag )
	{
	case O_RDONLY:
		return (long)fopen( devname , "rb" ) ? : -1;
	}
	return -1;
}
/******************************************************************************/
static long hleclose(long fd)//bfc0d8a0
{
	printf("close(%lx)\n",fd);
	return fclose( (FILE*)fd );
}
/******************************************************************************/
static long hleread(long fd, void *buf, long n)//bfc0d8b0
{
	printf("read(%lx,%lx,%lx)\n", fd , (long)buf , n );
	return fread( buf , 1 , n , (FILE*)fd );
}
/******************************************************************************/
static long ___LoadHeader( long hfile , struct EXEC *exec)//bfc03c90
{
	char buf[0x800];
	if( hleread( hfile , buf , 0x00000800 ) < 0x00000800 ) return 0;
	memcpy( exec , buf + 0x10 , 0x0000003c );//at bfc02b50
	return 1;
}
/******************************************************************************/
static long hleLoad(char *name, struct EXEC *exec)//A0:42//Load//bfc03a18
{
	char *buf;//?
	long hfile = hleopen( name, O_RDONLY );
	if( hfile < 0 ) return 0;
	if( !___LoadHeader( hfile , exec ) )//at bfc03c90
	{
		hleclose( hfile );//at bfc0d8a0
		return 0;
	}
	buf = malloc( exec -> t_size );//?
	hleread( hfile , buf , exec -> t_size );//at bfc0d8b0
	cpuWriteData( exec -> t_addr , buf , exec -> t_size );//?
	free( buf );//?
	hleclose( hfile );//at bfc0d8a0;
//	FlushCashe();//at bfc01920
//hle
	MapFunctionsLoad( name, exec -> t_size );
//
	return 1;
}
/******************************************************************************/

static long PluginLoad()
{
	return 0;
}

static long PluginSave()
{
	return 0;
}

static long PluginQuit()
{
	return 0;
}

static long PluginClose()
{
	return 0;
}

static long PluginStop()
{
	return 0;
}

static long PluginStart()
{
	return 0;
}

static long PluginOpen()
{
	if(STORAGE_GET_FUNC(cpuWriteData,cpuWriteDataType,"cpuWriteData")) return -1;
	if(STORAGE_GET_FUNC(cpuHookAddr,cpuHookAddrType,"cpuHookAddr")) return -1;
	return 0;
}

static long PluginInit()
{
	STORAGE_SET("hleLoad", hleLoad, 0);
    return 0;
}

RbPSe_Plugin *RbPSePluginLoad(RbPSe_Emulator* emulator)
{
	Emulator = emulator;
	Plugin.Init = PluginInit;
	Plugin.Open = PluginOpen;
	Plugin.Start = PluginStart;
	Plugin.Stop = PluginStop;
	Plugin.Close = PluginClose;
	Plugin.Quit = PluginQuit;
	Plugin.Save = PluginSave;
	Plugin.Load = PluginLoad;
	return &Plugin;
}
