#ifndef _MEMORY_H_
#define _MEMORY_H_

long memoryOpen(void);

void	cpuWriteDataByte(char data, long addr)	__attribute__((regparm(2)));
void	cpuWriteDataHalf(short data, long addr)	__attribute__((regparm(2)));
void	cpuWriteDataWord(long data, long addr)	__attribute__((regparm(2)));

char			cpuReadDataByte(long addr)	__attribute__((regparm(1)));
unsigned char	cpuReadDataByteU(long addr)	__attribute__((regparm(1)));
short			cpuReadDataHalf(long addr)	__attribute__((regparm(1)));
unsigned short	cpuReadDataHalfU(long addr)	__attribute__((regparm(1)));
long			cpuReadDataWord(long addr)	__attribute__((regparm(1)));

void	cpuWriteDataWordLeft( long addr, unsigned long *reg )	__attribute__((regparm(2)));
void	cpuWriteDataWordRight( long addr, unsigned long *reg )	__attribute__((regparm(2)));
void	cpuReadDataWordLeft( long addr, unsigned long *reg )	__attribute__((regparm(2)));
void	cpuReadDataWordRight( long addr, unsigned long *reg )	__attribute__((regparm(2)));


void	cpuWriteData(long dst, void *src, long count)	__attribute__((regparm(3)));

void	cpuClearData(long dst, long count)		__attribute__((regparm(2)));

#endif//_MEMORY_H_
