//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//

#include "emulator.h"
#include "storage.h"

#include "cpudefs.h"
/*
#include "funcs.h"

#include "hle/libapi.h"
*/
#include "stdio.h"
/******************************************************************************/
static RbPSe_Emulator *Emulator;
static RbPSe_Plugin Plugin;
static RbPSe_Storage Storage;
/******************************************************************************/
static	cpuHookOpCodeType	cpuHookOpCode;
/******************************************************************************/
/******************************************************************************/
static long cop2data[32];
static long cop2ctrl[32];
enum
{
	R11R12 = 0,
	R13R21,
	R22R23,
	R31R32,
	R33,
	TRX,
	TRY,
	TRZ,
	L11L12,
	L13L21,
	L22L23,
	L31L32,
	L33,
	RBK,
	GBK,
	BBK,
	LR1LR2,
	LR3LG1,
	LG2LG3,
	LB1LB2,
	LB3,
	RFC,
	GFC,
	BFC,
	OFX,
	OFY,
	H,
	DQA,
	DQB,
	ZSF3,
	ZSF4,
	FLAG
};
/******************************************************************************/
static void _Opcode_32( unsigned long opcode )  __attribute__((regparm(1)));
static void _Opcode_32( unsigned long opcode )
{
	printf("Opcode 32 unsupported");
	__asm__("op32: jmp op32");
//	register unsigned long ultmp __asm__("edx") = opcode;
//	goto *_Cop2s[ ultmp & 0x3f ];
}
/******************************************************************************/
static unsigned long _MFC2( unsigned long reg )             __attribute__((regparm(1)));
static unsigned long _MFC2( unsigned long reg )
{
	printf("[ cop2 ] Read Data From %lx\n", reg );
	return cop2data[ reg ];
}
static unsigned long (*_MFC2_addr)(unsigned long) = _MFC2;
/******************************************************************************/
static unsigned long _CFC2( unsigned long reg )             __attribute__((regparm(1)));
static unsigned long _CFC2( unsigned long reg )
{
	printf("[ cop2 ] Read Ctrl From %lx\n", reg );
	return cop2ctrl[ reg ];
}
static unsigned long (*_CFC2_addr)(unsigned long) = _CFC2;
/******************************************************************************/
static void _MTC2( unsigned long value, unsigned long reg ) __attribute__((regparm(2)));
static void _MTC2( unsigned long value, unsigned long reg )
{
	printf("[ cop2 ] Write Data %lx To %lx\n", value, reg );
	cop2data[ reg ] = value;
}
static void (*_MTC2_addr)(unsigned long, unsigned long) = _MTC2;
/******************************************************************************/
static void _CTC2( unsigned long value, unsigned long reg ) __attribute__((regparm(2)));
static void _CTC2( unsigned long value, unsigned long reg )
{
	printf("[ cop2 ] Write Ctrl %lx To %lx\n", value, reg );
	cop2ctrl[ reg ] = value;
}
static void (*_CTC2_addr)(unsigned long, unsigned long) = _CTC2;
/******************************************************************************/
static struct//nop
{
	char const0[8];
	char const1[8];
}
COpcodeNOP = {
	{ 0xeb, 0x0e, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
	{ 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 }
};
static struct//mov eax, rd //call [www]//mov [esi+rt], eax
{
	char const0[1];
	long rd                                     __attribute__((packed));
	char const1[2];
	unsigned long (**mfc2)(unsigned long)       __attribute__((packed));
	char const2[2];
	char rt;
	char const3[2];
}
COpcodeMFC2 = {
	{ 0xb8 }, 0, { 0xff, 0x15 }, &_MFC2_addr, { 0x89, 0x46 }, 0, { 0x90, 0x90 }
};
static struct//mov eax, rd //call [www]//mov [esi+rt], eax
{
	char const0[1];
	long rd                                     __attribute__((packed));
	char const1[2];
	unsigned long (**cfc2)(unsigned long)       __attribute__((packed));
	char const2[2];
	char rt;
	char const3[2];
}
COpcodeCFC2 = {
	{ 0xb8 }, 0, { 0xff, 0x15 }, &_CFC2_addr, { 0x89, 0x46 }, 0, { 0x90, 0x90 }
};
static struct//mov eax, [ esi + 11 ]//mov edx, 22//call [www]
{
	char const0[2];
	char rt;
	char const1[1];
	long rd                                     __attribute__((packed));
	char const2[2];
	void (**mtc2)(unsigned long, unsigned long) __attribute__((packed));
	char const3[2];
}
COpcodeMTC2 = {
	{ 0x8b, 0x46 }, 0, { 0xba }, 0, { 0xff, 0x15 }, &_MTC2_addr, { 0x90, 0x90 }
};
static struct//mov eax, [ esi + 11 ]//mov edx, 22//call [www]
{
	char const0[2];
	char rt;
	char const1[1];
	long rd                                     __attribute__((packed));
	char const2[2];
	void (**ctc2)(unsigned long, unsigned long) __attribute__((packed));
	char const3[2];
}
COpcodeCTC2 = {
	{ 0x8b, 0x46 }, 0, { 0xba }, 0, { 0xff, 0x15 }, &_CTC2_addr, { 0x90, 0x90 }
};
/******************************************************************************/
static void _Cop2mov_us( unsigned long opcode ) __attribute__((regparm(1)));
static void _Cop2mov_us( unsigned long opcode )
{
	printf("Cop2mov opcode %lx unsupported", opcode );
	__asm__("c2mus: jmp c2mus");
}
static void _Cop2mov_00( unsigned long opcode ) __attribute__((regparm(1)));
static void _Cop2mov_00( unsigned long opcode )
{
	char rt = (( opcode >> 0x10 ) & 0x1f ) << 2;
	if( rt )
	{
		COpcodeMFC2.rt = rt;
		COpcodeMFC2.rd = ( opcode >> 0x0b ) & 0x1f;
		__asm__("movl   %0, %%esi"::"p"(&COpcodeMFC2));
	}
	else
	{
		__asm__("movl   %0, %%esi"::"p"(&COpcodeNOP));
	}
	__asm__("movl   $0x04, %ecx");
	__asm__("xorl   %eax, %eax");
}
static void _Cop2mov_02( unsigned long opcode ) __attribute__((regparm(1)));
static void _Cop2mov_02( unsigned long opcode )
{
	char rt = (( opcode >> 0x10 ) & 0x1f ) << 2;
	if( rt )
	{
		COpcodeCFC2.rt = rt;
		COpcodeCFC2.rd = ( opcode >> 0x0b ) & 0x1f;
		__asm__("movl   %0, %%esi"::"p"(&COpcodeCFC2));
	}
	else
	{
		__asm__("movl   %0, %%esi"::"p"(&COpcodeNOP));
	}
	__asm__("movl   $0x04, %ecx");
	__asm__("xorl   %eax, %eax");
}
static void _Cop2mov_04( unsigned long opcode ) __attribute__((regparm(1)));
static void _Cop2mov_04( unsigned long opcode )
{
	COpcodeMTC2.rt = (( opcode >> 0x10 ) & 0x1f ) << 2;
	COpcodeMTC2.rd = ( opcode >> 0x0b ) & 0x1f;
	__asm__("movl   %0, %%esi"::"p"(&COpcodeMTC2));
	__asm__("movl   $0x04, %ecx");
	__asm__("xorl   %eax, %eax");
}
static void _Cop2mov_06( unsigned long opcode ) __attribute__((regparm(1)));
static void _Cop2mov_06( unsigned long opcode )
{
	COpcodeCTC2.rt = (( opcode >> 0x10 ) & 0x1f ) << 2;
	COpcodeCTC2.rd = ( opcode >> 0x0b ) & 0x1f;
	__asm__("movl   %0, %%esi"::"p"(&COpcodeCTC2));
	__asm__("movl   $0x04, %ecx");
	__asm__("xorl   %eax, %eax");
}
/******************************************************************************/
static void *_Cop2movs[32] = {
	_Cop2mov_00, _Cop2mov_us, _Cop2mov_02, _Cop2mov_us,
	_Cop2mov_04, _Cop2mov_us, _Cop2mov_06, _Cop2mov_us,
	_Cop2mov_us, _Cop2mov_us, _Cop2mov_us, _Cop2mov_us,
	_Cop2mov_us, _Cop2mov_us, _Cop2mov_us, _Cop2mov_us,
	_Cop2mov_us, _Cop2mov_us, _Cop2mov_us, _Cop2mov_us,
	_Cop2mov_us, _Cop2mov_us, _Cop2mov_us, _Cop2mov_us,
	_Cop2mov_us, _Cop2mov_us, _Cop2mov_us, _Cop2mov_us,
	_Cop2mov_us, _Cop2mov_us, _Cop2mov_us, _Cop2mov_us,
};
/******************************************************************************/
static void _Cop2mov( unsigned long opcode ) __attribute__((regparm(1)));
static void _Cop2mov( unsigned long opcode )
{
	register unsigned long ultmp __asm__("edx") = opcode;
	goto *_Cop2movs[ ( ultmp >> 0x15 ) & 0x1f ];
}
/******************************************************************************/
static void *_Cop2s[64] = { _Cop2mov };
/******************************************************************************/
static void _Opcode_12( unsigned long opcode )  __attribute__((regparm(1)));
static void _Opcode_12( unsigned long opcode )
{
	register unsigned long ultmp __asm__("edx") = opcode;
	goto *_Cop2s[ ultmp & 0x3f ];
}
/******************************************************************************/
void hleInitGeom(void)//full
{
	printf("[ hle ] InitGeom()\n");//?
	fflush(0);//?
//  cop0[ SR ] |= 0x40000000;
	cop2ctrl[ ZSF3 ] = 0x00000155;
	cop2ctrl[ ZSF4 ] = 0x00000100;
	cop2ctrl[ H ] = 0x000003e8;
	cop2ctrl[ DQA ] = 0xffffef9e;
	cop2ctrl[ DQB ] = 0x01400000;
	cop2ctrl[ OFX ] = 0x00000000;
	cop2ctrl[ OFY ] = 0x00000000;
}
/******************************************************************************/
void psxInitGeom(void)
{
	hleInitGeom();
}
/******************************************************************************/

static long PluginLoad()
{
	return 0;
}

static long PluginSave()
{
	return 0;
}

static long PluginQuit()
{
	return 0;
}

static long PluginClose()
{
	return 0;
}

static long PluginStop()
{
	return 0;
}

static long PluginStart()
{
	return 0;
}

static long PluginOpen()
{
	if(STORAGE_GET_FUNC(cpuHookOpCode,cpuHookOpCodeType,"cpuHookOpCode")) return -1;
	cpuHookOpCode( _Opcode_12, 0x4bffffff );
	cpuHookOpCode( _Opcode_32, 0xcbffffff );
	return 0;
}

static long PluginInit()
{
//	STORAGE_SET("psxInitGeom",	psxInitGeom,	0);
	return 0;
}

RbPSe_Plugin *RbPSePluginLoad(RbPSe_Emulator* emulator)
{
	Emulator = emulator;
	Plugin.Init = PluginInit;
	Plugin.Open = PluginOpen;
	Plugin.Start = PluginStart;
	Plugin.Stop = PluginStop;
	Plugin.Close = PluginClose;
	Plugin.Quit = PluginQuit;
	Plugin.Save = PluginSave;
	Plugin.Load = PluginLoad;
	return &Plugin;
}
