//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "emulator.h"
#include "storage.h"
#include "funcs.h"

#include "hle/libapi.h"

#include "stdio.h"
/******************************************************************************/
static RbPSe_Emulator *Emulator;
static RbPSe_Plugin Plugin;
static RbPSe_Storage Storage;
/******************************************************************************/
static CPUExecType CPUExec;
/******************************************************************************/
static hleLoadType hleLoad;
/******************************************************************************/
//register unsigned long *psxregs __asm__("esi");
/******************************************************************************/
static struct EXEC bootexec;
static void boot(void)
{
	__asm__("pushl %esi");
	__asm__("pushl %edi");
//	__asm__("movl	%0, %%esi"::"m"(Emulator -> Storage));
//	__asm__("movl   %0, %%eax"::"m"(bootexec . s_addr):"eax");
//	__asm__("movl	%0, %%edi"::"m"(Emulator -> Memory));
//	__asm__("movl	%eax, 0x74(%esi)");
//
	__asm__("movl	%0, %%esi			\n\t"
			"movl	%1, %%edi			\n\t"
			"movl	%%edx, 0x74(%%esi)		"
			:
			:"m"(Emulator -> Storage ), "m"( Emulator -> Memory ), "d"(bootexec.s_addr)
	);
//
    CPUExec( bootexec . pc0 );
	__asm__("popl %edi");
	__asm__("popl %esi");
}
/******************************************************************************/

static long PluginLoad()
{
	return 0;
}

static long PluginSave()
{
	return 0;
}

static long PluginQuit()
{
	return 0;
}

static long PluginClose()
{
	return 0;
}

static long PluginStop()
{
	return 0;
}

static long PluginStart()
{
	return 0;
}

static long PluginOpen()
{
	if(STORAGE_GET_FUNC(CPUExec,CPUExecType,"___CPUExec")) return -1;
	if(STORAGE_GET_FUNC(hleLoad,hleLoadType,"hleLoad")) return -1;
	switch( Emulator -> SourceType )
	{
	case SOURCE_TYPE_NONE:
		printf("No Source\n");
		return -1;
	case SOURCE_TYPE_CD:
		printf("Currently Disabled Source \"CD\"\n");
		return -1;
	case SOURCE_TYPE_ISO:
		printf("Currently Disabled Source \"ISO\"\n");
		return -1;
	case SOURCE_TYPE_FILE:
		printf("Loading file...");
		if( !hleLoad( Emulator -> SourceName , &bootexec ) )
		{
			printf("failed\n");
			return -1;
		}
		break;
	default:
		printf("Unknown Source\n");
		return -1;
	}
	printf(" SP = [ %lx ][ %lx ][ %lx ]\n", bootexec.s_addr, bootexec.s_size, bootexec.sp );
	return 0;
}

static long PluginInit()
{
	STORAGE_SET("___boot", boot, 0);
    return 0;
}

RbPSe_Plugin *RbPSePluginLoad(RbPSe_Emulator* emulator)
{
	Emulator = emulator;
	Plugin.Init = PluginInit;
	Plugin.Open = PluginOpen;
	Plugin.Start = PluginStart;
	Plugin.Stop = PluginStop;
	Plugin.Close = PluginClose;
	Plugin.Quit = PluginQuit;
	Plugin.Save = PluginSave;
	Plugin.Load = PluginLoad;
	return &Plugin;
}
