//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "cop0.h"

#include "dyn.h"

#include <stdio.h>

static long cop0regs[32];
/******************************************************************************/
static unsigned long _MFC0( unsigned long reg )				__attribute__((regparm(1)));
static unsigned long _MFC0( unsigned long reg )
{
	printf("[ cop0 ] Read Data From %lx\n", reg );
	return cop0regs[ reg ];
}
static unsigned long (*_MFC0_addr)(unsigned long) = _MFC0;
/******************************************************************************/
static void _MTC0( unsigned long value, unsigned long reg )	__attribute__((regparm(2)));
static void _MTC0( unsigned long value, unsigned long reg )
{
	printf("[ cop0 ] Write Data %lx To %lx\n", value, reg );
	cop0regs[ reg ] = value;
}
static void (*_MTC0_addr)(unsigned long, unsigned long) = _MTC0;
/******************************************************************************/
static struct//nop
{
	char const0[8];
	char const1[8];
}
COpcodeNOP = {
	{ 0xeb, 0x0e, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 },
	{ 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90 }
};
static struct//mov eax, rd //call [www]//mov [esi+rt], eax
{
	char const0[1];
	long rd										__attribute__((packed));
	char const1[2];
	unsigned long (**mfc0)(unsigned long)		__attribute__((packed));
	char const2[2];
	char rt;
	char const3[2];
}
COpcodeMFC0 = {
	{ 0xb8 }, 0, { 0xff, 0x15 }, &_MFC0_addr, { 0x89, 0x46 }, 0, { 0x90, 0x90 }
};
static struct//mov eax, [ esi + 11 ]//mov edx, 22//call [www]
{
	char const0[2];
	char rt;
	char const1[1];
	long rd										__attribute__((packed));
	char const2[2];
	void (**mtc0)(unsigned long, unsigned long)	__attribute__((packed));
	char const3[2];
}
COpcodeMTC0 = {
	{ 0x8b, 0x46 }, 0, { 0xba }, 0, { 0xff, 0x15 }, &_MTC0_addr, { 0x90, 0x90 }
};
/******************************************************************************/
static void _Cop0mov_us( unsigned long opcode ) __attribute__((regparm(1)));
static void _Cop0mov_us( unsigned long opcode )
{
	printf("Cop0mov opcode %lx unsupported", opcode );
	__asm__("c0mus: jmp c0mus");
}
static void _Cop0mov_00( unsigned long opcode ) __attribute__((regparm(1)));
static void _Cop0mov_00( unsigned long opcode )
{
	char rt = (( opcode >> 0x10 ) & 0x1f ) << 2;
	if( rt )
	{
		COpcodeMFC0.rt = rt;
		COpcodeMFC0.rd = ( opcode >> 0x0b ) & 0x1f;
		__asm__("movl	%0, %%esi"::"p"(&COpcodeMFC0));
	}
	else
	{
		__asm__("movl	%0, %%esi"::"p"(&COpcodeNOP));
	}
	__asm__("movl   $0x04, %ecx");
	__asm__("xorl   %eax, %eax");
}
static void _Cop0mov_04( unsigned long opcode )	__attribute__((regparm(1)));
static void _Cop0mov_04( unsigned long opcode )
{
 	COpcodeMTC0.rt = (( opcode >> 0x10 ) & 0x1f ) << 2;
	COpcodeMTC0.rd = ( opcode >> 0x0b ) & 0x1f;
	__asm__("movl   %0, %%esi"::"p"(&COpcodeMTC0));
	__asm__("movl   $0x04, %ecx");
	__asm__("xorl   %eax, %eax");
}
/******************************************************************************/
static void *_Cop0movs[32] = {
	_Cop0mov_00, _Cop0mov_us, _Cop0mov_us, _Cop0mov_us,
	_Cop0mov_04, _Cop0mov_us, _Cop0mov_us, _Cop0mov_us,
	_Cop0mov_us, _Cop0mov_us, _Cop0mov_us, _Cop0mov_us,
	_Cop0mov_us, _Cop0mov_us, _Cop0mov_us, _Cop0mov_us,
	_Cop0mov_us, _Cop0mov_us, _Cop0mov_us, _Cop0mov_us,
	_Cop0mov_us, _Cop0mov_us, _Cop0mov_us, _Cop0mov_us,
	_Cop0mov_us, _Cop0mov_us, _Cop0mov_us, _Cop0mov_us,
	_Cop0mov_us, _Cop0mov_us, _Cop0mov_us, _Cop0mov_us,
};
/******************************************************************************/
static void _Cop0mov( unsigned long opcode ) __attribute__((regparm(1)));
static void _Cop0mov( unsigned long opcode )
{
	register unsigned long ultmp __asm__("edx") = opcode;
	goto *_Cop0movs[ ( ultmp >> 0x15 ) & 0x1f ];
}
/******************************************************************************/
static void *_Cop0s[64] = { _Cop0mov };
/******************************************************************************/
static void _Opcode_10( unsigned long opcode )	__attribute__((regparm(1)));
static void	_Opcode_10( unsigned long opcode )
{
	register unsigned long ultmp __asm__("edx") = opcode;
	goto *_Cop0s[ ultmp & 0x3f ];
}
/******************************************************************************/

long	cop0Open()
{
	cpuHookOpCode( _Opcode_10, 0x43ffffff );
	return 0;
}
