//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "hardware.h"

#include "emulator.h"
#include "plugin.h"
#include "storage.h"
#include <stdio.h>

/******************************************************************************/
static void *__HWWByteTable[0x4000];
static void *__HWWHalfTable[0x4000];
static void *__HWWWordTable[0x4000];
static void *__HWRByteTable[0x4000];
static void *__HWRHalfTable[0x4000];
static void *__HWRWordTable[0x4000];
static char  hardwarememory[0x4000];
/******************************************************************************/

static long  __DefScratchRWord(long addr) __attribute__((regparm(1)));
static long  __DefScratchRWord(long addr)
{
	return *((long*)(hardwarememory + addr));
}

static short __DefScratchRHalf(long addr) __attribute__((regparm(1)));
static short __DefScratchRHalf(long addr)
{
	return *((short*)(hardwarememory + addr));
}

static char  __DefScratchRByte(long addr) __attribute__((regparm(1)));
static char  __DefScratchRByte(long addr)
{
	return *((char*)(hardwarememory + addr));
}

static void  __DefScratchWWord(long data, long addr) __attribute__((regparm(2)));
static void  __DefScratchWWord(long data, long addr)
{
	*((long*)(hardwarememory + addr)) = data;
}

static void  __DefScratchWHalf(short data, long addr) __attribute__((regparm(2)));
static void  __DefScratchWHalf(short data, long addr)
{
	*((short*)(hardwarememory + addr)) = data;
}

static void  __DefScratchWByte(char data, long addr) __attribute__((regparm(2)));
static void  __DefScratchWByte(char data, long addr)
{
	*((char*)(hardwarememory + addr)) = data;
}

/******************************************************************************/

static long  __DefaultHWRWord(long addr) __attribute__((regparm(1)));
static long  __DefaultHWRWord(long addr)
{
	long tmp = *((long*)(hardwarememory + addr));
	printf("[ HW ] Read word [ %lx ] at ( %lx )\n", tmp, addr);//?
	fflush(0);
	return tmp;
}

static short __DefaultHWRHalf(long addr) __attribute__((regparm(1)));
static short __DefaultHWRHalf(long addr)
{
	short tmp = *((short*)(hardwarememory + addr));
	printf("[ HW ] Read half [ %x ] at ( %lx )\n", tmp, addr);//?
	fflush(0);
	return tmp;
}

static char  __DefaultHWRByte(long addr) __attribute__((regparm(1)));
static char  __DefaultHWRByte(long addr)
{
	return *((char*)(hardwarememory + addr));
}

static void  __DefaultHWWWord( long data, long addr) __attribute__((regparm(2)));
static void  __DefaultHWWWord(long data, long addr)
{
	printf("[ HW ] Write word [ %lx ] to ( %lx )\n", data, addr);//?
	fflush(0);
	*((long*)(hardwarememory + addr)) = data;
}

static void  __DefaultHWWHalf(short data, long addr) __attribute__((regparm(2)));
static void  __DefaultHWWHalf(short data, long addr)
{
	printf("[ HW ] Write half [ %x ] to ( %lx )\n", data, addr);//?
	fflush(0);
	*((short*)(hardwarememory + addr)) = data;
}

static void  __DefaultHWWByte( char data, long addr) __attribute__((regparm(2)));
static void  __DefaultHWWByte(char data, long addr)
{
	*((char*)(hardwarememory + addr)) = data;
}

/******************************************************************************/

long cpuReadPortWord(long addr)
{
	goto *__HWRWordTable[addr & 0x00003fff];
}

short cpuReadPortHalf(long addr)
{
	goto *__HWRHalfTable[addr & 0x00003fff];
}

char cpuReadPortByte(long addr)
{
	goto *__HWRByteTable[addr & 0x00003fff];
}

/******************************************************************************/

void cpuWritePortWord(long data, long addr)
{
	goto *__HWWWordTable[addr & 0x00003fff];
}

void cpuWritePortHalf(short data, long addr)
{
	goto *__HWWHalfTable[addr & 0x00003fff];
}

void cpuWritePortByte(char data, long addr)
{
	goto *__HWWByteTable[addr & 0x00003fff];
}

/******************************************************************************/

void cpuHookPortWord(void *write, void *read, long addr)
{
	if( ! write ) write = __DefaultHWWWord;
	__HWWWordTable[ addr ] = write;
//
	if( ! read ) read = __DefaultHWRWord;
	__HWRWordTable[ addr ] = read;
}

void cpuHookPortHalf(void *write, void *read, long addr)
{
	if( ! write ) write = __DefaultHWWHalf;
	__HWWHalfTable[ addr ] = write;
//
	if( ! read ) read = __DefaultHWRHalf;
	__HWRHalfTable[ addr ] = read;
}

void cpuHookPortByte(void *write, void *read, long addr)
{
	if( ! write ) write = __DefaultHWWByte;
	__HWWByteTable[ addr ] = write;
//
	if( ! read ) read = __DefaultHWRByte;
	__HWRByteTable[ addr ] = read;
}

/******************************************************************************/
long hardwareOpen()
{
	long i = 0;
	while(i < 0x1000)
	{
		__HWWByteTable[i] = __DefScratchWByte;
		__HWWHalfTable[i] = __DefScratchWHalf;
		__HWWWordTable[i] = __DefScratchWWord;
		__HWRByteTable[i] = __DefScratchRByte;
		__HWRHalfTable[i] = __DefScratchRHalf;
		__HWRWordTable[i] = __DefScratchRWord;
		i++;
	}
	while(i < 0x4000)
	{
		__HWWByteTable[i] = __DefaultHWWByte;
		__HWWHalfTable[i] = __DefaultHWWHalf;
		__HWWWordTable[i] = __DefaultHWWWord;
		__HWRByteTable[i] = __DefaultHWRByte;
		__HWRHalfTable[i] = __DefaultHWRHalf;
		__HWRWordTable[i] = __DefaultHWRWord;
		i++;
	}
	return 0;
}
