#ifndef _IRQ_H_
#define _IRQ_H_

#include "hledefs.h"

long		irqOpen();

long		hleEnterCriticalSection(void);
void		hleExitCriticalSection(void);

void		hleReturnFromException(void);
void		hleResetEntryInt(void);
void		hleHookEntryInt( hlejmp_buf env );


unsigned long	cpuCheckIrqWord(unsigned long)		__attribute__((regparm(1)));
unsigned short	cpuCheckIrqHalf(unsigned short)		__attribute__((regparm(1)));

void		cpuIrqMaskEnable(unsigned long)			__attribute__((regparm(1)));
void		cpuIrqRequest(long)						__attribute__((regparm(1)));

void		cpuWriteIrqRegisterWord(unsigned long)	__attribute__((regparm(1)));
void		cpuWriteIrqMaskWord(unsigned long)		__attribute__((regparm(1)));
void		cpuWriteIrqRegisterHalf(unsigned short)	__attribute__((regparm(1)));
void		cpuWriteIrqMaskHalf(unsigned short)		__attribute__((regparm(1)));
unsigned long	cpuReadIrqRegisterWord(void);
unsigned long	cpuReadIrqMaskWord(void);
unsigned short	cpuReadIrqRegisterHalf(void);
unsigned short	cpuReadIrqMaskHalf(void);

#endif//_INQ_H_
