#include "libetc_hle.h"
#include "libetc_hle_main.h"
#include "irq.h"

#include <stdio.h>
/*
void		hlePadInit(void);//void PadInit(int mode);
void		hlePadRead(void);//u_long PadRead(u_short id);
void		hlePadStop(void);//void PadStop(void);
void		hleVSync(void);//int VSync(int mode);
void        hleResetCallback(void);//void ResetCallback(void);
void		hleInterruptCallback(void);//tmp//only//hle//version//
void		hleDMACallback(void);//tmp//only//hle//version//
void		hleVSyncCallback(void);//void VSyncCallback(void (*func)());
void		hleVSyncCallbacks(void);//tmp//only//hle//version//
void		hleStopCallback(void);//void StopCallback(void);
void		hleRestartCallback(void);//int RestartCallback(void);
void		hleCheckCallback(void);//int CheckCallback(void);
void		hleGetIntrMask(void);//tmp//only//hle//version//
void		hleSetIntrMask(void);//tmp//only//hle//version//
void		hleSetVideoMode(void);//long SetVideoMode(long mode);
void		hleGetVideoMode(void);//long GetVideoMode(void);
*/
/******************************************************************************/
/******************************************************************************/
static void *setIntrVSync(int index, void (*callback)())
{
	void (*old)() = cbIntrVSync[index];
	if( callback != old ) cbIntrVSync[index] = callback;
	return old;
}
/******************************************************************************/
void *startIntrVSync()
{
//	*t1_mode = 0x0100;
	Vcount = 0;
	memclr( (void*)cbIntrVSync, 8 );
	hleInterruptCallback( 0, trapIntrVSync );
	return setIntrVSync;
}
/******************************************************************************/
static void *setIntrDMA(int index, void (*callback)())
{
	void (*old)() = cbIntrDMA[index];
	if( callback != old )
	{
		if( callback )
		{
			cbIntrDMA[index] = callback;
//			*dicr = ((*dicr & 0xffffff) | 0x800000) |  (1 << (index + 16));
		}
		else
		{
			cbIntrDMA[index] = 0;
//			*dicr = ((*dicr & 0xffffff) | 0x800000) & ~(1 << (index + 16));
		}
	}
	return old;
}
/******************************************************************************/
void *startIntrDMA()
{
	memclr( (void*)cbIntrDMA, 8 );
//	*dicr = 0;
	hleInterruptCallback( 3, trapIntrDMA );
	return setIntrDMA;
}
/******************************************************************************/
void *setIntr(int index, void (*callback)())
{
	void (*old)() = intrData.cbIntr[index];
	int mask;
	if( callback == old || !intrData.started ) return old;

	mask = cpuReadIrqMaskHalf();
	cpuWriteIrqMaskHalf( 0 );

	if( callback )
	{
		intrData.cbIntr[index] = callback;
		mask |= 1 << index;
		intrData.mask |= 1 << index;
	}
	else
	{
		intrData.cbIntr[index] = 0;
		mask &= ~(1 << index);
		intrData.mask &= ~(1 << index);
	}
//	if(index == 0)
//	{
//		ChangeClearPAD(callback == 0);
//		ChangeClearRCnt(3, callback == 0);
//	}
//	if(index == 4) ChangeClearRCnt(0, callback == 0);
//	if(index == 5) ChangeClearRCnt(1, callback == 0);
//	if(index == 6) ChangeClearRCnt(2, callback == 0);

	cpuWriteIrqMaskHalf( mask );
	return old;
}
/******************************************************************************/
void *stopIntr()
{
	if( !intrData.started ) return 0;
	hleEnterCriticalSection();
//	intrData.oldmask = *int_mask;
//	intrData.dma = *dpcr;
//	*int_reg = *int_mask = 0;
//	*dpcr &= 0x77777777;
	hleResetEntryInt();
	intrData.started = 0;
	return &intrData;
}
/******************************************************************************/
void *resetIntr()
{
	if( intrData.started ) return 0;
//	HookEntryInt(intrData.trap);
	intrData.started = 1;
//	*int_mask = intrData.oldmask;
//	*dpcr = intrData.dma;
	hleExitCriticalSection();
	return &intrData;
}
/******************************************************************************/
/***H*L*E**********************************************************************/
/******************************************************************************/
int hleVSync(int mode)
{
	if( mode < 0 )
    {
		printf( "%lx\n ", Vcount );
		return Vcount;
	}
	return 0;
}
void *hleResetCallback(void)
{
	return intrCB->startIntr();
}
void *hleInterruptCallback(int index, void (*callback)())
{
	return intrCB->setIntr(index, callback);
}
void *hleDMACallback(int index, void (*callback)())
{
	return intrCB->setIntrDMA(index, callback);
}
void *hleVSyncCallback(void (*callback)())
{
	return intrCB->setIntrVSync(4, callback);
}
void *hleVSyncCallbacks(int index, void (*callback)())
{
	return intrCB->setIntrVSync(index, callback);
}
void *hleStopCallback(void)
{
	return intrCB->stopIntr();
}
void *hleRestartCallback(void)
{
	return intrCB->resetIntr();
}
int32 hleCheckCallback(void)
{
	return intrData.trapped;
}
uint16 hleGetIntrMask(void)
{
	return 0;//*int_mask;
}
uint16 hleSetIntrMask(uint16 mask)
{
//	uint16 old = *int_mask;
//	*int_mask = mask;
	return 0;//old;
}
/******************************************************************************/
