#ifndef _LIBETC_HLE_MAIN_H_
#define _LIBETC_HLE_MAIN_H_

#include "defs.h"
#include "hledefs.h"

typedef struct
{
	uint16      started;
	uint16      trapped;
	void        (*cbIntr[11])();
	uint16      mask, oldmask;
	uint32      dma;
	hlejmp_buf  trap;
	uint8       stack[0x1000];
}
intrDataStruct;

extern intrDataStruct   intrData;

typedef struct
{
	char    *id;
	void    *(*setIntrDMA)(int, void (*)());
	void    *(*setIntr)(int, void (*)());
	void    *(*startIntr)();
	void    *(*stopIntr)();
	void    *(*setIntrVSync)(int, void (*)());
	void    *(*resetIntr)();
}
intrCBStruct;

extern intrCBStruct*	intrCB;

extern void     (*cbIntrVSync[8])();
extern uint32   Vcount;
extern void     (*cbIntrDMA[8])();

void		trapIntrVSync();
void*		startIntrVSync();
void		trapIntrDMA();
void*		startIntrDMA();
void		trapIntr();
void*		startIntr();
void*		setIntr( int, void (*)());
void*		stopIntr();
void*		resetIntr();
void		memclr( uint32 *ptr, int32 n );

#endif//_LIBETC_HLE_MAIN_H_
