

DSCR:	equ 0xffc9	; DSP DMA Control Reg
DSBL:	equ 0xffcb	; DSP DMA Block Length
DSPA:	equ 0xffcd	; DSP DMA DMEM Address
DSMAH:	equ	0xffce	; DSP DMA Mem Address H
DSMAL:	equ 0xffcf	; DSP DMA Mem Address L

ACSAH:	equ 0xffd4
ACSAL:	equ	0xffd5
ACEAH:	equ	0xffd6
ACEAL:	equ	0xffd7
ACCAH:	equ	0xffd8
ACCAL:	equ	0xffd9
AMDM:	equ	0xffef	; ARAM DMA Request Mask

DIRQ:	equ	0xfffb	; DSP Irq Request
DMBH:	equ	0xfffc	; DSP Mailbox H
DMBL:	equ	0xfffd	; DSP Mailbox L
CMBH:	equ	0xfffe	; CPU Mailbox H
CMBL:	equ 0xffff	; CPU Mailbox L

R00:	equ	0x00
R01:	equ	0x01
R02:	equ	0x02
R03:	equ	0x03
R04:	equ	0x04
R05:	equ	0x05
R06:	equ	0x06
R07:	equ	0x07
R08:	equ	0x08
R09:	equ	0x09
R0A:	equ	0x0a
R0B:	equ	0x0b
R0C:	equ	0x0c
R0D:	equ	0x0d
R0E:	equ	0x0e
R0F:	equ	0x0f
R10:	equ	0x10
R11:	equ	0x11
R12:	equ	0x12
R13:	equ	0x13
R14:	equ	0x14
R15:	equ	0x15
R16:	equ	0x16
R17:	equ	0x17
R18:	equ	0x18
R19:	equ	0x19
R1A:	equ	0x1a
R1B:	equ	0x1b
R1C:	equ	0x1c
R1D:	equ	0x1d
R1E:	equ	0x1e
R1F:	equ	0x1f

ACH0:	equ	0x10
ACH1:	equ	0x11
ACL0:	equ	0x1e
ACL1:	equ	0x1f

DSP_CR_IMEM:	equ		2
DSP_CR_TO_CPU:	equ		1

; Interrupt vectors 8 vectors, 2 opcodes each

	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	jmp		irq8
	
; Main code at 0x10
	CW		0x1301
	CW		0x1302
	CW		0x1303
	CW		0x1304
	CW		0x1305
	CW		0x1306

	CW		0x8e00
	lri		$r12, #0x00ff
	
main:
	lri		$R18, #0xbeef
	lri		$r19, #0xdeca
	lri		$r1f, #0x1ee7
	;lri	R3, #0x5656
	;lri	R4, #0x7878
	;lri	R5, #0x9a9a
	;lri	R6, #0xbcbc
	;lri	R7, #0xdede
	
	lri		$r02, #0x0400
	cw		0x1b58
	cw		0x1b59
	cw		0x1b5f
	
	lri		$R18, #0xdede
	lri		$r19, #0xfade
	lri		$r1f, #0xfee7
	lri		$r02, #0x0500

	cw		0x1b58
	cw		0x1b59
	cw		0x1b5f


	cw		0x8e00

	call	wait_for_dsp_mbox
	si		@DMBH, #0x8888
	si		@DMBL, #0xbeef
	si		@DIRQ, #0x0001

	cw		0x8e00

	call	wait_for_cpu_mbox
	lrs		$ACL0, @CMBL
	andc	$acl1, #0x7fff
	
	sr		@0x0e00, $ACL1
	sr		@0x0e01, $ACL0

	sr		@0x0c00, $ACL1
	sr		@0x0c01, $ACL0

	call	wait_for_dsp_mbox
	si		@DMBH, #0x8888
	sr		@DMBL, $ACL0
	si		@DIRQ, #0x0001
	
	lri		$r1e, #0x1234
	lri		$r00, #0x0110
	cw		0x1b1e
	;srr		@$r00, $r1f
	
	
	cw		0x8e00
	lri		$r00, #0x0110
	lri		$r01, #0x0220
	lri		$r02, #0x0330
	lri		$r03, #0x0401
	lri		$r04, #0x0550
	lri		$r05, #0x0660
	lri		$r06, #0x0770
	lri		$r07, #0x0880
	lri		$r08, #0x0111
	lri		$r09, #0x0221
	lri		$r0a, #0x0331
	lri		$r0b, #0x0441
	lri		$r0c, #0x0551
	lri		$r0d, #0x0661
	lri		$r0e, #0x0771
	lri		$r0f, #0x0881

	lri		$r10, #0x1117
	lri		$r11, #0x1227
	lri		$r13, #0x1447
	lri		$r14, #0x1557
	lri		$r15, #0x1667
	lri		$r16, #0x1777
	lri		$r17, #0x1887
	lri		$r18, #0x2113
	lri		$r19, #0x2223
	lri		$r1a, #0x2333
	lri		$r1b, #0x2443
	lri		$r1c, #0x2553
	lri		$r1d, #0x2663
	lri		$r1e, #0x2773
	lri		$r1f, #0x2883

	;lri		$r10, #0x0
	;lri		$r11, #0x0
	lri			$r13, #0x0
	;lri		$r14, #0x0
	;lri		$r15, #0x0
	;lri		$r16, #0x0
	;lri		$r17, #0x0
	;lri		$r18, #0x0
	;lri		$r19, #0x0
	;lri		$r1a, #0x0
	;lri		$r1b, #0x0
	;lri		$r1c, #0x0
	;lri		$r1d, #0x0
	;lri		$r1e, #0x0

	
	;lri		$r1e, #0x3
	;	#0x0000
	;cw		0x19de
	;cw		0x0380
	;cw		0x2
addr:
	cw		0x8e00
	;lri		$r1e, #0x00123
	;lri		$r1f, #0x0002
	;cw		0x4c00
	;cw		0x007f
	;cw		0x0213
	;lri		$r00, #0x0110
	;lri		$r03, #0x0401
	;cw		0x89f0
	;cw		0xb100
	;lri	$r00, #0x0400
	;cw		0x4e00
	;cw		0x007f
	;cw		0x0004
	;cw		0x0277

	;cw		0x8e00
	;cw		0x8c00
	;cw		0x8f00
	;lri		$acl0, #0x0001
	;lri		$acl0, #0x0002
	;add0c	#0xfff0
	;cw		0x8b00
	;cw		0x8d00
	;cw		0x8900
	;cw		0x8e00
	;lri		$acl0, #0x0013
	;lri		$acl1, #0x0011
	;lri		$r1c, #0x0004
	;lri		$r1d, #0x1203
	;cw		0x000
	
	;cw		0x8a00
	
	;lri			$r1a, #0x1234
	;lri		$r10, #0x1234
	;lri			$acl0, #0x12
	lri			$r00, #0x0c00
	lri			$r01, #0x0c00
	lri			$r02, #0x0c00
	lri			$r03, #0x0c00
	
	;lri		$r12, #0x0000
	lri		$r13, #0
	;lri		$r13, #0xffff
	
	;lri		$r1a, #0x0400
	;lri		$r1e, #0x0000
	;cw		0x11a0
	;dar		$r00

val0:	equ	0x0008
val1:	equ	0x0014

	cw		0x8e00
	cw		0x8100
	cw		0x8900
	cw		0x8100
	
	;lri		$r0f, #0x0000
	lri		$r14, #0x0000
	lri		$r15, #0x0000
	lri		$r16, #0x0000
	lri		$r17, #0x0000

	lri		$r10, #0x0000
	lri		$r11, #0x0033

	lri		$r18, #0x0004
	lri		$r19, #0x0021
	lri		$r1a, #0x0003
	lri		$r1b, #0x0005
	lri		$r1c, #0x0007
	lri		$r1d, #0x0008
	lri		$acl0, #0x0010
	lri		$acl1, #0x0011

	;CLRA	$ACL0
	;CLRA	$ACL1
	LRI		$ACL1, #0x0020
	LRIS	$ACL0, #0x0010
	;CW		0x0064		; *** UNKNOWN OPCODE
	;CW		irq8
	LRI		$r00, #0x0c00
	LRI		$R01, #0x0c00
	cw		0x8b00
	cw		0x6070
	;cw		0x9800
	;cw		0x9500
	nop
	
	LRI		$R01, #0x0c00
	lrri	$acl1, @$r01


	;SRRI	@$R00, $ACL1
	;SRRI	@$R00, $ACL1
	;LRI		$R00, #0x0d60
	;CW		0x005e		; *** UNKNOWN OPCODE
	;SRRI	@$R00, $ACL1
	
	;LRI		$R00, #0x0400
	;CW		0x005e
	;LRRi		$acl1, @$R00
	;lri		$r13, #0
	;set40
	;cw		0x8a00
	;cw		0x8d00
	;clra	$acl0
	;clra	$acl1
	
	;lri		$r00, #0x400
	;lri		$r03, #0xc00
	;lri		$acl0, #0x0010
	;lri		$acl1, #0x0018
	;cw		0xd000
	
	;cw		0x153f
	;cw		0xd000
	;cw		0x6e00
	;call	stinky
	;lri		$r01, #stinky
	;cw		(irq8 - stinky) | 0x1100;
	;cw		0x1100
	;cw		stinky
	;cw		0x8200
	;lri		$r02, #stinky
	
stinky:
	
	
	;cw		0x02a0
	;cw		0x8001
	;mrr		$r00, $r13
	;cw	0xc010
	;cw	0x6f00
	;cw	0x4c00
	;nop
	;lri		$r13, #0
	;cw		0x0240
	;cw		0x1234
	;mrr		$r01, $r13

	;lri		$r13, #0
	;cw		0x8f00
	;cw		0x8900
	
	;lri		$r1c, #0x0000
	;lri		$r1d, #0x0000
	
	;lri		$ach0, #0x0000
	;lri		$ach1, #0x0000

	;lri		$acl0, #val0
	;lri		$acl1, #val1
	;cw		0x8200
	;mrr		$r01, $r13


	;cw		0x8900
	;lri		$acl0, #0x8000
	;lri		$acl1, #0x0000
	
	;cw		0xb100
	
	;cw		0x64a0
	;mrr		$r0d, $r1d
	;mrr		$r0d, $r1f
	;mrr		$r0e, $r1e
	;mrr		$r0f, $r1d
	;lri		$acl0, #0xffff
	;cw			0x8900
	;mrr		$r1f, $r0d
	;mrr		$r1d, $r0d
	;mrr		$r1f, $r0e
	;mrr		$r1c, $r0f
	;mrr		$r1e, $r0c
	
	
	sr		@0xc00,  $r00
	sr		@0xc01,  $r01
	sr		@0xc02,  $r02
	sr		@0xc03,  $r03
	sr		@0xc04,  $r04
	sr		@0xc05,  $r05
	sr		@0xc06,  $r06
	sr		@0xc07,  $r07
	sr		@0xc08,  $r08
	sr		@0xc09,  $r09
	sr		@0xc0a,  $r0a
	sr		@0xc0b,  $r0b
	sr		@0xc0c,  $r0c
	sr		@0xc0d,  $r0d
	sr		@0xc0e,  $r0e
	sr		@0xc0f,  $r0f
	sr		@0xc10,  $r10
	sr		@0xc11,  $r11
	sr		@0xc12,  $r12
	sr		@0xc13,  $r13
	sr		@0xc14,  $r14
	sr		@0xc15,  $r15
	sr		@0xc16,  $r16
	sr		@0xc17,  $r17
	sr		@0xc18,  $r18
	sr		@0xc19,  $r19
	sr		@0xc1a,  $r1a
	sr		@0xc1b,  $r1b
	sr		@0xc1c,  $r1c
	sr		@0xc1d,  $r1d
	sr		@0xc1e,  $r1e
	sr		@0xc1f,  $r1f




	lri		$r18, #0x0c00
	lri		$r19, #1		;(DSP_CR_IMEM | DSP_CR_TO_CPU)
	lri		$r1a, #0x400

	cw		0x8e00
	lr		$r1e, @0x0e00
	lr		$r1c, @0x0e01

	call	do_dma

dead_loop:
	jmp		0x8000

do_dma:
	sr		@DSMAH, $r1e
	sr		@DSMAL, $r1c
	sr		@DSPA, $r18
	sr		@DSCR, $r19
	sr		@DSBL, $r1a
wait_dma:
	LRS		$ACL0, @DSCR
	andf	$acl0, #0x0004
	JNZ		wait_dma
	RET


wait_for_dsp_mbox:
	lrs		$ACL1, @DMBH
	andf	$acl1, #0x8000
	jnz		wait_for_dsp_mbox
	ret

wait_for_cpu_mbox:
	lrs		$ACL1, @cmbh
	andf	$acl1, #0x8000
	jzr		wait_for_cpu_mbox
	ret
	
irq8:
	lrs		$ACL1, @DMBH
	andf	$acl1, #0x8000
	jnz		irq8
	si		@DMBH, #0x8BAD
	si		@DMBL, #0xFA7E
	si		@DIRQ, #0x0001
	rti
