/*
   Hyllian's xBR-lv2 Shader
   
   Copyright (C) 2011/2014 Hyllian/Jararaca - sergiogdb@gmail.com

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


   Incorporates some of the ideas from SABR shader. Thanks to Joshua Street.
*/

/*
[configuration]

[OptionBool]
GUIName = xbr-lvl2
OptionName = BR
DefaultValue = true

[/configuration]
*/

const float coef = 2.0;
const float3 rgbw = float3(16.163, 23.351, 8.4772);
const float4 xbr_eq_threshold = float4(15.0, 15.0, 15.0, 15.0);
const float xbr_scale = 3.0;

const float4 Ao = float4( 1.0, -1.0, -1.0, 1.0 );
const float4 Bo = float4( 1.0,  1.0, -1.0,-1.0 );
const float4 Co = float4( 1.5,  0.5, -0.5, 0.5 );
const float4 Ax = float4( 1.0, -1.0, -1.0, 1.0 );
const float4 Bx = float4( 0.5,  2.0, -0.5,-2.0 );
const float4 Cx = float4( 1.0,  1.0, -0.5, 0.0 );
const float4 Ay = float4( 1.0, -1.0, -1.0, 1.0 );
const float4 By = float4( 2.0,  0.5, -2.0,-0.5 );
const float4 Cy = float4( 2.0,  0.0, -1.0, 0.5 );


float4 df(float4 A, float4 B)
{
    return abs(A-B);
}

float4 weighted_distance(float4 a, float4 b, float4 c, float4 d, float4 e, float4 f, float4 g, float4 h)
{
    return (df(a,b) + df(a,c) + df(d,e) + df(d,f) + 4.0*df(g,h));
}


bvec4 eq(float4 A, float4 B)
{
    return (greaterThan(xbr_eq_threshold, df(A, B)));
}


void main() {
    float4 color = Sample();
    if OptionEnabled(BR) {
        bvec4 edr, edr_left, edr_up, px; // px = pixel, edr = edge detection rule
        bvec4 interp_restriction_lv1, interp_restriction_lv2_left, interp_restriction_lv2_up;
        float4 fx, fx_left, fx_up, final_fx; // inequations of straight lines.
	float3 res1, res2, pix1, pix2, pix[4];
        float4 pixel;
	float4 delta         = float4(1.0/xbr_scale, 1.0/xbr_scale, 1.0/xbr_scale, 1.0/xbr_scale);
	float4 deltaL        = float4(0.5/xbr_scale, 1.0/xbr_scale, 0.5/xbr_scale, 1.0/xbr_scale);
	float4 deltaU        = deltaL.yxwz;

    
    float2 fp  = fract(GetCoordinates()*GetResolution());
    float2 TexCoord_0 = GetCoordinates()-fp*GetInvResolution();
    float2 dx = float2(GetInvResolution().x, 0.0);
    float2 dy = float2(0.0, GetInvResolution().y);
    float2 y2 = dy+dy; float2 x2 = dx+dx;

    float3 A  = SampleLocation(TexCoord_0 - dx - dy).xyz;
    float3 B  = SampleLocation(TexCoord_0 - dy).xyz;
    float3 C  = SampleLocation(TexCoord_0 + dx - dy).xyz;
    float3 D  = SampleLocation(TexCoord_0 - dx).xyz;
    float3 E  = SampleLocation(TexCoord_0).xyz;
    float3 F  = SampleLocation(TexCoord_0 + dx).xyz;
    float3 G  = SampleLocation(TexCoord_0  - dx + dy).xyz;
    float3 H  = SampleLocation(TexCoord_0 + dy).xyz;
    float3 I  = SampleLocation(TexCoord_0 + dx + dy).xyz;
    float3 A1 = SampleLocation(TexCoord_0  - dx - y2).xyz;
    float3 C1 = SampleLocation(TexCoord_0  + dx - y2).xyz;
    float3 A0 = SampleLocation(TexCoord_0 - x2 - dy).xyz;
    float3 G0 = SampleLocation(TexCoord_0 - x2 + dy).xyz;
    float3 C4 = SampleLocation(TexCoord_0 + x2 - dy).xyz;
    float3 I4 = SampleLocation(TexCoord_0 + x2 + dy).xyz;
    float3 G5 = SampleLocation(TexCoord_0 - dx + y2).xyz;
    float3 I5 = SampleLocation(TexCoord_0 + dx + y2).xyz;
    float3 B1 = SampleLocation(TexCoord_0 - y2).xyz;
    float3 D0 = SampleLocation(TexCoord_0 - x2).xyz;
    float3 H5 = SampleLocation(TexCoord_0 + y2).xyz;
    float3 F4 = SampleLocation(TexCoord_0 + x2).xyz;

    float4 b  = float4(dot(B ,rgbw), dot(D ,rgbw), dot(H ,rgbw), dot(F ,rgbw));
    float4 c  = float4(dot(C ,rgbw), dot(A ,rgbw), dot(G ,rgbw), dot(I ,rgbw));
    float4 d  = float4(b.y, b.z, b.w, b.x);
    float4 e  = float4(dot(E,rgbw));
    float4 f  = float4(b.w, b.x, b.y, b.z);
    float4 g  = float4(c.z, c.w, c.x, c.y);
    float4 h  = float4(b.z, b.w, b.x, b.y);
    float4 i  = float4(c.w, c.x, c.y, c.z);
    float4 i4 = float4(dot(I4,rgbw), dot(C1,rgbw), dot(A0,rgbw), dot(G5,rgbw));
    float4 i5 = float4(dot(I5,rgbw), dot(C4,rgbw), dot(A1,rgbw), dot(G0,rgbw));
    float4 h5 = float4(dot(H5,rgbw), dot(F4,rgbw), dot(B1,rgbw), dot(D0,rgbw));
    float4 f4 = float4(h5.y, h5.z, h5.w, h5.x);



	// These inequations define the line below which interpolation occurs.
	fx      = (Ao*fp.y+Bo*fp.x); 
	fx_left = (Ax*fp.y+Bx*fp.x);
	fx_up   = (Ay*fp.y+By*fp.x);


    interp_restriction_lv1 = bvec4(float4(notEqual(e,f))*float4(notEqual(e,h)));
    interp_restriction_lv2_left = bvec4(float4(notEqual(e,g))*float4(notEqual(d,g)));
    interp_restriction_lv2_up   = bvec4(float4(notEqual(e,c))*float4(notEqual(b,c)));


	float4 fx45 = clamp((fx      + delta  -Co)/(2*delta ), 0.0, 1.0);
	float4 fx30 = clamp((fx_left + deltaL -Cx)/(2*deltaL), 0.0, 1.0);
	float4 fx60 = clamp((fx_up   + deltaU -Cy)/(2*deltaU), 0.0, 1.0);

    edr      = bvec4(float4(lessThan(weighted_distance( e, c, g, i, h5, f4, h, f), weighted_distance( h, d, i5, f, i4, b, e, i)))*float4(interp_restriction_lv1));
    edr_left = bvec4(float4(lessThanEqual(coef*df(f,g),df(h,c)))*float4(interp_restriction_lv2_left)*float4(edr)); 
    edr_up   = bvec4(float4(greaterThanEqual(df(f,g),coef*df(h,c)))*float4(interp_restriction_lv2_up)*float4(edr));


	fx45 = float4(edr)*fx45;
	fx30 = float4(edr_left)*fx30;
	fx60 = float4(edr_up)*fx60;

        px = lessThanEqual(df(e,f),df(e,h));

	float4 maximo = max(max(fx30, fx60), fx45);

        pix[0] = mix(E, mix(H, F, float(px.x)), maximo.x);
        pix[1] = mix(E, mix(F, B, float(px.y)), maximo.y);
        pix[2] = mix(E, mix(B, D, float(px.z)), maximo.z);
        pix[3] = mix(E, mix(D, H, float(px.w)), maximo.w);
	pixel = float4(dot( pix[0], rgbw ), dot( pix[1], rgbw ), dot( pix[2], rgbw ), dot( pix[3], rgbw ));
	

	float4 diff = df(pixel,e);

	float3 res = pix[0];
	float mx = diff.x;

        if (diff.y > mx) {res = pix[1]; mx = diff.y;}
        if (diff.z > mx) {res = pix[2]; mx = diff.z;}
        if (diff.w > mx) {res = pix[3];}
        color.xyz = res;
	}
    SetOutput(color);
}


