/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.cpu;

import jario.hardware.Bus1bit;
import jario.hardware.Bus32bit;
import jario.hardware.Bus8bit;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.snes.cpu.ALU;
import jario.snes.cpu.BusB;
import jario.snes.cpu.CPUCore;
import jario.snes.cpu.CPUCoreOperation;
import jario.snes.cpu.Channel;
import jario.snes.cpu.DMA;
import jario.snes.cpu.HVCounter;
import jario.snes.cpu.Status;
import java.util.Arrays;

public class CPU
extends CPUCore
implements Hardware,
Clockable,
Bus8bit,
Configurable {
    public static final int NTSC = 0;
    public static final int PAL = 1;
    protected Bus8bit bus;
    protected Clockable smp_clk;
    protected Clockable ppu_clk;
    protected Bus1bit ppu1bit;
    protected Bus8bit smp_bus;
    protected Bus8bit input_bus;
    protected Bus32bit video_bus;
    private long smpClocks;
    private int ticks;
    private int stage;
    private int addr;
    Channel[] channel = new Channel[8];
    DMA dma;
    private int cpu_version;
    Status status = new BusB();
    private ALU alu = new ALU();
    HVCounter counter;
    Runnable scanline = new Runnable(){

        @Override
        public void run() {
            CPU.this.status.dma_counter = CPU.this.status.dma_counter + CPU.this.status.line_clocks & 7;
            CPU.this.status.line_clocks = CPU.this.counter.lineclocks();
            CPU.this.video_bus.write32bit(0, CPU.this.counter.vcounter());
            if (CPU.this.counter.vcounter() == 241) {
                ((Clockable)CPU.this.input_bus).clock(0L);
                ((Clockable)CPU.this.video_bus).clock(0L);
            }
            if (CPU.this.counter.vcounter() == 0) {
                CPU.this.status.hdma_init_position = CPU.this.cpu_version == 1 ? 20 - CPU.this.dma_counter() : 12 + CPU.this.dma_counter();
                CPU.this.status.hdma_init_triggered = false;
            }
            if (CPU.this.cpu_version == 2) {
                CPU.this.status.dram_refresh_position = 538 - CPU.this.dma_counter();
            }
            CPU.this.status.dram_refreshed = false;
            if (CPU.this.counter.vcounter() <= (!CPU.this.ppu1bit.read1bit(1) ? 224 : 239)) {
                CPU.this.status.hdma_position = 1104;
                CPU.this.status.hdma_triggered = false;
            }
            if (CPU.this.status.auto_joypad_poll && CPU.this.counter.vcounter() == (!CPU.this.ppu1bit.read1bit(1) ? 227 : 242)) {
                CPU.this.input_bus.write8bit(1, (byte)0);
                CPU.this.run_auto_joypad_poll();
            }
        }
    };

    public CPU() {
        this.initialize_opcode_table();
        int i = 0;
        while (i < this.channel.length) {
            this.channel[i] = new Channel();
            ++i;
        }
        this.dma = new DMA(this);
        this.counter = new HVCounter();
        this.counter.scanline = this.scanline;
        this.power();
    }

    public void connect(int port, Hardware hw) {
        switch (port) {
            case 0: {
                this.bus = (Bus8bit)hw;
                break;
            }
            case 1: {
                this.smp_clk = (Clockable)hw;
                this.smp_bus = (Bus8bit)hw;
                break;
            }
            case 2: {
                this.input_bus = (Bus8bit)hw;
                break;
            }
            case 3: {
                this.video_bus = (Bus32bit)hw;
                break;
            }
            case 4: {
                this.ppu_clk = (Clockable)hw;
                this.counter.ppu1bit = this.ppu1bit = (Bus1bit)hw;
            }
        }
    }

    @Override
    public boolean interrupt_pending() {
        return this.status.interrupt_pending;
    }

    public final void clock(long clocks) {
        while (clocks-- > 0L) {
            if (this.ticks-- > 0) {
                this.counter.tick();
                if ((this.counter.hcounter() & 2) != 0) {
                    this.poll_interrupts();
                }
                this.smpClocks += 2L;
                this.ppu_clk.clock(2L);
                if (this.ticks == 0 && !this.status.dram_refreshed && this.counter.hcounter() >= this.status.dram_refresh_position) {
                    this.status.dram_refreshed = true;
                    this.status.irq_lock = false;
                    this.ticks = 20;
                }
            } else {
                switch (this.stage) {
                    case 0: {
                        if (this.status.interrupt_pending) {
                            this.status.interrupt_pending = false;
                            if (this.status.nmi_pending) {
                                this.status.nmi_pending = false;
                                this.status.interrupt_vector = !this.regs.e ? 65514 : 65530;
                                this.op_irq();
                            } else if (this.status.irq_pending) {
                                this.status.irq_pending = false;
                                this.status.interrupt_vector = !this.regs.e ? 65518 : 65534;
                                this.op_irq();
                            } else if (this.status.reset_pending) {
                                this.status.reset_pending = false;
                                this.regs.pc.l(this.bus.read8bit(65532) & 0xFF);
                                this.regs.pc.h(this.bus.read8bit(65533) & 0xFF);
                                System.out.println("reset pending: " + Integer.toHexString(this.regs.pc.w()));
                                this.add_clocks(186);
                            }
                        }
                        this.addr = (this.regs.pc.b() << 16) + this.regs.pc.w();
                        this.regs.pc.w(this.regs.pc.w() + 1);
                        this.status.clock_count = this.speed(this.addr);
                        this.dma_edge();
                        this.status.irq_lock = false;
                        this.ticks = this.status.clock_count - 4 >> 1;
                        this.stage = 1;
                        break;
                    }
                    case 1: {
                        this.regs.mdr = this.bus.read8bit(this.addr);
                        this.status.irq_lock = false;
                        this.ticks = 2;
                        this.stage = 2;
                        break;
                    }
                    case 2: {
                        this.alu_edge();
                        int op = this.regs.mdr & 0xFF;
                        ((CPUCoreOperation)this.opcode_table.get(op)).Invoke();
                        this.stage = 0;
                    }
                }
            }
            this.smp_clk.clock(this.smpClocks);
            this.smpClocks = 0L;
        }
    }

    public void reset() {
        this.stage = 0;
        this.smpClocks = 0L;
        this.counter.reset();
        this.regs.pc.set(0);
        this.regs.x.h(0);
        this.regs.y.h(0);
        this.regs.s.h(1);
        this.regs.d.set(0);
        this.regs.db = 0;
        this.regs.p.set(52);
        this.regs.e = true;
        this.regs.mdr = 0;
        this.regs.wai = false;
        this.update_table();
        if (this.status != null) {
            this.mmio_reset();
            this.dma.dma_reset();
            this.timing_reset();
        }
    }

    public byte read8bit(int addr) {
        if (((addr &= 0xFFFF) & 0xFFC0) == 8512) {
            return this.smp_bus.read8bit(addr);
        }
        if ((addr & 0xFF80) == 17152) {
            int i = addr >> 4 & 7;
            switch (addr & 0xF) {
                case 0: {
                    return this.mmio_r43x0(i);
                }
                case 1: {
                    return this.mmio_r43x1(i);
                }
                case 2: {
                    return this.mmio_r43x2(i);
                }
                case 3: {
                    return this.mmio_r43x3(i);
                }
                case 4: {
                    return this.mmio_r43x4(i);
                }
                case 5: {
                    return this.mmio_r43x5(i);
                }
                case 6: {
                    return this.mmio_r43x6(i);
                }
                case 7: {
                    return this.mmio_r43x7(i);
                }
                case 8: {
                    return this.mmio_r43x8(i);
                }
                case 9: {
                    return this.mmio_r43x9(i);
                }
                case 10: {
                    return this.mmio_r43xa(i);
                }
                case 11: {
                    return this.mmio_r43xb(i);
                }
                case 12: {
                    return this.regs.mdr;
                }
                case 13: {
                    return this.regs.mdr;
                }
                case 14: {
                    return this.regs.mdr;
                }
                case 15: {
                    return this.mmio_r43xb(i);
                }
            }
        }
        switch (addr) {
            case 8576: {
                return this.mmio_r2180();
            }
            case 16406: {
                return this.mmio_r4016();
            }
            case 16407: {
                return this.mmio_r4017();
            }
            case 16912: {
                return this.mmio_r4210();
            }
            case 16913: {
                return this.mmio_r4211();
            }
            case 16914: {
                return this.mmio_r4212();
            }
            case 16915: {
                return this.mmio_r4213();
            }
            case 16916: {
                return this.mmio_r4214();
            }
            case 16917: {
                return this.mmio_r4215();
            }
            case 16918: {
                return this.mmio_r4216();
            }
            case 16919: {
                return this.mmio_r4217();
            }
            case 16920: {
                return this.mmio_r4218();
            }
            case 16921: {
                return this.mmio_r4219();
            }
            case 16922: {
                return this.mmio_r421a();
            }
            case 16923: {
                return this.mmio_r421b();
            }
            case 16924: {
                return this.mmio_r421c();
            }
            case 16925: {
                return this.mmio_r421d();
            }
            case 16926: {
                return this.mmio_r421e();
            }
            case 16927: {
                return this.mmio_r421f();
            }
        }
        return this.regs.mdr;
    }

    public void write8bit(int addr, byte data) {
        if (((addr &= 0xFFFF) & 0xFFC0) == 8512) {
            ((Bus8bit)this.status).write8bit(addr, data);
            return;
        }
        if ((addr & 0xFF80) == 17152) {
            int i = addr >> 4 & 7;
            switch (addr & 0xF) {
                case 0: {
                    this.mmio_w43x0(i, data);
                    return;
                }
                case 1: {
                    this.mmio_w43x1(i, data);
                    return;
                }
                case 2: {
                    this.mmio_w43x2(i, data);
                    return;
                }
                case 3: {
                    this.mmio_w43x3(i, data);
                    return;
                }
                case 4: {
                    this.mmio_w43x4(i, data);
                    return;
                }
                case 5: {
                    this.mmio_w43x5(i, data);
                    return;
                }
                case 6: {
                    this.mmio_w43x6(i, data);
                    return;
                }
                case 7: {
                    this.mmio_w43x7(i, data);
                    return;
                }
                case 8: {
                    this.mmio_w43x8(i, data);
                    return;
                }
                case 9: {
                    this.mmio_w43x9(i, data);
                    return;
                }
                case 10: {
                    this.mmio_w43xa(i, data);
                    return;
                }
                case 11: {
                    this.mmio_w43xb(i, data);
                    return;
                }
                case 12: {
                    return;
                }
                case 13: {
                    return;
                }
                case 14: {
                    return;
                }
                case 15: {
                    this.mmio_w43xb(i, data);
                    return;
                }
            }
        }
        switch (addr) {
            case 8576: {
                this.mmio_w2180(data);
                return;
            }
            case 8577: {
                this.mmio_w2181(data);
                return;
            }
            case 8578: {
                this.mmio_w2182(data);
                return;
            }
            case 8579: {
                this.mmio_w2183(data);
                return;
            }
            case 16406: {
                this.mmio_w4016(data);
                return;
            }
            case 16407: {
                return;
            }
            case 16896: {
                this.mmio_w4200(data);
                return;
            }
            case 16897: {
                this.mmio_w4201(data);
                return;
            }
            case 16898: {
                this.mmio_w4202(data);
                return;
            }
            case 16899: {
                this.mmio_w4203(data);
                return;
            }
            case 16900: {
                this.mmio_w4204(data);
                return;
            }
            case 16901: {
                this.mmio_w4205(data);
                return;
            }
            case 16902: {
                this.mmio_w4206(data);
                return;
            }
            case 16903: {
                this.mmio_w4207(data);
                return;
            }
            case 16904: {
                this.mmio_w4208(data);
                return;
            }
            case 16905: {
                this.mmio_w4209(data);
                return;
            }
            case 16906: {
                this.mmio_w420a(data);
                return;
            }
            case 16907: {
                this.mmio_w420b(data);
                return;
            }
            case 16908: {
                this.mmio_w420c(data);
                return;
            }
            case 16909: {
                this.mmio_w420d(data);
                return;
            }
        }
    }

    public Object readConfig(String key) {
        if (key.equals("BUS B")) {
            return this.status;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("cpu version")) {
            this.cpu_version = (Integer)value;
        }
        if (key.equals("region")) {
            this.counter.region = value.toString().equals("ntsc") ? 0 : 1;
        }
    }

    @Override
    public void op_io() {
        this.status.clock_count = 6;
        this.dma_edge();
        this.add_clocks(6);
        this.alu_edge();
    }

    @Override
    public byte op_read(int addr) {
        this.status.clock_count = this.speed(addr);
        this.dma_edge();
        this.add_clocks(this.status.clock_count - 4);
        this.regs.mdr = this.bus.read8bit(addr);
        this.add_clocks(4);
        this.alu_edge();
        return this.regs.mdr;
    }

    @Override
    public void op_write(int addr, byte data) {
        this.alu_edge();
        this.status.clock_count = this.speed(addr);
        this.dma_edge();
        this.add_clocks(this.status.clock_count);
        this.regs.mdr = data;
        this.bus.write8bit(addr, this.regs.mdr);
    }

    @Override
    public void last_cycle() {
        if (!this.status.irq_lock) {
            this.status.nmi_pending |= this.nmi_test();
            this.status.irq_pending |= this.irq_test();
            this.status.interrupt_pending = this.status.nmi_pending || this.status.irq_pending;
        }
    }

    private void power() {
        this.regs.a.set(0);
        this.regs.x.set(0);
        this.regs.y.set(0);
        this.regs.s.set(511);
        this.dma.dma_power();
        this.reset();
    }

    private int speed(int addr) {
        if ((addr & 0x408000) != 0) {
            if ((addr & 0x800000) != 0) {
                return this.status.rom_speed;
            }
            return 8;
        }
        if ((addr + 24576 & 0x4000) != 0) {
            return 8;
        }
        if ((addr - 16384 & 0x7E00) != 0) {
            return 6;
        }
        return 12;
    }

    private void mmio_reset() {
        Arrays.fill(this.status.port, (byte)0);
        this.status.wram_addr = 0;
        this.status.joypad1_bits = -1;
        this.status.joypad2_bits = -1;
        this.status.nmi_enabled = false;
        this.status.hirq_enabled = false;
        this.status.virq_enabled = false;
        this.status.auto_joypad_poll = false;
        this.status.pio = 255;
        this.status.wrmpya = 255;
        this.status.wrmpyb = 255;
        this.status.wrdiva = 65535;
        this.status.wrdivb = 255;
        this.status.hirq_pos = 511;
        this.status.virq_pos = 511;
        this.status.rom_speed = 8;
        this.status.rddiv = 0;
        this.status.rdmpy = 0;
        this.status.joy1l = 0;
        this.status.joy1h = 0;
        this.status.joy2l = 0;
        this.status.joy2h = 0;
        this.status.joy3l = 0;
        this.status.joy3h = 0;
        this.status.joy4l = 0;
        this.status.joy4h = 0;
        this.alu.mpyctr = 0;
        this.alu.divctr = 0;
        this.alu.shift = 0;
    }

    private byte mmio_r2180() {
        return this.bus.read8bit(0x7E0000 | this.status.wram_addr++ & 0x1FFFF);
    }

    private byte mmio_r4016() {
        int r = this.regs.mdr & 0xFC;
        return (byte)(r |= this.input_bus.read8bit(0) & 3);
    }

    private byte mmio_r4017() {
        int r = this.regs.mdr & 0xE0 | 0x1C;
        return (byte)(r |= this.input_bus.read8bit(1) & 3);
    }

    private byte mmio_r4210() {
        int r = this.regs.mdr & 0x70;
        r |= (this.rdnmi() ? 1 : 0) << 7;
        return (byte)(r |= this.cpu_version & 0xF);
    }

    private byte mmio_r4211() {
        int r = this.regs.mdr & 0x7F;
        return (byte)(r |= (this.timeup() ? 1 : 0) << 7);
    }

    private byte mmio_r4212() {
        int vs;
        int r = this.regs.mdr & 0x3E;
        int n = vs = !this.ppu1bit.read1bit(1) ? 225 : 240;
        if (this.counter.vcounter() >= vs && this.counter.vcounter() <= vs + 2) {
            r |= 1;
        }
        if (this.counter.hcounter() <= 2 || this.counter.hcounter() >= 1096) {
            r |= 0x40;
        }
        if (this.counter.vcounter() >= vs) {
            r |= 0x80;
        }
        return (byte)r;
    }

    private byte mmio_r4213() {
        return (byte)this.status.pio;
    }

    private byte mmio_r4214() {
        return (byte)(this.status.rddiv >> 0);
    }

    private byte mmio_r4215() {
        return (byte)(this.status.rddiv >> 8);
    }

    private byte mmio_r4216() {
        return (byte)(this.status.rdmpy >> 0);
    }

    private byte mmio_r4217() {
        return (byte)(this.status.rdmpy >> 8);
    }

    private byte mmio_r4218() {
        return (byte)this.status.joy1l;
    }

    private byte mmio_r4219() {
        return (byte)this.status.joy1h;
    }

    private byte mmio_r421a() {
        return (byte)this.status.joy2l;
    }

    private byte mmio_r421b() {
        return (byte)this.status.joy2h;
    }

    private byte mmio_r421c() {
        return (byte)this.status.joy3l;
    }

    private byte mmio_r421d() {
        return (byte)this.status.joy3h;
    }

    private byte mmio_r421e() {
        return (byte)this.status.joy4l;
    }

    private byte mmio_r421f() {
        return (byte)this.status.joy4h;
    }

    private byte mmio_r43x0(int i) {
        return (byte)((this.channel[i].direction ? 1 : 0) << 7 | (this.channel[i].indirect ? 1 : 0) << 6 | (this.channel[i].unused ? 1 : 0) << 5 | (this.channel[i].reverse_transfer ? 1 : 0) << 4 | (this.channel[i].fixed_transfer ? 1 : 0) << 3 | this.channel[i].transfer_mode << 0);
    }

    private byte mmio_r43x1(int i) {
        return (byte)this.channel[i].dest_addr;
    }

    private byte mmio_r43x2(int i) {
        return (byte)(this.channel[i].source_addr >> 0);
    }

    private byte mmio_r43x3(int i) {
        return (byte)(this.channel[i].source_addr >> 8);
    }

    private byte mmio_r43x4(int i) {
        return (byte)this.channel[i].source_bank;
    }

    private byte mmio_r43x5(int i) {
        return (byte)(this.channel[i].transfer_size() >> 0);
    }

    private byte mmio_r43x6(int i) {
        return (byte)(this.channel[i].transfer_size() >> 8);
    }

    private byte mmio_r43x7(int i) {
        return (byte)this.channel[i].indirect_bank;
    }

    private byte mmio_r43x8(int i) {
        return (byte)(this.channel[i].hdma_addr >> 0);
    }

    private byte mmio_r43x9(int i) {
        return (byte)(this.channel[i].hdma_addr >> 8);
    }

    private byte mmio_r43xa(int i) {
        return (byte)this.channel[i].line_counter;
    }

    private byte mmio_r43xb(int i) {
        return (byte)this.channel[i].unknown;
    }

    private void mmio_w2180(byte data) {
        this.bus.write8bit(0x7E0000 | this.status.wram_addr++ & 0x1FFFF, data);
    }

    private void mmio_w2181(byte data) {
        this.status.wram_addr = this.status.wram_addr & 0x1FF00 | (data & 0xFF) << 0;
    }

    private void mmio_w2182(byte data) {
        this.status.wram_addr = this.status.wram_addr & 0x100FF | (data & 0xFF) << 8;
    }

    private void mmio_w2183(byte data) {
        this.status.wram_addr = this.status.wram_addr & 0xFFFF | (data & 0xFF) << 16;
    }

    private void mmio_w4016(byte data) {
        this.input_bus.write8bit(0, data);
    }

    private void mmio_w4200(byte data) {
        this.status.auto_joypad_poll = (data & 1) != 0;
        this.nmitimen_update(data);
    }

    private void mmio_w4201(byte data) {
        this.ppu1bit.write1bit(29, (data >> 7 & 1) != 0);
        this.status.pio = data & 0xFF;
    }

    private void mmio_w4202(byte data) {
        this.status.wrmpya = data & 0xFF;
    }

    private void mmio_w4203(byte data) {
        this.status.rdmpy = 0;
        if (this.alu.mpyctr != 0 || this.alu.divctr != 0) {
            return;
        }
        this.status.wrmpyb = data & 0xFF;
        this.status.rddiv = this.status.wrmpyb << 8 | this.status.wrmpya;
        this.alu.mpyctr = 8;
        this.alu.shift = this.status.wrmpyb;
    }

    private void mmio_w4204(byte data) {
        this.status.wrdiva = this.status.wrdiva & 0xFF00 | (data & 0xFF) << 0;
    }

    private void mmio_w4205(byte data) {
        this.status.wrdiva = this.status.wrdiva & 0xFF | (data & 0xFF) << 8;
    }

    private void mmio_w4206(byte data) {
        this.status.rdmpy = this.status.wrdiva;
        if (this.alu.mpyctr != 0 || this.alu.divctr != 0) {
            return;
        }
        this.status.wrdivb = data & 0xFF;
        this.alu.divctr = 16;
        this.alu.shift = this.status.wrdivb << 16;
    }

    private void mmio_w4207(byte data) {
        this.status.hirq_pos = this.status.hirq_pos & 0x100 | (data & 0xFF) << 0;
    }

    private void mmio_w4208(byte data) {
        this.status.hirq_pos = this.status.hirq_pos & 0xFF | (data & 0xFF) << 8;
    }

    private void mmio_w4209(byte data) {
        this.status.virq_pos = this.status.virq_pos & 0x100 | (data & 0xFF) << 0;
    }

    private void mmio_w420a(byte data) {
        this.status.virq_pos = this.status.virq_pos & 0xFF | (data & 0xFF) << 8;
    }

    private void mmio_w420b(byte data) {
        int i = 0;
        while (i < 8) {
            this.channel[i].dma_enabled = (data & 1 << i) != 0;
            ++i;
        }
        if (data != 0) {
            this.status.dma_pending = true;
        }
    }

    private void mmio_w420c(byte data) {
        int i = 0;
        while (i < 8) {
            this.channel[i].hdma_enabled = (data & 1 << i) != 0;
            ++i;
        }
    }

    private void mmio_w420d(byte data) {
        this.status.rom_speed = (data & 1) != 0 ? 6 : 8;
    }

    private void mmio_w43x0(int i, byte data) {
        this.channel[i].direction = (data & 0x80) != 0;
        this.channel[i].indirect = (data & 0x40) != 0;
        this.channel[i].unused = (data & 0x20) != 0;
        this.channel[i].reverse_transfer = (data & 0x10) != 0;
        this.channel[i].fixed_transfer = (data & 8) != 0;
        this.channel[i].transfer_mode = data & 7;
    }

    private void mmio_w43x1(int i, byte data) {
        this.channel[i].dest_addr = data & 0xFF;
    }

    private void mmio_w43x2(int i, byte data) {
        this.channel[i].source_addr = this.channel[i].source_addr & 0xFF00 | (data & 0xFF) << 0;
    }

    private void mmio_w43x3(int i, byte data) {
        this.channel[i].source_addr = this.channel[i].source_addr & 0xFF | (data & 0xFF) << 8;
    }

    private void mmio_w43x4(int i, byte data) {
        this.channel[i].source_bank = data & 0xFF;
    }

    private void mmio_w43x5(int i, byte data) {
        this.channel[i].transfer_size(this.channel[i].transfer_size() & 0xFF00 | (data & 0xFF) << 0);
    }

    private void mmio_w43x6(int i, byte data) {
        this.channel[i].transfer_size(this.channel[i].transfer_size() & 0xFF | (data & 0xFF) << 8);
    }

    private void mmio_w43x7(int i, byte data) {
        this.channel[i].indirect_bank = data & 0xFF;
    }

    private void mmio_w43x8(int i, byte data) {
        this.channel[i].hdma_addr = this.channel[i].hdma_addr & 0xFF00 | (data & 0xFF) << 0;
    }

    private void mmio_w43x9(int i, byte data) {
        this.channel[i].hdma_addr = this.channel[i].hdma_addr & 0xFF | (data & 0xFF) << 8;
    }

    private void mmio_w43xa(int i, byte data) {
        this.channel[i].line_counter = data & 0xFF;
    }

    private void mmio_w43xb(int i, byte data) {
        this.channel[i].unknown = data & 0xFF;
    }

    private int dma_counter() {
        return this.status.dma_counter + this.counter.hcounter() & 7;
    }

    final void add_clocks(int clocks) {
        this.status.irq_lock = false;
        this.ticks = clocks >> 1;
        while (this.ticks-- != 0) {
            this.counter.tick();
            if ((this.counter.hcounter() & 2) != 0) {
                this.poll_interrupts();
            }
            this.smpClocks += 2L;
            this.ppu_clk.clock(2L);
        }
        if (!this.status.dram_refreshed && this.counter.hcounter() >= this.status.dram_refresh_position) {
            this.status.dram_refreshed = true;
            this.add_clocks(40);
        }
    }

    private void alu_edge() {
        if (this.alu.mpyctr != 0) {
            --this.alu.mpyctr;
            if ((this.status.rddiv & 1) != 0) {
                this.status.rdmpy += this.alu.shift;
            }
            this.status.rddiv >>= 1;
            this.alu.shift <<= 1;
        }
        if (this.alu.divctr != 0) {
            --this.alu.divctr;
            this.status.rddiv <<= 1;
            this.alu.shift >>= 1;
            if (this.status.rdmpy >= this.alu.shift) {
                this.status.rdmpy -= this.alu.shift;
                this.status.rddiv |= 1;
            }
        }
    }

    void dma_edge() {
        if (this.status.dma_active) {
            if (this.status.hdma_pending) {
                this.status.hdma_pending = false;
                if (this.dma.hdma_enabled_channels() != 0) {
                    if (this.dma.dma_enabled_channels() == 0) {
                        this.dma.dma_add_clocks(8 - this.dma_counter());
                    }
                    if (!this.status.hdma_mode) {
                        this.dma.hdma_init();
                    } else {
                        this.dma.hdma_run();
                    }
                    if (this.dma.dma_enabled_channels() == 0) {
                        this.add_clocks(this.status.clock_count - this.status.dma_clocks % this.status.clock_count);
                        this.status.dma_active = false;
                    }
                }
            }
            if (this.status.dma_pending) {
                this.status.dma_pending = false;
                if (this.dma.dma_enabled_channels() != 0) {
                    this.dma.dma_add_clocks(8 - this.dma_counter());
                    this.dma.dma_run();
                    this.add_clocks(this.status.clock_count - this.status.dma_clocks % this.status.clock_count);
                    this.status.dma_active = false;
                }
            }
        }
        if (!this.status.hdma_init_triggered && this.counter.hcounter() >= this.status.hdma_init_position) {
            this.status.hdma_init_triggered = true;
            this.dma.hdma_init_reset();
            if (this.dma.hdma_enabled_channels() != 0) {
                this.status.hdma_pending = true;
                this.status.hdma_mode = false;
            }
        }
        if (!this.status.hdma_triggered && this.counter.hcounter() >= this.status.hdma_position) {
            this.status.hdma_triggered = true;
            if (this.dma.hdma_active_channels() != 0) {
                this.status.hdma_pending = true;
                this.status.hdma_mode = true;
            }
        }
        if (!this.status.dma_active && (this.status.dma_pending || this.status.hdma_pending)) {
            this.status.dma_clocks = 0;
            this.status.dma_active = true;
        }
    }

    private void timing_reset() {
        this.status.clock_count = 0;
        this.status.line_clocks = this.counter.lineclocks();
        this.status.irq_lock = false;
        this.status.dram_refresh_position = this.cpu_version == 1 ? 530 : 538;
        this.status.dram_refreshed = false;
        this.status.hdma_init_position = this.cpu_version == 1 ? 20 - this.dma_counter() : 12 + this.dma_counter();
        this.status.hdma_init_triggered = false;
        this.status.hdma_position = 1104;
        this.status.hdma_triggered = false;
        this.status.nmi_valid = false;
        this.status.nmi_line = false;
        this.status.nmi_transition = false;
        this.status.nmi_pending = false;
        this.status.nmi_hold = false;
        this.status.irq_valid = false;
        this.status.irq_line = false;
        this.status.irq_transition = false;
        this.status.irq_pending = false;
        this.status.irq_hold = false;
        this.status.reset_pending = true;
        this.status.interrupt_pending = true;
        this.status.interrupt_vector = 65532;
        this.status.dma_active = false;
        this.status.dma_counter = 0;
        this.status.dma_clocks = 0;
        this.status.dma_pending = false;
        this.status.hdma_pending = false;
        this.status.hdma_mode = false;
    }

    private final void poll_interrupts() {
        boolean irq_valid;
        boolean nmi_valid;
        if (this.status.nmi_hold) {
            this.status.nmi_hold = false;
            if (this.status.nmi_enabled) {
                this.status.nmi_transition = true;
            }
        }
        boolean bl = nmi_valid = this.counter.vcounter(2) >= (!this.ppu1bit.read1bit(1) ? 225 : 240);
        if (!this.status.nmi_valid && nmi_valid) {
            this.status.nmi_line = true;
            this.status.nmi_hold = true;
        } else if (this.status.nmi_valid && !nmi_valid) {
            this.status.nmi_line = false;
        }
        this.status.nmi_valid = nmi_valid;
        this.status.irq_hold = false;
        if (this.status.irq_line && (this.status.virq_enabled || this.status.hirq_enabled)) {
            this.status.irq_transition = true;
        }
        boolean bl2 = irq_valid = this.status.virq_enabled || this.status.hirq_enabled;
        if (irq_valid && (this.status.virq_enabled && this.counter.vcounter(10) != this.status.virq_pos || this.status.hirq_enabled && this.counter.hcounter(10) != (this.status.hirq_pos + 1) * 4 || this.status.virq_pos != 0 && this.counter.vcounter(6) == 0)) {
            irq_valid = false;
        }
        if (!this.status.irq_valid && irq_valid) {
            this.status.irq_line = true;
            this.status.irq_hold = true;
        }
        this.status.irq_valid = irq_valid;
    }

    private void nmitimen_update(byte data) {
        boolean nmi_enabled = this.status.nmi_enabled;
        this.status.nmi_enabled = (data & 0x80) != 0;
        this.status.virq_enabled = (data & 0x20) != 0;
        boolean bl = this.status.hirq_enabled = (data & 0x10) != 0;
        if (!nmi_enabled && this.status.nmi_enabled && this.status.nmi_line) {
            this.status.nmi_transition = true;
        }
        if (this.status.virq_enabled && !this.status.hirq_enabled && this.status.irq_line) {
            this.status.irq_transition = true;
        }
        if (!this.status.virq_enabled && !this.status.hirq_enabled) {
            this.status.irq_line = false;
            this.status.irq_transition = false;
        }
        this.status.irq_lock = true;
    }

    private boolean rdnmi() {
        boolean result = this.status.nmi_line;
        if (!this.status.nmi_hold) {
            this.status.nmi_line = false;
        }
        return result;
    }

    private boolean timeup() {
        boolean result = this.status.irq_line;
        if (!this.status.irq_hold) {
            this.status.irq_line = false;
            this.status.irq_transition = false;
        }
        return result;
    }

    private boolean nmi_test() {
        if (!this.status.nmi_transition) {
            return false;
        }
        this.status.nmi_transition = false;
        this.regs.wai = false;
        return true;
    }

    private boolean irq_test() {
        if (!this.status.irq_transition && !this.regs.irq) {
            return false;
        }
        this.status.irq_transition = false;
        this.regs.wai = false;
        return !this.regs.p.i;
    }

    private void run_auto_joypad_poll() {
        int joy1 = 0;
        int joy2 = 0;
        int joy3 = 0;
        int joy4 = 0;
        int i = 0;
        while (i < 16) {
            byte port0 = this.input_bus.read8bit(0);
            byte port1 = this.input_bus.read8bit(1);
            joy1 |= (port0 & 1) != 0 ? 32768 >> i : 0;
            joy2 |= (port1 & 1) != 0 ? 32768 >> i : 0;
            joy3 |= (port0 & 2) != 0 ? 32768 >> i : 0;
            joy4 |= (port1 & 2) != 0 ? 32768 >> i : 0;
            ++i;
        }
        this.status.joy1l = joy1 >> 0;
        this.status.joy1h = joy1 >> 8;
        this.status.joy2l = joy2 >> 0;
        this.status.joy2h = joy2 >> 8;
        this.status.joy3l = joy3 >> 0;
        this.status.joy3h = joy3 >> 8;
        this.status.joy4l = joy4 >> 0;
        this.status.joy4h = joy4 >> 8;
    }

    private void op_irq() {
        this.op_read(this.regs.pc.get());
        this.op_io();
        if (!this.regs.e) {
            this.op_writestack(this.regs.pc.b());
        }
        this.op_writestack(this.regs.pc.h());
        this.op_writestack(this.regs.pc.l());
        this.op_writestack(this.regs.e ? this.regs.p.get() & 0xFFFFFFEF : this.regs.p.get());
        this.rd.l(this.op_read(this.status.interrupt_vector + 0));
        this.regs.pc.b(0);
        this.regs.p.i = true;
        this.regs.p.d = false;
        this.rd.h(this.op_read(this.status.interrupt_vector + 1));
        this.regs.pc.w(this.rd.w());
    }
}

