/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.ppu;

import jario.hardware.Bus1bit;
import jario.hardware.Bus8bit;
import jario.hardware.BusDMA;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.snes.ppu.Background;
import jario.snes.ppu.Display;
import jario.snes.ppu.HVCounter;
import jario.snes.ppu.Regs;
import jario.snes.ppu.Screen;
import jario.snes.ppu.Sprite;
import jario.snes.ppu.Window;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PPU
implements Hardware,
Clockable,
Bus1bit,
Bus8bit,
BusDMA,
Configurable {
    public static final int NTSC = 0;
    public static final int PAL = 1;
    private int region;
    int[] vram;
    int[] oamram;
    int[] cgram;
    private long clock;
    int ticks;
    private int pc = 1;
    private int address = 1;
    private int pixel = 256;
    private boolean accuracy;
    private boolean requestAccuracy;
    Regs regs = new Regs();
    Background bg1;
    Background bg2;
    Background bg3;
    Background bg4;
    Sprite sprite;
    Window window;
    Screen screen;
    ByteBuffer output;
    private int ppu1_version = 1;
    private int ppu2_version = 3;
    Display display;
    HVCounter counter;

    public void connect(int port, Hardware hw) {
    }

    final void latch_counters() {
        this.regs.hcounter = this.counter.hdot() & 0xFFFF;
        this.regs.vcounter = this.counter.vcounter() & 0xFFFF;
        this.regs.counters_latched = true;
    }

    public boolean read1bit(int address) {
        switch (address) {
            case 0: {
                return this.display.interlace;
            }
            case 1: {
                return this.display.overscan;
            }
            case 2: {
                return this.display.hires;
            }
            case 3: {
                return this.counter.field();
            }
        }
        return false;
    }

    public void write1bit(int address, boolean data) {
        switch (address) {
            case 29: {
                if (this.display.latch != 0 && !data) {
                    this.latch_counters();
                }
                this.display.latch = data ? 1 : 0;
            }
        }
    }

    public final void clock(long clocks) {
        this.clock -= clocks;
        block10: while (this.clock < 0L) {
            if (this.accuracy) {
                switch (this.pc) {
                    case 0: {
                        this.counter.tick(2);
                        this.clock += 2L;
                        if (--this.ticks != 0) continue block10;
                        this.pc = this.address;
                        if (this.pc != 1) continue block10;
                        this.accuracy = this.requestAccuracy;
                        break;
                    }
                    case 1: {
                        this.scanline();
                        this.ticks = 14;
                        this.address = 2;
                        this.pc = 0;
                        break;
                    }
                    case 2: {
                        if (this.counter.vcounter() <= (!this.regs.overscan ? 224 : 239)) {
                            if (this.counter.vcounter() != 0) {
                                this.bg1.run(true);
                                this.bg2.run(true);
                                this.bg3.run(true);
                                this.bg4.run(true);
                            }
                            this.pixel = -7;
                            this.ticks = 1;
                            this.address = 7;
                        } else {
                            this.ticks = 601;
                            this.address = 5;
                        }
                        this.pc = 0;
                        break;
                    }
                    case 3: {
                        this.ticks = 7;
                        this.address = 4;
                        this.pc = 0;
                        break;
                    }
                    case 4: {
                        if (this.sprite.tilefetch_cycle()) {
                            if (this.ticks > 0) {
                                this.address = 5;
                            } else {
                                this.ticks = this.counter.lineclocks() - 1230 >> 1;
                                this.address = 1;
                            }
                        }
                        this.pc = 0;
                        break;
                    }
                    case 5: {
                        this.ticks = this.counter.lineclocks() - 1230 >> 1;
                        this.address = 1;
                        this.pc = 0;
                        break;
                    }
                    case 6: {
                        if (this.counter.vcounter() != 0) {
                            this.bg1.run(true);
                            this.bg2.run(true);
                            this.bg3.run(true);
                            this.bg4.run(true);
                        }
                        this.ticks = 1;
                        this.address = 7;
                        this.pc = 0;
                        break;
                    }
                    case 7: {
                        if (this.counter.vcounter() != 0) {
                            this.bg1.run(false);
                            this.bg2.run(false);
                            this.bg3.run(false);
                            this.bg4.run(false);
                        }
                        if (this.pixel >= 0) {
                            this.sprite.run();
                            this.window.run();
                            this.screen.run();
                        }
                        this.ticks = 1;
                        this.address = ++this.pixel <= 255 ? 6 : 3;
                        this.pc = 0;
                    }
                }
                continue;
            }
            this.scanline();
            this.add_clocks(60);
            if (this.counter.vcounter() <= (!this.regs.overscan ? 224 : 239)) {
                int pixel = -7;
                while (pixel <= 255) {
                    if (this.counter.vcounter() != 0) {
                        this.bg1.run(true);
                        this.bg2.run(true);
                        this.bg3.run(true);
                        this.bg4.run(true);
                    }
                    this.add_clocks(2);
                    if (this.counter.vcounter() != 0) {
                        this.bg1.run(false);
                        this.bg2.run(false);
                        this.bg3.run(false);
                        this.bg4.run(false);
                    }
                    if (pixel >= 0) {
                        this.sprite.run();
                        this.window.run();
                        this.screen.run();
                    }
                    this.add_clocks(2);
                    ++pixel;
                }
                this.add_clocks(22);
                this.sprite.tilefetch();
            } else {
                this.add_clocks(1210);
            }
            this.add_clocks(this.counter.lineclocks() - 1270);
            this.accuracy = this.requestAccuracy;
        }
    }

    private void power() {
        Arrays.fill(this.vram, 0);
        Arrays.fill(this.oamram, 0);
        Arrays.fill(this.cgram, 0);
        this.reset();
    }

    public void reset() {
        this.clock = 0L;
        this.pc = 1;
        if (this.counter != null) {
            this.counter.reset();
        }
        Arrays.fill(this.output.array(), (byte)0);
        this.mmio_reset();
        this.bg1.reset();
        this.bg2.reset();
        this.bg3.reset();
        this.bg4.reset();
        this.sprite.reset();
        this.window.reset();
        this.screen.reset();
        if (this.display != null) {
            this.display.latch = 1;
            this.display.hires = true;
            this.frame();
        }
    }

    public PPU() {
        this.vram = new int[65536];
        this.oamram = new int[544];
        this.cgram = new int[512];
        this.bg1 = new Background(this, 0);
        this.bg2 = new Background(this, 1);
        this.bg3 = new Background(this, 2);
        this.bg4 = new Background(this, 3);
        this.sprite = new Sprite(this);
        this.window = new Window(this);
        this.screen = new Screen(this);
        this.output = ByteBuffer.allocate(0x200000);
        this.display = new Display();
        this.display.latch = 1;
        this.display.hires = true;
        this.counter = new HVCounter(this);
        this.power();
    }

    private int get_vram_address() {
        int addr = this.regs.vram_addr;
        switch (this.regs.vram_mapping) {
            case 0: {
                break;
            }
            case 1: {
                addr = addr & 0xFF00 | (addr & 0x1F) << 3 | addr >> 5 & 7;
                break;
            }
            case 2: {
                addr = addr & 0xFE00 | (addr & 0x3F) << 3 | addr >> 6 & 7;
                break;
            }
            case 3: {
                addr = addr & 0xFC00 | (addr & 0x7F) << 3 | addr >> 7 & 7;
            }
        }
        return addr << 1 & 0xFFFF;
    }

    private int vram_read(int addr) {
        if (this.regs.display_disable || this.counter.vcounter() >= (!this.regs.overscan ? 225 : 240)) {
            return this.vram[addr];
        }
        return 0;
    }

    private void vram_write(int addr, int data) {
        if (this.regs.display_disable || this.counter.vcounter() >= (!this.regs.overscan ? 225 : 240)) {
            this.vram[addr] = data & 0xFF;
        }
    }

    private void mmio_update_video_mode() {
        switch (this.regs.bgmode) {
            case 0: {
                this.bg1.mode = 0;
                this.bg1.priority0 = 8;
                this.bg1.priority1 = 11;
                this.bg2.mode = 0;
                this.bg2.priority0 = 7;
                this.bg2.priority1 = 10;
                this.bg3.mode = 0;
                this.bg3.priority0 = 2;
                this.bg3.priority1 = 5;
                this.bg4.mode = 0;
                this.bg4.priority0 = 1;
                this.bg4.priority1 = 4;
                this.sprite.priority0 = 3;
                this.sprite.priority1 = 6;
                this.sprite.priority2 = 9;
                this.sprite.priority3 = 12;
                break;
            }
            case 1: {
                this.bg1.mode = 1;
                this.bg2.mode = 1;
                this.bg3.mode = 0;
                this.bg4.mode = 4;
                if (this.regs.bg3_priority) {
                    this.bg1.priority0 = 5;
                    this.bg1.priority1 = 8;
                    this.bg2.priority0 = 4;
                    this.bg2.priority1 = 7;
                    this.bg3.priority0 = 1;
                    this.bg3.priority1 = 10;
                    this.sprite.priority0 = 2;
                    this.sprite.priority1 = 3;
                    this.sprite.priority2 = 6;
                    this.sprite.priority3 = 9;
                    break;
                }
                this.bg1.priority0 = 6;
                this.bg1.priority1 = 9;
                this.bg2.priority0 = 5;
                this.bg2.priority1 = 8;
                this.bg3.priority0 = 1;
                this.bg3.priority1 = 3;
                this.sprite.priority0 = 2;
                this.sprite.priority1 = 4;
                this.sprite.priority2 = 7;
                this.sprite.priority3 = 10;
                break;
            }
            case 2: {
                this.bg1.mode = 1;
                this.bg2.mode = 1;
                this.bg3.mode = 4;
                this.bg4.mode = 4;
                this.bg1.priority0 = 3;
                this.bg1.priority1 = 7;
                this.bg2.priority0 = 1;
                this.bg2.priority1 = 5;
                this.sprite.priority0 = 2;
                this.sprite.priority1 = 4;
                this.sprite.priority2 = 6;
                this.sprite.priority3 = 8;
                break;
            }
            case 3: {
                this.bg1.mode = 2;
                this.bg2.mode = 1;
                this.bg3.mode = 4;
                this.bg4.mode = 4;
                this.bg1.priority0 = 3;
                this.bg1.priority1 = 7;
                this.bg2.priority0 = 1;
                this.bg2.priority1 = 5;
                this.sprite.priority0 = 2;
                this.sprite.priority1 = 4;
                this.sprite.priority2 = 6;
                this.sprite.priority3 = 8;
                break;
            }
            case 4: {
                this.bg1.mode = 2;
                this.bg2.mode = 0;
                this.bg3.mode = 4;
                this.bg4.mode = 4;
                this.bg1.priority0 = 3;
                this.bg1.priority1 = 7;
                this.bg2.priority0 = 1;
                this.bg2.priority1 = 5;
                this.sprite.priority0 = 2;
                this.sprite.priority1 = 4;
                this.sprite.priority2 = 6;
                this.sprite.priority3 = 8;
                break;
            }
            case 5: {
                this.bg1.mode = 1;
                this.bg2.mode = 0;
                this.bg3.mode = 4;
                this.bg4.mode = 4;
                this.bg1.priority0 = 3;
                this.bg1.priority1 = 7;
                this.bg2.priority0 = 1;
                this.bg2.priority1 = 5;
                this.sprite.priority0 = 2;
                this.sprite.priority1 = 4;
                this.sprite.priority2 = 6;
                this.sprite.priority3 = 8;
                break;
            }
            case 6: {
                this.bg1.mode = 1;
                this.bg2.mode = 4;
                this.bg3.mode = 4;
                this.bg4.mode = 4;
                this.bg1.priority0 = 2;
                this.bg1.priority1 = 5;
                this.sprite.priority0 = 1;
                this.sprite.priority1 = 3;
                this.sprite.priority2 = 4;
                this.sprite.priority3 = 6;
                break;
            }
            case 7: {
                if (!this.regs.mode7_extbg) {
                    this.bg1.mode = 3;
                    this.bg2.mode = 4;
                    this.bg3.mode = 4;
                    this.bg4.mode = 4;
                    this.bg1.priority0 = 2;
                    this.bg1.priority1 = 2;
                    this.sprite.priority0 = 1;
                    this.sprite.priority1 = 3;
                    this.sprite.priority2 = 4;
                    this.sprite.priority3 = 5;
                    break;
                }
                this.bg1.mode = 3;
                this.bg2.mode = 3;
                this.bg3.mode = 4;
                this.bg4.mode = 4;
                this.bg1.priority0 = 3;
                this.bg1.priority1 = 3;
                this.bg2.priority0 = 1;
                this.bg2.priority1 = 5;
                this.sprite.priority0 = 2;
                this.sprite.priority1 = 4;
                this.sprite.priority2 = 6;
                this.sprite.priority3 = 7;
            }
        }
    }

    private void mmio_w2100(int data) {
        if (this.regs.display_disable && this.counter.vcounter() == (!this.regs.overscan ? 225 : 240)) {
            this.sprite.address_reset();
        }
        this.regs.display_disable = (data & 0x80) != 0;
        this.regs.display_brightness = data & 0xF;
    }

    private void mmio_w2101(int data) {
        this.sprite.base_size = data >> 5 & 7;
        this.sprite.nameselect = data >> 3 & 3;
        this.sprite.tiledata_addr = (data & 3) << 14;
    }

    private void mmio_w2102(int data) {
        this.regs.oam_baseaddr = this.regs.oam_baseaddr & 0x200 | (data & 0xFF) << 1;
        this.sprite.address_reset();
    }

    private void mmio_w2103(int data) {
        this.regs.oam_priority = (data & 0x80) != 0;
        this.regs.oam_baseaddr = (data & 1) << 9 | this.regs.oam_baseaddr & 0x1FE;
        this.sprite.address_reset();
    }

    private void mmio_w2104(int data) {
        boolean latch = (this.regs.oam_addr & 1) != 0;
        int addr = this.regs.oam_addr;
        this.regs.oam_addr = this.regs.oam_addr + 1 & 0x3FF;
        if (!this.regs.display_disable && this.counter.vcounter() < (!this.regs.overscan ? 225 : 240)) {
            addr = this.regs.oam_iaddr & 0x3FF;
        }
        if ((addr & 0x200) != 0) {
            addr &= 0x21F;
        }
        if (!latch) {
            this.regs.oam_latchdata = data & 0xFF;
        }
        if ((addr & 0x200) != 0) {
            this.sprite.update(addr, data);
        } else if (latch) {
            this.sprite.update((addr & 0xFFFFFFFE) + 0, this.regs.oam_latchdata);
            this.sprite.update((addr & 0xFFFFFFFE) + 1, data);
        }
        this.sprite.set_first_sprite();
    }

    private void mmio_w2105(int data) {
        this.bg4.tile_size = (data & 0x80) != 0;
        this.bg3.tile_size = (data & 0x40) != 0;
        this.bg2.tile_size = (data & 0x20) != 0;
        this.bg1.tile_size = (data & 0x10) != 0;
        this.regs.bg3_priority = (data & 8) != 0;
        this.regs.bgmode = data & 7;
        this.mmio_update_video_mode();
    }

    private void mmio_w2106(int data) {
        int mosaic_size = data >> 4 & 0xF;
        this.bg4.mosaic = (data & 8) != 0 ? mosaic_size : 0;
        this.bg3.mosaic = (data & 4) != 0 ? mosaic_size : 0;
        this.bg2.mosaic = (data & 2) != 0 ? mosaic_size : 0;
        this.bg1.mosaic = (data & 1) != 0 ? mosaic_size : 0;
    }

    private void mmio_w2107(int data) {
        this.bg1.screen_addr = (data & 0x7C) << 9;
        this.bg1.screen_size = data & 3;
    }

    private void mmio_w2108(int data) {
        this.bg2.screen_addr = (data & 0x7C) << 9;
        this.bg2.screen_size = data & 3;
    }

    private void mmio_w2109(int data) {
        this.bg3.screen_addr = (data & 0x7C) << 9;
        this.bg3.screen_size = data & 3;
    }

    private void mmio_w210a(int data) {
        this.bg4.screen_addr = (data & 0x7C) << 9;
        this.bg4.screen_size = data & 3;
    }

    private void mmio_w210b(int data) {
        this.bg1.tiledata_addr = (data & 7) << 13;
        this.bg2.tiledata_addr = (data & 0x70) << 9;
    }

    private void mmio_w210c(int data) {
        this.bg3.tiledata_addr = (data & 7) << 13;
        this.bg4.tiledata_addr = (data & 0x70) << 9;
    }

    private void mmio_w210d(int data) {
        this.regs.mode7_hoffset = ((data & 0xFF) << 8 | this.regs.mode7_latchdata) & 0xFFFF;
        this.regs.mode7_latchdata = data & 0xFF;
        this.bg1.hoffset = (data & 0xFF) << 8 | this.regs.bgofs_latchdata & 0xFFFFFFF8 | this.bg1.hoffset >> 8 & 7;
        this.regs.bgofs_latchdata = data & 0xFF;
    }

    private void mmio_w210e(int data) {
        this.regs.mode7_voffset = ((data & 0xFF) << 8 | this.regs.mode7_latchdata) & 0xFFFF;
        this.regs.mode7_latchdata = data & 0xFF;
        this.bg1.voffset = (data & 0xFF) << 8 | this.regs.bgofs_latchdata;
        this.regs.bgofs_latchdata = data & 0xFF;
    }

    private void mmio_w210f(int data) {
        this.bg2.hoffset = (data & 0xFF) << 8 | this.regs.bgofs_latchdata & 0xFFFFFFF8 | this.bg2.hoffset >> 8 & 7;
        this.regs.bgofs_latchdata = data & 0xFF;
    }

    private void mmio_w2110(int data) {
        this.bg2.voffset = (data & 0xFF) << 8 | this.regs.bgofs_latchdata;
        this.regs.bgofs_latchdata = data & 0xFF;
    }

    private void mmio_w2111(int data) {
        this.bg3.hoffset = (data & 0xFF) << 8 | this.regs.bgofs_latchdata & 0xFFFFFFF8 | this.bg3.hoffset >> 8 & 7;
        this.regs.bgofs_latchdata = data & 0xFF;
    }

    private void mmio_w2112(int data) {
        this.bg3.voffset = (data & 0xFF) << 8 | this.regs.bgofs_latchdata;
        this.regs.bgofs_latchdata = data & 0xFF;
    }

    private void mmio_w2113(int data) {
        this.bg4.hoffset = (data & 0xFF) << 8 | this.regs.bgofs_latchdata & 0xFFFFFFF8 | this.bg4.hoffset >> 8 & 7;
        this.regs.bgofs_latchdata = data & 0xFF;
    }

    private void mmio_w2114(int data) {
        this.bg4.voffset = (data & 0xFF) << 8 | this.regs.bgofs_latchdata;
        this.regs.bgofs_latchdata = data & 0xFF;
    }

    private void mmio_w2115(int data) {
        this.regs.vram_incmode = (data & 0x80) != 0;
        this.regs.vram_mapping = data >> 2 & 3;
        switch (data & 3) {
            case 0: {
                this.regs.vram_incsize = 1;
                break;
            }
            case 1: {
                this.regs.vram_incsize = 32;
                break;
            }
            case 2: {
                this.regs.vram_incsize = 128;
                break;
            }
            case 3: {
                this.regs.vram_incsize = 128;
            }
        }
    }

    private void mmio_w2116(int data) {
        this.regs.vram_addr &= 0xFF00;
        this.regs.vram_addr |= (data & 0xFF) << 0;
        int addr = this.get_vram_address();
        this.regs.vram_readbuffer = this.vram_read(addr + 0) << 0;
        this.regs.vram_readbuffer |= this.vram_read(addr + 1) << 8;
    }

    private void mmio_w2117(int data) {
        this.regs.vram_addr &= 0xFF;
        this.regs.vram_addr |= (data & 0xFF) << 8;
        int addr = this.get_vram_address();
        this.regs.vram_readbuffer = this.vram_read(addr + 0) << 0;
        this.regs.vram_readbuffer |= this.vram_read(addr + 1) << 8;
    }

    private void mmio_w2118(int data) {
        int addr = this.get_vram_address() + 0;
        this.vram_write(addr, data);
        if (!this.regs.vram_incmode) {
            this.regs.vram_addr += this.regs.vram_incsize;
        }
    }

    private void mmio_w2119(int data) {
        int addr = this.get_vram_address() + 1;
        this.vram_write(addr, data);
        if (this.regs.vram_incmode) {
            this.regs.vram_addr += this.regs.vram_incsize;
        }
    }

    private void mmio_w211a(int data) {
        this.regs.mode7_repeat = data >> 6 & 3;
        this.regs.mode7_vflip = (data & 2) != 0;
        this.regs.mode7_hflip = (data & 1) != 0;
    }

    private void mmio_w211b(int data) {
        this.regs.m7a = ((data & 0xFF) << 8 | this.regs.mode7_latchdata) & 0xFFFF;
        this.regs.mode7_latchdata = data & 0xFF;
    }

    private void mmio_w211c(int data) {
        this.regs.m7b = ((data & 0xFF) << 8 | this.regs.mode7_latchdata) & 0xFFFF;
        this.regs.mode7_latchdata = data & 0xFF;
    }

    private void mmio_w211d(int data) {
        this.regs.m7c = ((data & 0xFF) << 8 | this.regs.mode7_latchdata) & 0xFFFF;
        this.regs.mode7_latchdata = data & 0xFF;
    }

    private void mmio_w211e(int data) {
        this.regs.m7d = ((data & 0xFF) << 8 | this.regs.mode7_latchdata) & 0xFFFF;
        this.regs.mode7_latchdata = data & 0xFF;
    }

    private void mmio_w211f(int data) {
        this.regs.m7x = ((data & 0xFF) << 8 | this.regs.mode7_latchdata) & 0xFFFF;
        this.regs.mode7_latchdata = data & 0xFF;
    }

    private void mmio_w2120(int data) {
        this.regs.m7y = ((data & 0xFF) << 8 | this.regs.mode7_latchdata) & 0xFFFF;
        this.regs.mode7_latchdata = data & 0xFF;
    }

    private void mmio_w2121(int data) {
        this.regs.cgram_addr = (data & 0xFF) << 1;
    }

    private void mmio_w2122(int data) {
        boolean latch = (this.regs.cgram_addr & 1) != 0;
        int addr = this.regs.cgram_addr;
        this.regs.cgram_addr = this.regs.cgram_addr + 1 & 0x1FF;
        if (!this.regs.display_disable && this.counter.vcounter() > 0 && this.counter.vcounter() < (!this.regs.overscan ? 225 : 240) && this.counter.hcounter() >= 88 && this.counter.hcounter() < 1096) {
            addr = this.regs.cgram_iaddr & 0x1FF;
        }
        if (!latch) {
            this.regs.cgram_latchdata = data & 0xFF;
        } else {
            this.cgram[(addr & 0xFFFFFFFE) + 0] = this.regs.cgram_latchdata & 0xFF;
            this.cgram[(addr & 0xFFFFFFFE) + 1] = data & 0x7F;
        }
    }

    private void mmio_w2123(int data) {
        this.window.bg2_two_enable = (data & 0x80) != 0;
        this.window.bg2_two_invert = (data & 0x40) != 0;
        this.window.bg2_one_enable = (data & 0x20) != 0;
        this.window.bg2_one_invert = (data & 0x10) != 0;
        this.window.bg1_two_enable = (data & 8) != 0;
        this.window.bg1_two_invert = (data & 4) != 0;
        this.window.bg1_one_enable = (data & 2) != 0;
        this.window.bg1_one_invert = (data & 1) != 0;
    }

    private void mmio_w2124(int data) {
        this.window.bg4_two_enable = (data & 0x80) != 0;
        this.window.bg4_two_invert = (data & 0x40) != 0;
        this.window.bg4_one_enable = (data & 0x20) != 0;
        this.window.bg4_one_invert = (data & 0x10) != 0;
        this.window.bg3_two_enable = (data & 8) != 0;
        this.window.bg3_two_invert = (data & 4) != 0;
        this.window.bg3_one_enable = (data & 2) != 0;
        this.window.bg3_one_invert = (data & 1) != 0;
    }

    private void mmio_w2125(int data) {
        this.window.col_two_enable = (data & 0x80) != 0;
        this.window.col_two_invert = (data & 0x40) != 0;
        this.window.col_one_enable = (data & 0x20) != 0;
        this.window.col_one_invert = (data & 0x10) != 0;
        this.window.oam_two_enable = (data & 8) != 0;
        this.window.oam_two_invert = (data & 4) != 0;
        this.window.oam_one_enable = (data & 2) != 0;
        this.window.oam_one_invert = (data & 1) != 0;
    }

    private void mmio_w2126(int data) {
        this.window.one_left = data & 0xFF;
    }

    private void mmio_w2127(int data) {
        this.window.one_right = data & 0xFF;
    }

    private void mmio_w2128(int data) {
        this.window.two_left = data & 0xFF;
    }

    private void mmio_w2129(int data) {
        this.window.two_right = data & 0xFF;
    }

    private void mmio_w212a(int data) {
        this.window.bg4_mask = data >> 6 & 3;
        this.window.bg3_mask = data >> 4 & 3;
        this.window.bg2_mask = data >> 2 & 3;
        this.window.bg1_mask = data >> 0 & 3;
    }

    private void mmio_w212b(int data) {
        this.window.col_mask = data >> 2 & 3;
        this.window.oam_mask = data >> 0 & 3;
    }

    private void mmio_w212c(int data) {
        this.sprite.main_enable = (data & 0x10) != 0;
        this.bg4.main_enable = (data & 8) != 0;
        this.bg3.main_enable = (data & 4) != 0;
        this.bg2.main_enable = (data & 2) != 0;
        this.bg1.main_enable = (data & 1) != 0;
    }

    private void mmio_w212d(int data) {
        this.sprite.sub_enable = (data & 0x10) != 0;
        this.bg4.sub_enable = (data & 8) != 0;
        this.bg3.sub_enable = (data & 4) != 0;
        this.bg2.sub_enable = (data & 2) != 0;
        this.bg1.sub_enable = (data & 1) != 0;
    }

    private void mmio_w212e(int data) {
        this.window.oam_main_enable = (data & 0x10) != 0;
        this.window.bg4_main_enable = (data & 8) != 0;
        this.window.bg3_main_enable = (data & 4) != 0;
        this.window.bg2_main_enable = (data & 2) != 0;
        this.window.bg1_main_enable = (data & 1) != 0;
    }

    private void mmio_w212f(int data) {
        this.window.oam_sub_enable = (data & 0x10) != 0;
        this.window.bg4_sub_enable = (data & 8) != 0;
        this.window.bg3_sub_enable = (data & 4) != 0;
        this.window.bg2_sub_enable = (data & 2) != 0;
        this.window.bg1_sub_enable = (data & 1) != 0;
    }

    private void mmio_w2130(int data) {
        this.window.col_main_mask = data >> 6 & 3;
        this.window.col_sub_mask = data >> 4 & 3;
        this.screen.addsub_mode = (data & 2) != 0;
        this.screen.direct_color = (data & 1) != 0;
    }

    private void mmio_w2131(int data) {
        this.screen.color_mode = (data & 0x80) != 0;
        this.screen.color_halve = (data & 0x40) != 0;
        this.screen.back_color_enable = (data & 0x20) != 0;
        this.screen.oam_color_enable = (data & 0x10) != 0;
        this.screen.bg4_color_enable = (data & 8) != 0;
        this.screen.bg3_color_enable = (data & 4) != 0;
        this.screen.bg2_color_enable = (data & 2) != 0;
        this.screen.bg1_color_enable = (data & 1) != 0;
    }

    private void mmio_w2132(int data) {
        if ((data & 0x80) != 0) {
            this.screen.color_b = data & 0x1F;
        }
        if ((data & 0x40) != 0) {
            this.screen.color_g = data & 0x1F;
        }
        if ((data & 0x20) != 0) {
            this.screen.color_r = data & 0x1F;
        }
    }

    private void mmio_w2133(int data) {
        this.regs.mode7_extbg = (data & 0x40) != 0;
        this.regs.pseudo_hires = (data & 8) != 0;
        this.regs.overscan = (data & 4) != 0;
        this.sprite.interlace = (data & 2) != 0;
        this.regs.interlace = (data & 1) != 0;
        this.mmio_update_video_mode();
    }

    private int mmio_r2134() {
        int result = (short)this.regs.m7a * (byte)(this.regs.m7b >> 8);
        this.regs.ppu1_mdr = result >> 0 & 0xFF;
        return this.regs.ppu1_mdr;
    }

    private int mmio_r2135() {
        int result = (short)this.regs.m7a * (byte)(this.regs.m7b >> 8);
        this.regs.ppu1_mdr = result >> 8 & 0xFF;
        return this.regs.ppu1_mdr;
    }

    private int mmio_r2136() {
        int result = (short)this.regs.m7a * (byte)(this.regs.m7b >> 8);
        this.regs.ppu1_mdr = result >> 16 & 0xFF;
        return this.regs.ppu1_mdr;
    }

    private int mmio_r2137() {
        if (this.display.latch != 0) {
            this.latch_counters();
        }
        return this.regs.ppu1_mdr;
    }

    private int mmio_r2138() {
        int addr = this.regs.oam_addr;
        this.regs.oam_addr = this.regs.oam_addr + 1 & 0x3FF;
        if (!this.regs.display_disable && this.counter.vcounter() < (!this.regs.overscan ? 225 : 240)) {
            addr = this.regs.oam_iaddr & 0x3FF;
        }
        if ((addr & 0x200) != 0) {
            addr &= 0x21F;
        }
        this.regs.ppu1_mdr = this.oamram[addr];
        this.sprite.set_first_sprite();
        return this.regs.ppu1_mdr;
    }

    private int mmio_r2139() {
        int addr = this.get_vram_address() + 0;
        this.regs.ppu1_mdr = this.regs.vram_readbuffer >> 0 & 0xFF;
        if (!this.regs.vram_incmode) {
            this.regs.vram_readbuffer = this.vram_read((addr &= 0xFFFE) + 0) << 0;
            this.regs.vram_readbuffer |= this.vram_read(addr + 1) << 8;
            this.regs.vram_addr += this.regs.vram_incsize;
        }
        return this.regs.ppu1_mdr;
    }

    private int mmio_r213a() {
        int addr = this.get_vram_address() + 1;
        this.regs.ppu1_mdr = this.regs.vram_readbuffer >> 8 & 0xFF;
        if (this.regs.vram_incmode) {
            this.regs.vram_readbuffer = this.vram_read((addr &= 0xFFFE) + 0) << 0;
            this.regs.vram_readbuffer |= this.vram_read(addr + 1) << 8;
            this.regs.vram_addr += this.regs.vram_incsize;
        }
        return this.regs.ppu1_mdr;
    }

    private int mmio_r213b() {
        boolean latch = (this.regs.cgram_addr & 1) != 0;
        int addr = this.regs.cgram_addr++;
        this.regs.cgram_addr &= 0x1FF;
        if (!this.regs.display_disable && this.counter.vcounter() > 0 && this.counter.vcounter() < (!this.regs.overscan ? 225 : 240) && this.counter.hcounter() >= 88 && this.counter.hcounter() < 1096) {
            addr = this.regs.cgram_iaddr;
        }
        if (!latch) {
            this.regs.ppu2_mdr = this.cgram[addr];
        } else {
            this.regs.ppu2_mdr &= 0x80;
            this.regs.ppu2_mdr |= this.cgram[addr];
        }
        return this.regs.ppu2_mdr;
    }

    private int mmio_r213c() {
        if (!this.regs.latch_hcounter) {
            this.regs.ppu2_mdr = this.regs.hcounter >> 0 & 0xFF;
        } else {
            this.regs.ppu2_mdr &= 0xFE;
            this.regs.ppu2_mdr |= this.regs.hcounter >> 8 & 1;
        }
        this.regs.latch_hcounter = this.regs.latch_hcounter ^ true;
        return this.regs.ppu2_mdr;
    }

    private int mmio_r213d() {
        if (!this.regs.latch_vcounter) {
            this.regs.ppu2_mdr = this.regs.vcounter >> 0 & 0xFF;
        } else {
            this.regs.ppu2_mdr &= 0xFE;
            this.regs.ppu2_mdr |= this.regs.vcounter >> 8 & 1;
        }
        this.regs.latch_vcounter = this.regs.latch_vcounter ^ true;
        return this.regs.ppu2_mdr;
    }

    private int mmio_r213e() {
        this.regs.ppu1_mdr &= 0x10;
        this.regs.ppu1_mdr = this.regs.ppu1_mdr | (this.sprite.time_over ? 1 : 0) << 7;
        this.regs.ppu1_mdr = this.regs.ppu1_mdr | (this.sprite.range_over ? 1 : 0) << 6;
        this.regs.ppu1_mdr |= this.ppu1_version & 0xF;
        return this.regs.ppu1_mdr;
    }

    private int mmio_r213f() {
        this.regs.latch_hcounter = false;
        this.regs.latch_vcounter = false;
        this.regs.ppu2_mdr &= 0x20;
        this.regs.ppu2_mdr = this.regs.ppu2_mdr | (this.counter.field() ? 1 : 0) << 7;
        if (this.display.latch == 0) {
            this.regs.ppu2_mdr |= 0x40;
        } else if (this.regs.counters_latched) {
            this.regs.ppu2_mdr |= 0x40;
            this.regs.counters_latched = false;
        }
        this.regs.ppu2_mdr = this.regs.ppu2_mdr | (this.region == 0 ? 0 : 1) << 4;
        this.regs.ppu2_mdr |= this.ppu2_version & 0xF;
        return this.regs.ppu2_mdr;
    }

    private void mmio_reset() {
        this.regs.ppu1_mdr = 255;
        this.regs.ppu2_mdr = 255;
        this.regs.vram_readbuffer = 0;
        this.regs.oam_latchdata = 0;
        this.regs.cgram_latchdata = 0;
        this.regs.bgofs_latchdata = 0;
        this.regs.mode7_latchdata = 0;
        this.regs.counters_latched = false;
        this.regs.latch_hcounter = false;
        this.regs.latch_vcounter = false;
        this.regs.oam_iaddr = 0;
        this.regs.cgram_iaddr = 0;
        this.regs.display_disable = true;
        this.regs.display_brightness = 0;
        this.regs.oam_baseaddr = 0;
        this.regs.oam_addr = 0;
        this.regs.oam_priority = false;
        this.regs.bg3_priority = false;
        this.regs.bgmode = 0;
        this.regs.mode7_hoffset = 0;
        this.regs.mode7_voffset = 0;
        this.regs.vram_incmode = true;
        this.regs.vram_mapping = 0;
        this.regs.vram_incsize = 1;
        this.regs.vram_addr = 0;
        this.regs.mode7_repeat = 0;
        this.regs.mode7_vflip = false;
        this.regs.mode7_hflip = false;
        this.regs.m7a = 0;
        this.regs.m7b = 0;
        this.regs.m7c = 0;
        this.regs.m7d = 0;
        this.regs.m7x = 0;
        this.regs.m7y = 0;
        this.regs.cgram_addr = 0;
        this.regs.mode7_extbg = false;
        this.regs.pseudo_hires = false;
        this.regs.overscan = false;
        this.regs.interlace = false;
        this.regs.hcounter = 0;
        this.regs.vcounter = 0;
    }

    public byte read8bit(int addr) {
        switch (addr & 0xFFFF) {
            case 8500: {
                return (byte)this.mmio_r2134();
            }
            case 8501: {
                return (byte)this.mmio_r2135();
            }
            case 8502: {
                return (byte)this.mmio_r2136();
            }
            case 8503: {
                return (byte)this.mmio_r2137();
            }
            case 8504: {
                return (byte)this.mmio_r2138();
            }
            case 8505: {
                return (byte)this.mmio_r2139();
            }
            case 8506: {
                return (byte)this.mmio_r213a();
            }
            case 8507: {
                return (byte)this.mmio_r213b();
            }
            case 8508: {
                return (byte)this.mmio_r213c();
            }
            case 8509: {
                return (byte)this.mmio_r213d();
            }
            case 8510: {
                return (byte)this.mmio_r213e();
            }
            case 8511: {
                return (byte)this.mmio_r213f();
            }
        }
        return (byte)this.regs.ppu1_mdr;
    }

    public void write8bit(int addr, byte data) {
        switch (addr & 0xFFFF) {
            case 8448: {
                this.mmio_w2100(data);
                return;
            }
            case 8449: {
                this.mmio_w2101(data);
                return;
            }
            case 8450: {
                this.mmio_w2102(data);
                return;
            }
            case 8451: {
                this.mmio_w2103(data);
                return;
            }
            case 8452: {
                this.mmio_w2104(data);
                return;
            }
            case 8453: {
                this.mmio_w2105(data);
                return;
            }
            case 8454: {
                this.mmio_w2106(data);
                return;
            }
            case 8455: {
                this.mmio_w2107(data);
                return;
            }
            case 8456: {
                this.mmio_w2108(data);
                return;
            }
            case 8457: {
                this.mmio_w2109(data);
                return;
            }
            case 8458: {
                this.mmio_w210a(data);
                return;
            }
            case 8459: {
                this.mmio_w210b(data);
                return;
            }
            case 8460: {
                this.mmio_w210c(data);
                return;
            }
            case 8461: {
                this.mmio_w210d(data);
                return;
            }
            case 8462: {
                this.mmio_w210e(data);
                return;
            }
            case 8463: {
                this.mmio_w210f(data);
                return;
            }
            case 8464: {
                this.mmio_w2110(data);
                return;
            }
            case 8465: {
                this.mmio_w2111(data);
                return;
            }
            case 8466: {
                this.mmio_w2112(data);
                return;
            }
            case 8467: {
                this.mmio_w2113(data);
                return;
            }
            case 8468: {
                this.mmio_w2114(data);
                return;
            }
            case 8469: {
                this.mmio_w2115(data);
                return;
            }
            case 8470: {
                this.mmio_w2116(data);
                return;
            }
            case 8471: {
                this.mmio_w2117(data);
                return;
            }
            case 8472: {
                this.mmio_w2118(data);
                return;
            }
            case 8473: {
                this.mmio_w2119(data);
                return;
            }
            case 8474: {
                this.mmio_w211a(data);
                return;
            }
            case 8475: {
                this.mmio_w211b(data);
                return;
            }
            case 8476: {
                this.mmio_w211c(data);
                return;
            }
            case 8477: {
                this.mmio_w211d(data);
                return;
            }
            case 8478: {
                this.mmio_w211e(data);
                return;
            }
            case 8479: {
                this.mmio_w211f(data);
                return;
            }
            case 8480: {
                this.mmio_w2120(data);
                return;
            }
            case 8481: {
                this.mmio_w2121(data);
                return;
            }
            case 8482: {
                this.mmio_w2122(data);
                return;
            }
            case 8483: {
                this.mmio_w2123(data);
                return;
            }
            case 8484: {
                this.mmio_w2124(data);
                return;
            }
            case 8485: {
                this.mmio_w2125(data);
                return;
            }
            case 8486: {
                this.mmio_w2126(data);
                return;
            }
            case 8487: {
                this.mmio_w2127(data);
                return;
            }
            case 8488: {
                this.mmio_w2128(data);
                return;
            }
            case 8489: {
                this.mmio_w2129(data);
                return;
            }
            case 8490: {
                this.mmio_w212a(data);
                return;
            }
            case 8491: {
                this.mmio_w212b(data);
                return;
            }
            case 8492: {
                this.mmio_w212c(data);
                return;
            }
            case 8493: {
                this.mmio_w212d(data);
                return;
            }
            case 8494: {
                this.mmio_w212e(data);
                return;
            }
            case 8495: {
                this.mmio_w212f(data);
                return;
            }
            case 8496: {
                this.mmio_w2130(data);
                return;
            }
            case 8497: {
                this.mmio_w2131(data);
                return;
            }
            case 8498: {
                this.mmio_w2132(data);
                return;
            }
            case 8499: {
                this.mmio_w2133(data);
                return;
            }
        }
    }

    final void add_clocks(int clocks) {
        clocks >>= 1;
        while (clocks-- != 0) {
            this.counter.tick(2);
            this.clock += 2L;
        }
    }

    private final void scanline() {
        if (this.counter.vcounter() == 0) {
            this.frame();
        }
        this.bg1.scanline();
        this.bg2.scanline();
        this.bg3.scanline();
        this.bg4.scanline();
        this.sprite.scanline();
        this.window.scanline();
        this.screen.scanline();
    }

    private final void frame() {
        this.sprite.frame();
        this.display.interlace = this.regs.interlace;
        this.display.overscan = this.regs.overscan;
    }

    public Object readConfig(String key) {
        if (key.equals("accuracy")) {
            return this.accuracy;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("region")) {
            this.counter.region = value.toString().equals("ntsc") ? 0 : 1;
            this.region = this.counter.region;
        } else if (key.equals("ppu1 version")) {
            this.ppu1_version = (Integer)value;
        } else if (key.equals("ppu2 version")) {
            this.ppu1_version = (Integer)value;
        } else if (key.equals("accuracy")) {
            this.requestAccuracy = (Boolean)value;
        }
    }

    public void readDMA(int address, ByteBuffer data, int offset, int length) {
        System.arraycopy(this.output.array(), 0, data.array(), offset, length);
    }

    public void writeDMA(int address, ByteBuffer data, int offset, int length) {
    }

    static class Output {
        public Pixel main = new Pixel();
        public Pixel sub = new Pixel();
        public int id;

        public Output(int id) {
            this.id = id;
        }

        static class Pixel {
            public int priority;
            public int palette;
            public int tile;

            Pixel() {
            }
        }
    }
}

