/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.ppu;

import jario.snes.ppu.PPU;
import jario.snes.ppu.SpriteItem;
import jario.snes.ppu.State;
import jario.snes.ppu.TileItem;
import java.util.Arrays;

public class Sprite {
    public boolean main_enable;
    public boolean sub_enable;
    public boolean interlace;
    public int base_size;
    public int nameselect;
    public int tiledata_addr;
    public int first_sprite;
    public int priority0;
    public int priority1;
    public int priority2;
    public int priority3;
    public boolean time_over;
    public boolean range_over;
    public int output_main_priority;
    public int output_main_palette;
    public int output_sub_priority;
    public int output_sub_palette;
    private PPU self;
    private int[] oamram;
    private int[] vram;
    private SpriteItem[] list = new SpriteItem[128];
    private State t = new State();
    int i = 31;
    int tx = 0;

    public final void update(int addr, int data) {
        this.oamram[addr] = data & 0xFF;
        if (addr < 512) {
            int n = addr >> 2;
            if ((addr &= 3) == 0) {
                this.list[n].x = this.list[n].x & 0x100 | data & 0xFF;
            } else if (addr == 1) {
                this.list[n].y = data & 0xFF;
            } else if (addr == 2) {
                this.list[n].character = data & 0xFF;
            } else {
                this.list[n].vflip = (data & 0x80) != 0;
                this.list[n].hflip = (data & 0x40) != 0;
                this.list[n].priority = data >> 4 & 3;
                this.list[n].palette = data >> 1 & 7;
                this.list[n].nameselect = (data & 1) != 0;
            }
        } else {
            int n = (addr & 0x1F) << 2;
            this.list[n + 0].x = (data & 1) << 8 | this.list[n + 0].x & 0xFF;
            this.list[n + 0].size = (data & 2) != 0;
            this.list[n + 1].x = (data & 4) << 6 | this.list[n + 1].x & 0xFF;
            this.list[n + 1].size = (data & 8) != 0;
            this.list[n + 2].x = (data & 0x10) << 4 | this.list[n + 2].x & 0xFF;
            this.list[n + 2].size = (data & 0x20) != 0;
            this.list[n + 3].x = (data & 0x40) << 2 | this.list[n + 3].x & 0xFF;
            this.list[n + 3].size = (data & 0x80) != 0;
        }
    }

    public final void address_reset() {
        this.self.regs.oam_addr = this.self.regs.oam_baseaddr & 0x3FF;
        this.set_first_sprite();
    }

    public final void set_first_sprite() {
        this.first_sprite = !this.self.regs.oam_priority ? 0 : this.self.regs.oam_addr >> 2 & 0x7F;
    }

    public final void frame() {
        this.time_over = false;
        this.range_over = false;
    }

    public final void scanline() {
        this.t.x = 0;
        this.t.y = this.self.counter.vcounter();
        this.t.item_count = 0;
        this.t.tile_count = 0;
        this.t.active = !this.t.active;
        int[] oam_item = this.t.item[this.t.active ? 1 : 0];
        TileItem[] oam_tile = this.t.tile[this.t.active ? 1 : 0];
        if (this.t.y == (!this.self.regs.overscan ? 225 : 240) && !this.self.regs.display_disable) {
            this.address_reset();
        }
        if (this.t.y >= (!this.self.regs.overscan ? 224 : 239)) {
            return;
        }
        Arrays.fill(oam_item, 0, 32, 255);
        int i = 0;
        while (i < 34) {
            oam_tile[i].x = 65535;
            ++i;
        }
        i = 0;
        while (i < 128) {
            int sprite = this.first_sprite + i & 0x7F;
            if (this.on_scanline(this.list[sprite])) {
                if (this.t.item_count++ >= 32) break;
                oam_item[this.t.item_count - 1] = sprite;
            }
            ++i;
        }
        if (this.t.item_count > 0 && this.t.item_count > oam_item.length) {
            this.self.regs.oam_iaddr = 512;
        } else if (this.t.item_count > 0 && oam_item[this.t.item_count - 1] != 255) {
            this.self.regs.oam_iaddr = 512 + (oam_item[this.t.item_count - 1] >> 2) & 0x3FF;
        }
    }

    public final void run() {
        this.output_main_priority = 0;
        this.output_sub_priority = 0;
        TileItem[] oam_tile = this.t.tile[!this.t.active ? 1 : 0];
        int[] priority_table = new int[]{this.priority0, this.priority1, this.priority2, this.priority3};
        int x = this.t.x++;
        int n = 0;
        while (n < 34) {
            TileItem tile = oam_tile[n];
            if (tile.x == 65535) break;
            int px = x - Sprite.sclip(9, tile.x);
            if ((px & 0xFFFFFFF8) == 0) {
                int mask = 128 >> (!tile.hflip ? px : 7 - px);
                int color = ((tile.d0 & mask) != 0 ? 1 : 0) << 0;
                color |= ((tile.d1 & mask) != 0 ? 1 : 0) << 1;
                color |= ((tile.d2 & mask) != 0 ? 1 : 0) << 2;
                if ((color |= ((tile.d3 & mask) != 0 ? 1 : 0) << 3) != 0) {
                    if (this.main_enable) {
                        this.output_main_palette = tile.palette + color & 0xFF;
                        this.output_main_priority = priority_table[tile.priority];
                    }
                    if (this.sub_enable) {
                        this.output_sub_palette = tile.palette + color & 0xFF;
                        this.output_sub_priority = priority_table[tile.priority];
                    }
                }
            }
            ++n;
        }
    }

    public final boolean tilefetch_cycle() {
        int[] oam_item = this.t.item[this.t.active ? 1 : 0];
        TileItem[] oam_tile = this.t.tile[this.t.active ? 1 : 0];
        while (this.i >= 0) {
            if (oam_item[this.i] == 255) {
                --this.i;
                continue;
            }
            SpriteItem sprite = this.list[oam_item[this.i]];
            int tile_width = sprite.width(this.base_size) >> 3;
            int x = sprite.x;
            int y = this.t.y - sprite.y & 0xFF;
            if (this.interlace) {
                y <<= 1;
            }
            if (sprite.vflip) {
                y = sprite.width(this.base_size) == sprite.height(this.base_size, this.interlace) ? sprite.height(this.base_size, this.interlace) - 1 - y : (y < sprite.width(this.base_size) ? sprite.width(this.base_size) - 1 - y : sprite.width(this.base_size) + (sprite.width(this.base_size) - 1 - (y - sprite.width(this.base_size))));
            }
            if (this.interlace) {
                y = !sprite.vflip ? y + (this.self.counter.field() ? 1 : 0) : y - (this.self.counter.field() ? 1 : 0);
            }
            x &= 0x1FF;
            y &= 0xFF;
            int tiledata_addr_ = this.tiledata_addr;
            int chrx = sprite.character >> 0 & 0xF;
            int chry = sprite.character >> 4 & 0xF;
            if (sprite.nameselect) {
                tiledata_addr_ += 8192 + (this.nameselect << 13);
            }
            chry += y >> 3;
            chry &= 0xF;
            chry <<= 4;
            while (this.tx < tile_width) {
                int sx = x + (this.tx << 3) & 0x1FF;
                if (x != 256 && sx >= 256 && sx + 7 < 512) {
                    ++this.tx;
                    continue;
                }
                if (this.t.tile_count++ >= 34) break;
                int n = this.t.tile_count - 1;
                oam_tile[n].x = sx;
                oam_tile[n].priority = sprite.priority;
                oam_tile[n].palette = 128 + (sprite.palette << 4);
                oam_tile[n].hflip = sprite.hflip;
                int mx = !sprite.hflip ? this.tx : tile_width - 1 - this.tx;
                int pos = tiledata_addr_ + (chry + (chrx + mx & 0xF) << 5);
                int addr = (pos & 0xFFE0) + (y & 7) * 2;
                oam_tile[n].d0 = this.vram[addr + 0];
                oam_tile[n].d1 = this.vram[addr + 1];
                oam_tile[n].d2 = this.vram[addr + 16];
                oam_tile[n].d3 = this.vram[addr + 17];
                this.self.ticks = 2;
                ++this.tx;
                if (this.tx >= tile_width) {
                    --this.i;
                    this.tx = 0;
                }
                return false;
            }
            --this.i;
            this.tx = 0;
        }
        this.i = 31;
        if (this.t.tile_count < 34) {
            this.self.ticks = (34 - this.t.tile_count) * 4 >> 1;
        }
        this.time_over |= this.t.tile_count > 34;
        this.range_over |= this.t.item_count > 32;
        return true;
    }

    final void tilefetch() {
        int[] oam_item = this.t.item[this.t.active ? 1 : 0];
        TileItem[] oam_tile = this.t.tile[this.t.active ? 1 : 0];
        int i = 31;
        while (i >= 0) {
            if (oam_item[i] != 255) {
                SpriteItem sprite = this.list[oam_item[i]];
                int tile_width = sprite.width(this.base_size) >> 3;
                int x = sprite.x;
                int y = this.t.y - sprite.y & 0xFF;
                if (this.interlace) {
                    y <<= 1;
                }
                if (sprite.vflip) {
                    y = sprite.width(this.base_size) == sprite.height(this.base_size, this.interlace) ? sprite.height(this.base_size, this.interlace) - 1 - y : (y < sprite.width(this.base_size) ? sprite.width(this.base_size) - 1 - y : sprite.width(this.base_size) + (sprite.width(this.base_size) - 1 - (y - sprite.width(this.base_size))));
                }
                if (this.interlace) {
                    y = !sprite.vflip ? y + (this.self.counter.field() ? 1 : 0) : y - (this.self.counter.field() ? 1 : 0);
                }
                x &= 0x1FF;
                y &= 0xFF;
                int tiledata_addr_ = this.tiledata_addr;
                int chrx = sprite.character >> 0 & 0xF;
                int chry = sprite.character >> 4 & 0xF;
                if (sprite.nameselect) {
                    tiledata_addr_ += 8192 + (this.nameselect << 13);
                }
                chry += y >> 3;
                chry &= 0xF;
                chry <<= 4;
                int tx = 0;
                while (tx < tile_width) {
                    int sx = x + (tx << 3) & 0x1FF;
                    if (x == 256 || sx < 256 || sx + 7 >= 512) {
                        if (this.t.tile_count++ >= 34) break;
                        int n = this.t.tile_count - 1;
                        oam_tile[n].x = sx;
                        oam_tile[n].priority = sprite.priority;
                        oam_tile[n].palette = 128 + (sprite.palette << 4);
                        oam_tile[n].hflip = sprite.hflip;
                        int mx = !sprite.hflip ? tx : tile_width - 1 - tx;
                        int pos = tiledata_addr_ + (chry + (chrx + mx & 0xF) << 5);
                        int addr = (pos & 0xFFE0) + (y & 7) * 2;
                        oam_tile[n].d0 = this.vram[addr];
                        oam_tile[n].d1 = this.vram[addr + 1];
                        this.self.add_clocks(2);
                        oam_tile[n].d2 = this.vram[addr + 16];
                        oam_tile[n].d3 = this.vram[addr + 17];
                        this.self.add_clocks(2);
                    }
                    ++tx;
                }
            }
            --i;
        }
        if (this.t.tile_count < 34) {
            this.self.add_clocks((34 - this.t.tile_count) * 4);
        }
        this.time_over |= this.t.tile_count > 34;
        this.range_over |= this.t.item_count > 32;
    }

    public void reset() {
        int i = 0;
        while (i < 128) {
            this.list[i].x = 0;
            this.list[i].y = 0;
            this.list[i].character = 0;
            this.list[i].nameselect = false;
            this.list[i].vflip = false;
            this.list[i].hflip = false;
            this.list[i].priority = 0;
            this.list[i].palette = 0;
            this.list[i].size = false;
            ++i;
        }
        this.t.x = 0;
        this.t.y = 0;
        this.t.item_count = 0;
        this.t.tile_count = 0;
        this.t.active = false;
        int n = 0;
        while (n < 2) {
            Arrays.fill(this.t.item[n], 0);
            int i2 = 0;
            while (i2 < 34) {
                this.t.tile[n][i2].x = 0;
                this.t.tile[n][i2].priority = 0;
                this.t.tile[n][i2].palette = 0;
                this.t.tile[n][i2].hflip = false;
                this.t.tile[n][i2].d0 = 0;
                this.t.tile[n][i2].d1 = 0;
                this.t.tile[n][i2].d2 = 0;
                this.t.tile[n][i2].d3 = 0;
                ++i2;
            }
            ++n;
        }
        this.main_enable = false;
        this.sub_enable = false;
        this.interlace = false;
        this.base_size = 0;
        this.nameselect = 0;
        this.tiledata_addr = 0;
        this.first_sprite = 0;
        this.priority0 = 0;
        this.priority1 = 0;
        this.priority2 = 0;
        this.priority3 = 0;
        this.time_over = false;
        this.range_over = false;
        this.output_main_palette = 0;
        this.output_main_priority = 0;
        this.output_sub_palette = 0;
        this.output_sub_priority = 0;
    }

    public Sprite(PPU self_) {
        this.self = self_;
        this.oamram = this.self.oamram;
        this.vram = this.self.vram;
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = new SpriteItem();
            ++i;
        }
    }

    private final boolean on_scanline(SpriteItem sprite) {
        int height;
        if (sprite.x > 256 && sprite.x + sprite.width(this.base_size) - 1 < 512) {
            return false;
        }
        int n = height = !this.interlace ? sprite.height(this.base_size, this.interlace) : sprite.height(this.base_size, this.interlace) >> 1;
        if (this.t.y >= sprite.y && this.t.y < sprite.y + height) {
            return true;
        }
        return sprite.y + height >= 256 && this.t.y < (sprite.y + height & 0xFF);
    }

    private static final int sclip(int bits, int x) {
        int b = 1 << bits - 1;
        int m = (1 << bits) - 1;
        return (x & m ^ b) - b;
    }
}

