/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.cpu;

import jario.hardware.Bus1bit;

public class HVCounter {
    Bus1bit ppu1bit;
    private Status status = new Status();
    private History history = new History();
    Runnable scanline;
    int region;

    final void tick() {
        this.status.hcounter += 2;
        if (this.status.hcounter >= 1360 && this.status.hcounter == this.lineclocks()) {
            this.status.hcounter = 0;
            this.vcounter_tick();
        }
        this.history.index = this.history.index + 1 & 0x7FF;
        this.history.field[this.history.index] = this.status.field;
        this.history.vcounter[this.history.index] = this.status.vcounter;
        this.history.hcounter[this.history.index] = this.status.hcounter;
    }

    final boolean field() {
        return this.status.field;
    }

    final int vcounter() {
        return this.status.vcounter;
    }

    final int hcounter() {
        return this.status.hcounter;
    }

    final boolean field(int offset) {
        return this.history.field[this.history.index - (offset >> 1) & 0x7FF];
    }

    final int vcounter(int offset) {
        return this.history.vcounter[this.history.index - (offset >> 1) & 0x7FF];
    }

    final int hcounter(int offset) {
        return this.history.hcounter[this.history.index - (offset >> 1) & 0x7FF];
    }

    final int hdot() {
        if (this.region == 0 && !this.status.interlace && this.status.vcounter == 240 && this.status.field) {
            return this.status.hcounter >> 2;
        }
        return this.status.hcounter - ((this.status.hcounter > 1292 ? 1 : 0) << 1) - ((this.status.hcounter > 1310 ? 1 : 0) << 1) >> 2;
    }

    final int lineclocks() {
        if (this.region == 0 && !this.status.interlace && this.status.vcounter == 240 && this.status.field) {
            return 1360;
        }
        return 1364;
    }

    void reset() {
        this.status.interlace = false;
        this.status.field = false;
        this.status.vcounter = 0;
        this.status.hcounter = 0;
        this.history.index = 0;
        int i = 0;
        while (i < 2048) {
            this.history.field[i] = false;
            this.history.vcounter[i] = 0;
            this.history.hcounter[i] = 0;
            ++i;
        }
    }

    private void vcounter_tick() {
        if (++this.status.vcounter == 128) {
            this.status.interlace = this.ppu1bit.read1bit(0);
        }
        if (this.region == 0 && !this.status.interlace && this.status.vcounter == 262 || this.region == 0 && this.status.interlace && this.status.vcounter == 263 || this.region == 0 && this.status.interlace && this.status.vcounter == 262 && this.status.field || this.region == 1 && !this.status.interlace && this.status.vcounter == 312 || this.region == 1 && this.status.interlace && this.status.vcounter == 313 || this.region == 1 && this.status.interlace && this.status.vcounter == 312 && this.status.field) {
            this.status.vcounter = 0;
            boolean bl = this.status.field = !this.status.field;
        }
        if (this.scanline != null) {
            this.scanline.run();
        }
    }

    public class History {
        public boolean[] field = new boolean[2048];
        public int[] vcounter = new int[2048];
        public int[] hcounter = new int[2048];
        public int index;
    }

    class Status {
        public boolean interlace;
        public boolean field;
        public int vcounter;
        public int hcounter;

        Status() {
        }
    }
}

