/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.dsp;

import jario.hardware.Bus32bit;
import jario.hardware.Bus8bit;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.snes.performance.dsp.SPCDSP;

public class DSP
implements Hardware,
Clockable,
Bus8bit,
Configurable {
    private long clock;
    private byte[] apuram = new byte[65536];
    private Bus32bit output;
    private SPCDSP spc_dsp = new SPCDSP();
    private short[] samplebuffer = new short[8192];
    boolean[] channel_enabled = new boolean[8];
    private Bus8bit sram = new Bus8bit(){

        public byte read8bit(int address) {
            return DSP.this.apuram[address];
        }

        public void write8bit(int address, byte data) {
            ((DSP)DSP.this).apuram[address] = data;
        }
    };

    public DSP() {
        int i = 0;
        while (i < 8) {
            this.channel_enabled[i] = true;
            ++i;
        }
        this.clock = 0L;
        this.power();
    }

    public void connect(int port, Hardware hw) {
        switch (port) {
            case 0: {
                this.output = (Bus32bit)hw;
            }
        }
    }

    public byte read8bit(int addr) {
        return this.spc_dsp.read(addr);
    }

    public void write8bit(int addr, byte data) {
        this.spc_dsp.write(addr, data);
    }

    public void clock(long clocks) {
        this.clock -= clocks;
        while (this.clock < 0L) {
            this.spc_dsp.run(1);
            this.clock += 24L;
            int count = this.spc_dsp.sample_count();
            if (count <= 0) continue;
            int n = 0;
            while (n < count) {
                this.output.write32bit(0, (this.samplebuffer[n + 0] & 0xFFFF) << 16 | this.samplebuffer[n + 1] & 0xFFFF);
                n += 2;
            }
            this.spc_dsp.set_output(this.samplebuffer, 8192);
        }
    }

    public void reset() {
        this.spc_dsp.soft_reset();
        this.spc_dsp.set_output(this.samplebuffer, 8192);
        this.clock = 0L;
    }

    public Object readConfig(String key) {
        if (key.equalsIgnoreCase("SRAM")) {
            return this.sram;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
    }

    private void power() {
        this.spc_dsp.init(this.apuram);
        this.spc_dsp.reset();
        this.spc_dsp.set_output(this.samplebuffer, 8192);
    }
}

