/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.dsp;

import jario.snes.performance.dsp.State;
import jario.snes.performance.dsp.Voice;

public class SPCDSP {
    public static int[] initial_regs;
    public static final int voice_count = 8;
    public static final int register_count = 128;
    public static final int GlobalReg_mvoll = 12;
    public static final int GlobalReg_mvolr = 28;
    public static final int GlobalReg_evoll = 44;
    public static final int GlobalReg_evolr = 60;
    public static final int GlobalReg_kon = 76;
    public static final int GlobalReg_koff = 92;
    public static final int GlobalReg_flg = 108;
    public static final int GlobalReg_endx = 124;
    public static final int GlobalReg_efb = 13;
    public static final int GlobalReg_pmon = 45;
    public static final int GlobalReg_non = 61;
    public static final int GlobalReg_eon = 77;
    public static final int GlobalReg_dir = 93;
    public static final int GlobalReg_esa = 109;
    public static final int GlobalReg_edl = 125;
    public static final int GlobalReg_fir = 15;
    public static final int VoiceReg_voll = 0;
    public static final int VoiceReg_volr = 1;
    public static final int VoiceReg_pitchl = 2;
    public static final int VoiceReg_pitchh = 3;
    public static final int VoiceReg_srcn = 4;
    public static final int VoiceReg_adsr0 = 5;
    public static final int VoiceReg_adsr1 = 6;
    public static final int VoiceReg_gain = 7;
    public static final int VoiceReg_envx = 8;
    public static final int VoiceReg_outx = 9;
    public static final int extra_size = 16;
    public static final int echo_hist_size = 8;
    public static final int brr_buf_size = 12;
    private static final int brr_block_size = 9;
    private State m = new State();
    private static final int simple_counter_range = 30720;
    private static int[] counter_rates;
    private static int[] counter_offsets;
    private static short[] gauss;

    static {
        int[] nArray = new int[128];
        nArray[108] = 224;
        initial_regs = nArray;
        counter_rates = new int[]{30721, 2048, 1536, 1280, 1024, 768, 640, 512, 384, 320, 256, 192, 160, 128, 96, 80, 64, 48, 40, 32, 24, 20, 16, 12, 10, 8, 6, 5, 4, 3, 2, 1};
        int[] nArray2 = new int[32];
        nArray2[0] = 1;
        nArray2[2] = 1040;
        nArray2[3] = 536;
        nArray2[5] = 1040;
        nArray2[6] = 536;
        nArray2[8] = 1040;
        nArray2[9] = 536;
        nArray2[11] = 1040;
        nArray2[12] = 536;
        nArray2[14] = 1040;
        nArray2[15] = 536;
        nArray2[17] = 1040;
        nArray2[18] = 536;
        nArray2[20] = 1040;
        nArray2[21] = 536;
        nArray2[23] = 1040;
        nArray2[24] = 536;
        nArray2[26] = 1040;
        nArray2[27] = 536;
        nArray2[29] = 1040;
        counter_offsets = nArray2;
        short[] sArray = new short[512];
        sArray[16] = 1;
        sArray[17] = 1;
        sArray[18] = 1;
        sArray[19] = 1;
        sArray[20] = 1;
        sArray[21] = 1;
        sArray[22] = 1;
        sArray[23] = 1;
        sArray[24] = 1;
        sArray[25] = 1;
        sArray[26] = 1;
        sArray[27] = 2;
        sArray[28] = 2;
        sArray[29] = 2;
        sArray[30] = 2;
        sArray[31] = 2;
        sArray[32] = 2;
        sArray[33] = 2;
        sArray[34] = 3;
        sArray[35] = 3;
        sArray[36] = 3;
        sArray[37] = 3;
        sArray[38] = 3;
        sArray[39] = 4;
        sArray[40] = 4;
        sArray[41] = 4;
        sArray[42] = 4;
        sArray[43] = 4;
        sArray[44] = 5;
        sArray[45] = 5;
        sArray[46] = 5;
        sArray[47] = 5;
        sArray[48] = 6;
        sArray[49] = 6;
        sArray[50] = 6;
        sArray[51] = 6;
        sArray[52] = 7;
        sArray[53] = 7;
        sArray[54] = 7;
        sArray[55] = 8;
        sArray[56] = 8;
        sArray[57] = 8;
        sArray[58] = 9;
        sArray[59] = 9;
        sArray[60] = 9;
        sArray[61] = 10;
        sArray[62] = 10;
        sArray[63] = 10;
        sArray[64] = 11;
        sArray[65] = 11;
        sArray[66] = 11;
        sArray[67] = 12;
        sArray[68] = 12;
        sArray[69] = 13;
        sArray[70] = 13;
        sArray[71] = 14;
        sArray[72] = 14;
        sArray[73] = 15;
        sArray[74] = 15;
        sArray[75] = 15;
        sArray[76] = 16;
        sArray[77] = 16;
        sArray[78] = 17;
        sArray[79] = 17;
        sArray[80] = 18;
        sArray[81] = 19;
        sArray[82] = 19;
        sArray[83] = 20;
        sArray[84] = 20;
        sArray[85] = 21;
        sArray[86] = 21;
        sArray[87] = 22;
        sArray[88] = 23;
        sArray[89] = 23;
        sArray[90] = 24;
        sArray[91] = 24;
        sArray[92] = 25;
        sArray[93] = 26;
        sArray[94] = 27;
        sArray[95] = 27;
        sArray[96] = 28;
        sArray[97] = 29;
        sArray[98] = 29;
        sArray[99] = 30;
        sArray[100] = 31;
        sArray[101] = 32;
        sArray[102] = 32;
        sArray[103] = 33;
        sArray[104] = 34;
        sArray[105] = 35;
        sArray[106] = 36;
        sArray[107] = 36;
        sArray[108] = 37;
        sArray[109] = 38;
        sArray[110] = 39;
        sArray[111] = 40;
        sArray[112] = 41;
        sArray[113] = 42;
        sArray[114] = 43;
        sArray[115] = 44;
        sArray[116] = 45;
        sArray[117] = 46;
        sArray[118] = 47;
        sArray[119] = 48;
        sArray[120] = 49;
        sArray[121] = 50;
        sArray[122] = 51;
        sArray[123] = 52;
        sArray[124] = 53;
        sArray[125] = 54;
        sArray[126] = 55;
        sArray[127] = 56;
        sArray[128] = 58;
        sArray[129] = 59;
        sArray[130] = 60;
        sArray[131] = 61;
        sArray[132] = 62;
        sArray[133] = 64;
        sArray[134] = 65;
        sArray[135] = 66;
        sArray[136] = 67;
        sArray[137] = 69;
        sArray[138] = 70;
        sArray[139] = 71;
        sArray[140] = 73;
        sArray[141] = 74;
        sArray[142] = 76;
        sArray[143] = 77;
        sArray[144] = 78;
        sArray[145] = 80;
        sArray[146] = 81;
        sArray[147] = 83;
        sArray[148] = 84;
        sArray[149] = 86;
        sArray[150] = 87;
        sArray[151] = 89;
        sArray[152] = 90;
        sArray[153] = 92;
        sArray[154] = 94;
        sArray[155] = 95;
        sArray[156] = 97;
        sArray[157] = 99;
        sArray[158] = 100;
        sArray[159] = 102;
        sArray[160] = 104;
        sArray[161] = 106;
        sArray[162] = 107;
        sArray[163] = 109;
        sArray[164] = 111;
        sArray[165] = 113;
        sArray[166] = 115;
        sArray[167] = 117;
        sArray[168] = 118;
        sArray[169] = 120;
        sArray[170] = 122;
        sArray[171] = 124;
        sArray[172] = 126;
        sArray[173] = 128;
        sArray[174] = 130;
        sArray[175] = 132;
        sArray[176] = 134;
        sArray[177] = 137;
        sArray[178] = 139;
        sArray[179] = 141;
        sArray[180] = 143;
        sArray[181] = 145;
        sArray[182] = 147;
        sArray[183] = 150;
        sArray[184] = 152;
        sArray[185] = 154;
        sArray[186] = 156;
        sArray[187] = 159;
        sArray[188] = 161;
        sArray[189] = 163;
        sArray[190] = 166;
        sArray[191] = 168;
        sArray[192] = 171;
        sArray[193] = 173;
        sArray[194] = 175;
        sArray[195] = 178;
        sArray[196] = 180;
        sArray[197] = 183;
        sArray[198] = 186;
        sArray[199] = 188;
        sArray[200] = 191;
        sArray[201] = 193;
        sArray[202] = 196;
        sArray[203] = 199;
        sArray[204] = 201;
        sArray[205] = 204;
        sArray[206] = 207;
        sArray[207] = 210;
        sArray[208] = 212;
        sArray[209] = 215;
        sArray[210] = 218;
        sArray[211] = 221;
        sArray[212] = 224;
        sArray[213] = 227;
        sArray[214] = 230;
        sArray[215] = 233;
        sArray[216] = 236;
        sArray[217] = 239;
        sArray[218] = 242;
        sArray[219] = 245;
        sArray[220] = 248;
        sArray[221] = 251;
        sArray[222] = 254;
        sArray[223] = 257;
        sArray[224] = 260;
        sArray[225] = 263;
        sArray[226] = 267;
        sArray[227] = 270;
        sArray[228] = 273;
        sArray[229] = 276;
        sArray[230] = 280;
        sArray[231] = 283;
        sArray[232] = 286;
        sArray[233] = 290;
        sArray[234] = 293;
        sArray[235] = 297;
        sArray[236] = 300;
        sArray[237] = 304;
        sArray[238] = 307;
        sArray[239] = 311;
        sArray[240] = 314;
        sArray[241] = 318;
        sArray[242] = 321;
        sArray[243] = 325;
        sArray[244] = 328;
        sArray[245] = 332;
        sArray[246] = 336;
        sArray[247] = 339;
        sArray[248] = 343;
        sArray[249] = 347;
        sArray[250] = 351;
        sArray[251] = 354;
        sArray[252] = 358;
        sArray[253] = 362;
        sArray[254] = 366;
        sArray[255] = 370;
        sArray[256] = 374;
        sArray[257] = 378;
        sArray[258] = 381;
        sArray[259] = 385;
        sArray[260] = 389;
        sArray[261] = 393;
        sArray[262] = 397;
        sArray[263] = 401;
        sArray[264] = 405;
        sArray[265] = 410;
        sArray[266] = 414;
        sArray[267] = 418;
        sArray[268] = 422;
        sArray[269] = 426;
        sArray[270] = 430;
        sArray[271] = 434;
        sArray[272] = 439;
        sArray[273] = 443;
        sArray[274] = 447;
        sArray[275] = 451;
        sArray[276] = 456;
        sArray[277] = 460;
        sArray[278] = 464;
        sArray[279] = 469;
        sArray[280] = 473;
        sArray[281] = 477;
        sArray[282] = 482;
        sArray[283] = 486;
        sArray[284] = 491;
        sArray[285] = 495;
        sArray[286] = 499;
        sArray[287] = 504;
        sArray[288] = 508;
        sArray[289] = 513;
        sArray[290] = 517;
        sArray[291] = 522;
        sArray[292] = 527;
        sArray[293] = 531;
        sArray[294] = 536;
        sArray[295] = 540;
        sArray[296] = 545;
        sArray[297] = 550;
        sArray[298] = 554;
        sArray[299] = 559;
        sArray[300] = 563;
        sArray[301] = 568;
        sArray[302] = 573;
        sArray[303] = 577;
        sArray[304] = 582;
        sArray[305] = 587;
        sArray[306] = 592;
        sArray[307] = 596;
        sArray[308] = 601;
        sArray[309] = 606;
        sArray[310] = 611;
        sArray[311] = 615;
        sArray[312] = 620;
        sArray[313] = 625;
        sArray[314] = 630;
        sArray[315] = 635;
        sArray[316] = 640;
        sArray[317] = 644;
        sArray[318] = 649;
        sArray[319] = 654;
        sArray[320] = 659;
        sArray[321] = 664;
        sArray[322] = 669;
        sArray[323] = 674;
        sArray[324] = 678;
        sArray[325] = 683;
        sArray[326] = 688;
        sArray[327] = 693;
        sArray[328] = 698;
        sArray[329] = 703;
        sArray[330] = 708;
        sArray[331] = 713;
        sArray[332] = 718;
        sArray[333] = 723;
        sArray[334] = 728;
        sArray[335] = 732;
        sArray[336] = 737;
        sArray[337] = 742;
        sArray[338] = 747;
        sArray[339] = 752;
        sArray[340] = 757;
        sArray[341] = 762;
        sArray[342] = 767;
        sArray[343] = 772;
        sArray[344] = 777;
        sArray[345] = 782;
        sArray[346] = 787;
        sArray[347] = 792;
        sArray[348] = 797;
        sArray[349] = 802;
        sArray[350] = 806;
        sArray[351] = 811;
        sArray[352] = 816;
        sArray[353] = 821;
        sArray[354] = 826;
        sArray[355] = 831;
        sArray[356] = 836;
        sArray[357] = 841;
        sArray[358] = 846;
        sArray[359] = 851;
        sArray[360] = 855;
        sArray[361] = 860;
        sArray[362] = 865;
        sArray[363] = 870;
        sArray[364] = 875;
        sArray[365] = 880;
        sArray[366] = 884;
        sArray[367] = 889;
        sArray[368] = 894;
        sArray[369] = 899;
        sArray[370] = 904;
        sArray[371] = 908;
        sArray[372] = 913;
        sArray[373] = 918;
        sArray[374] = 923;
        sArray[375] = 927;
        sArray[376] = 932;
        sArray[377] = 937;
        sArray[378] = 941;
        sArray[379] = 946;
        sArray[380] = 951;
        sArray[381] = 955;
        sArray[382] = 960;
        sArray[383] = 965;
        sArray[384] = 969;
        sArray[385] = 974;
        sArray[386] = 978;
        sArray[387] = 983;
        sArray[388] = 988;
        sArray[389] = 992;
        sArray[390] = 997;
        sArray[391] = 1001;
        sArray[392] = 1005;
        sArray[393] = 1010;
        sArray[394] = 1014;
        sArray[395] = 1019;
        sArray[396] = 1023;
        sArray[397] = 1027;
        sArray[398] = 1032;
        sArray[399] = 1036;
        sArray[400] = 1040;
        sArray[401] = 1045;
        sArray[402] = 1049;
        sArray[403] = 1053;
        sArray[404] = 1057;
        sArray[405] = 1061;
        sArray[406] = 1066;
        sArray[407] = 1070;
        sArray[408] = 1074;
        sArray[409] = 1078;
        sArray[410] = 1082;
        sArray[411] = 1086;
        sArray[412] = 1090;
        sArray[413] = 1094;
        sArray[414] = 1098;
        sArray[415] = 1102;
        sArray[416] = 1106;
        sArray[417] = 1109;
        sArray[418] = 1113;
        sArray[419] = 1117;
        sArray[420] = 1121;
        sArray[421] = 1125;
        sArray[422] = 1128;
        sArray[423] = 1132;
        sArray[424] = 1136;
        sArray[425] = 1139;
        sArray[426] = 1143;
        sArray[427] = 1146;
        sArray[428] = 1150;
        sArray[429] = 1153;
        sArray[430] = 1157;
        sArray[431] = 1160;
        sArray[432] = 1164;
        sArray[433] = 1167;
        sArray[434] = 1170;
        sArray[435] = 1174;
        sArray[436] = 1177;
        sArray[437] = 1180;
        sArray[438] = 1183;
        sArray[439] = 1186;
        sArray[440] = 1190;
        sArray[441] = 1193;
        sArray[442] = 1196;
        sArray[443] = 1199;
        sArray[444] = 1202;
        sArray[445] = 1205;
        sArray[446] = 1207;
        sArray[447] = 1210;
        sArray[448] = 1213;
        sArray[449] = 1216;
        sArray[450] = 1219;
        sArray[451] = 1221;
        sArray[452] = 1224;
        sArray[453] = 1227;
        sArray[454] = 1229;
        sArray[455] = 1232;
        sArray[456] = 1234;
        sArray[457] = 1237;
        sArray[458] = 1239;
        sArray[459] = 1241;
        sArray[460] = 1244;
        sArray[461] = 1246;
        sArray[462] = 1248;
        sArray[463] = 1251;
        sArray[464] = 1253;
        sArray[465] = 1255;
        sArray[466] = 1257;
        sArray[467] = 1259;
        sArray[468] = 1261;
        sArray[469] = 1263;
        sArray[470] = 1265;
        sArray[471] = 1267;
        sArray[472] = 1269;
        sArray[473] = 1270;
        sArray[474] = 1272;
        sArray[475] = 1274;
        sArray[476] = 1275;
        sArray[477] = 1277;
        sArray[478] = 1279;
        sArray[479] = 1280;
        sArray[480] = 1282;
        sArray[481] = 1283;
        sArray[482] = 1284;
        sArray[483] = 1286;
        sArray[484] = 1287;
        sArray[485] = 1288;
        sArray[486] = 1290;
        sArray[487] = 1291;
        sArray[488] = 1292;
        sArray[489] = 1293;
        sArray[490] = 1294;
        sArray[491] = 1295;
        sArray[492] = 1296;
        sArray[493] = 1297;
        sArray[494] = 1297;
        sArray[495] = 1298;
        sArray[496] = 1299;
        sArray[497] = 1300;
        sArray[498] = 1300;
        sArray[499] = 1301;
        sArray[500] = 1302;
        sArray[501] = 1302;
        sArray[502] = 1303;
        sArray[503] = 1303;
        sArray[504] = 1303;
        sArray[505] = 1304;
        sArray[506] = 1304;
        sArray[507] = 1304;
        sArray[508] = 1304;
        sArray[509] = 1304;
        sArray[510] = 1305;
        sArray[511] = 1305;
        gauss = sArray;
    }

    private static final int Clamp16(int io) {
        if ((short)io != io) {
            return io >> 31 ^ Short.MAX_VALUE;
        }
        return io;
    }

    public void init(byte[] ram_64k) {
        this.m.ram = ram_64k;
        this.mute_voices(0);
        this.disable_surround(false);
        this.set_output(null, 0);
        this.reset();
    }

    public void set_output(short[] _out, int size) {
        assert ((size & 1) == 0);
        if (_out == null) {
            _out = this.m.extra;
            size = 16;
        }
        this.m._out = _out;
        this.m._out_Offset = 0;
    }

    public int sample_count() {
        return this.m._out_Offset;
    }

    public void reset() {
        this.load(initial_regs);
    }

    public void soft_reset() {
        this.m.regs[108] = 224;
        this.soft_reset_common();
    }

    public byte read(int addr) {
        assert (addr < 128);
        return (byte)this.m.regs[addr];
    }

    public void write(int addr, byte data) {
        assert (addr < 128);
        this.m.regs[addr] = data & 0xFF;
        switch (addr & 0xF) {
            case 8: {
                this.m.envx_buf = data & 0xFF;
                break;
            }
            case 9: {
                this.m.outx_buf = data & 0xFF;
                break;
            }
            case 12: {
                if (addr == 76) {
                    this.m.new_kon = data & 0xFF;
                }
                if (addr != 124) break;
                this.m.endx_buf = 0;
                this.m.regs[124] = 0;
            }
        }
    }

    private static final boolean Phase(int n, int clocks_remain) {
        return n != 0 && --clocks_remain == 0;
    }

    public void run(int clocks_remain) {
        assert (clocks_remain > 0);
        int phase = this.m.phase;
        this.m.phase = phase + clocks_remain & 0x1F;
        block34: do {
            switch (phase) {
                case 0: {
                    this.voice_V5(this.m.voices[0]);
                    this.voice_V2(this.m.voices[1]);
                    if (SPCDSP.Phase(1, clocks_remain)) continue block34;
                }
                case 1: {
                    this.voice_V6(this.m.voices[0]);
                    this.voice_V3(this.m.voices[1]);
                    if (SPCDSP.Phase(2, clocks_remain)) continue block34;
                }
                case 2: {
                    this.voice_V7_V4_V1(this.m.voices, 0);
                    if (SPCDSP.Phase(3, clocks_remain)) continue block34;
                }
                case 3: {
                    this.voice_V8_V5_V2(this.m.voices, 0);
                    if (SPCDSP.Phase(4, clocks_remain)) continue block34;
                }
                case 4: {
                    this.voice_V9_V6_V3(this.m.voices, 0);
                    if (SPCDSP.Phase(5, clocks_remain)) continue block34;
                }
                case 5: {
                    this.voice_V7_V4_V1(this.m.voices, 1);
                    if (SPCDSP.Phase(6, clocks_remain)) continue block34;
                }
                case 6: {
                    this.voice_V8_V5_V2(this.m.voices, 1);
                    if (SPCDSP.Phase(7, clocks_remain)) continue block34;
                }
                case 7: {
                    this.voice_V9_V6_V3(this.m.voices, 1);
                    if (SPCDSP.Phase(8, clocks_remain)) continue block34;
                }
                case 8: {
                    this.voice_V7_V4_V1(this.m.voices, 2);
                    if (SPCDSP.Phase(9, clocks_remain)) continue block34;
                }
                case 9: {
                    this.voice_V8_V5_V2(this.m.voices, 2);
                    if (SPCDSP.Phase(10, clocks_remain)) continue block34;
                }
                case 10: {
                    this.voice_V9_V6_V3(this.m.voices, 2);
                    if (SPCDSP.Phase(11, clocks_remain)) continue block34;
                }
                case 11: {
                    this.voice_V7_V4_V1(this.m.voices, 3);
                    if (SPCDSP.Phase(12, clocks_remain)) continue block34;
                }
                case 12: {
                    this.voice_V8_V5_V2(this.m.voices, 3);
                    if (SPCDSP.Phase(13, clocks_remain)) continue block34;
                }
                case 13: {
                    this.voice_V9_V6_V3(this.m.voices, 3);
                    if (SPCDSP.Phase(14, clocks_remain)) continue block34;
                }
                case 14: {
                    this.voice_V7_V4_V1(this.m.voices, 4);
                    if (SPCDSP.Phase(15, clocks_remain)) continue block34;
                }
                case 15: {
                    this.voice_V8_V5_V2(this.m.voices, 4);
                    if (SPCDSP.Phase(16, clocks_remain)) continue block34;
                }
                case 16: {
                    this.voice_V9_V6_V3(this.m.voices, 4);
                    if (SPCDSP.Phase(17, clocks_remain)) continue block34;
                }
                case 17: {
                    this.voice_V1(this.m.voices[0]);
                    this.voice_V7(this.m.voices[5]);
                    this.voice_V4(this.m.voices[6]);
                    if (SPCDSP.Phase(18, clocks_remain)) continue block34;
                }
                case 18: {
                    this.voice_V8_V5_V2(this.m.voices, 5);
                    if (SPCDSP.Phase(19, clocks_remain)) continue block34;
                }
                case 19: {
                    this.voice_V9_V6_V3(this.m.voices, 5);
                    if (SPCDSP.Phase(20, clocks_remain)) continue block34;
                }
                case 20: {
                    this.voice_V1(this.m.voices[1]);
                    this.voice_V7(this.m.voices[6]);
                    this.voice_V4(this.m.voices[7]);
                    if (SPCDSP.Phase(21, clocks_remain)) continue block34;
                }
                case 21: {
                    this.voice_V8(this.m.voices[6]);
                    this.voice_V5(this.m.voices[7]);
                    this.voice_V2(this.m.voices[0]);
                    if (SPCDSP.Phase(22, clocks_remain)) continue block34;
                }
                case 22: {
                    this.voice_V3a(this.m.voices[0]);
                    this.voice_V9(this.m.voices[6]);
                    this.voice_V6(this.m.voices[7]);
                    this.echo_22();
                    if (SPCDSP.Phase(23, clocks_remain)) continue block34;
                }
                case 23: {
                    this.voice_V7(this.m.voices[7]);
                    this.echo_23();
                    if (SPCDSP.Phase(24, clocks_remain)) continue block34;
                }
                case 24: {
                    this.voice_V8(this.m.voices[7]);
                    this.echo_24();
                    if (SPCDSP.Phase(25, clocks_remain)) continue block34;
                }
                case 25: {
                    this.voice_V3b(this.m.voices[0]);
                    this.voice_V9(this.m.voices[7]);
                    this.echo_25();
                    if (SPCDSP.Phase(26, clocks_remain)) continue block34;
                }
                case 26: {
                    this.echo_26();
                    if (SPCDSP.Phase(27, clocks_remain)) continue block34;
                }
                case 27: {
                    this.misc_27();
                    this.echo_27();
                    if (SPCDSP.Phase(28, clocks_remain)) continue block34;
                }
                case 28: {
                    this.misc_28();
                    this.echo_28();
                    if (SPCDSP.Phase(29, clocks_remain)) continue block34;
                }
                case 29: {
                    this.misc_29();
                    this.echo_29();
                    if (SPCDSP.Phase(30, clocks_remain)) continue block34;
                }
                case 30: {
                    this.misc_30();
                    this.voice_V3c(this.m.voices[0]);
                    this.echo_30();
                    if (SPCDSP.Phase(31, clocks_remain)) continue block34;
                }
                case 31: {
                    this.voice_V4(this.m.voices[0]);
                    this.voice_V1(this.m.voices[2]);
                }
            }
        } while (--clocks_remain != 0);
    }

    public void mute_voices(int mask) {
        this.m.mute_mask = mask;
    }

    public void load(int[] regs) {
        System.arraycopy(regs, 0, this.m.regs, 0, this.m.regs.length);
        int i = 8;
        while (--i >= 0) {
            Voice v = this.m.voices[i];
            v.brr_offset = 1;
            v.vbit = 1 << i;
            v.regs = this.m.regs;
            v.r = i * 16;
        }
        this.m.new_kon = this.m.regs[76] & 0xFF;
        this.m.t_dir = this.m.regs[93] & 0xFF;
        this.m.t_esa = this.m.regs[109] & 0xFF;
        this.soft_reset_common();
    }

    public boolean check_kon() {
        boolean old = this.m.kon_check;
        this.m.kon_check = false;
        return old;
    }

    public void disable_surround(boolean disable) {
    }

    private void init_counter() {
        this.m.counter = 0;
    }

    private final void run_counters() {
        if (--this.m.counter < 0) {
            this.m.counter = 30719;
        }
    }

    private int read_counter(int rate) {
        return (this.m.counter + counter_offsets[rate]) % counter_rates[rate];
    }

    private int interpolate(Voice v) {
        int offset = v.interp_pos >> 4 & 0xFF;
        short[] fwd = gauss;
        int fwd_Offset = 255 - offset;
        short[] rev = gauss;
        int rev_Offset = offset;
        int[] _in = v.buf;
        int _in_Offset = (v.interp_pos >> 12) + v.buf_pos;
        int _out = fwd[fwd_Offset + 0] * _in[_in_Offset + 0] >> 11;
        _out += fwd[fwd_Offset + 256] * _in[_in_Offset + 1] >> 11;
        _out += rev[rev_Offset + 256] * _in[_in_Offset + 2] >> 11;
        _out = (short)_out;
        _out += rev[rev_Offset + 0] * _in[_in_Offset + 3] >> 11;
        _out = SPCDSP.Clamp16(_out);
        return _out &= 0xFFFFFFFE;
    }

    private void run_envelope(Voice v) {
        int env = v.env;
        if (v.env_mode == EnvMode.release) {
            if ((env -= 8) < 0) {
                env = 0;
            }
            v.env = env;
        } else {
            int rate;
            int env_data = v.regs[v.r + 6] & 0xFF;
            if ((this.m.t_adsr0 & 0x80) != 0) {
                if (v.env_mode.ordinal() >= EnvMode.decay.ordinal()) {
                    --env;
                    env -= env >> 8;
                    rate = env_data & 0x1F;
                    if (v.env_mode == EnvMode.decay) {
                        rate = (this.m.t_adsr0 >> 3 & 0xE) + 16;
                    }
                } else {
                    rate = (this.m.t_adsr0 & 0xF) * 2 + 1;
                    env += rate < 31 ? 32 : 1024;
                }
            } else {
                env_data = v.regs[v.r + 7] & 0xFF;
                int mode = env_data >> 5;
                if (mode < 4) {
                    env = env_data * 16;
                    rate = 31;
                } else {
                    rate = env_data & 0x1F;
                    if (mode == 4) {
                        env -= 32;
                    } else if (mode < 6) {
                        --env;
                        env -= env >> 8;
                    } else {
                        env += 32;
                        if (mode > 6 && ((long)v.hidden_env & 0xFFFFFFFFL) >= 1536L) {
                            env -= 24;
                        }
                    }
                }
            }
            if (env >> 8 == env_data >> 5 && v.env_mode == EnvMode.decay) {
                v.env_mode = EnvMode.sustain;
            }
            v.hidden_env = env;
            if (((long)env & 0xFFFFFFFFL) > 2047L) {
                int n = env = env < 0 ? 0 : 2047;
                if (v.env_mode == EnvMode.attack) {
                    v.env_mode = EnvMode.decay;
                }
            }
            if (this.read_counter(rate) == 0) {
                v.env = env;
            }
        }
    }

    private void decode_brr(Voice v) {
        int nybbles = this.m.t_brr_byte * 256 + (this.m.ram[v.brr_addr + v.brr_offset + 1 & 0xFFFF] & 0xFF);
        int header = this.m.t_brr_header;
        int[] pos = v.buf;
        int pos_p = v.buf_pos;
        if ((v.buf_pos += 4) >= 12) {
            v.buf_pos = 0;
        }
        int end_p = pos_p + 4;
        while (pos_p < end_p) {
            int s = (short)nybbles >> 12;
            int shift = header >> 4;
            s = s << shift >> 1;
            if (shift >= 13) {
                s = s >> 25 << 11;
            }
            int filter = header & 0xC;
            int p1 = pos[pos_p + 12 - 1];
            int p2 = pos[pos_p + 12 - 2] >> 1;
            if (filter >= 8) {
                s += p1;
                s -= p2;
                if (filter == 8) {
                    s += p2 >> 4;
                    s += p1 * -3 >> 6;
                } else {
                    s += p1 * -13 >> 7;
                    s += p2 * 3 >> 4;
                }
            } else if (filter != 0) {
                s += p1 >> 1;
                s += -p1 >> 5;
            }
            s = SPCDSP.Clamp16(s);
            int n = s = (int)((short)(s * 2));
            pos[pos_p + 0] = n;
            pos[pos_p + 12] = n;
            ++pos_p;
            nybbles <<= 4;
        }
    }

    private void misc_27() {
        this.m.t_pmon = this.m.regs[45] & 0xFE;
    }

    private void misc_28() {
        this.m.t_non = this.m.regs[61] & 0xFF;
        this.m.t_eon = this.m.regs[77] & 0xFF;
        this.m.t_dir = this.m.regs[93] & 0xFF;
    }

    private void misc_29() {
        if ((this.m.every_other_sample ^= 1) != 0) {
            this.m.new_kon &= ~this.m.kon;
        }
    }

    private void misc_30() {
        if (this.m.every_other_sample != 0) {
            this.m.kon = this.m.new_kon;
            this.m.t_koff = this.m.regs[92] & 0xFF | this.m.mute_mask;
        }
        this.run_counters();
        if (this.read_counter(this.m.regs[108] & 0x1F) == 0) {
            int feedback = this.m.noise << 13 ^ this.m.noise << 14;
            this.m.noise = feedback & 0x4000 ^ this.m.noise >> 1;
        }
    }

    private void voice_output(Voice v, int ch) {
        int amp = this.m.t_output * (byte)(v.regs[v.r + 0 + ch] & 0xFF) >> 7;
        int n = ch;
        this.m.t_main_out[n] = this.m.t_main_out[n] + amp;
        this.m.t_main_out[ch] = SPCDSP.Clamp16(this.m.t_main_out[ch]);
        if ((this.m.t_eon & v.vbit) != 0) {
            int n2 = ch;
            this.m.t_echo_out[n2] = this.m.t_echo_out[n2] + amp;
            this.m.t_echo_out[ch] = SPCDSP.Clamp16(this.m.t_echo_out[ch]);
        }
    }

    private void voice_V1(Voice v) {
        this.m.t_dir_addr = this.m.t_dir * 256 + this.m.t_srcn * 4;
        this.m.t_srcn = v.regs[v.r + 4] & 0xFF;
    }

    private void voice_V2(Voice v) {
        int entry = this.m.t_dir_addr & 0xFFFF;
        if (v.kon_delay == 0) {
            entry += 2;
        }
        int lo = this.m.ram[entry + 0] & 0xFF;
        int hi = this.m.ram[entry + 1] & 0xFF;
        this.m.t_brr_next_addr = (hi << 8) + lo;
        this.m.t_adsr0 = v.regs[v.r + 5] & 0xFF;
        this.m.t_pitch = v.regs[v.r + 2] & 0xFF;
    }

    private void voice_V3(Voice v) {
        this.voice_V3a(v);
        this.voice_V3b(v);
        this.voice_V3c(v);
    }

    private void voice_V3a(Voice v) {
        this.m.t_pitch += (v.regs[v.r + 3] & 0x3F) << 8;
    }

    private void voice_V3b(Voice v) {
        this.m.t_brr_byte = this.m.ram[v.brr_addr + v.brr_offset & 0xFFFF] & 0xFF;
        this.m.t_brr_header = this.m.ram[v.brr_addr] & 0xFF;
    }

    private void voice_V3c(Voice v) {
        if ((this.m.t_pmon & v.vbit) != 0) {
            this.m.t_pitch += (this.m.t_output >> 5) * this.m.t_pitch >> 10;
        }
        if (v.kon_delay != 0) {
            if (v.kon_delay == 5) {
                v.brr_addr = this.m.t_brr_next_addr;
                v.brr_offset = 1;
                v.buf_pos = 0;
                this.m.t_brr_header = 0;
                this.m.kon_check = true;
            }
            v.env = 0;
            v.hidden_env = 0;
            v.interp_pos = 0;
            if ((--v.kon_delay & 3) != 0) {
                v.interp_pos = 16384;
            }
            this.m.t_pitch = 0;
        }
        int output = this.interpolate(v);
        if ((this.m.t_non & v.vbit) != 0) {
            output = (short)(this.m.noise * 2);
        }
        this.m.t_output = output * v.env >> 11 & 0xFFFFFFFE;
        v.t_envx_out = v.env >> 4 & 0xFF;
        if ((this.m.regs[108] & 0x80) != 0 || (this.m.t_brr_header & 3) == 1) {
            v.env_mode = EnvMode.release;
            v.env = 0;
        }
        if (this.m.every_other_sample != 0) {
            if ((this.m.t_koff & v.vbit) != 0) {
                v.env_mode = EnvMode.release;
            }
            if ((this.m.kon & v.vbit) != 0) {
                v.kon_delay = 5;
                v.env_mode = EnvMode.attack;
            }
        }
        if (v.kon_delay == 0) {
            this.run_envelope(v);
        }
    }

    private void voice_V4(Voice v) {
        this.m.t_looped = 0;
        if (v.interp_pos >= 16384) {
            this.decode_brr(v);
            if ((v.brr_offset += 2) >= 9) {
                assert (v.brr_offset == 9);
                v.brr_addr = v.brr_addr + 9 & 0xFFFF;
                if ((this.m.t_brr_header & 1) != 0) {
                    v.brr_addr = this.m.t_brr_next_addr;
                    this.m.t_looped = v.vbit;
                }
                v.brr_offset = 1;
            }
        }
        v.interp_pos = (v.interp_pos & 0x3FFF) + this.m.t_pitch;
        if (v.interp_pos > Short.MAX_VALUE) {
            v.interp_pos = Short.MAX_VALUE;
        }
        this.voice_output(v, 0);
    }

    private void voice_V5(Voice v) {
        this.voice_output(v, 1);
        int endx_buf = this.m.regs[124] & 0xFF | this.m.t_looped;
        if (v.kon_delay == 5) {
            endx_buf &= ~v.vbit;
        }
        this.m.endx_buf = endx_buf & 0xFF;
    }

    private void voice_V6(Voice v) {
        this.m.outx_buf = this.m.t_output >> 8 & 0xFF;
    }

    private void voice_V7(Voice v) {
        this.m.regs[124] = this.m.endx_buf & 0xFF;
        this.m.envx_buf = v.t_envx_out & 0xFF;
    }

    private void voice_V8(Voice v) {
        v.regs[v.r + 9] = this.m.outx_buf & 0xFF;
    }

    private void voice_V9(Voice v) {
        v.regs[v.r + 8] = this.m.envx_buf & 0xFF;
    }

    private final void voice_V7_V4_V1(Voice[] v, int offset) {
        this.voice_V7(v[offset + 0]);
        this.voice_V1(v[offset + 3]);
        this.voice_V4(v[offset + 1]);
    }

    private final void voice_V8_V5_V2(Voice[] v, int offset) {
        this.voice_V8(v[offset + 0]);
        this.voice_V5(v[offset + 1]);
        this.voice_V2(v[offset + 2]);
    }

    private final void voice_V9_V6_V3(Voice[] v, int offset) {
        this.voice_V9(v[offset + 0]);
        this.voice_V6(v[offset + 1]);
        this.voice_V3(v[offset + 2]);
    }

    private void echo_read(int ch) {
        int lo = this.m.ram[this.m.t_echo_ptr + ch * 2 + 0 & 0xFFFF] & 0xFF;
        int hi = this.m.ram[this.m.t_echo_ptr + ch * 2 + 1 & 0xFFFF] & 0xFF;
        short s = (short)((hi << 8) + lo);
        int n = s >> 1;
        this.m.echo_hist[this.m.echo_hist_pos + 8][ch] = n;
        this.m.echo_hist[this.m.echo_hist_pos + 0][ch] = n;
    }

    private int echo_output(int ch) {
        int _out = (short)(this.m.t_main_out[ch] * (byte)(this.m.regs[12 + ch * 16] & 0xFF) >> 7) + (short)(this.m.t_echo_in[ch] * (byte)(this.m.regs[44 + ch * 16] & 0xFF) >> 7);
        _out = SPCDSP.Clamp16(_out);
        return _out;
    }

    private void echo_write(int ch) {
        if ((this.m.t_echo_enabled & 0x20) == 0) {
            int s = this.m.t_echo_out[ch];
            this.m.ram[this.m.t_echo_ptr + ch * 2 + 0 & 0xFFFF] = (byte)s;
            this.m.ram[this.m.t_echo_ptr + ch * 2 + 1 & 0xFFFF] = (byte)(s >> 8);
        }
        this.m.t_echo_out[ch] = 0;
    }

    private int CalcFir(int i, int ch) {
        return this.m.echo_hist[this.m.echo_hist_pos + i + 1][ch] * (byte)(this.m.regs[15 + i * 16] & 0xFF) >> 6;
    }

    private void echo_22() {
        this.m.echo_hist_pos = this.m.echo_hist_pos + 1 >= 8 ? 0 : ++this.m.echo_hist_pos;
        this.m.t_echo_ptr = this.m.t_esa * 256 + this.m.echo_offset & 0xFFFF;
        this.echo_read(0);
        int l = this.CalcFir(0, 0);
        int r = this.CalcFir(0, 1);
        this.m.t_echo_in[0] = l;
        this.m.t_echo_in[1] = r;
    }

    private void echo_23() {
        int l = this.CalcFir(1, 0) + this.CalcFir(2, 0);
        int r = this.CalcFir(1, 1) + this.CalcFir(2, 1);
        this.m.t_echo_in[0] = this.m.t_echo_in[0] + l;
        this.m.t_echo_in[1] = this.m.t_echo_in[1] + r;
        this.echo_read(1);
    }

    private void echo_24() {
        int l = this.CalcFir(3, 0) + this.CalcFir(4, 0) + this.CalcFir(5, 0);
        int r = this.CalcFir(3, 1) + this.CalcFir(4, 1) + this.CalcFir(5, 1);
        this.m.t_echo_in[0] = this.m.t_echo_in[0] + l;
        this.m.t_echo_in[1] = this.m.t_echo_in[1] + r;
    }

    private void echo_25() {
        int l = this.m.t_echo_in[0] + this.CalcFir(6, 0);
        int r = this.m.t_echo_in[1] + this.CalcFir(6, 1);
        l = (short)l;
        r = (short)r;
        l += (short)this.CalcFir(7, 0);
        r += (short)this.CalcFir(7, 1);
        l = SPCDSP.Clamp16(l);
        r = SPCDSP.Clamp16(r);
        this.m.t_echo_in[0] = l & 0xFFFFFFFE;
        this.m.t_echo_in[1] = r & 0xFFFFFFFE;
    }

    private void echo_26() {
        this.m.t_main_out[0] = this.echo_output(0);
        int l = this.m.t_echo_out[0] + (short)(this.m.t_echo_in[0] * (byte)(this.m.regs[13] & 0xFF) >> 7);
        int r = this.m.t_echo_out[1] + (short)(this.m.t_echo_in[1] * (byte)(this.m.regs[13] & 0xFF) >> 7);
        l = SPCDSP.Clamp16(l);
        r = SPCDSP.Clamp16(r);
        this.m.t_echo_out[0] = l & 0xFFFFFFFE;
        this.m.t_echo_out[1] = r & 0xFFFFFFFE;
    }

    private final void WRITE_SAMPLES(int l, int r) {
        this.m._out[this.m._out_Offset + 0] = (short)l;
        this.m._out[this.m._out_Offset + 1] = (short)r;
        this.m._out_Offset += 2;
        if (this.m._out_Offset >= this.m._out.length) {
            assert (this.m._out_Offset == this.m._out.length);
            this.m._out = this.m.extra;
        }
    }

    private void echo_27() {
        int l = this.m.t_main_out[0];
        int r = this.echo_output(1);
        this.m.t_main_out[0] = 0;
        this.m.t_main_out[1] = 0;
        if ((this.m.regs[108] & 0x40) != 0) {
            l = 0;
            r = 0;
        }
        this.WRITE_SAMPLES(l, r);
    }

    private void echo_28() {
        this.m.t_echo_enabled = this.m.regs[108] & 0xFF;
    }

    private void echo_29() {
        this.m.t_esa = this.m.regs[109] & 0xFF;
        if (this.m.echo_offset == 0) {
            this.m.echo_length = (this.m.regs[125] & 0xF) * 2048;
        }
        this.m.echo_offset += 4;
        if (this.m.echo_offset >= this.m.echo_length) {
            this.m.echo_offset = 0;
        }
        this.echo_write(0);
        this.m.t_echo_enabled = this.m.regs[108] & 0xFF;
    }

    private void echo_30() {
        this.echo_write(1);
    }

    private void soft_reset_common() {
        assert (this.m.ram != null);
        this.m.noise = 16384;
        this.m.echo_hist_pos = 0;
        this.m.every_other_sample = 1;
        this.m.echo_offset = 0;
        this.m.phase = 0;
        this.init_counter();
    }

    public static enum EnvMode {
        release,
        attack,
        decay,
        sustain;

    }
}

