/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.dsp;

import jario.hardware.Bus32bit;
import jario.hardware.Bus8bit;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.snes.dsp.DSPCore;
import jario.snes.dsp.Voice;

public class DSP
extends DSPCore
implements Clockable,
Bus8bit,
Configurable {
    private long clock;
    private Bus8bit sram = new Bus8bit(){

        public byte read8bit(int address) {
            return DSP.this.apuram[address];
        }

        public void write8bit(int address, byte data) {
            DSP.this.apuram[address] = data;
        }
    };

    public DSP() {
        int i = 0;
        while (i < this.voice.length) {
            this.voice[i] = new Voice(12);
            ++i;
        }
        this.power();
    }

    public void connect(int port, Hardware hw) {
        switch (port) {
            case 0: {
                this.audio = (Bus32bit)hw;
            }
        }
    }

    public byte read8bit(int addr) {
        return (byte)this.state.regs[addr];
    }

    public void write8bit(int addr, byte data) {
        this.state.regs[addr] = data & 0xFF;
        if ((addr & 0xF) == 8) {
            this.state.envx_buf = data & 0xFF;
        } else if ((addr & 0xF) == 9) {
            this.state.outx_buf = data & 0xFF;
        } else if ((addr & 0xFF) == 76) {
            this.state.new_kon = data & 0xFF;
        } else if ((addr & 0xFF) == 124) {
            this.state.endx_buf = 0;
            this.state.regs[124] = 0;
        }
    }

    public final void clock(long clocks) {
        this.clock -= clocks;
        while (this.clock < 0L) {
            this.ops[this.op++].run();
            this.op &= 0x1F;
            this.clock += 24L;
        }
    }

    public void reset() {
        this.clock = 0L;
        this.op = 0;
        this.state.regs[108] = 224;
        this.state.noise = 16384;
        this.state.echo_hist_pos = 0;
        this.state.every_other_sample = true;
        this.state.echo_offset = 0;
        this.state.counter = 0;
    }

    public Object readConfig(String key) {
        if (key.equalsIgnoreCase("SRAM")) {
            return this.sram;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
    }

    private void power() {
        this.state.echo_hist_pos = 0;
        this.state.every_other_sample = false;
        this.state.kon = 0;
        this.state.noise = 0;
        this.state.counter = 0;
        this.state.echo_offset = 0;
        this.state.echo_length = 0;
        this.state.new_kon = 0;
        this.state.endx_buf = 0;
        this.state.envx_buf = 0;
        this.state.outx_buf = 0;
        this.state.t_pmon = 0;
        this.state.t_non = 0;
        this.state.t_eon = 0;
        this.state.t_dir = 0;
        this.state.t_koff = 0;
        this.state.t_brr_next_addr = 0;
        this.state.t_adsr0 = 0;
        this.state.t_brr_header = 0;
        this.state.t_brr_byte = 0;
        this.state.t_srcn = 0;
        this.state.t_esa = 0;
        this.state.t_echo_disabled = 0;
        this.state.t_dir_addr = 0;
        this.state.t_pitch = 0;
        this.state.t_output = 0;
        this.state.t_looped = 0;
        this.state.t_echo_ptr = 0;
        this.state.t_main_out[1] = 0;
        this.state.t_main_out[0] = 0;
        this.state.t_echo_out[1] = 0;
        this.state.t_echo_out[0] = 0;
        this.state.t_echo_in[1] = 0;
        this.state.t_echo_in[0] = 0;
        int i = 0;
        while (i < 8) {
            this.voice[i].buf_pos = 0;
            this.voice[i].interp_pos = 0;
            this.voice[i].brr_addr = 0;
            this.voice[i].brr_offset = 1;
            this.voice[i].vbit = 1 << i;
            this.voice[i].vidx = i * 16;
            this.voice[i].kon_delay = 0;
            this.voice[i].env_mode = 0;
            this.voice[i].env = 0;
            this.voice[i].t_envx_out = 0;
            this.voice[i].hidden_env = 0;
            ++i;
        }
        this.reset();
    }
}

