/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.dsp;

import jario.hardware.Bus32bit;
import jario.hardware.Hardware;
import jario.snes.dsp.State;
import jario.snes.dsp.Voice;

public abstract class DSPCore
implements Hardware {
    protected byte[] apuram = new byte[65536];
    protected Bus32bit audio;
    public DSPOp op_0 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_5(DSPCore.this.voice[0]);
            DSPCore.this.voice_2(DSPCore.this.voice[1]);
        }
    };
    public DSPOp op_1 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_6(DSPCore.this.voice[0]);
            DSPCore.this.voice_3(DSPCore.this.voice[1]);
        }
    };
    public DSPOp op_2 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_7(DSPCore.this.voice[0]);
            DSPCore.this.voice_4(DSPCore.this.voice[1]);
            DSPCore.this.voice_1(DSPCore.this.voice[3]);
        }
    };
    public DSPOp op_3 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_8(DSPCore.this.voice[0]);
            DSPCore.this.voice_5(DSPCore.this.voice[1]);
            DSPCore.this.voice_2(DSPCore.this.voice[2]);
        }
    };
    public DSPOp op_4 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_9(DSPCore.this.voice[0]);
            DSPCore.this.voice_6(DSPCore.this.voice[1]);
            DSPCore.this.voice_3(DSPCore.this.voice[2]);
        }
    };
    public DSPOp op_5 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_7(DSPCore.this.voice[1]);
            DSPCore.this.voice_4(DSPCore.this.voice[2]);
            DSPCore.this.voice_1(DSPCore.this.voice[4]);
        }
    };
    public DSPOp op_6 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_8(DSPCore.this.voice[1]);
            DSPCore.this.voice_5(DSPCore.this.voice[2]);
            DSPCore.this.voice_2(DSPCore.this.voice[3]);
        }
    };
    public DSPOp op_7 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_9(DSPCore.this.voice[1]);
            DSPCore.this.voice_6(DSPCore.this.voice[2]);
            DSPCore.this.voice_3(DSPCore.this.voice[3]);
        }
    };
    public DSPOp op_8 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_7(DSPCore.this.voice[2]);
            DSPCore.this.voice_4(DSPCore.this.voice[3]);
            DSPCore.this.voice_1(DSPCore.this.voice[5]);
        }
    };
    public DSPOp op_9 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_8(DSPCore.this.voice[2]);
            DSPCore.this.voice_5(DSPCore.this.voice[3]);
            DSPCore.this.voice_2(DSPCore.this.voice[4]);
        }
    };
    public DSPOp op_10 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_9(DSPCore.this.voice[2]);
            DSPCore.this.voice_6(DSPCore.this.voice[3]);
            DSPCore.this.voice_3(DSPCore.this.voice[4]);
        }
    };
    public DSPOp op_11 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_7(DSPCore.this.voice[3]);
            DSPCore.this.voice_4(DSPCore.this.voice[4]);
            DSPCore.this.voice_1(DSPCore.this.voice[6]);
        }
    };
    public DSPOp op_12 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_8(DSPCore.this.voice[3]);
            DSPCore.this.voice_5(DSPCore.this.voice[4]);
            DSPCore.this.voice_2(DSPCore.this.voice[5]);
        }
    };
    public DSPOp op_13 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_9(DSPCore.this.voice[3]);
            DSPCore.this.voice_6(DSPCore.this.voice[4]);
            DSPCore.this.voice_3(DSPCore.this.voice[5]);
        }
    };
    public DSPOp op_14 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_7(DSPCore.this.voice[4]);
            DSPCore.this.voice_4(DSPCore.this.voice[5]);
            DSPCore.this.voice_1(DSPCore.this.voice[7]);
        }
    };
    public DSPOp op_15 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_8(DSPCore.this.voice[4]);
            DSPCore.this.voice_5(DSPCore.this.voice[5]);
            DSPCore.this.voice_2(DSPCore.this.voice[6]);
        }
    };
    public DSPOp op_16 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_9(DSPCore.this.voice[4]);
            DSPCore.this.voice_6(DSPCore.this.voice[5]);
            DSPCore.this.voice_3(DSPCore.this.voice[6]);
        }
    };
    public DSPOp op_17 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_1(DSPCore.this.voice[0]);
            DSPCore.this.voice_7(DSPCore.this.voice[5]);
            DSPCore.this.voice_4(DSPCore.this.voice[6]);
        }
    };
    public DSPOp op_18 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_8(DSPCore.this.voice[5]);
            DSPCore.this.voice_5(DSPCore.this.voice[6]);
            DSPCore.this.voice_2(DSPCore.this.voice[7]);
        }
    };
    public DSPOp op_19 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_9(DSPCore.this.voice[5]);
            DSPCore.this.voice_6(DSPCore.this.voice[6]);
            DSPCore.this.voice_3(DSPCore.this.voice[7]);
        }
    };
    public DSPOp op_20 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_1(DSPCore.this.voice[1]);
            DSPCore.this.voice_7(DSPCore.this.voice[6]);
            DSPCore.this.voice_4(DSPCore.this.voice[7]);
        }
    };
    public DSPOp op_21 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_8(DSPCore.this.voice[6]);
            DSPCore.this.voice_5(DSPCore.this.voice[7]);
            DSPCore.this.voice_2(DSPCore.this.voice[0]);
        }
    };
    public DSPOp op_22 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_3a(DSPCore.this.voice[0]);
            DSPCore.this.voice_9(DSPCore.this.voice[6]);
            DSPCore.this.voice_6(DSPCore.this.voice[7]);
            DSPCore.this.echo_22();
        }
    };
    public DSPOp op_23 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_7(DSPCore.this.voice[7]);
            DSPCore.this.echo_23();
        }
    };
    public DSPOp op_24 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_8(DSPCore.this.voice[7]);
            DSPCore.this.echo_24();
        }
    };
    public DSPOp op_25 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_3b(DSPCore.this.voice[0]);
            DSPCore.this.voice_9(DSPCore.this.voice[7]);
            DSPCore.this.echo_25();
        }
    };
    public DSPOp op_26 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.echo_26();
        }
    };
    public DSPOp op_27 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.misc_27();
            DSPCore.this.echo_27();
        }
    };
    public DSPOp op_28 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.misc_28();
            DSPCore.this.echo_28();
        }
    };
    public DSPOp op_29 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.misc_29();
            DSPCore.this.echo_29();
        }
    };
    public DSPOp op_30 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.misc_30();
            DSPCore.this.voice_3c(DSPCore.this.voice[0]);
            DSPCore.this.echo_30();
        }
    };
    public DSPOp op_31 = new DSPOp(){

        @Override
        public void run() {
            DSPCore.this.voice_4(DSPCore.this.voice[0]);
            DSPCore.this.voice_1(DSPCore.this.voice[2]);
        }
    };
    protected DSPOp[] ops = new DSPOp[32];
    protected int op;
    public static final int GlobalReg_mvoll = 12;
    public static final int GlobalReg_mvolr = 28;
    public static final int GlobalReg_evoll = 44;
    public static final int GlobalReg_evolr = 60;
    public static final int GlobalReg_kon = 76;
    public static final int GlobalReg_koff = 92;
    public static final int GlobalReg_flg = 108;
    public static final int GlobalReg_endx = 124;
    public static final int GlobalReg_efb = 13;
    public static final int GlobalReg_pmon = 45;
    public static final int GlobalReg_non = 61;
    public static final int GlobalReg_eon = 77;
    public static final int GlobalReg_dir = 93;
    public static final int GlobalReg_esa = 109;
    public static final int GlobalReg_edl = 125;
    public static final int GlobalReg_fir = 15;
    public static final int VoiceReg_voll = 0;
    public static final int VoiceReg_volr = 1;
    public static final int VoiceReg_pitchl = 2;
    public static final int VoiceReg_pitchh = 3;
    public static final int VoiceReg_srcn = 4;
    public static final int VoiceReg_adsr0 = 5;
    public static final int VoiceReg_adsr1 = 6;
    public static final int VoiceReg_gain = 7;
    public static final int VoiceReg_envx = 8;
    public static final int VoiceReg_outx = 9;
    public static final int EnvMode_release = 0;
    public static final int EnvMode_attack = 1;
    public static final int EnvMode_decay = 2;
    public static final int EnvMode_sustain = 3;
    public static final int echo_hist_size = 8;
    public static final int brr_buf_size = 12;
    public static final int brr_block_size = 9;
    protected State state = new State(8);
    protected Voice[] voice = new Voice[8];
    private static short[] gaussian_table;
    private static final int counter_range = 30720;
    private static int[] counter_rate;
    private static int[] counter_offset;

    static {
        short[] sArray = new short[512];
        sArray[16] = 1;
        sArray[17] = 1;
        sArray[18] = 1;
        sArray[19] = 1;
        sArray[20] = 1;
        sArray[21] = 1;
        sArray[22] = 1;
        sArray[23] = 1;
        sArray[24] = 1;
        sArray[25] = 1;
        sArray[26] = 1;
        sArray[27] = 2;
        sArray[28] = 2;
        sArray[29] = 2;
        sArray[30] = 2;
        sArray[31] = 2;
        sArray[32] = 2;
        sArray[33] = 2;
        sArray[34] = 3;
        sArray[35] = 3;
        sArray[36] = 3;
        sArray[37] = 3;
        sArray[38] = 3;
        sArray[39] = 4;
        sArray[40] = 4;
        sArray[41] = 4;
        sArray[42] = 4;
        sArray[43] = 4;
        sArray[44] = 5;
        sArray[45] = 5;
        sArray[46] = 5;
        sArray[47] = 5;
        sArray[48] = 6;
        sArray[49] = 6;
        sArray[50] = 6;
        sArray[51] = 6;
        sArray[52] = 7;
        sArray[53] = 7;
        sArray[54] = 7;
        sArray[55] = 8;
        sArray[56] = 8;
        sArray[57] = 8;
        sArray[58] = 9;
        sArray[59] = 9;
        sArray[60] = 9;
        sArray[61] = 10;
        sArray[62] = 10;
        sArray[63] = 10;
        sArray[64] = 11;
        sArray[65] = 11;
        sArray[66] = 11;
        sArray[67] = 12;
        sArray[68] = 12;
        sArray[69] = 13;
        sArray[70] = 13;
        sArray[71] = 14;
        sArray[72] = 14;
        sArray[73] = 15;
        sArray[74] = 15;
        sArray[75] = 15;
        sArray[76] = 16;
        sArray[77] = 16;
        sArray[78] = 17;
        sArray[79] = 17;
        sArray[80] = 18;
        sArray[81] = 19;
        sArray[82] = 19;
        sArray[83] = 20;
        sArray[84] = 20;
        sArray[85] = 21;
        sArray[86] = 21;
        sArray[87] = 22;
        sArray[88] = 23;
        sArray[89] = 23;
        sArray[90] = 24;
        sArray[91] = 24;
        sArray[92] = 25;
        sArray[93] = 26;
        sArray[94] = 27;
        sArray[95] = 27;
        sArray[96] = 28;
        sArray[97] = 29;
        sArray[98] = 29;
        sArray[99] = 30;
        sArray[100] = 31;
        sArray[101] = 32;
        sArray[102] = 32;
        sArray[103] = 33;
        sArray[104] = 34;
        sArray[105] = 35;
        sArray[106] = 36;
        sArray[107] = 36;
        sArray[108] = 37;
        sArray[109] = 38;
        sArray[110] = 39;
        sArray[111] = 40;
        sArray[112] = 41;
        sArray[113] = 42;
        sArray[114] = 43;
        sArray[115] = 44;
        sArray[116] = 45;
        sArray[117] = 46;
        sArray[118] = 47;
        sArray[119] = 48;
        sArray[120] = 49;
        sArray[121] = 50;
        sArray[122] = 51;
        sArray[123] = 52;
        sArray[124] = 53;
        sArray[125] = 54;
        sArray[126] = 55;
        sArray[127] = 56;
        sArray[128] = 58;
        sArray[129] = 59;
        sArray[130] = 60;
        sArray[131] = 61;
        sArray[132] = 62;
        sArray[133] = 64;
        sArray[134] = 65;
        sArray[135] = 66;
        sArray[136] = 67;
        sArray[137] = 69;
        sArray[138] = 70;
        sArray[139] = 71;
        sArray[140] = 73;
        sArray[141] = 74;
        sArray[142] = 76;
        sArray[143] = 77;
        sArray[144] = 78;
        sArray[145] = 80;
        sArray[146] = 81;
        sArray[147] = 83;
        sArray[148] = 84;
        sArray[149] = 86;
        sArray[150] = 87;
        sArray[151] = 89;
        sArray[152] = 90;
        sArray[153] = 92;
        sArray[154] = 94;
        sArray[155] = 95;
        sArray[156] = 97;
        sArray[157] = 99;
        sArray[158] = 100;
        sArray[159] = 102;
        sArray[160] = 104;
        sArray[161] = 106;
        sArray[162] = 107;
        sArray[163] = 109;
        sArray[164] = 111;
        sArray[165] = 113;
        sArray[166] = 115;
        sArray[167] = 117;
        sArray[168] = 118;
        sArray[169] = 120;
        sArray[170] = 122;
        sArray[171] = 124;
        sArray[172] = 126;
        sArray[173] = 128;
        sArray[174] = 130;
        sArray[175] = 132;
        sArray[176] = 134;
        sArray[177] = 137;
        sArray[178] = 139;
        sArray[179] = 141;
        sArray[180] = 143;
        sArray[181] = 145;
        sArray[182] = 147;
        sArray[183] = 150;
        sArray[184] = 152;
        sArray[185] = 154;
        sArray[186] = 156;
        sArray[187] = 159;
        sArray[188] = 161;
        sArray[189] = 163;
        sArray[190] = 166;
        sArray[191] = 168;
        sArray[192] = 171;
        sArray[193] = 173;
        sArray[194] = 175;
        sArray[195] = 178;
        sArray[196] = 180;
        sArray[197] = 183;
        sArray[198] = 186;
        sArray[199] = 188;
        sArray[200] = 191;
        sArray[201] = 193;
        sArray[202] = 196;
        sArray[203] = 199;
        sArray[204] = 201;
        sArray[205] = 204;
        sArray[206] = 207;
        sArray[207] = 210;
        sArray[208] = 212;
        sArray[209] = 215;
        sArray[210] = 218;
        sArray[211] = 221;
        sArray[212] = 224;
        sArray[213] = 227;
        sArray[214] = 230;
        sArray[215] = 233;
        sArray[216] = 236;
        sArray[217] = 239;
        sArray[218] = 242;
        sArray[219] = 245;
        sArray[220] = 248;
        sArray[221] = 251;
        sArray[222] = 254;
        sArray[223] = 257;
        sArray[224] = 260;
        sArray[225] = 263;
        sArray[226] = 267;
        sArray[227] = 270;
        sArray[228] = 273;
        sArray[229] = 276;
        sArray[230] = 280;
        sArray[231] = 283;
        sArray[232] = 286;
        sArray[233] = 290;
        sArray[234] = 293;
        sArray[235] = 297;
        sArray[236] = 300;
        sArray[237] = 304;
        sArray[238] = 307;
        sArray[239] = 311;
        sArray[240] = 314;
        sArray[241] = 318;
        sArray[242] = 321;
        sArray[243] = 325;
        sArray[244] = 328;
        sArray[245] = 332;
        sArray[246] = 336;
        sArray[247] = 339;
        sArray[248] = 343;
        sArray[249] = 347;
        sArray[250] = 351;
        sArray[251] = 354;
        sArray[252] = 358;
        sArray[253] = 362;
        sArray[254] = 366;
        sArray[255] = 370;
        sArray[256] = 374;
        sArray[257] = 378;
        sArray[258] = 381;
        sArray[259] = 385;
        sArray[260] = 389;
        sArray[261] = 393;
        sArray[262] = 397;
        sArray[263] = 401;
        sArray[264] = 405;
        sArray[265] = 410;
        sArray[266] = 414;
        sArray[267] = 418;
        sArray[268] = 422;
        sArray[269] = 426;
        sArray[270] = 430;
        sArray[271] = 434;
        sArray[272] = 439;
        sArray[273] = 443;
        sArray[274] = 447;
        sArray[275] = 451;
        sArray[276] = 456;
        sArray[277] = 460;
        sArray[278] = 464;
        sArray[279] = 469;
        sArray[280] = 473;
        sArray[281] = 477;
        sArray[282] = 482;
        sArray[283] = 486;
        sArray[284] = 491;
        sArray[285] = 495;
        sArray[286] = 499;
        sArray[287] = 504;
        sArray[288] = 508;
        sArray[289] = 513;
        sArray[290] = 517;
        sArray[291] = 522;
        sArray[292] = 527;
        sArray[293] = 531;
        sArray[294] = 536;
        sArray[295] = 540;
        sArray[296] = 545;
        sArray[297] = 550;
        sArray[298] = 554;
        sArray[299] = 559;
        sArray[300] = 563;
        sArray[301] = 568;
        sArray[302] = 573;
        sArray[303] = 577;
        sArray[304] = 582;
        sArray[305] = 587;
        sArray[306] = 592;
        sArray[307] = 596;
        sArray[308] = 601;
        sArray[309] = 606;
        sArray[310] = 611;
        sArray[311] = 615;
        sArray[312] = 620;
        sArray[313] = 625;
        sArray[314] = 630;
        sArray[315] = 635;
        sArray[316] = 640;
        sArray[317] = 644;
        sArray[318] = 649;
        sArray[319] = 654;
        sArray[320] = 659;
        sArray[321] = 664;
        sArray[322] = 669;
        sArray[323] = 674;
        sArray[324] = 678;
        sArray[325] = 683;
        sArray[326] = 688;
        sArray[327] = 693;
        sArray[328] = 698;
        sArray[329] = 703;
        sArray[330] = 708;
        sArray[331] = 713;
        sArray[332] = 718;
        sArray[333] = 723;
        sArray[334] = 728;
        sArray[335] = 732;
        sArray[336] = 737;
        sArray[337] = 742;
        sArray[338] = 747;
        sArray[339] = 752;
        sArray[340] = 757;
        sArray[341] = 762;
        sArray[342] = 767;
        sArray[343] = 772;
        sArray[344] = 777;
        sArray[345] = 782;
        sArray[346] = 787;
        sArray[347] = 792;
        sArray[348] = 797;
        sArray[349] = 802;
        sArray[350] = 806;
        sArray[351] = 811;
        sArray[352] = 816;
        sArray[353] = 821;
        sArray[354] = 826;
        sArray[355] = 831;
        sArray[356] = 836;
        sArray[357] = 841;
        sArray[358] = 846;
        sArray[359] = 851;
        sArray[360] = 855;
        sArray[361] = 860;
        sArray[362] = 865;
        sArray[363] = 870;
        sArray[364] = 875;
        sArray[365] = 880;
        sArray[366] = 884;
        sArray[367] = 889;
        sArray[368] = 894;
        sArray[369] = 899;
        sArray[370] = 904;
        sArray[371] = 908;
        sArray[372] = 913;
        sArray[373] = 918;
        sArray[374] = 923;
        sArray[375] = 927;
        sArray[376] = 932;
        sArray[377] = 937;
        sArray[378] = 941;
        sArray[379] = 946;
        sArray[380] = 951;
        sArray[381] = 955;
        sArray[382] = 960;
        sArray[383] = 965;
        sArray[384] = 969;
        sArray[385] = 974;
        sArray[386] = 978;
        sArray[387] = 983;
        sArray[388] = 988;
        sArray[389] = 992;
        sArray[390] = 997;
        sArray[391] = 1001;
        sArray[392] = 1005;
        sArray[393] = 1010;
        sArray[394] = 1014;
        sArray[395] = 1019;
        sArray[396] = 1023;
        sArray[397] = 1027;
        sArray[398] = 1032;
        sArray[399] = 1036;
        sArray[400] = 1040;
        sArray[401] = 1045;
        sArray[402] = 1049;
        sArray[403] = 1053;
        sArray[404] = 1057;
        sArray[405] = 1061;
        sArray[406] = 1066;
        sArray[407] = 1070;
        sArray[408] = 1074;
        sArray[409] = 1078;
        sArray[410] = 1082;
        sArray[411] = 1086;
        sArray[412] = 1090;
        sArray[413] = 1094;
        sArray[414] = 1098;
        sArray[415] = 1102;
        sArray[416] = 1106;
        sArray[417] = 1109;
        sArray[418] = 1113;
        sArray[419] = 1117;
        sArray[420] = 1121;
        sArray[421] = 1125;
        sArray[422] = 1128;
        sArray[423] = 1132;
        sArray[424] = 1136;
        sArray[425] = 1139;
        sArray[426] = 1143;
        sArray[427] = 1146;
        sArray[428] = 1150;
        sArray[429] = 1153;
        sArray[430] = 1157;
        sArray[431] = 1160;
        sArray[432] = 1164;
        sArray[433] = 1167;
        sArray[434] = 1170;
        sArray[435] = 1174;
        sArray[436] = 1177;
        sArray[437] = 1180;
        sArray[438] = 1183;
        sArray[439] = 1186;
        sArray[440] = 1190;
        sArray[441] = 1193;
        sArray[442] = 1196;
        sArray[443] = 1199;
        sArray[444] = 1202;
        sArray[445] = 1205;
        sArray[446] = 1207;
        sArray[447] = 1210;
        sArray[448] = 1213;
        sArray[449] = 1216;
        sArray[450] = 1219;
        sArray[451] = 1221;
        sArray[452] = 1224;
        sArray[453] = 1227;
        sArray[454] = 1229;
        sArray[455] = 1232;
        sArray[456] = 1234;
        sArray[457] = 1237;
        sArray[458] = 1239;
        sArray[459] = 1241;
        sArray[460] = 1244;
        sArray[461] = 1246;
        sArray[462] = 1248;
        sArray[463] = 1251;
        sArray[464] = 1253;
        sArray[465] = 1255;
        sArray[466] = 1257;
        sArray[467] = 1259;
        sArray[468] = 1261;
        sArray[469] = 1263;
        sArray[470] = 1265;
        sArray[471] = 1267;
        sArray[472] = 1269;
        sArray[473] = 1270;
        sArray[474] = 1272;
        sArray[475] = 1274;
        sArray[476] = 1275;
        sArray[477] = 1277;
        sArray[478] = 1279;
        sArray[479] = 1280;
        sArray[480] = 1282;
        sArray[481] = 1283;
        sArray[482] = 1284;
        sArray[483] = 1286;
        sArray[484] = 1287;
        sArray[485] = 1288;
        sArray[486] = 1290;
        sArray[487] = 1291;
        sArray[488] = 1292;
        sArray[489] = 1293;
        sArray[490] = 1294;
        sArray[491] = 1295;
        sArray[492] = 1296;
        sArray[493] = 1297;
        sArray[494] = 1297;
        sArray[495] = 1298;
        sArray[496] = 1299;
        sArray[497] = 1300;
        sArray[498] = 1300;
        sArray[499] = 1301;
        sArray[500] = 1302;
        sArray[501] = 1302;
        sArray[502] = 1303;
        sArray[503] = 1303;
        sArray[504] = 1303;
        sArray[505] = 1304;
        sArray[506] = 1304;
        sArray[507] = 1304;
        sArray[508] = 1304;
        sArray[509] = 1304;
        sArray[510] = 1305;
        sArray[511] = 1305;
        gaussian_table = sArray;
        int[] nArray = new int[32];
        nArray[1] = 2048;
        nArray[2] = 1536;
        nArray[3] = 1280;
        nArray[4] = 1024;
        nArray[5] = 768;
        nArray[6] = 640;
        nArray[7] = 512;
        nArray[8] = 384;
        nArray[9] = 320;
        nArray[10] = 256;
        nArray[11] = 192;
        nArray[12] = 160;
        nArray[13] = 128;
        nArray[14] = 96;
        nArray[15] = 80;
        nArray[16] = 64;
        nArray[17] = 48;
        nArray[18] = 40;
        nArray[19] = 32;
        nArray[20] = 24;
        nArray[21] = 20;
        nArray[22] = 16;
        nArray[23] = 12;
        nArray[24] = 10;
        nArray[25] = 8;
        nArray[26] = 6;
        nArray[27] = 5;
        nArray[28] = 4;
        nArray[29] = 3;
        nArray[30] = 2;
        nArray[31] = 1;
        counter_rate = nArray;
        int[] nArray2 = new int[32];
        nArray2[2] = 1040;
        nArray2[3] = 536;
        nArray2[5] = 1040;
        nArray2[6] = 536;
        nArray2[8] = 1040;
        nArray2[9] = 536;
        nArray2[11] = 1040;
        nArray2[12] = 536;
        nArray2[14] = 1040;
        nArray2[15] = 536;
        nArray2[17] = 1040;
        nArray2[18] = 536;
        nArray2[20] = 1040;
        nArray2[21] = 536;
        nArray2[23] = 1040;
        nArray2[24] = 536;
        nArray2[26] = 1040;
        nArray2[27] = 536;
        nArray2[29] = 1040;
        counter_offset = nArray2;
    }

    void initOps() {
        this.ops[0] = this.op_0;
        this.ops[1] = this.op_1;
        this.ops[2] = this.op_2;
        this.ops[3] = this.op_3;
        this.ops[4] = this.op_4;
        this.ops[5] = this.op_5;
        this.ops[6] = this.op_6;
        this.ops[7] = this.op_7;
        this.ops[8] = this.op_8;
        this.ops[9] = this.op_9;
        this.ops[10] = this.op_10;
        this.ops[11] = this.op_11;
        this.ops[12] = this.op_12;
        this.ops[13] = this.op_13;
        this.ops[14] = this.op_14;
        this.ops[15] = this.op_15;
        this.ops[16] = this.op_16;
        this.ops[17] = this.op_17;
        this.ops[18] = this.op_18;
        this.ops[19] = this.op_19;
        this.ops[20] = this.op_20;
        this.ops[21] = this.op_21;
        this.ops[22] = this.op_22;
        this.ops[23] = this.op_23;
        this.ops[24] = this.op_24;
        this.ops[25] = this.op_25;
        this.ops[26] = this.op_26;
        this.ops[27] = this.op_27;
        this.ops[28] = this.op_28;
        this.ops[29] = this.op_29;
        this.ops[30] = this.op_30;
        this.ops[31] = this.op_31;
    }

    private final int gaussian_interpolate(Voice v) {
        int offset = v.interp_pos >> 4 & 0xFF;
        int fwd = 255 - offset;
        int rev = offset;
        offset = v.buf_pos + (v.interp_pos >> 12);
        int output = gaussian_table[fwd + 0] * v.buffer.read(offset + 0) >> 11;
        output += gaussian_table[fwd + 256] * v.buffer.read(offset + 1) >> 11;
        output += gaussian_table[rev + 256] * v.buffer.read(offset + 2) >> 11;
        output = (short)output;
        return DSPCore.sclamp(16, output += gaussian_table[rev + 0] * v.buffer.read(offset + 3) >> 11) & 0xFFFFFFFE;
    }

    private void counter_tick() {
        --this.state.counter;
        if (this.state.counter < 0) {
            this.state.counter = 30719;
        }
    }

    private boolean counter_poll(int rate) {
        if (rate == 0) {
            return false;
        }
        return (this.state.counter + counter_offset[rate]) % counter_rate[rate] == 0;
    }

    private void envelope_run(Voice v) {
        int rate;
        int env = v.env;
        if (v.env_mode == 0) {
            if ((env -= 8) < 0) {
                env = 0;
            }
            v.env = env;
            return;
        }
        int env_data = this.state.regs[v.vidx + 6] & 0xFF;
        if ((this.state.t_adsr0 & 0x80) != 0) {
            if (v.env_mode >= 2) {
                --env;
                env -= env >> 8;
                rate = env_data & 0x1F;
                if (v.env_mode == 2) {
                    rate = (this.state.t_adsr0 >> 3 & 0xE) + 16;
                }
            } else {
                rate = ((this.state.t_adsr0 & 0xF) << 1) + 1;
                env += rate < 31 ? 32 : 1024;
            }
        } else {
            env_data = this.state.regs[v.vidx + 7] & 0xFF;
            int mode = env_data >> 5;
            if (mode < 4) {
                env = env_data << 4;
                rate = 31;
            } else {
                rate = env_data & 0x1F;
                if (mode == 4) {
                    env -= 32;
                } else if (mode < 6) {
                    --env;
                    env -= env >> 8;
                } else {
                    env += 32;
                    if (mode > 6 && ((long)v.hidden_env & 0xFFFFFFFFL) >= 1536L) {
                        env -= 24;
                    }
                }
            }
        }
        if (env >> 8 == env_data >> 5 && v.env_mode == 2) {
            v.env_mode = 3;
        }
        v.hidden_env = env;
        if (((long)env & 0xFFFFFFFFL) > 2047L) {
            int n = env = env < 0 ? 0 : 2047;
            if (v.env_mode == 1) {
                v.env_mode = 2;
            }
        }
        if (this.counter_poll(rate)) {
            v.env = env;
        }
    }

    private final void brr_decode(Voice v) {
        int nybbles = (this.state.t_brr_byte << 8) + (this.apuram[v.brr_addr + v.brr_offset + 1 & 0xFFFF] & 0xFF);
        int filter = this.state.t_brr_header >> 2 & 3;
        int scale = this.state.t_brr_header >> 4;
        int i = 0;
        while (i < 4) {
            int s = (short)nybbles >> 12;
            nybbles <<= 4;
            if (scale <= 12) {
                s <<= scale;
                s >>= 1;
            } else {
                s &= 0xFFFFF800;
            }
            int p1 = v.buffer.read(v.buf_pos - 1);
            int p2 = v.buffer.read(v.buf_pos - 2) >> 1;
            switch (filter) {
                case 0: {
                    break;
                }
                case 1: {
                    s += p1 >> 1;
                    s += -p1 >> 5;
                    break;
                }
                case 2: {
                    s += p1;
                    s -= p2;
                    s += p2 >> 4;
                    s += p1 * -3 >> 6;
                    break;
                }
                case 3: {
                    s += p1;
                    s -= p2;
                    s += p1 * -13 >> 7;
                    s += p2 * 3 >> 4;
                }
            }
            s = DSPCore.sclamp(16, s);
            s = (short)(s << 1);
            v.buffer.write(v.buf_pos++, s);
            if (v.buf_pos >= 12) {
                v.buf_pos = 0;
            }
            ++i;
        }
    }

    private void misc_27() {
        this.state.t_pmon = this.state.regs[45] & 0xFF & 0xFFFFFFFE;
    }

    private void misc_28() {
        this.state.t_non = this.state.regs[61] & 0xFF;
        this.state.t_eon = this.state.regs[77] & 0xFF;
        this.state.t_dir = this.state.regs[93] & 0xFF;
    }

    private void misc_29() {
        boolean bl = this.state.every_other_sample = !this.state.every_other_sample;
        if (this.state.every_other_sample) {
            this.state.new_kon &= ~this.state.kon;
        }
    }

    private void misc_30() {
        if (this.state.every_other_sample) {
            this.state.kon = this.state.new_kon;
            this.state.t_koff = this.state.regs[92] & 0xFF;
        }
        this.counter_tick();
        if (this.counter_poll(this.state.regs[108] & 0x1F)) {
            int feedback = this.state.noise << 13 ^ this.state.noise << 14;
            this.state.noise = feedback & 0x4000 ^ this.state.noise >> 1;
        }
    }

    private void voice_output(Voice v, boolean ch) {
        int channel = ch ? 1 : 0;
        int amp = this.state.t_output * (byte)(this.state.regs[v.vidx + 0 + channel] & 0xFF) >> 7;
        int n = channel;
        this.state.t_main_out[n] = this.state.t_main_out[n] + amp;
        this.state.t_main_out[channel] = DSPCore.sclamp(16, this.state.t_main_out[channel]);
        if ((this.state.t_eon & v.vbit) != 0) {
            int n2 = channel;
            this.state.t_echo_out[n2] = this.state.t_echo_out[n2] + amp;
            this.state.t_echo_out[channel] = DSPCore.sclamp(16, this.state.t_echo_out[channel]);
        }
    }

    private void voice_1(Voice v) {
        this.state.t_dir_addr = (this.state.t_dir << 8) + (this.state.t_srcn << 2);
        this.state.t_srcn = this.state.regs[v.vidx + 4] & 0xFF;
    }

    private void voice_2(Voice v) {
        int addr = this.state.t_dir_addr & 0xFFFF;
        if (v.kon_delay == 0) {
            addr += 2;
        }
        int lo = this.apuram[addr + 0] & 0xFF;
        int hi = this.apuram[addr + 1] & 0xFF;
        this.state.t_brr_next_addr = (hi << 8) + lo;
        this.state.t_adsr0 = this.state.regs[v.vidx + 5] & 0xFF;
        this.state.t_pitch = this.state.regs[v.vidx + 2] & 0xFF;
    }

    private final void voice_3(Voice v) {
        this.voice_3a(v);
        this.voice_3b(v);
        this.voice_3c(v);
    }

    private final void voice_3a(Voice v) {
        this.state.t_pitch += (this.state.regs[v.vidx + 3] & 0x3F) << 8;
    }

    private final void voice_3b(Voice v) {
        this.state.t_brr_byte = this.apuram[v.brr_addr + v.brr_offset & 0xFFFF] & 0xFF;
        this.state.t_brr_header = this.apuram[v.brr_addr & 0xFFFF] & 0xFF;
    }

    private final void voice_3c(Voice v) {
        if ((this.state.t_pmon & v.vbit) != 0) {
            this.state.t_pitch += (this.state.t_output >> 5) * this.state.t_pitch >> 10;
        }
        if (v.kon_delay != 0) {
            if (v.kon_delay == 5) {
                v.brr_addr = this.state.t_brr_next_addr;
                v.brr_offset = 1;
                v.buf_pos = 0;
                this.state.t_brr_header = 0;
            }
            v.env = 0;
            v.hidden_env = 0;
            v.interp_pos = 0;
            --v.kon_delay;
            if ((v.kon_delay & 3) != 0) {
                v.interp_pos = 16384;
            }
            this.state.t_pitch = 0;
        }
        int output = this.gaussian_interpolate(v);
        if ((this.state.t_non & v.vbit) != 0) {
            output = (short)(this.state.noise << 1);
        }
        this.state.t_output = output * v.env >> 11 & 0xFFFFFFFE;
        v.t_envx_out = v.env >> 4;
        if ((this.state.regs[108] & 0x80) != 0 || (this.state.t_brr_header & 3) == 1) {
            v.env_mode = 0;
            v.env = 0;
        }
        if (this.state.every_other_sample) {
            if ((this.state.t_koff & v.vbit) != 0) {
                v.env_mode = 0;
            }
            if ((this.state.kon & v.vbit) != 0) {
                v.kon_delay = 5;
                v.env_mode = 1;
            }
        }
        if (v.kon_delay == 0) {
            this.envelope_run(v);
        }
    }

    private void voice_4(Voice v) {
        this.state.t_looped = 0;
        if (v.interp_pos >= 16384) {
            this.brr_decode(v);
            v.brr_offset += 2;
            if (v.brr_offset >= 9) {
                v.brr_addr = v.brr_addr + 9 & 0xFFFF;
                if ((this.state.t_brr_header & 1) != 0) {
                    v.brr_addr = this.state.t_brr_next_addr;
                    this.state.t_looped = v.vbit;
                }
                v.brr_offset = 1;
            }
        }
        v.interp_pos = (v.interp_pos & 0x3FFF) + this.state.t_pitch;
        if (v.interp_pos > Short.MAX_VALUE) {
            v.interp_pos = Short.MAX_VALUE;
        }
        this.voice_output(v, false);
    }

    private void voice_5(Voice v) {
        this.voice_output(v, true);
        this.state.endx_buf = this.state.regs[124] & 0xFF | this.state.t_looped;
        if (v.kon_delay == 5) {
            this.state.endx_buf &= ~v.vbit;
        }
    }

    private void voice_6(Voice v) {
        this.state.outx_buf = this.state.t_output >> 8;
    }

    private void voice_7(Voice v) {
        this.state.regs[124] = this.state.endx_buf & 0xFF;
        this.state.envx_buf = v.t_envx_out;
    }

    private void voice_8(Voice v) {
        this.state.regs[v.vidx + 9] = this.state.outx_buf & 0xFF;
    }

    private void voice_9(Voice v) {
        this.state.regs[v.vidx + 8] = this.state.envx_buf & 0xFF;
    }

    private int calc_fir(int i, boolean ch) {
        int channel = ch ? 1 : 0;
        int s = this.state.echo_hist[channel].read(this.state.echo_hist_pos + i + 1);
        return s * (byte)(this.state.regs[15 + i * 16] & 0xFF) >> 6;
    }

    private int echo_output(boolean ch) {
        int channel = ch ? 1 : 0;
        int output = (short)(this.state.t_main_out[channel] * (byte)(this.state.regs[12 + channel * 16] & 0xFF) >> 7) + (short)(this.state.t_echo_in[channel] * (byte)(this.state.regs[44 + channel * 16] & 0xFF) >> 7);
        return DSPCore.sclamp(16, output);
    }

    private void echo_read(boolean ch) {
        int channel = ch ? 1 : 0;
        int addr = this.state.t_echo_ptr + channel * 2;
        int lo = this.apuram[addr + 0 & 0xFFFF] & 0xFF;
        int hi = this.apuram[addr + 1 & 0xFFFF] & 0xFF;
        short s = (short)((hi << 8) + lo);
        this.state.echo_hist[channel].write(this.state.echo_hist_pos, s >> 1);
    }

    private void echo_write(boolean ch) {
        int channel;
        int n = channel = ch ? 1 : 0;
        if ((this.state.t_echo_disabled & 0x20) == 0) {
            int addr = this.state.t_echo_ptr + channel * 2;
            int s = this.state.t_echo_out[channel];
            this.apuram[addr + 0 & 0xFFFF] = (byte)(s & 0xFF);
            this.apuram[addr + 1 & 0xFFFF] = (byte)(s >> 8 & 0xFF);
        }
        this.state.t_echo_out[channel] = 0;
    }

    private void echo_22() {
        ++this.state.echo_hist_pos;
        if (this.state.echo_hist_pos >= 8) {
            this.state.echo_hist_pos = 0;
        }
        this.state.t_echo_ptr = (this.state.t_esa << 8) + this.state.echo_offset & 0xFFFF;
        this.echo_read(false);
        int l = this.calc_fir(0, false);
        int r = this.calc_fir(0, true);
        this.state.t_echo_in[0] = l;
        this.state.t_echo_in[1] = r;
    }

    private void echo_23() {
        int l = this.calc_fir(1, false) + this.calc_fir(2, false);
        int r = this.calc_fir(1, true) + this.calc_fir(2, true);
        this.state.t_echo_in[0] = this.state.t_echo_in[0] + l;
        this.state.t_echo_in[1] = this.state.t_echo_in[1] + r;
        this.echo_read(true);
    }

    private void echo_24() {
        int l = this.calc_fir(3, false) + this.calc_fir(4, false) + this.calc_fir(5, false);
        int r = this.calc_fir(3, true) + this.calc_fir(4, true) + this.calc_fir(5, true);
        this.state.t_echo_in[0] = this.state.t_echo_in[0] + l;
        this.state.t_echo_in[1] = this.state.t_echo_in[1] + r;
    }

    private void echo_25() {
        int l = this.state.t_echo_in[0] + this.calc_fir(6, false);
        int r = this.state.t_echo_in[1] + this.calc_fir(6, true);
        l = (short)l;
        r = (short)r;
        this.state.t_echo_in[0] = DSPCore.sclamp(16, l += (short)this.calc_fir(7, false)) & 0xFFFFFFFE;
        this.state.t_echo_in[1] = DSPCore.sclamp(16, r += (short)this.calc_fir(7, true)) & 0xFFFFFFFE;
    }

    private void echo_26() {
        this.state.t_main_out[0] = this.echo_output(false);
        int l = this.state.t_echo_out[0] + (short)(this.state.t_echo_in[0] * (byte)(this.state.regs[13] & 0xFF) >> 7);
        int r = this.state.t_echo_out[1] + (short)(this.state.t_echo_in[1] * (byte)(this.state.regs[13] & 0xFF) >> 7);
        this.state.t_echo_out[0] = DSPCore.sclamp(16, l) & 0xFFFFFFFE;
        this.state.t_echo_out[1] = DSPCore.sclamp(16, r) & 0xFFFFFFFE;
    }

    private void echo_27() {
        int outl = this.state.t_main_out[0];
        int outr = this.echo_output(true);
        this.state.t_main_out[0] = 0;
        this.state.t_main_out[1] = 0;
        if ((this.state.regs[108] & 0x40) != 0) {
            outl = 0;
            outr = 0;
        }
        this.audio.write32bit(0, outl << 16 | outr & 0xFFFF);
    }

    private void echo_28() {
        this.state.t_echo_disabled = this.state.regs[108] & 0xFF;
    }

    private void echo_29() {
        this.state.t_esa = this.state.regs[109] & 0xFF;
        if (this.state.echo_offset == 0) {
            this.state.echo_length = (this.state.regs[125] & 0xF) << 11;
        }
        this.state.echo_offset += 4;
        if (this.state.echo_offset >= this.state.echo_length) {
            this.state.echo_offset = 0;
        }
        this.echo_write(false);
        this.state.t_echo_disabled = this.state.regs[108] & 0xFF;
    }

    private void echo_30() {
        this.echo_write(true);
    }

    public DSPCore() {
        this.initOps();
    }

    private static final int sclamp(int bits, int x) {
        int b = 1 << bits - 1;
        int m = (1 << bits - 1) - 1;
        return x > m ? m : (x < -b ? -b : x);
    }

    static interface DSPOp {
        public void run();
    }
}

