/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.smp;

import jario.hardware.Bus8bit;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.snes.smp.SMPCore;
import jario.snes.smp.SMPTimer;
import jario.snes.smp.Status;

public class SMP
extends SMPCore
implements Hardware,
Clockable,
Bus8bit,
Configurable {
    private static final int FREQUENCY = 24607104;
    private long clock;
    private int frequency_multiplier;
    protected Bus8bit apuram;
    protected Clockable dsp_clk;
    protected Bus8bit dsp_bus;
    protected Bus8bit cpu_bus;
    private SMPTimer t0;
    private SMPTimer t1;
    private SMPTimer t2;
    private static int[] iplrom;
    Status status = new Status();

    static {
        int[] nArray = new int[64];
        nArray[0] = 205;
        nArray[1] = 239;
        nArray[2] = 189;
        nArray[3] = 232;
        nArray[5] = 198;
        nArray[6] = 29;
        nArray[7] = 208;
        nArray[8] = 252;
        nArray[9] = 143;
        nArray[10] = 170;
        nArray[11] = 244;
        nArray[12] = 143;
        nArray[13] = 187;
        nArray[14] = 245;
        nArray[15] = 120;
        nArray[16] = 204;
        nArray[17] = 244;
        nArray[18] = 208;
        nArray[19] = 251;
        nArray[20] = 47;
        nArray[21] = 25;
        nArray[22] = 235;
        nArray[23] = 244;
        nArray[24] = 208;
        nArray[25] = 252;
        nArray[26] = 126;
        nArray[27] = 244;
        nArray[28] = 208;
        nArray[29] = 11;
        nArray[30] = 228;
        nArray[31] = 245;
        nArray[32] = 203;
        nArray[33] = 244;
        nArray[34] = 215;
        nArray[36] = 252;
        nArray[37] = 208;
        nArray[38] = 243;
        nArray[39] = 171;
        nArray[40] = 1;
        nArray[41] = 16;
        nArray[42] = 239;
        nArray[43] = 126;
        nArray[44] = 244;
        nArray[45] = 16;
        nArray[46] = 235;
        nArray[47] = 186;
        nArray[48] = 246;
        nArray[49] = 218;
        nArray[51] = 186;
        nArray[52] = 244;
        nArray[53] = 196;
        nArray[54] = 244;
        nArray[55] = 221;
        nArray[56] = 93;
        nArray[57] = 208;
        nArray[58] = 219;
        nArray[59] = 31;
        nArray[62] = 192;
        nArray[63] = 255;
        iplrom = nArray;
    }

    public SMP() {
        this.t0 = new SMPTimer(192, this);
        this.t1 = new SMPTimer(192, this);
        this.t2 = new SMPTimer(24, this);
        this.power();
    }

    public void connect(int port, Hardware hw) {
        switch (port) {
            case 0: {
                this.dsp_bus = (Bus8bit)hw;
                this.dsp_clk = (Clockable)hw;
                this.apuram = (Bus8bit)((Configurable)hw).readConfig("SRAM");
                break;
            }
            case 1: {
                this.cpu_bus = (Bus8bit)((Configurable)hw).readConfig("BUS B");
            }
        }
    }

    public byte read8bit(int port) {
        return this.apuram.read8bit(244 + (port & 3));
    }

    public void write8bit(int port, byte data) {
        this.apuram.write8bit(244 + (port & 3), data);
    }

    public void clock(long clocks) {
        this.clock -= clocks * 24607104L;
        while (this.clock < 0L) {
            this.opcode_table[this.op_readpc()].Invoke();
        }
    }

    public void reset() {
        this.clock = 0L;
        this.regs.pc = 65472;
        this.regs.r[this.regs.a] = 0;
        this.regs.r[this.regs.x] = 0;
        this.regs.r[this.regs.y] = 0;
        this.regs.r[this.regs.sp] = 239;
        this.regs.p.set(2);
        if (this.apuram != null) {
            int i = 0;
            while (i < 65536) {
                this.apuram.write8bit(i, (byte)0);
                ++i;
            }
        }
        this.status.clock_counter = 0;
        this.status.dsp_counter = 0;
        this.status.timer_step = 3;
        this.status.clock_speed = 0;
        this.status.timer_speed = 0;
        this.status.timers_enabled = true;
        this.status.ram_disabled = false;
        this.status.ram_writable = true;
        this.status.timers_disabled = false;
        this.status.iplrom_enabled = true;
        this.status.dsp_addr = 0;
        this.status.ram0 = 0;
        this.status.ram1 = 0;
        this.t0.stage0_ticks = 0;
        this.t1.stage0_ticks = 0;
        this.t2.stage0_ticks = 0;
        this.t0.stage1_ticks = 0;
        this.t1.stage1_ticks = 0;
        this.t2.stage1_ticks = 0;
        this.t0.stage2_ticks = 0;
        this.t1.stage2_ticks = 0;
        this.t2.stage2_ticks = 0;
        this.t0.stage3_ticks = 0;
        this.t1.stage3_ticks = 0;
        this.t2.stage3_ticks = 0;
        this.t0.current_line = false;
        this.t1.current_line = false;
        this.t2.current_line = false;
        this.t0.enabled = false;
        this.t1.enabled = false;
        this.t2.enabled = false;
    }

    private void power() {
        this.t0.target = 0;
        this.t1.target = 0;
        this.t2.target = 0;
        this.reset();
    }

    private int ram_read(int addr) {
        if ((addr & 0xFFFF) >= 65472 && this.status.iplrom_enabled) {
            return iplrom[addr & 0x3F];
        }
        if (this.status.ram_disabled) {
            return 90;
        }
        return this.apuram.read8bit(addr & 0xFFFF) & 0xFF;
    }

    private void ram_write(int addr, int data) {
        if (this.status.ram_writable && !this.status.ram_disabled) {
            this.apuram.write8bit(addr & 0xFFFF, (byte)data);
        }
    }

    private int op_busread(int addr) {
        int r = 0;
        if ((addr & 0xFFF0) == 240) {
            switch (addr) {
                case 240: {
                    r = 0;
                    break;
                }
                case 241: {
                    r = 0;
                    break;
                }
                case 242: {
                    r = this.status.dsp_addr;
                    break;
                }
                case 243: {
                    r = this.dsp_bus.read8bit(this.status.dsp_addr & 0x7F) & 0xFF;
                    break;
                }
                case 244: 
                case 245: 
                case 246: 
                case 247: {
                    r = this.cpu_bus.read8bit(addr) & 0xFF;
                    break;
                }
                case 248: {
                    r = this.status.ram0;
                    break;
                }
                case 249: {
                    r = this.status.ram1;
                    break;
                }
                case 250: 
                case 251: 
                case 252: {
                    r = 0;
                    break;
                }
                case 253: {
                    r = this.t0.stage3_ticks & 0xF;
                    this.t0.stage3_ticks = 0;
                    break;
                }
                case 254: {
                    r = this.t1.stage3_ticks & 0xF;
                    this.t1.stage3_ticks = 0;
                    break;
                }
                case 255: {
                    r = this.t2.stage3_ticks & 0xF;
                    this.t2.stage3_ticks = 0;
                }
            }
        } else {
            r = this.ram_read(addr);
        }
        return r & 0xFF;
    }

    private void op_buswrite(int addr, int data) {
        if ((addr & 0xFFF0) == 240) {
            switch (addr) {
                case 240: {
                    if (this.regs.p.p) break;
                    this.status.clock_speed = data >> 6 & 3 & 0xFF;
                    this.status.timer_speed = data >> 4 & 3 & 0xFF;
                    this.status.timers_enabled = (data & 8) != 0;
                    this.status.ram_disabled = (data & 4) != 0;
                    this.status.ram_writable = (data & 2) != 0;
                    this.status.timers_disabled = (data & 1) != 0;
                    this.status.timer_step = (1 << this.status.clock_speed) + (2 << this.status.timer_speed);
                    this.t0.sync_stage1();
                    this.t1.sync_stage1();
                    this.t2.sync_stage1();
                    break;
                }
                case 241: {
                    boolean bl = this.status.iplrom_enabled = (data & 0x80) != 0;
                    if ((data & 0x30) != 0) {
                        if ((data & 0x20) != 0) {
                            this.cpu_bus.write8bit(2, (byte)0);
                            this.cpu_bus.write8bit(3, (byte)0);
                        }
                        if ((data & 0x10) != 0) {
                            this.cpu_bus.write8bit(0, (byte)0);
                            this.cpu_bus.write8bit(1, (byte)0);
                        }
                    }
                    if (!this.t2.enabled && (data & 4) != 0) {
                        this.t2.stage2_ticks = 0;
                        this.t2.stage3_ticks = 0;
                    }
                    boolean bl2 = this.t2.enabled = (data & 4) != 0;
                    if (!this.t1.enabled && (data & 2) != 0) {
                        this.t1.stage2_ticks = 0;
                        this.t1.stage3_ticks = 0;
                    }
                    boolean bl3 = this.t1.enabled = (data & 2) != 0;
                    if (!this.t0.enabled && (data & 1) != 0) {
                        this.t0.stage2_ticks = 0;
                        this.t0.stage3_ticks = 0;
                    }
                    this.t0.enabled = (data & 1) != 0;
                    break;
                }
                case 242: {
                    this.status.dsp_addr = data & 0xFF;
                    break;
                }
                case 243: {
                    if ((this.status.dsp_addr & 0x80) != 0) break;
                    this.dsp_bus.write8bit(this.status.dsp_addr & 0x7F, (byte)data);
                    break;
                }
                case 244: 
                case 245: 
                case 246: 
                case 247: {
                    this.write8bit(addr, (byte)data);
                    break;
                }
                case 248: {
                    this.status.ram0 = data & 0xFF;
                    break;
                }
                case 249: {
                    this.status.ram1 = data & 0xFF;
                    break;
                }
                case 250: {
                    this.t0.target = data & 0xFF;
                    break;
                }
                case 251: {
                    this.t1.target = data & 0xFF;
                    break;
                }
                case 252: {
                    this.t2.target = data & 0xFF;
                    break;
                }
            }
        }
        this.ram_write(addr, data & 0xFF);
    }

    @Override
    public void op_io() {
        this.add_clocks(24L);
        this.cycle_edge();
    }

    @Override
    public byte op_read(int addr) {
        this.add_clocks(12L);
        int r = this.op_busread(addr);
        this.add_clocks(12L);
        this.cycle_edge();
        return (byte)r;
    }

    @Override
    public void op_write(int addr, byte data) {
        this.add_clocks(24L);
        this.op_buswrite(addr, data);
        this.cycle_edge();
    }

    private void add_clocks(long clocks) {
        this.clock += clocks * (long)this.frequency_multiplier;
        this.dsp_clk.clock(clocks);
    }

    private void cycle_edge() {
        this.t0.tick();
        this.t1.tick();
        this.t2.tick();
        switch (this.status.clock_speed) {
            case 0: {
                break;
            }
            case 1: {
                this.add_clocks(24L);
                break;
            }
            case 2: {
                System.out.println("SMP lock (entering infinite loop)");
                while (true) {
                    this.add_clocks(24L);
                }
            }
            case 3: {
                this.add_clocks(216L);
            }
        }
    }

    public Object readConfig(String key) {
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("region")) {
            this.frequency_multiplier = value.toString().equals("ntsc") ? 21477272 : 21281370;
        }
    }
}

