/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.smp;

import jario.snes.smp.Regs;
import jario.snes.smp.SMPCoreOpArgument;
import jario.snes.smp.SMPCoreOpResult;
import jario.snes.smp.SMPCoreOperation;

public abstract class SMPCore {
    public Regs regs = new Regs();
    public int dp;
    public int sp;
    public int rd;
    public int wr;
    public int bit;
    public int ya;
    private static final int OpCode_A = 0;
    private static final int OpCode_X = 1;
    private static final int OpCode_Y = 2;
    private static final int OpCode_SP = 3;
    public SMPCoreOperation.SMPCoreOp op_adc = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            int r = args.x + args.y + (SMPCore.this.regs.p.c ? 1 : 0);
            SMPCore.this.regs.p.n = (r & 0x80) != 0;
            SMPCore.this.regs.p.v = (~(args.x ^ args.y) & (args.x ^ r) & 0x80) != 0;
            SMPCore.this.regs.p.h = ((args.x ^ args.y ^ r) & 0x10) != 0;
            SMPCore.this.regs.p.z = (r & 0xFF) == 0;
            SMPCore.this.regs.p.c = r > 255;
            return new SMPCoreOpResult(r);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_addw = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.regs.p.c = false;
            int r = SMPCore.this.op_adc.Invoke(new SMPCoreOpArgument(args.x & 0xFF, args.y & 0xFF)).result_byte();
            SMPCore.this.regs.p.z = (r |= SMPCore.this.op_adc.Invoke(new SMPCoreOpArgument(args.x >> 8 & 0xFF, args.y >> 8 & 0xFF)).result_byte() << 8) == 0;
            return new SMPCoreOpResult(r);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_and = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            args.x &= args.y;
            SMPCore.this.regs.p.n = (args.x & 0x80) != 0;
            SMPCore.this.regs.p.z = args.x == 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_cmp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            int r = args.x - args.y;
            SMPCore.this.regs.p.n = (r & 0x80) != 0;
            SMPCore.this.regs.p.z = (r & 0xFF) == 0;
            SMPCore.this.regs.p.c = r >= 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_cmpw = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            int r = args.x - args.y;
            SMPCore.this.regs.p.n = (r & 0x8000) != 0;
            SMPCore.this.regs.p.z = (r & 0xFFFF) == 0;
            SMPCore.this.regs.p.c = r >= 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_eor = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            args.x ^= args.y;
            SMPCore.this.regs.p.n = (args.x & 0x80) != 0;
            SMPCore.this.regs.p.z = args.x == 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_inc = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            ++args.x;
            SMPCore.this.regs.p.n = (args.x & 0x80) != 0;
            SMPCore.this.regs.p.z = (args.x & 0xFF) == 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_dec = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            --args.x;
            SMPCore.this.regs.p.n = (args.x & 0x80) != 0;
            SMPCore.this.regs.p.z = (args.x & 0xFF) == 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_or = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            args.x |= args.y;
            SMPCore.this.regs.p.n = (args.x & 0x80) != 0;
            SMPCore.this.regs.p.z = args.x == 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_sbc = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            int r = args.x - args.y - (!SMPCore.this.regs.p.c ? 1 : 0);
            SMPCore.this.regs.p.n = (r & 0x80) != 0;
            SMPCore.this.regs.p.v = ((args.x ^ args.y) & (args.x ^ r) & 0x80) != 0;
            SMPCore.this.regs.p.h = ((args.x ^ args.y ^ r) & 0x10) == 0;
            SMPCore.this.regs.p.z = (r & 0xFF) == 0;
            SMPCore.this.regs.p.c = r >= 0;
            return new SMPCoreOpResult(r);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_subw = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.regs.p.c = true;
            int r = SMPCore.this.op_sbc.Invoke(new SMPCoreOpArgument(args.x & 0xFF, args.y & 0xFF)).result_byte();
            SMPCore.this.regs.p.z = (r |= SMPCore.this.op_sbc.Invoke(new SMPCoreOpArgument(args.x >> 8 & 0xFF, args.y >> 8 & 0xFF)).result_byte() << 8) == 0;
            return new SMPCoreOpResult(r);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_asl = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.regs.p.c = (args.x & 0x80) != 0;
            args.x <<= 1;
            SMPCore.this.regs.p.n = (args.x & 0x80) != 0;
            SMPCore.this.regs.p.z = (args.x & 0xFF) == 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_lsr = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.regs.p.c = (args.x & 1) != 0;
            args.x >>= 1;
            SMPCore.this.regs.p.n = (args.x & 0x80) != 0;
            SMPCore.this.regs.p.z = (args.x & 0xFF) == 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_rol = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            int carry = SMPCore.this.regs.p.c ? 1 : 0;
            SMPCore.this.regs.p.c = (args.x & 0x80) != 0;
            args.x = (args.x << 1 | carry) & 0xFF;
            SMPCore.this.regs.p.n = (args.x & 0x80) != 0;
            SMPCore.this.regs.p.z = args.x == 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_ror = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            int carry = (SMPCore.this.regs.p.c ? 1 : 0) << 7;
            SMPCore.this.regs.p.c = (args.x & 1) != 0;
            args.x = (carry | args.x >> 1) & 0xFF;
            SMPCore.this.regs.p.n = (args.x & 0x80) != 0;
            SMPCore.this.regs.p.z = args.x == 0;
            return new SMPCoreOpResult(args.x);
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_reg_reg = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.regs.r[args.to] = SMPCore.this.regs.r[args.from];
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[args.to] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[args.to] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_sp_x = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.regs.r[SMPCore.this.regs.sp] = SMPCore.this.regs.r[SMPCore.this.regs.x];
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_reg_const = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.regs.r[args.n] = SMPCore.this.op_readpc();
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[args.n] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[args.n] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_a_ix = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.regs.r[SMPCore.this.regs.a] = SMPCore.this.op_readdp(SMPCore.this.regs.r[SMPCore.this.regs.x]);
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.a] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_a_ixinc = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            int n = SMPCore.this.regs.x;
            int n2 = SMPCore.this.regs.r[n];
            SMPCore.this.regs.r[n] = n2 + 1;
            SMPCore.this.regs.r[SMPCore.this.regs.a] = SMPCore.this.op_readdp(n2);
            SMPCore.this.op_io();
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.a] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_reg_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.sp = SMPCore.this.op_readpc();
            SMPCore.this.regs.r[args.n] = SMPCore.this.op_readdp(SMPCore.this.sp);
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[args.n] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[args.n] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_reg_dpr = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.sp = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            SMPCore.this.regs.r[args.n] = SMPCore.this.op_readdp(SMPCore.this.sp + SMPCore.this.regs.r[args.i]);
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[args.n] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[args.n] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_reg_addr = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.sp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.sp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.regs.r[args.n] = SMPCore.this.op_readaddr(SMPCore.this.sp);
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[args.n] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[args.n] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_a_addrr = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.sp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.sp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.op_io();
            SMPCore.this.regs.r[SMPCore.this.regs.a] = SMPCore.this.op_readaddr(SMPCore.this.sp + SMPCore.this.regs.r[args.i]);
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.a] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_a_idpx = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() + SMPCore.this.regs.r[SMPCore.this.regs.x] & 0xFFFF;
            SMPCore.this.op_io();
            SMPCore.this.sp = SMPCore.this.op_readdp(SMPCore.this.dp + 0) << 0;
            SMPCore.this.sp |= SMPCore.this.op_readdp(SMPCore.this.dp + 1) << 8;
            SMPCore.this.regs.r[SMPCore.this.regs.a] = SMPCore.this.op_readaddr(SMPCore.this.sp);
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.a] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_a_idpy = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            SMPCore.this.sp = SMPCore.this.op_readdp(SMPCore.this.dp + 0) << 0;
            SMPCore.this.sp |= SMPCore.this.op_readdp(SMPCore.this.dp + 1) << 8;
            SMPCore.this.regs.r[SMPCore.this.regs.a] = SMPCore.this.op_readaddr(SMPCore.this.sp + SMPCore.this.regs.r[SMPCore.this.regs.y]);
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.a] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_dp_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.sp = SMPCore.this.op_readpc();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.sp);
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.op_writedp(SMPCore.this.dp, SMPCore.this.rd);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_dp_const = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readpc();
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.op_writedp(SMPCore.this.dp, SMPCore.this.rd);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_ix_a = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_readdp(SMPCore.this.regs.r[SMPCore.this.regs.x]);
            SMPCore.this.op_writedp(SMPCore.this.regs.r[SMPCore.this.regs.x], SMPCore.this.regs.r[SMPCore.this.regs.a]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_ixinc_a = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            int n = SMPCore.this.regs.x;
            int n2 = SMPCore.this.regs.r[n];
            SMPCore.this.regs.r[n] = n2 + 1;
            SMPCore.this.op_writedp(n2, SMPCore.this.regs.r[SMPCore.this.regs.a]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_dp_reg = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.op_writedp(SMPCore.this.dp, SMPCore.this.regs.r[args.n]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_dpr_reg = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            SMPCore.this.dp += SMPCore.this.regs.r[args.i];
            SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.op_writedp(SMPCore.this.dp, SMPCore.this.regs.r[args.n]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_addr_reg = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.op_writeaddr(SMPCore.this.dp, SMPCore.this.regs.r[args.n]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_addrr_a = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.op_io();
            SMPCore.this.dp += SMPCore.this.regs.r[args.i];
            SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.op_writeaddr(SMPCore.this.dp, SMPCore.this.regs.r[SMPCore.this.regs.a]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_idpx_a = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.sp = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            SMPCore.this.sp += SMPCore.this.regs.r[SMPCore.this.regs.x];
            SMPCore.this.dp = SMPCore.this.op_readdp(SMPCore.this.sp + 0) << 0;
            SMPCore.this.dp |= SMPCore.this.op_readdp(SMPCore.this.sp + 1) << 8;
            SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.op_writeaddr(SMPCore.this.dp, SMPCore.this.regs.r[SMPCore.this.regs.a]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov_idpy_a = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.sp = SMPCore.this.op_readpc();
            SMPCore.this.dp = SMPCore.this.op_readdp(SMPCore.this.sp + 0) << 0;
            SMPCore.this.dp |= SMPCore.this.op_readdp(SMPCore.this.sp + 1) << 8;
            SMPCore.this.op_io();
            SMPCore.this.dp += SMPCore.this.regs.r[SMPCore.this.regs.y];
            SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.op_writeaddr(SMPCore.this.dp, SMPCore.this.regs.r[SMPCore.this.regs.a]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_movw_ya_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.sp = SMPCore.this.op_readpc();
            SMPCore.this.regs.r[SMPCore.this.regs.a] = SMPCore.this.op_readdp(SMPCore.this.sp + 0);
            SMPCore.this.op_io();
            SMPCore.this.regs.r[SMPCore.this.regs.y] = SMPCore.this.op_readdp(SMPCore.this.sp + 1);
            SMPCore.this.regs.p.n = (SMPCore.this.regs.ya.get() & 0x8000) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.ya.get() == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_movw_dp_ya = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.op_writedp(SMPCore.this.dp + 0, SMPCore.this.regs.r[SMPCore.this.regs.a]);
            SMPCore.this.op_writedp(SMPCore.this.dp + 1, SMPCore.this.regs.r[SMPCore.this.regs.y]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov1_c_bit = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.sp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.sp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.bit = SMPCore.this.sp >> 13;
            SMPCore.this.sp &= 0x1FFF;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.sp);
            SMPCore.this.regs.p.c = (SMPCore.this.rd & 1 << SMPCore.this.bit) != 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mov1_bit_c = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.bit = SMPCore.this.dp >> 13;
            SMPCore.this.dp &= 0x1FFF;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.rd = SMPCore.this.regs.p.c ? (SMPCore.this.rd |= 1 << SMPCore.this.bit) : (SMPCore.this.rd &= ~(1 << SMPCore.this.bit));
            SMPCore.this.op_io();
            SMPCore.this.op_writeaddr(SMPCore.this.dp, SMPCore.this.rd);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_bra = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.pc += (byte)SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_branch = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readpc();
            if (((SMPCore.this.regs.p.get() & args.flag) != 0 ? 1 : 0) != args.value) {
                return null;
            }
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.pc += (byte)SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_bitbranch = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.sp = SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.rd = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            if (((SMPCore.this.sp & args.mask) != 0 ? 1 : 0) != args.value) {
                return null;
            }
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.pc += (byte)SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_cbne_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.sp = SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.rd = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            if (SMPCore.this.regs.r[SMPCore.this.regs.a] == SMPCore.this.sp) {
                return null;
            }
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.pc += (byte)SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_cbne_dpx = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            SMPCore.this.sp = SMPCore.this.op_readdp(SMPCore.this.dp + SMPCore.this.regs.r[SMPCore.this.regs.x]);
            SMPCore.this.rd = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            if (SMPCore.this.regs.r[SMPCore.this.regs.a] == SMPCore.this.sp) {
                return null;
            }
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.pc += (byte)SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_dbnz_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.wr = SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.op_writedp(SMPCore.this.dp, --SMPCore.this.wr);
            SMPCore.this.rd = SMPCore.this.op_readpc();
            if (SMPCore.this.wr == 0) {
                return null;
            }
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.pc += (byte)SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_dbnz_y = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            int n = SMPCore.this.regs.y;
            SMPCore.this.regs.r[n] = SMPCore.this.regs.r[n] - 1;
            SMPCore.this.op_io();
            if (SMPCore.this.regs.r[SMPCore.this.regs.y] == 0) {
                return null;
            }
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.pc += (byte)SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_jmp_addr = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readpc() << 0;
            SMPCore.this.rd |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.regs.pc = SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_jmp_iaddrx = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.op_io();
            SMPCore.this.dp += SMPCore.this.regs.r[SMPCore.this.regs.x];
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp + 0) << 0;
            SMPCore.this.rd |= SMPCore.this.op_readaddr(SMPCore.this.dp + 1) << 8;
            SMPCore.this.regs.pc = SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_call = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readpc() << 0;
            SMPCore.this.rd |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_writestack(SMPCore.this.regs.pc >> 8);
            SMPCore.this.op_writestack(SMPCore.this.regs.pc >> 0);
            SMPCore.this.regs.pc = SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_pcall = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_writestack(SMPCore.this.regs.pc >> 8);
            SMPCore.this.op_writestack(SMPCore.this.regs.pc >> 0);
            SMPCore.this.regs.pc = 0xFF00 | SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_tcall = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = 65502 - (args.n << 1);
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp + 0) << 0;
            SMPCore.this.rd |= SMPCore.this.op_readaddr(SMPCore.this.dp + 1) << 8;
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_writestack(SMPCore.this.regs.pc >> 8);
            SMPCore.this.op_writestack(SMPCore.this.regs.pc >> 0);
            SMPCore.this.regs.pc = SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_brk = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readaddr(65502) << 0;
            SMPCore.this.rd |= SMPCore.this.op_readaddr(65503) << 8;
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_writestack(SMPCore.this.regs.pc >> 8);
            SMPCore.this.op_writestack(SMPCore.this.regs.pc >> 0);
            SMPCore.this.op_writestack(SMPCore.this.regs.p.get());
            SMPCore.this.regs.pc = SMPCore.this.rd;
            SMPCore.this.regs.p.b = true;
            SMPCore.this.regs.p.i = false;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_ret = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readstack() << 0;
            SMPCore.this.rd |= SMPCore.this.op_readstack() << 8;
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.pc = SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_reti = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.regs.p.set(SMPCore.this.op_readstack());
            SMPCore.this.rd = SMPCore.this.op_readstack() << 0;
            SMPCore.this.rd |= SMPCore.this.op_readstack() << 8;
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.pc = SMPCore.this.rd;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_reg_const = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readpc();
            SMPCore.this.regs.r[args.n] = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.r[args.n] & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_a_ix = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.regs.r[SMPCore.this.regs.x]);
            SMPCore.this.regs.r[SMPCore.this.regs.a] = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.r[SMPCore.this.regs.a] & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_reg_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.regs.r[args.n] = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.r[args.n] & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_a_dpx = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.dp + SMPCore.this.regs.r[SMPCore.this.regs.x]);
            SMPCore.this.regs.r[SMPCore.this.regs.a] = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.r[SMPCore.this.regs.a] & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_reg_addr = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.regs.r[args.n] = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.r[args.n] & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_a_addrr = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.op_io();
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp + SMPCore.this.regs.r[args.i]);
            SMPCore.this.regs.r[SMPCore.this.regs.a] = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.r[SMPCore.this.regs.a] & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_a_idpx = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() + SMPCore.this.regs.r[SMPCore.this.regs.x] & 0xFFFF;
            SMPCore.this.op_io();
            SMPCore.this.sp = SMPCore.this.op_readdp(SMPCore.this.dp + 0) << 0;
            SMPCore.this.sp |= SMPCore.this.op_readdp(SMPCore.this.dp + 1) << 8;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.sp);
            SMPCore.this.regs.r[SMPCore.this.regs.a] = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.r[SMPCore.this.regs.a] & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_a_idpy = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            SMPCore.this.sp = SMPCore.this.op_readdp(SMPCore.this.dp + 0) << 0;
            SMPCore.this.sp |= SMPCore.this.op_readdp(SMPCore.this.dp + 1) << 8;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.sp + SMPCore.this.regs.r[SMPCore.this.regs.y]);
            SMPCore.this.regs.r[SMPCore.this.regs.a] = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.r[SMPCore.this.regs.a] & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_ix_iy = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.regs.r[SMPCore.this.regs.y]);
            SMPCore.this.wr = SMPCore.this.op_readdp(SMPCore.this.regs.r[SMPCore.this.regs.x]);
            SMPCore.this.wr = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.wr & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            SMPCoreOperation.SMPCoreOp cmp = SMPCore.this.op_cmp;
            if (args.op_func != cmp) {
                SMPCore.this.op_writedp(SMPCore.this.regs.r[SMPCore.this.regs.x], SMPCore.this.wr);
            } else {
                SMPCore.this.op_io();
            }
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_dp_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.sp = SMPCore.this.op_readpc();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.sp);
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.wr = SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.wr = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.wr & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            SMPCoreOperation.SMPCoreOp cmp = SMPCore.this.op_cmp;
            if (args.op_func != cmp) {
                SMPCore.this.op_writedp(SMPCore.this.dp, SMPCore.this.wr);
            } else {
                SMPCore.this.op_io();
            }
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_dp_const = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.rd = SMPCore.this.op_readpc();
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.wr = SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.wr = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.wr & 0xFF, SMPCore.this.rd & 0xFF)).result_byte();
            SMPCoreOperation.SMPCoreOp cmp = SMPCore.this.op_cmp;
            if (args.op_func != cmp) {
                SMPCore.this.op_writedp(SMPCore.this.dp, SMPCore.this.wr);
            } else {
                SMPCore.this.op_io();
            }
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_read_ya_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.dp + 0) << 0;
            SMPCore.this.op_io();
            SMPCore.this.rd |= SMPCore.this.op_readdp(SMPCore.this.dp + 1) << 8;
            SMPCore.this.regs.ya.set(args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.ya.get(), SMPCore.this.rd & 0xFFFF)).result_ushort());
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_cmpw_ya_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.dp + 0) << 0;
            SMPCore.this.rd |= SMPCore.this.op_readdp(SMPCore.this.dp + 1) << 8;
            SMPCore.this.op_cmpw.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.ya.get(), SMPCore.this.rd & 0xFFFF));
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_and1_bit = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.bit = SMPCore.this.dp >> 13;
            SMPCore.this.dp &= 0x1FFF;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.regs.p.c = ((SMPCore.this.regs.p.c ? 1 : 0) & (((SMPCore.this.rd & 1 << SMPCore.this.bit) != 0 ? 1 : 0) ^ args.op)) != 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_eor1_bit = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.bit = SMPCore.this.dp >> 13;
            SMPCore.this.dp &= 0x1FFF;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.op_io();
            SMPCore.this.regs.p.c = SMPCore.this.regs.p.c ^ (SMPCore.this.rd & 1 << SMPCore.this.bit) != 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_not1_bit = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.bit = SMPCore.this.dp >> 13;
            SMPCore.this.dp &= 0x1FFF;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.rd ^= 1 << SMPCore.this.bit;
            SMPCore.this.op_writeaddr(SMPCore.this.dp, SMPCore.this.rd);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_or1_bit = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.bit = SMPCore.this.dp >> 13;
            SMPCore.this.dp &= 0x1FFF;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.op_io();
            SMPCore.this.regs.p.c = ((SMPCore.this.regs.p.c ? 1 : 0) | ((SMPCore.this.rd & 1 << SMPCore.this.bit) != 0 ? 1 : 0) ^ args.op) != 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_adjust_reg = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.regs.r[args.n] = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.regs.r[args.n] & 0xFF)).result_byte();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_adjust_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.rd = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.rd & 0xFF)).result_byte();
            SMPCore.this.op_writedp(SMPCore.this.dp, SMPCore.this.rd);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_adjust_dpx = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.op_io();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.dp + SMPCore.this.regs.r[SMPCore.this.regs.x]);
            SMPCore.this.rd = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.rd & 0xFF)).result_byte();
            SMPCore.this.op_writedp(SMPCore.this.dp + SMPCore.this.regs.r[SMPCore.this.regs.x], SMPCore.this.rd);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_adjust_addr = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.rd = args.op_func.Invoke(new SMPCoreOpArgument(SMPCore.this.rd & 0xFF)).result_byte();
            SMPCore.this.op_writeaddr(SMPCore.this.dp, SMPCore.this.rd);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_adjust_addr_a = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc() << 0;
            SMPCore.this.dp |= SMPCore.this.op_readpc() << 8;
            SMPCore.this.rd = SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.a] - SMPCore.this.rd & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.a] - SMPCore.this.rd == 0;
            SMPCore.this.op_readaddr(SMPCore.this.dp);
            SMPCore.this.op_writeaddr(SMPCore.this.dp, args.op != 0 ? SMPCore.this.rd | SMPCore.this.regs.r[SMPCore.this.regs.a] : SMPCore.this.rd & ~SMPCore.this.regs.r[SMPCore.this.regs.a]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_adjustw_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.dp) << 0;
            SMPCore.this.rd += args.adjust & 0xFFFF;
            SMPCore.this.op_writedp(SMPCore.this.dp++, SMPCore.this.rd);
            SMPCore.this.rd += SMPCore.this.op_readdp(SMPCore.this.dp) << 8;
            SMPCore.this.op_writedp(SMPCore.this.dp, SMPCore.this.rd >> 8);
            SMPCore.this.regs.p.n = (SMPCore.this.rd & 0x8000) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.rd == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_nop = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_wait = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            System.out.println("SMP wait (entering infinite loop)");
            while (true) {
                SMPCore.this.op_io();
                SMPCore.this.op_io();
            }
        }
    };
    public SMPCoreOperation.SMPCoreOp op_xcn = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.r[SMPCore.this.regs.a] = SMPCore.this.regs.r[SMPCore.this.regs.a] >> 4 | SMPCore.this.regs.r[SMPCore.this.regs.a] << 4 & 0xFF;
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.a] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_daa = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            if (SMPCore.this.regs.p.c || SMPCore.this.regs.r[SMPCore.this.regs.a] > 153) {
                int n = SMPCore.this.regs.a;
                SMPCore.this.regs.r[n] = SMPCore.this.regs.r[n] + 96;
                SMPCore.this.regs.p.c = true;
            }
            if (SMPCore.this.regs.p.h || (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0xF) > 9) {
                int n = SMPCore.this.regs.a;
                SMPCore.this.regs.r[n] = SMPCore.this.regs.r[n] + 6;
            }
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.a] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_das = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            if (!SMPCore.this.regs.p.c || SMPCore.this.regs.r[SMPCore.this.regs.a] > 153) {
                int n = SMPCore.this.regs.a;
                SMPCore.this.regs.r[n] = SMPCore.this.regs.r[n] - 96;
                SMPCore.this.regs.p.c = false;
            }
            if (!SMPCore.this.regs.p.h || (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0xF) > 9) {
                int n = SMPCore.this.regs.a;
                SMPCore.this.regs.r[n] = SMPCore.this.regs.r[n] - 6;
            }
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.a] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_setbit = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.regs.p.set(SMPCore.this.regs.p.get() & ~args.mask | args.value);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_notc = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.p.c = !SMPCore.this.regs.p.c;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_seti = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.p.i = args.value != 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_setbit_dp = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.dp = SMPCore.this.op_readpc();
            SMPCore.this.rd = SMPCore.this.op_readdp(SMPCore.this.dp);
            SMPCore.this.rd = args.op != 0 ? SMPCore.this.rd | args.value : SMPCore.this.rd & ~args.value;
            SMPCore.this.op_writedp(SMPCore.this.dp, SMPCore.this.rd);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_push_reg = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_writestack(SMPCore.this.regs.r[args.n]);
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_push_p = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_writestack(SMPCore.this.regs.p.get());
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_pop_reg = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.r[args.n] = SMPCore.this.op_readstack();
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_pop_p = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.regs.p.set(SMPCore.this.op_readstack());
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_mul_ya = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.ya = SMPCore.this.regs.r[SMPCore.this.regs.y] * SMPCore.this.regs.r[SMPCore.this.regs.a] & 0xFFFF;
            SMPCore.this.regs.r[SMPCore.this.regs.a] = SMPCore.this.ya & 0xFF;
            SMPCore.this.regs.r[SMPCore.this.regs.y] = SMPCore.this.ya >> 8 & 0xFF;
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.y] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.y] == 0;
            return null;
        }
    };
    public SMPCoreOperation.SMPCoreOp op_div_ya_x = new SMPCoreOperation.SMPCoreOp(){

        @Override
        public SMPCoreOpResult Invoke(SMPCoreOpArgument args) {
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.op_io();
            SMPCore.this.ya = SMPCore.this.regs.ya.get();
            SMPCore.this.regs.p.v = SMPCore.this.regs.r[SMPCore.this.regs.y] >= SMPCore.this.regs.r[SMPCore.this.regs.x];
            boolean bl = SMPCore.this.regs.p.h = (SMPCore.this.regs.r[SMPCore.this.regs.y] & 0xF) >= (SMPCore.this.regs.r[SMPCore.this.regs.x] & 0xF);
            if (SMPCore.this.regs.r[SMPCore.this.regs.y] < SMPCore.this.regs.r[SMPCore.this.regs.x] << 1) {
                SMPCore.this.regs.r[SMPCore.this.regs.a] = SMPCore.this.ya / SMPCore.this.regs.r[SMPCore.this.regs.x] & 0xFF;
                SMPCore.this.regs.r[SMPCore.this.regs.y] = SMPCore.this.ya % SMPCore.this.regs.r[SMPCore.this.regs.x] & 0xFF;
            } else {
                SMPCore.this.regs.r[SMPCore.this.regs.a] = 255 - (SMPCore.this.ya - (SMPCore.this.regs.r[SMPCore.this.regs.x] << 9)) / (256 - SMPCore.this.regs.r[SMPCore.this.regs.x]) & 0xFF;
                SMPCore.this.regs.r[SMPCore.this.regs.y] = SMPCore.this.regs.r[SMPCore.this.regs.x] + (SMPCore.this.ya - (SMPCore.this.regs.r[SMPCore.this.regs.x] << 9)) % (256 - SMPCore.this.regs.r[SMPCore.this.regs.x]) & 0xFF;
            }
            SMPCore.this.regs.p.n = (SMPCore.this.regs.r[SMPCore.this.regs.a] & 0x80) != 0;
            SMPCore.this.regs.p.z = SMPCore.this.regs.r[SMPCore.this.regs.a] == 0;
            return null;
        }
    };
    public SMPCoreOperation[] opcode_table = new SMPCoreOperation[256];

    protected int op_readpc() {
        return this.op_read(this.regs.pc++) & 0xFF;
    }

    protected int op_readstack() {
        int n = this.regs.sp;
        int n2 = this.regs.r[n] + 1;
        this.regs.r[n] = n2;
        return this.op_read(0x100 | n2) & 0xFF;
    }

    protected void op_writestack(int data) {
        int n = this.regs.sp;
        int n2 = this.regs.r[n];
        this.regs.r[n] = n2 - 1;
        this.op_write(0x100 | n2, (byte)data);
    }

    protected int op_readaddr(int addr) {
        return this.op_read(addr) & 0xFF;
    }

    protected void op_writeaddr(int addr, int data) {
        this.op_write(addr, (byte)data);
    }

    protected int op_readdp(int addr) {
        return this.op_read(((this.regs.p.p ? 1 : 0) << 8) + addr) & 0xFF;
    }

    protected void op_writedp(int addr, int data) {
        this.op_write(((this.regs.p.p ? 1 : 0) << 8) + addr, (byte)data);
    }

    public abstract void op_io();

    public abstract byte op_read(int var1);

    public abstract void op_write(int var1, byte var2);

    public void initialize_opcode_table() {
        this.opcode_table[0] = new SMPCoreOperation(this.op_nop, null);
        this.opcode_table[1] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 0;
            }
        });
        this.opcode_table[2] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 1;
                this.value = 1;
            }
        });
        this.opcode_table[3] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 1;
                this.value = 1;
            }
        });
        this.opcode_table[4] = new SMPCoreOperation(this.op_read_reg_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
                this.n = 0;
            }
        });
        this.opcode_table[5] = new SMPCoreOperation(this.op_read_reg_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
                this.n = 0;
            }
        });
        this.opcode_table[6] = new SMPCoreOperation(this.op_read_a_ix, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
            }
        });
        this.opcode_table[7] = new SMPCoreOperation(this.op_read_a_idpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
            }
        });
        this.opcode_table[8] = new SMPCoreOperation(this.op_read_reg_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
                this.n = 0;
            }
        });
        this.opcode_table[9] = new SMPCoreOperation(this.op_read_dp_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
            }
        });
        this.opcode_table[10] = new SMPCoreOperation(this.op_or1_bit, new SMPCoreOpArgument(){
            {
                this.op = 0;
            }
        });
        this.opcode_table[11] = new SMPCoreOperation(this.op_adjust_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_asl;
            }
        });
        this.opcode_table[12] = new SMPCoreOperation(this.op_adjust_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_asl;
            }
        });
        this.opcode_table[13] = new SMPCoreOperation(this.op_push_p, null);
        this.opcode_table[14] = new SMPCoreOperation(this.op_adjust_addr_a, new SMPCoreOpArgument(){
            {
                this.op = 1;
            }
        });
        this.opcode_table[15] = new SMPCoreOperation(this.op_brk, null);
        this.opcode_table[16] = new SMPCoreOperation(this.op_branch, new SMPCoreOpArgument(){
            {
                this.flag = 128;
                this.value = 0;
            }
        });
        this.opcode_table[17] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 1;
            }
        });
        this.opcode_table[18] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 0;
                this.value = 1;
            }
        });
        this.opcode_table[19] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 1;
                this.value = 0;
            }
        });
        this.opcode_table[20] = new SMPCoreOperation(this.op_read_a_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
            }
        });
        this.opcode_table[21] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
                this.i = 1;
            }
        });
        this.opcode_table[22] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
                this.i = 2;
            }
        });
        this.opcode_table[23] = new SMPCoreOperation(this.op_read_a_idpy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
            }
        });
        this.opcode_table[24] = new SMPCoreOperation(this.op_read_dp_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
            }
        });
        this.opcode_table[25] = new SMPCoreOperation(this.op_read_ix_iy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_or;
            }
        });
        this.opcode_table[26] = new SMPCoreOperation(this.op_adjustw_dp, new SMPCoreOpArgument(){
            {
                this.adjust = -1;
            }
        });
        this.opcode_table[27] = new SMPCoreOperation(this.op_adjust_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_asl;
            }
        });
        this.opcode_table[28] = new SMPCoreOperation(this.op_adjust_reg, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_asl;
                this.n = 0;
            }
        });
        this.opcode_table[29] = new SMPCoreOperation(this.op_adjust_reg, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_dec;
                this.n = 1;
            }
        });
        this.opcode_table[30] = new SMPCoreOperation(this.op_read_reg_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.n = 1;
            }
        });
        this.opcode_table[31] = new SMPCoreOperation(this.op_jmp_iaddrx, null);
        this.opcode_table[32] = new SMPCoreOperation(this.op_setbit, new SMPCoreOpArgument(){
            {
                this.mask = 32;
                this.value = 0;
            }
        });
        this.opcode_table[33] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 2;
            }
        });
        this.opcode_table[34] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 1;
                this.value = 2;
            }
        });
        this.opcode_table[35] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 2;
                this.value = 1;
            }
        });
        this.opcode_table[36] = new SMPCoreOperation(this.op_read_reg_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
                this.n = 0;
            }
        });
        this.opcode_table[37] = new SMPCoreOperation(this.op_read_reg_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
                this.n = 0;
            }
        });
        this.opcode_table[38] = new SMPCoreOperation(this.op_read_a_ix, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
            }
        });
        this.opcode_table[39] = new SMPCoreOperation(this.op_read_a_idpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
            }
        });
        this.opcode_table[40] = new SMPCoreOperation(this.op_read_reg_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
                this.n = 0;
            }
        });
        this.opcode_table[41] = new SMPCoreOperation(this.op_read_dp_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
            }
        });
        this.opcode_table[42] = new SMPCoreOperation(this.op_or1_bit, new SMPCoreOpArgument(){
            {
                this.op = 1;
            }
        });
        this.opcode_table[43] = new SMPCoreOperation(this.op_adjust_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_rol;
            }
        });
        this.opcode_table[44] = new SMPCoreOperation(this.op_adjust_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_rol;
            }
        });
        this.opcode_table[45] = new SMPCoreOperation(this.op_push_reg, new SMPCoreOpArgument(){
            {
                this.n = 0;
            }
        });
        this.opcode_table[46] = new SMPCoreOperation(this.op_cbne_dp, null);
        this.opcode_table[47] = new SMPCoreOperation(this.op_bra, null);
        this.opcode_table[48] = new SMPCoreOperation(this.op_branch, new SMPCoreOpArgument(){
            {
                this.flag = 128;
                this.value = 1;
            }
        });
        this.opcode_table[49] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 3;
            }
        });
        this.opcode_table[50] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 0;
                this.value = 2;
            }
        });
        this.opcode_table[51] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 2;
                this.value = 0;
            }
        });
        this.opcode_table[52] = new SMPCoreOperation(this.op_read_a_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
            }
        });
        this.opcode_table[53] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
                this.i = 1;
            }
        });
        this.opcode_table[54] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
                this.i = 2;
            }
        });
        this.opcode_table[55] = new SMPCoreOperation(this.op_read_a_idpy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
            }
        });
        this.opcode_table[56] = new SMPCoreOperation(this.op_read_dp_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
            }
        });
        this.opcode_table[57] = new SMPCoreOperation(this.op_read_ix_iy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_and;
            }
        });
        this.opcode_table[58] = new SMPCoreOperation(this.op_adjustw_dp, new SMPCoreOpArgument(){
            {
                this.adjust = 1;
            }
        });
        this.opcode_table[59] = new SMPCoreOperation(this.op_adjust_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_rol;
            }
        });
        this.opcode_table[60] = new SMPCoreOperation(this.op_adjust_reg, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_rol;
                this.n = 0;
            }
        });
        this.opcode_table[61] = new SMPCoreOperation(this.op_adjust_reg, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_inc;
                this.n = 1;
            }
        });
        this.opcode_table[62] = new SMPCoreOperation(this.op_read_reg_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.n = 1;
            }
        });
        this.opcode_table[63] = new SMPCoreOperation(this.op_call, null);
        this.opcode_table[64] = new SMPCoreOperation(this.op_setbit, new SMPCoreOpArgument(){
            {
                this.mask = 32;
                this.value = 32;
            }
        });
        this.opcode_table[65] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 4;
            }
        });
        this.opcode_table[66] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 1;
                this.value = 4;
            }
        });
        this.opcode_table[67] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 4;
                this.value = 1;
            }
        });
        this.opcode_table[68] = new SMPCoreOperation(this.op_read_reg_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
                this.n = 0;
            }
        });
        this.opcode_table[69] = new SMPCoreOperation(this.op_read_reg_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
                this.n = 0;
            }
        });
        this.opcode_table[70] = new SMPCoreOperation(this.op_read_a_ix, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
            }
        });
        this.opcode_table[71] = new SMPCoreOperation(this.op_read_a_idpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
            }
        });
        this.opcode_table[72] = new SMPCoreOperation(this.op_read_reg_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
                this.n = 0;
            }
        });
        this.opcode_table[73] = new SMPCoreOperation(this.op_read_dp_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
            }
        });
        this.opcode_table[74] = new SMPCoreOperation(this.op_and1_bit, new SMPCoreOpArgument(){
            {
                this.op = 0;
            }
        });
        this.opcode_table[75] = new SMPCoreOperation(this.op_adjust_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_lsr;
            }
        });
        this.opcode_table[76] = new SMPCoreOperation(this.op_adjust_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_lsr;
            }
        });
        this.opcode_table[77] = new SMPCoreOperation(this.op_push_reg, new SMPCoreOpArgument(){
            {
                this.n = 1;
            }
        });
        this.opcode_table[78] = new SMPCoreOperation(this.op_adjust_addr_a, new SMPCoreOpArgument(){
            {
                this.op = 0;
            }
        });
        this.opcode_table[79] = new SMPCoreOperation(this.op_pcall, null);
        this.opcode_table[80] = new SMPCoreOperation(this.op_branch, new SMPCoreOpArgument(){
            {
                this.flag = 64;
                this.value = 0;
            }
        });
        this.opcode_table[81] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 5;
            }
        });
        this.opcode_table[82] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 0;
                this.value = 4;
            }
        });
        this.opcode_table[83] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 4;
                this.value = 0;
            }
        });
        this.opcode_table[84] = new SMPCoreOperation(this.op_read_a_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
            }
        });
        this.opcode_table[85] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
                this.i = 1;
            }
        });
        this.opcode_table[86] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
                this.i = 2;
            }
        });
        this.opcode_table[87] = new SMPCoreOperation(this.op_read_a_idpy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
            }
        });
        this.opcode_table[88] = new SMPCoreOperation(this.op_read_dp_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
            }
        });
        this.opcode_table[89] = new SMPCoreOperation(this.op_read_ix_iy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_eor;
            }
        });
        this.opcode_table[90] = new SMPCoreOperation(this.op_cmpw_ya_dp, null);
        this.opcode_table[91] = new SMPCoreOperation(this.op_adjust_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_lsr;
            }
        });
        this.opcode_table[92] = new SMPCoreOperation(this.op_adjust_reg, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_lsr;
                this.n = 0;
            }
        });
        this.opcode_table[93] = new SMPCoreOperation(this.op_mov_reg_reg, new SMPCoreOpArgument(){
            {
                this.to = 1;
                this.from = 0;
            }
        });
        this.opcode_table[94] = new SMPCoreOperation(this.op_read_reg_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.n = 2;
            }
        });
        this.opcode_table[95] = new SMPCoreOperation(this.op_jmp_addr, null);
        this.opcode_table[96] = new SMPCoreOperation(this.op_setbit, new SMPCoreOpArgument(){
            {
                this.mask = 1;
                this.value = 0;
            }
        });
        this.opcode_table[97] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 6;
            }
        });
        this.opcode_table[98] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 1;
                this.value = 8;
            }
        });
        this.opcode_table[99] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 8;
                this.value = 1;
            }
        });
        this.opcode_table[100] = new SMPCoreOperation(this.op_read_reg_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.n = 0;
            }
        });
        this.opcode_table[101] = new SMPCoreOperation(this.op_read_reg_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.n = 0;
            }
        });
        this.opcode_table[102] = new SMPCoreOperation(this.op_read_a_ix, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
            }
        });
        this.opcode_table[103] = new SMPCoreOperation(this.op_read_a_idpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
            }
        });
        this.opcode_table[104] = new SMPCoreOperation(this.op_read_reg_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.n = 0;
            }
        });
        this.opcode_table[105] = new SMPCoreOperation(this.op_read_dp_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
            }
        });
        this.opcode_table[106] = new SMPCoreOperation(this.op_and1_bit, new SMPCoreOpArgument(){
            {
                this.op = 1;
            }
        });
        this.opcode_table[107] = new SMPCoreOperation(this.op_adjust_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_ror;
            }
        });
        this.opcode_table[108] = new SMPCoreOperation(this.op_adjust_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_ror;
            }
        });
        this.opcode_table[109] = new SMPCoreOperation(this.op_push_reg, new SMPCoreOpArgument(){
            {
                this.n = 2;
            }
        });
        this.opcode_table[110] = new SMPCoreOperation(this.op_dbnz_dp, null);
        this.opcode_table[111] = new SMPCoreOperation(this.op_ret, null);
        this.opcode_table[112] = new SMPCoreOperation(this.op_branch, new SMPCoreOpArgument(){
            {
                this.flag = 64;
                this.value = 1;
            }
        });
        this.opcode_table[113] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 7;
            }
        });
        this.opcode_table[114] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 0;
                this.value = 8;
            }
        });
        this.opcode_table[115] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 8;
                this.value = 0;
            }
        });
        this.opcode_table[116] = new SMPCoreOperation(this.op_read_a_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
            }
        });
        this.opcode_table[117] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.i = 1;
            }
        });
        this.opcode_table[118] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.i = 2;
            }
        });
        this.opcode_table[119] = new SMPCoreOperation(this.op_read_a_idpy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
            }
        });
        this.opcode_table[120] = new SMPCoreOperation(this.op_read_dp_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
            }
        });
        this.opcode_table[121] = new SMPCoreOperation(this.op_read_ix_iy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
            }
        });
        this.opcode_table[122] = new SMPCoreOperation(this.op_read_ya_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_addw;
            }
        });
        this.opcode_table[123] = new SMPCoreOperation(this.op_adjust_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_ror;
            }
        });
        this.opcode_table[124] = new SMPCoreOperation(this.op_adjust_reg, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_ror;
                this.n = 0;
            }
        });
        this.opcode_table[125] = new SMPCoreOperation(this.op_mov_reg_reg, new SMPCoreOpArgument(){
            {
                this.to = 0;
                this.from = 1;
            }
        });
        this.opcode_table[126] = new SMPCoreOperation(this.op_read_reg_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.n = 2;
            }
        });
        this.opcode_table[127] = new SMPCoreOperation(this.op_reti, null);
        this.opcode_table[128] = new SMPCoreOperation(this.op_setbit, new SMPCoreOpArgument(){
            {
                this.mask = 1;
                this.value = 1;
            }
        });
        this.opcode_table[129] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 8;
            }
        });
        this.opcode_table[130] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 1;
                this.value = 16;
            }
        });
        this.opcode_table[131] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 16;
                this.value = 1;
            }
        });
        this.opcode_table[132] = new SMPCoreOperation(this.op_read_reg_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
                this.n = 0;
            }
        });
        this.opcode_table[133] = new SMPCoreOperation(this.op_read_reg_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
                this.n = 0;
            }
        });
        this.opcode_table[134] = new SMPCoreOperation(this.op_read_a_ix, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
            }
        });
        this.opcode_table[135] = new SMPCoreOperation(this.op_read_a_idpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
            }
        });
        this.opcode_table[136] = new SMPCoreOperation(this.op_read_reg_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
                this.n = 0;
            }
        });
        this.opcode_table[137] = new SMPCoreOperation(this.op_read_dp_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
            }
        });
        this.opcode_table[138] = new SMPCoreOperation(this.op_eor1_bit, null);
        this.opcode_table[139] = new SMPCoreOperation(this.op_adjust_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_dec;
            }
        });
        this.opcode_table[140] = new SMPCoreOperation(this.op_adjust_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_dec;
            }
        });
        this.opcode_table[141] = new SMPCoreOperation(this.op_mov_reg_const, new SMPCoreOpArgument(){
            {
                this.n = 2;
            }
        });
        this.opcode_table[142] = new SMPCoreOperation(this.op_pop_p, null);
        this.opcode_table[143] = new SMPCoreOperation(this.op_mov_dp_const, null);
        this.opcode_table[144] = new SMPCoreOperation(this.op_branch, new SMPCoreOpArgument(){
            {
                this.flag = 1;
                this.value = 0;
            }
        });
        this.opcode_table[145] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 9;
            }
        });
        this.opcode_table[146] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 0;
                this.value = 16;
            }
        });
        this.opcode_table[147] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 16;
                this.value = 0;
            }
        });
        this.opcode_table[148] = new SMPCoreOperation(this.op_read_a_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
            }
        });
        this.opcode_table[149] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
                this.i = 1;
            }
        });
        this.opcode_table[150] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
                this.i = 2;
            }
        });
        this.opcode_table[151] = new SMPCoreOperation(this.op_read_a_idpy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
            }
        });
        this.opcode_table[152] = new SMPCoreOperation(this.op_read_dp_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
            }
        });
        this.opcode_table[153] = new SMPCoreOperation(this.op_read_ix_iy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_adc;
            }
        });
        this.opcode_table[154] = new SMPCoreOperation(this.op_read_ya_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_subw;
            }
        });
        this.opcode_table[155] = new SMPCoreOperation(this.op_adjust_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_dec;
            }
        });
        this.opcode_table[156] = new SMPCoreOperation(this.op_adjust_reg, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_dec;
                this.n = 0;
            }
        });
        this.opcode_table[157] = new SMPCoreOperation(this.op_mov_reg_reg, new SMPCoreOpArgument(){
            {
                this.to = 1;
                this.from = 3;
            }
        });
        this.opcode_table[158] = new SMPCoreOperation(this.op_div_ya_x, null);
        this.opcode_table[159] = new SMPCoreOperation(this.op_xcn, null);
        this.opcode_table[160] = new SMPCoreOperation(this.op_seti, new SMPCoreOpArgument(){
            {
                this.value = 1;
            }
        });
        this.opcode_table[161] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 10;
            }
        });
        this.opcode_table[162] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 1;
                this.value = 32;
            }
        });
        this.opcode_table[163] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 32;
                this.value = 1;
            }
        });
        this.opcode_table[164] = new SMPCoreOperation(this.op_read_reg_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
                this.n = 0;
            }
        });
        this.opcode_table[165] = new SMPCoreOperation(this.op_read_reg_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
                this.n = 0;
            }
        });
        this.opcode_table[166] = new SMPCoreOperation(this.op_read_a_ix, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
            }
        });
        this.opcode_table[167] = new SMPCoreOperation(this.op_read_a_idpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
            }
        });
        this.opcode_table[168] = new SMPCoreOperation(this.op_read_reg_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
                this.n = 0;
            }
        });
        this.opcode_table[169] = new SMPCoreOperation(this.op_read_dp_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
            }
        });
        this.opcode_table[170] = new SMPCoreOperation(this.op_mov1_c_bit, null);
        this.opcode_table[171] = new SMPCoreOperation(this.op_adjust_dp, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_inc;
            }
        });
        this.opcode_table[172] = new SMPCoreOperation(this.op_adjust_addr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_inc;
            }
        });
        this.opcode_table[173] = new SMPCoreOperation(this.op_read_reg_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.n = 2;
            }
        });
        this.opcode_table[174] = new SMPCoreOperation(this.op_pop_reg, new SMPCoreOpArgument(){
            {
                this.n = 0;
            }
        });
        this.opcode_table[175] = new SMPCoreOperation(this.op_mov_ixinc_a, null);
        this.opcode_table[176] = new SMPCoreOperation(this.op_branch, new SMPCoreOpArgument(){
            {
                this.flag = 1;
                this.value = 1;
            }
        });
        this.opcode_table[177] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 11;
            }
        });
        this.opcode_table[178] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 0;
                this.value = 32;
            }
        });
        this.opcode_table[179] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 32;
                this.value = 0;
            }
        });
        this.opcode_table[180] = new SMPCoreOperation(this.op_read_a_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
            }
        });
        this.opcode_table[181] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
                this.i = 1;
            }
        });
        this.opcode_table[182] = new SMPCoreOperation(this.op_read_a_addrr, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
                this.i = 2;
            }
        });
        this.opcode_table[183] = new SMPCoreOperation(this.op_read_a_idpy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
            }
        });
        this.opcode_table[184] = new SMPCoreOperation(this.op_read_dp_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
            }
        });
        this.opcode_table[185] = new SMPCoreOperation(this.op_read_ix_iy, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_sbc;
            }
        });
        this.opcode_table[186] = new SMPCoreOperation(this.op_movw_ya_dp, null);
        this.opcode_table[187] = new SMPCoreOperation(this.op_adjust_dpx, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_inc;
            }
        });
        this.opcode_table[188] = new SMPCoreOperation(this.op_adjust_reg, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_inc;
                this.n = 0;
            }
        });
        this.opcode_table[189] = new SMPCoreOperation(this.op_mov_sp_x, null);
        this.opcode_table[190] = new SMPCoreOperation(this.op_das, null);
        this.opcode_table[191] = new SMPCoreOperation(this.op_mov_a_ixinc, null);
        this.opcode_table[192] = new SMPCoreOperation(this.op_seti, new SMPCoreOpArgument(){
            {
                this.value = 0;
            }
        });
        this.opcode_table[193] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 12;
            }
        });
        this.opcode_table[194] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 1;
                this.value = 64;
            }
        });
        this.opcode_table[195] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 64;
                this.value = 1;
            }
        });
        this.opcode_table[196] = new SMPCoreOperation(this.op_mov_dp_reg, new SMPCoreOpArgument(){
            {
                this.n = 0;
            }
        });
        this.opcode_table[197] = new SMPCoreOperation(this.op_mov_addr_reg, new SMPCoreOpArgument(){
            {
                this.n = 0;
            }
        });
        this.opcode_table[198] = new SMPCoreOperation(this.op_mov_ix_a, null);
        this.opcode_table[199] = new SMPCoreOperation(this.op_mov_idpx_a, null);
        this.opcode_table[200] = new SMPCoreOperation(this.op_read_reg_const, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_cmp;
                this.n = 1;
            }
        });
        this.opcode_table[201] = new SMPCoreOperation(this.op_mov_addr_reg, new SMPCoreOpArgument(){
            {
                this.n = 1;
            }
        });
        this.opcode_table[202] = new SMPCoreOperation(this.op_mov1_bit_c, null);
        this.opcode_table[203] = new SMPCoreOperation(this.op_mov_dp_reg, new SMPCoreOpArgument(){
            {
                this.n = 2;
            }
        });
        this.opcode_table[204] = new SMPCoreOperation(this.op_mov_addr_reg, new SMPCoreOpArgument(){
            {
                this.n = 2;
            }
        });
        this.opcode_table[205] = new SMPCoreOperation(this.op_mov_reg_const, new SMPCoreOpArgument(){
            {
                this.n = 1;
            }
        });
        this.opcode_table[206] = new SMPCoreOperation(this.op_pop_reg, new SMPCoreOpArgument(){
            {
                this.n = 1;
            }
        });
        this.opcode_table[207] = new SMPCoreOperation(this.op_mul_ya, null);
        this.opcode_table[208] = new SMPCoreOperation(this.op_branch, new SMPCoreOpArgument(){
            {
                this.flag = 2;
                this.value = 0;
            }
        });
        this.opcode_table[209] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 13;
            }
        });
        this.opcode_table[210] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 0;
                this.value = 64;
            }
        });
        this.opcode_table[211] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 64;
                this.value = 0;
            }
        });
        this.opcode_table[212] = new SMPCoreOperation(this.op_mov_dpr_reg, new SMPCoreOpArgument(){
            {
                this.n = 0;
                this.i = 1;
            }
        });
        this.opcode_table[213] = new SMPCoreOperation(this.op_mov_addrr_a, new SMPCoreOpArgument(){
            {
                this.i = 1;
            }
        });
        this.opcode_table[214] = new SMPCoreOperation(this.op_mov_addrr_a, new SMPCoreOpArgument(){
            {
                this.i = 2;
            }
        });
        this.opcode_table[215] = new SMPCoreOperation(this.op_mov_idpy_a, null);
        this.opcode_table[216] = new SMPCoreOperation(this.op_mov_dp_reg, new SMPCoreOpArgument(){
            {
                this.n = 1;
            }
        });
        this.opcode_table[217] = new SMPCoreOperation(this.op_mov_dpr_reg, new SMPCoreOpArgument(){
            {
                this.n = 1;
                this.i = 2;
            }
        });
        this.opcode_table[218] = new SMPCoreOperation(this.op_movw_dp_ya, null);
        this.opcode_table[219] = new SMPCoreOperation(this.op_mov_dpr_reg, new SMPCoreOpArgument(){
            {
                this.n = 2;
                this.i = 1;
            }
        });
        this.opcode_table[220] = new SMPCoreOperation(this.op_adjust_reg, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_dec;
                this.n = 2;
            }
        });
        this.opcode_table[221] = new SMPCoreOperation(this.op_mov_reg_reg, new SMPCoreOpArgument(){
            {
                this.to = 0;
                this.from = 2;
            }
        });
        this.opcode_table[222] = new SMPCoreOperation(this.op_cbne_dpx, null);
        this.opcode_table[223] = new SMPCoreOperation(this.op_daa, null);
        this.opcode_table[224] = new SMPCoreOperation(this.op_setbit, new SMPCoreOpArgument(){
            {
                this.mask = 72;
                this.value = 0;
            }
        });
        this.opcode_table[225] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 14;
            }
        });
        this.opcode_table[226] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 1;
                this.value = 128;
            }
        });
        this.opcode_table[227] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 128;
                this.value = 1;
            }
        });
        this.opcode_table[228] = new SMPCoreOperation(this.op_mov_reg_dp, new SMPCoreOpArgument(){
            {
                this.n = 0;
            }
        });
        this.opcode_table[229] = new SMPCoreOperation(this.op_mov_reg_addr, new SMPCoreOpArgument(){
            {
                this.n = 0;
            }
        });
        this.opcode_table[230] = new SMPCoreOperation(this.op_mov_a_ix, null);
        this.opcode_table[231] = new SMPCoreOperation(this.op_mov_a_idpx, null);
        this.opcode_table[232] = new SMPCoreOperation(this.op_mov_reg_const, new SMPCoreOpArgument(){
            {
                this.n = 0;
            }
        });
        this.opcode_table[233] = new SMPCoreOperation(this.op_mov_reg_addr, new SMPCoreOpArgument(){
            {
                this.n = 1;
            }
        });
        this.opcode_table[234] = new SMPCoreOperation(this.op_not1_bit, null);
        this.opcode_table[235] = new SMPCoreOperation(this.op_mov_reg_dp, new SMPCoreOpArgument(){
            {
                this.n = 2;
            }
        });
        this.opcode_table[236] = new SMPCoreOperation(this.op_mov_reg_addr, new SMPCoreOpArgument(){
            {
                this.n = 2;
            }
        });
        this.opcode_table[237] = new SMPCoreOperation(this.op_notc, null);
        this.opcode_table[238] = new SMPCoreOperation(this.op_pop_reg, new SMPCoreOpArgument(){
            {
                this.n = 2;
            }
        });
        this.opcode_table[239] = new SMPCoreOperation(this.op_wait, null);
        this.opcode_table[240] = new SMPCoreOperation(this.op_branch, new SMPCoreOpArgument(){
            {
                this.flag = 2;
                this.value = 1;
            }
        });
        this.opcode_table[241] = new SMPCoreOperation(this.op_tcall, new SMPCoreOpArgument(){
            {
                this.n = 15;
            }
        });
        this.opcode_table[242] = new SMPCoreOperation(this.op_setbit_dp, new SMPCoreOpArgument(){
            {
                this.op = 0;
                this.value = 128;
            }
        });
        this.opcode_table[243] = new SMPCoreOperation(this.op_bitbranch, new SMPCoreOpArgument(){
            {
                this.mask = 128;
                this.value = 0;
            }
        });
        this.opcode_table[244] = new SMPCoreOperation(this.op_mov_reg_dpr, new SMPCoreOpArgument(){
            {
                this.n = 0;
                this.i = 1;
            }
        });
        this.opcode_table[245] = new SMPCoreOperation(this.op_mov_a_addrr, new SMPCoreOpArgument(){
            {
                this.i = 1;
            }
        });
        this.opcode_table[246] = new SMPCoreOperation(this.op_mov_a_addrr, new SMPCoreOpArgument(){
            {
                this.i = 2;
            }
        });
        this.opcode_table[247] = new SMPCoreOperation(this.op_mov_a_idpy, null);
        this.opcode_table[248] = new SMPCoreOperation(this.op_mov_reg_dp, new SMPCoreOpArgument(){
            {
                this.n = 1;
            }
        });
        this.opcode_table[249] = new SMPCoreOperation(this.op_mov_reg_dpr, new SMPCoreOpArgument(){
            {
                this.n = 1;
                this.i = 2;
            }
        });
        this.opcode_table[250] = new SMPCoreOperation(this.op_mov_dp_dp, null);
        this.opcode_table[251] = new SMPCoreOperation(this.op_mov_reg_dpr, new SMPCoreOpArgument(){
            {
                this.n = 2;
                this.i = 1;
            }
        });
        this.opcode_table[252] = new SMPCoreOperation(this.op_adjust_reg, new SMPCoreOpArgument(){
            {
                this.op_func = SMPCore.this.op_inc;
                this.n = 2;
            }
        });
        this.opcode_table[253] = new SMPCoreOperation(this.op_mov_reg_reg, new SMPCoreOpArgument(){
            {
                this.to = 2;
                this.from = 0;
            }
        });
        this.opcode_table[254] = new SMPCoreOperation(this.op_dbnz_y, null);
        this.opcode_table[255] = new SMPCoreOperation(this.op_wait, null);
    }

    public SMPCore() {
        this.initialize_opcode_table();
    }
}

