/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.smp;

import jario.snes.smp.SMP;

public class SMPTimer {
    public int stage0_ticks;
    public int stage1_ticks;
    public int stage2_ticks;
    public int stage3_ticks;
    public boolean current_line;
    public boolean enabled;
    public int target;
    private int timer_frequency;
    private SMP smp;

    public void tick() {
        this.stage0_ticks += this.smp.status.timer_step & 0xFF;
        if (this.stage0_ticks < this.timer_frequency) {
            return;
        }
        this.stage0_ticks -= this.timer_frequency & 0xFF;
        this.stage1_ticks ^= 1;
        this.sync_stage1();
    }

    public void sync_stage1() {
        boolean new_line;
        boolean bl = new_line = this.stage1_ticks != 0;
        if (!this.smp.status.timers_enabled) {
            new_line = false;
        }
        if (this.smp.status.timers_disabled) {
            new_line = false;
        }
        boolean old_line = this.current_line;
        this.current_line = new_line;
        if (!old_line || new_line) {
            return;
        }
        if (!this.enabled) {
            return;
        }
        ++this.stage2_ticks;
        if (this.stage2_ticks != this.target) {
            return;
        }
        this.stage2_ticks = 0;
        ++this.stage3_ticks;
        this.stage3_ticks &= 0xF;
    }

    public SMPTimer(int timer_frequency_, SMP smp) {
        this.timer_frequency = timer_frequency_;
        this.smp = smp;
    }
}

