/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.cpu;

import jario.hardware.Bus1bit;
import jario.hardware.Bus32bit;
import jario.hardware.Bus8bit;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.snes.performance.cpu.BusB;
import jario.snes.performance.cpu.CPUCore;
import jario.snes.performance.cpu.CPUCoreOperation;
import jario.snes.performance.cpu.Channel;
import jario.snes.performance.cpu.DMA;
import jario.snes.performance.cpu.HVCounter;
import jario.snes.performance.cpu.PriorityQueue;
import jario.snes.performance.cpu.Status;

public class CPU
extends CPUCore
implements Hardware,
Clockable,
Bus8bit,
Configurable {
    public static final int NTSC = 0;
    public static final int PAL = 1;
    private int region;
    static CPU cpu;
    protected Bus8bit bus;
    protected Clockable smp_clk;
    protected Clockable ppu_clk;
    protected Bus1bit ppu1bit;
    protected Bus8bit smp_bus;
    protected Bus8bit input_port;
    protected Bus32bit video;
    private long smpClocks;
    private static final int QueueEvent_DramRefresh = 0;
    private static final int QueueEvent_HdmaRun = 1;
    private PriorityQueue queue;
    private DMA dma;
    int[] port_data = new int[4];
    Channel[] channel = new Channel[8];
    Status status = new BusB();
    HVCounter counter = new HVCounter();
    private PriorityQueue.Callback queue_event = new PriorityQueue.Callback(){

        @Override
        public void call(int id) {
            switch (id) {
                case 0: {
                    CPU.this.add_clocks(40);
                    return;
                }
                case 1: {
                    CPU.this.dma.hdma_run();
                    return;
                }
            }
        }
    };
    private Runnable scanline = new Runnable(){

        @Override
        public void run() {
            CPU.this.synchronize_smp();
            CPU.this.video.write32bit(0, CPU.this.counter.vcounter());
            if (CPU.this.counter.vcounter() == 241) {
                ((Clockable)CPU.this.input_port).clock(0L);
                ((Clockable)CPU.this.video).clock(0L);
            }
            if (CPU.this.counter.vcounter() == 0) {
                CPU.this.dma.hdma_init();
            }
            CPU.this.queue.enqueue(534, 0);
            if (CPU.this.counter.vcounter() <= (!CPU.this.ppu1bit.read1bit(1) ? 224 : 239)) {
                CPU.this.queue.enqueue(1112, 1);
            }
            boolean nmi_valid = CPU.this.status.nmi_valid;
            boolean bl = CPU.this.status.nmi_valid = CPU.this.counter.vcounter() >= (!CPU.this.ppu1bit.read1bit(1) ? 225 : 240);
            if (!nmi_valid && CPU.this.status.nmi_valid) {
                CPU.this.status.nmi_line = true;
                if (CPU.this.status.nmi_enabled) {
                    CPU.this.status.nmi_transition = true;
                }
            } else if (nmi_valid && !CPU.this.status.nmi_valid) {
                CPU.this.status.nmi_line = false;
            }
            if (CPU.this.status.auto_joypad_poll_enabled && CPU.this.counter.vcounter() == (!CPU.this.ppu1bit.read1bit(1) ? 227 : 242)) {
                CPU.this.input_port.write8bit(1, (byte)0);
                CPU.this.run_auto_joypad_poll();
            }
        }
    };

    public CPU() {
        cpu = this;
        int i = 0;
        while (i < this.channel.length) {
            this.channel[i] = new Channel();
            ++i;
        }
        this.queue = new PriorityQueue(512, this.queue_event);
        this.dma = new DMA(this);
        this.counter.scanline = this.scanline;
        this.power();
    }

    public void connect(int port, Hardware hw) {
        switch (port) {
            case 0: {
                this.bus = (Bus8bit)hw;
                break;
            }
            case 1: {
                this.smp_clk = (Clockable)hw;
                this.smp_bus = (Bus8bit)hw;
                break;
            }
            case 2: {
                this.input_port = (Bus8bit)hw;
                break;
            }
            case 3: {
                this.video = (Bus32bit)hw;
                break;
            }
            case 4: {
                this.ppu_clk = (Clockable)hw;
                this.counter.ppu1bit = this.ppu1bit = (Bus1bit)hw;
            }
        }
    }

    public final void clock(long clocks) {
        while (clocks-- > 0L) {
            if (this.status.nmi_pending) {
                this.status.nmi_pending = false;
                this.op_irq(!this.regs.e ? 65514 : 65530);
            }
            if (this.status.irq_pending) {
                this.status.irq_pending = false;
                this.op_irq(!this.regs.e ? 65518 : 65534);
            }
            ((CPUCoreOperation)this.opcode_table.get(this.op_readpc())).Invoke();
        }
    }

    public void reset() {
        this.smpClocks = 0L;
        this.counter.reset();
        this.regs.pc.set(0);
        this.regs.x.h(0);
        this.regs.y.h(0);
        this.regs.s.h(1);
        this.regs.d.set(0);
        this.regs.db = 0;
        this.regs.p.set(52);
        this.regs.e = true;
        this.regs.mdr = 0;
        this.regs.wai = false;
        this.update_table();
        if (this.bus != null) {
            this.regs.pc.l(this.bus.read8bit(65532) & 0xFF);
            this.regs.pc.h(this.bus.read8bit(65533) & 0xFF);
            this.regs.pc.b(0);
        } else {
            this.regs.pc.set(0);
        }
        this.status.nmi_valid = false;
        this.status.nmi_line = false;
        this.status.nmi_transition = false;
        this.status.nmi_pending = false;
        this.status.irq_valid = false;
        this.status.irq_line = false;
        this.status.irq_transition = false;
        this.status.irq_pending = false;
        this.status.irq_lock = false;
        this.status.hdma_pending = false;
        this.status.wram_addr = 0;
        this.status.nmi_enabled = false;
        this.status.virq_enabled = false;
        this.status.hirq_enabled = false;
        this.status.auto_joypad_poll_enabled = false;
        this.status.pio = 255;
        this.status.htime = 0;
        this.status.vtime = 0;
        this.status.rom_speed = 8;
        this.status.joy1h = 0;
        this.status.joy1l = 0;
        this.status.joy2h = 0;
        this.status.joy2l = 0;
        this.status.joy3h = 0;
        this.status.joy3l = 0;
        this.status.joy4h = 0;
        this.status.joy4l = 0;
        this.dma.dma_reset();
    }

    public byte read8bit(int addr) {
        if ((addr & 0xFFC0) == 8512) {
            this.synchronize_smp();
            return this.smp_bus.read8bit(addr & 3);
        }
        switch (addr & 0xFFFF) {
            case 8576: {
                byte result = this.bus.read8bit(0x7E0000 | this.status.wram_addr);
                this.status.wram_addr = this.status.wram_addr + 1 & 0x1FFFF;
                return result;
            }
            case 16406: {
                int result = this.regs.mdr & 0xFC;
                return (byte)(result |= this.input_port.read8bit(0) & 3);
            }
            case 16407: {
                int result = this.regs.mdr & 0xE0 | 0x1C;
                return (byte)(result |= this.input_port.read8bit(1) & 3);
            }
            case 16912: {
                int result = this.regs.mdr & 0x70;
                result |= (this.status.nmi_line ? 1 : 0) << 7;
                this.status.nmi_line = false;
                return (byte)(result |= 2);
            }
            case 16913: {
                int result = this.regs.mdr & 0x7F;
                int n = this.status.irq_line ? 1 : 0;
                this.status.irq_line = false;
                return (byte)(result |= n << 7);
            }
            case 16914: {
                int vbstart;
                int result = this.regs.mdr & 0x3E;
                int n = vbstart = !this.ppu1bit.read1bit(1) ? 225 : 240;
                if (this.counter.vcounter() >= vbstart && this.counter.vcounter() <= vbstart + 2) {
                    result |= 1;
                }
                if (this.counter.hcounter() <= 2 || this.counter.hcounter() >= 1096) {
                    result |= 0x40;
                }
                if (this.counter.vcounter() >= vbstart) {
                    result |= 0x80;
                }
                return (byte)result;
            }
            case 16915: {
                return (byte)this.status.pio;
            }
            case 16916: {
                return (byte)(this.status.rddiv >> 0);
            }
            case 16917: {
                return (byte)(this.status.rddiv >> 8);
            }
            case 16918: {
                return (byte)(this.status.rdmpy >> 0);
            }
            case 16919: {
                return (byte)(this.status.rdmpy >> 8);
            }
            case 16920: {
                return (byte)this.status.joy1l;
            }
            case 16921: {
                return (byte)this.status.joy1h;
            }
            case 16922: {
                return (byte)this.status.joy2l;
            }
            case 16923: {
                return (byte)this.status.joy2h;
            }
            case 16924: {
                return (byte)this.status.joy3l;
            }
            case 16925: {
                return (byte)this.status.joy3h;
            }
            case 16926: {
                return (byte)this.status.joy4l;
            }
            case 16927: {
                return (byte)this.status.joy4h;
            }
        }
        if ((addr & 0xFF80) == 17152) {
            int i = addr >> 4 & 7;
            switch (addr & 0xFF8F) {
                case 17152: {
                    return (byte)((this.channel[i].direction ? 1 : 0) << 7 | (this.channel[i].indirect ? 1 : 0) << 6 | (this.channel[i].unused ? 1 : 0) << 5 | (this.channel[i].reverse_transfer ? 1 : 0) << 4 | (this.channel[i].fixed_transfer ? 1 : 0) << 3 | this.channel[i].transfer_mode << 0);
                }
                case 17153: {
                    return (byte)this.channel[i].dest_addr;
                }
                case 17154: {
                    return (byte)(this.channel[i].source_addr >> 0);
                }
                case 17155: {
                    return (byte)(this.channel[i].source_addr >> 8);
                }
                case 17156: {
                    return (byte)this.channel[i].source_bank;
                }
                case 17157: {
                    return (byte)(this.channel[i].transfer_size() >> 0);
                }
                case 17158: {
                    return (byte)(this.channel[i].transfer_size() >> 8);
                }
                case 17159: {
                    return (byte)this.channel[i].indirect_bank;
                }
                case 17160: {
                    return (byte)(this.channel[i].hdma_addr >> 0);
                }
                case 17161: {
                    return (byte)(this.channel[i].hdma_addr >> 8);
                }
                case 17162: {
                    return (byte)this.channel[i].line_counter;
                }
                case 17163: 
                case 17167: {
                    return (byte)this.channel[i].unknown;
                }
            }
        }
        return this.regs.mdr;
    }

    public void write8bit(int addr, byte data_) {
        int data = data_ & 0xFF;
        if ((addr & 0xFFC0) == 8512) {
            this.synchronize_smp();
            this.port_write(addr & 3, data_);
            return;
        }
        switch (addr & 0xFFFF) {
            case 8576: {
                this.bus.write8bit(0x7E0000 | this.status.wram_addr, data_);
                this.status.wram_addr = this.status.wram_addr + 1 & 0x1FFFF;
                return;
            }
            case 8577: {
                this.status.wram_addr = this.status.wram_addr & 0x1FF00 | data << 0;
                return;
            }
            case 8578: {
                this.status.wram_addr = this.status.wram_addr & 0x100FF | data << 8;
                return;
            }
            case 8579: {
                this.status.wram_addr = this.status.wram_addr & 0xFFFF | (data & 1) << 16;
                return;
            }
            case 16406: {
                this.input_port.write8bit(0, data_);
                return;
            }
            case 16896: {
                boolean nmi_enabled = this.status.nmi_enabled;
                this.status.nmi_enabled = (data & 0x80) != 0;
                this.status.virq_enabled = (data & 0x20) != 0;
                this.status.hirq_enabled = (data & 0x10) != 0;
                boolean bl = this.status.auto_joypad_poll_enabled = (data & 1) != 0;
                if (!nmi_enabled && this.status.nmi_enabled && this.status.nmi_line) {
                    this.status.nmi_transition = true;
                }
                if (this.status.virq_enabled && !this.status.hirq_enabled && this.status.irq_line) {
                    this.status.irq_transition = true;
                }
                if (!this.status.virq_enabled && !this.status.hirq_enabled) {
                    this.status.irq_line = false;
                    this.status.irq_transition = false;
                }
                this.status.irq_lock = true;
                return;
            }
            case 16897: {
                this.ppu1bit.write1bit(29, (data >> 7 & 1) != 0);
                this.status.pio = data;
            }
            case 16898: {
                this.status.wrmpya = data;
                return;
            }
            case 16899: {
                this.status.wrmpyb = data;
                this.status.rdmpy = this.status.wrmpya * this.status.wrmpyb & 0xFFFF;
                return;
            }
            case 16900: {
                this.status.wrdiva = this.status.wrdiva & 0xFF00 | data << 0;
                return;
            }
            case 16901: {
                this.status.wrdiva = data << 8 | this.status.wrdiva & 0xFF;
                return;
            }
            case 16902: {
                this.status.wrdivb = data;
                this.status.rddiv = (this.status.wrdivb != 0 ? this.status.wrdiva / this.status.wrdivb : 65535) & 0xFFFF;
                this.status.rdmpy = (this.status.wrdivb != 0 ? this.status.wrdiva % this.status.wrdivb : this.status.wrdiva) & 0xFFFF;
                return;
            }
            case 16903: {
                this.status.htime = this.status.htime & 0x100 | data << 0;
                return;
            }
            case 16904: {
                this.status.htime = (data & 1) << 8 | this.status.htime & 0xFF;
                return;
            }
            case 16905: {
                this.status.vtime = this.status.vtime & 0x100 | data << 0;
                return;
            }
            case 16906: {
                this.status.vtime = (data & 1) << 8 | this.status.vtime & 0xFF;
                return;
            }
            case 16907: {
                int i = 0;
                while (i < 8) {
                    this.channel[i].dma_enabled = (data & 1 << i) != 0;
                    ++i;
                }
                if (data != 0) {
                    this.dma.dma_run();
                }
                return;
            }
            case 16908: {
                int i = 0;
                while (i < 8) {
                    this.channel[i].hdma_enabled = (data & 1 << i) != 0;
                    ++i;
                }
                return;
            }
            case 16909: {
                this.status.rom_speed = (data & 1) != 0 ? 6 : 8;
                return;
            }
        }
        if ((addr & 0xFF80) == 17152) {
            int i = addr >> 4 & 7;
            switch (addr & 0xFF8F) {
                case 17152: {
                    this.channel[i].direction = (data & 0x80) != 0;
                    this.channel[i].indirect = (data & 0x40) != 0;
                    this.channel[i].unused = (data & 0x20) != 0;
                    this.channel[i].reverse_transfer = (data & 0x10) != 0;
                    this.channel[i].fixed_transfer = (data & 8) != 0;
                    this.channel[i].transfer_mode = data & 7;
                    return;
                }
                case 17153: {
                    this.channel[i].dest_addr = data;
                    return;
                }
                case 17154: {
                    this.channel[i].source_addr = this.channel[i].source_addr & 0xFF00 | data << 0;
                    return;
                }
                case 17155: {
                    this.channel[i].source_addr = data << 8 | this.channel[i].source_addr & 0xFF;
                    return;
                }
                case 17156: {
                    this.channel[i].source_bank = data;
                    return;
                }
                case 17157: {
                    this.channel[i].transfer_size(this.channel[i].transfer_size() & 0xFF00 | data << 0);
                    return;
                }
                case 17158: {
                    this.channel[i].transfer_size(data << 8 | this.channel[i].transfer_size() & 0xFF);
                    return;
                }
                case 17159: {
                    this.channel[i].indirect_bank = data;
                    return;
                }
                case 17160: {
                    this.channel[i].hdma_addr = this.channel[i].hdma_addr & 0xFF00 | data << 0;
                    return;
                }
                case 17161: {
                    this.channel[i].hdma_addr = data << 8 | this.channel[i].hdma_addr & 0xFF;
                    return;
                }
                case 17162: {
                    this.channel[i].line_counter = data;
                    return;
                }
                case 17163: 
                case 17167: {
                    this.channel[i].unknown = data;
                    return;
                }
            }
        }
    }

    public Object readConfig(String key) {
        if (key.equals("BUS B")) {
            return this.status;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("region")) {
            this.counter.region = value.toString().equals("ntsc") ? 0 : 1;
            this.region = this.counter.region;
        }
    }

    @Override
    public void op_io() {
        this.add_clocks(6);
    }

    @Override
    public byte op_read(int addr) {
        this.regs.mdr = this.bus.read8bit(addr);
        this.add_clocks(this.speed(addr));
        return this.regs.mdr;
    }

    @Override
    public void op_write(int addr, byte data) {
        this.add_clocks(this.speed(addr));
        this.regs.mdr = data;
        this.bus.write8bit(addr, this.regs.mdr);
    }

    @Override
    public boolean interrupt_pending() {
        return false;
    }

    @Override
    public void last_cycle() {
        if (this.status.irq_lock) {
            this.status.irq_lock = false;
            return;
        }
        if (this.status.nmi_transition) {
            this.regs.wai = false;
            this.status.nmi_transition = false;
            this.status.nmi_pending = true;
        }
        if (this.status.irq_transition || this.regs.irq) {
            this.regs.wai = false;
            this.status.irq_transition = false;
            this.status.irq_pending = !this.regs.p.i;
        }
    }

    private final void step(int clocks) {
        this.smpClocks += (long)clocks;
        this.ppu_clk.clock((long)clocks);
    }

    private void synchronize_smp() {
        this.smp_clk.clock(this.smpClocks);
        this.smpClocks = 0L;
    }

    private void port_write(int port, byte data) {
        this.port_data[port & 3] = data & 0xFF;
    }

    private void power() {
        this.regs.a.set(0);
        this.regs.x.set(0);
        this.regs.y.set(0);
        this.regs.s.set(511);
        this.reset();
    }

    private void op_irq(int vector) {
        this.op_read(this.regs.pc.get());
        this.op_io();
        if (!this.regs.e) {
            this.op_writestack(this.regs.pc.b());
        }
        this.op_writestack(this.regs.pc.h());
        this.op_writestack(this.regs.pc.l());
        this.op_writestack(this.regs.e ? this.regs.p.get() & 0xFFFFFFEF & 0xFF : this.regs.p.get() & 0xFF);
        this.rd.l(this.op_read(vector + 0));
        this.regs.pc.b(0);
        this.regs.p.i = true;
        this.regs.p.d = false;
        this.rd.h(this.op_read(vector + 1));
        this.regs.pc.w(this.rd.w());
    }

    final void add_clocks(int clocks) {
        if (this.status.hirq_enabled) {
            if (this.status.virq_enabled) {
                int cpu_time = this.counter.vcounter() * 1364 + this.counter.hcounter();
                int irq_time = this.status.vtime * 1364 + this.status.htime * 4;
                int framelines = (this.region == 0 ? 262 : 312) + (this.counter.field() ? 1 : 0);
                if (cpu_time > irq_time) {
                    irq_time += framelines * 1364;
                }
                boolean irq_valid = this.status.irq_valid;
                boolean bl = this.status.irq_valid = cpu_time <= irq_time && cpu_time + clocks > irq_time;
                if (!irq_valid && this.status.irq_valid) {
                    this.status.irq_line = true;
                }
            } else {
                int irq_time = this.status.htime * 4;
                if (this.counter.hcounter() > irq_time) {
                    irq_time += 1364;
                }
                boolean irq_valid = this.status.irq_valid;
                boolean bl = this.status.irq_valid = this.counter.hcounter() <= irq_time && this.counter.hcounter() + clocks > irq_time;
                if (!irq_valid && this.status.irq_valid) {
                    this.status.irq_line = true;
                }
            }
            if (this.status.irq_line) {
                this.status.irq_transition = true;
            }
        } else if (this.status.virq_enabled) {
            boolean irq_valid = this.status.irq_valid;
            boolean bl = this.status.irq_valid = this.counter.vcounter() == this.status.vtime;
            if (!irq_valid && this.status.irq_valid) {
                this.status.irq_line = true;
            }
            if (this.status.irq_line) {
                this.status.irq_transition = true;
            }
        } else {
            this.status.irq_valid = false;
        }
        this.counter.tick(clocks);
        this.queue.tick(clocks);
        this.step(clocks);
    }

    private void run_auto_joypad_poll() {
        int joy1 = 0;
        int joy2 = 0;
        int joy3 = 0;
        int joy4 = 0;
        int i = 0;
        while (i < 16) {
            byte port0 = this.input_port.read8bit(0);
            byte port1 = this.input_port.read8bit(1);
            joy1 |= (port0 & 1) != 0 ? 32768 >> i : 0;
            joy2 |= (port1 & 1) != 0 ? 32768 >> i : 0;
            joy3 |= (port0 & 2) != 0 ? 32768 >> i : 0;
            joy4 |= (port1 & 2) != 0 ? 32768 >> i : 0;
            ++i;
        }
        this.status.joy1l = joy1 & 0xFF;
        this.status.joy1h = joy1 >> 8 & 0xFF;
        this.status.joy2l = joy2 & 0xFF;
        this.status.joy2h = joy2 >> 8 & 0xFF;
        this.status.joy3l = joy3 & 0xFF;
        this.status.joy3h = joy3 >> 8 & 0xFF;
        this.status.joy4l = joy4 & 0xFF;
        this.status.joy4h = joy4 >> 8 & 0xFF;
    }

    private int speed(int addr) {
        if ((addr & 0x408000) != 0) {
            if ((addr & 0x800000) != 0) {
                return this.status.rom_speed;
            }
            return 8;
        }
        if ((addr + 24576 & 0x4000) != 0) {
            return 8;
        }
        if ((addr - 16384 & 0x7E00) != 0) {
            return 6;
        }
        return 12;
    }
}

