/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.cpu;

import jario.snes.performance.cpu.CPUCoreOpArgument;
import jario.snes.performance.cpu.CPUCoreOperation;
import jario.snes.performance.cpu.Reg24;
import jario.snes.performance.cpu.Regs;
import java.util.Arrays;
import java.util.List;

public abstract class CPUCore {
    public Regs regs = new Regs();
    public Reg24 aa = new Reg24();
    public Reg24 rd = new Reg24();
    public int sp;
    public int dp;
    public CPUCoreOperation.CPUCoreOp op_adc_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int result;
            if (!CPUCore.this.regs.p.d) {
                result = CPUCore.this.regs.a.l() + CPUCore.this.rd.l() + (CPUCore.this.regs.p.c ? 1 : 0);
            } else {
                result = (CPUCore.this.regs.a.l() & 0xF) + (CPUCore.this.rd.l() & 0xF) + ((CPUCore.this.regs.p.c ? 1 : 0) << 0);
                if (result > 9) {
                    result += 6;
                }
                CPUCore.this.regs.p.c = result > 15;
                result = (CPUCore.this.regs.a.l() & 0xF0) + (CPUCore.this.rd.l() & 0xF0) + ((CPUCore.this.regs.p.c ? 1 : 0) << 4) + (result & 0xF);
            }
            boolean bl = CPUCore.this.regs.p.v = (~(CPUCore.this.regs.a.l() ^ CPUCore.this.rd.l()) & (CPUCore.this.regs.a.l() ^ result) & 0x80) != 0;
            if (CPUCore.this.regs.p.d && result > 159) {
                result += 96;
            }
            CPUCore.this.regs.p.c = result > 255;
            CPUCore.this.regs.p.n = (result & 0x80) != 0;
            CPUCore.this.regs.p.z = (result & 0xFF) == 0;
            CPUCore.this.regs.a.l(result);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adc_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int result;
            if (!CPUCore.this.regs.p.d) {
                result = CPUCore.this.regs.a.w() + CPUCore.this.rd.w() + (CPUCore.this.regs.p.c ? 1 : 0);
            } else {
                result = (CPUCore.this.regs.a.w() & 0xF) + (CPUCore.this.rd.w() & 0xF) + ((CPUCore.this.regs.p.c ? 1 : 0) << 0);
                if (result > 9) {
                    result += 6;
                }
                CPUCore.this.regs.p.c = result > 15;
                result = (CPUCore.this.regs.a.w() & 0xF0) + (CPUCore.this.rd.w() & 0xF0) + ((CPUCore.this.regs.p.c ? 1 : 0) << 4) + (result & 0xF);
                if (result > 159) {
                    result += 96;
                }
                CPUCore.this.regs.p.c = result > 255;
                result = (CPUCore.this.regs.a.w() & 0xF00) + (CPUCore.this.rd.w() & 0xF00) + ((CPUCore.this.regs.p.c ? 1 : 0) << 8) + (result & 0xFF);
                if (result > 2559) {
                    result += 1536;
                }
                CPUCore.this.regs.p.c = result > 4095;
                result = (CPUCore.this.regs.a.w() & 0xF000) + (CPUCore.this.rd.w() & 0xF000) + ((CPUCore.this.regs.p.c ? 1 : 0) << 12) + (result & 0xFFF);
            }
            boolean bl = CPUCore.this.regs.p.v = (~(CPUCore.this.regs.a.w() ^ CPUCore.this.rd.w()) & (CPUCore.this.regs.a.w() ^ result) & 0x8000) != 0;
            if (CPUCore.this.regs.p.d && result > 40959) {
                result += 24576;
            }
            CPUCore.this.regs.p.c = result > 65535;
            CPUCore.this.regs.p.n = (result & 0x8000) != 0;
            CPUCore.this.regs.p.z = (result & 0xFFFF) == 0;
            CPUCore.this.regs.a.w(result);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_and_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.a.l(CPUCore.this.regs.a.l() & CPUCore.this.rd.l());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_and_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.a.w(CPUCore.this.regs.a.w() & CPUCore.this.rd.w());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_bit_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.p.n = (CPUCore.this.rd.l() & 0x80) != 0;
            CPUCore.this.regs.p.v = (CPUCore.this.rd.l() & 0x40) != 0;
            CPUCore.this.regs.p.z = (CPUCore.this.rd.l() & CPUCore.this.regs.a.l()) == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_bit_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.p.n = (CPUCore.this.rd.w() & 0x8000) != 0;
            CPUCore.this.regs.p.v = (CPUCore.this.rd.w() & 0x4000) != 0;
            CPUCore.this.regs.p.z = (CPUCore.this.rd.w() & CPUCore.this.regs.a.w()) == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_cmp_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int r = CPUCore.this.regs.a.l() - CPUCore.this.rd.l();
            CPUCore.this.regs.p.n = (r & 0x80) != 0;
            CPUCore.this.regs.p.z = (r & 0xFF) == 0;
            CPUCore.this.regs.p.c = r >= 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_cmp_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int r = CPUCore.this.regs.a.w() - CPUCore.this.rd.w();
            CPUCore.this.regs.p.n = (r & 0x8000) != 0;
            CPUCore.this.regs.p.z = (r & 0xFFFF) == 0;
            CPUCore.this.regs.p.c = r >= 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_cpx_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int r = CPUCore.this.regs.x.l() - CPUCore.this.rd.l();
            CPUCore.this.regs.p.n = (r & 0x80) != 0;
            CPUCore.this.regs.p.z = (r & 0xFF) == 0;
            CPUCore.this.regs.p.c = r >= 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_cpx_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int r = CPUCore.this.regs.x.w() - CPUCore.this.rd.w();
            CPUCore.this.regs.p.n = (r & 0x8000) != 0;
            CPUCore.this.regs.p.z = (r & 0xFFFF) == 0;
            CPUCore.this.regs.p.c = r >= 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_cpy_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int r = CPUCore.this.regs.y.l() - CPUCore.this.rd.l();
            CPUCore.this.regs.p.n = (r & 0x80) != 0;
            CPUCore.this.regs.p.z = (r & 0xFF) == 0;
            CPUCore.this.regs.p.c = r >= 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_cpy_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int r = CPUCore.this.regs.y.w() - CPUCore.this.rd.w();
            CPUCore.this.regs.p.n = (r & 0x8000) != 0;
            CPUCore.this.regs.p.z = (r & 0xFFFF) == 0;
            CPUCore.this.regs.p.c = r >= 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_eor_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.a.l(CPUCore.this.regs.a.l() ^ CPUCore.this.rd.l());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_eor_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.a.w(CPUCore.this.regs.a.w() ^ CPUCore.this.rd.w());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_lda_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.a.l(CPUCore.this.rd.l());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_lda_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.a.w(CPUCore.this.rd.w());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_ldx_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.x.l(CPUCore.this.rd.l());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.x.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.x.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_ldx_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.x.w(CPUCore.this.rd.w());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.x.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.x.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_ldy_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.y.l(CPUCore.this.rd.l());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.y.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.y.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_ldy_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.y.w(CPUCore.this.rd.w());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.y.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.y.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_ora_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.a.l(CPUCore.this.regs.a.l() | CPUCore.this.rd.l());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_ora_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.a.w(CPUCore.this.regs.a.w() | CPUCore.this.rd.w());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sbc_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int result;
            CPUCore.this.rd.l(CPUCore.this.rd.l() ^ 0xFF);
            if (!CPUCore.this.regs.p.d) {
                result = CPUCore.this.regs.a.l() + CPUCore.this.rd.l() + (CPUCore.this.regs.p.c ? 1 : 0);
            } else {
                result = (CPUCore.this.regs.a.l() & 0xF) + (CPUCore.this.rd.l() & 0xF) + ((CPUCore.this.regs.p.c ? 1 : 0) << 0);
                if (result <= 15) {
                    result -= 6;
                }
                CPUCore.this.regs.p.c = result > 15;
                result = (CPUCore.this.regs.a.l() & 0xF0) + (CPUCore.this.rd.l() & 0xF0) + ((CPUCore.this.regs.p.c ? 1 : 0) << 4) + (result & 0xF);
            }
            boolean bl = CPUCore.this.regs.p.v = (~(CPUCore.this.regs.a.l() ^ CPUCore.this.rd.l()) & (CPUCore.this.regs.a.l() ^ result) & 0x80) != 0;
            if (CPUCore.this.regs.p.d && result <= 255) {
                result -= 96;
            }
            CPUCore.this.regs.p.c = result > 255;
            CPUCore.this.regs.p.n = (result & 0x80) != 0;
            CPUCore.this.regs.p.z = (result & 0xFF) == 0;
            CPUCore.this.regs.a.l(result);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sbc_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int result;
            CPUCore.this.rd.w(CPUCore.this.rd.w() ^ 0xFFFF);
            if (!CPUCore.this.regs.p.d) {
                result = CPUCore.this.regs.a.w() + CPUCore.this.rd.w() + (CPUCore.this.regs.p.c ? 1 : 0);
            } else {
                result = (CPUCore.this.regs.a.w() & 0xF) + (CPUCore.this.rd.w() & 0xF) + ((CPUCore.this.regs.p.c ? 1 : 0) << 0);
                if (result <= 15) {
                    result -= 6;
                }
                CPUCore.this.regs.p.c = result > 15;
                result = (CPUCore.this.regs.a.w() & 0xF0) + (CPUCore.this.rd.w() & 0xF0) + ((CPUCore.this.regs.p.c ? 1 : 0) << 4) + (result & 0xF);
                if (result <= 255) {
                    result -= 96;
                }
                CPUCore.this.regs.p.c = result > 255;
                result = (CPUCore.this.regs.a.w() & 0xF00) + (CPUCore.this.rd.w() & 0xF00) + ((CPUCore.this.regs.p.c ? 1 : 0) << 8) + (result & 0xFF);
                if (result <= 4095) {
                    result -= 1536;
                }
                CPUCore.this.regs.p.c = result > 4095;
                result = (CPUCore.this.regs.a.w() & 0xF000) + (CPUCore.this.rd.w() & 0xF000) + ((CPUCore.this.regs.p.c ? 1 : 0) << 12) + (result & 0xFFF);
            }
            boolean bl = CPUCore.this.regs.p.v = (~(CPUCore.this.regs.a.w() ^ CPUCore.this.rd.w()) & (CPUCore.this.regs.a.w() ^ result) & 0x8000) != 0;
            if (CPUCore.this.regs.p.d && result <= 65535) {
                result -= 24576;
            }
            CPUCore.this.regs.p.c = result > 65535;
            CPUCore.this.regs.p.n = (result & 0x8000) != 0;
            CPUCore.this.regs.p.z = (result & 0xFFFF) == 0;
            CPUCore.this.regs.a.w(result);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_inc_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.rd.l(CPUCore.this.rd.l() + 1);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_inc_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.rd.w(CPUCore.this.rd.w() + 1);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_dec_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.rd.l(CPUCore.this.rd.l() - 1);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_dec_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.rd.w(CPUCore.this.rd.w() - 1);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_asl_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.p.c = (CPUCore.this.rd.l() & 0x80) != 0;
            CPUCore.this.rd.l(CPUCore.this.rd.l() << 1);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_asl_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.p.c = (CPUCore.this.rd.w() & 0x8000) != 0;
            CPUCore.this.rd.w(CPUCore.this.rd.w() << 1);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_lsr_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.p.c = (CPUCore.this.rd.l() & 1) != 0;
            CPUCore.this.rd.l(CPUCore.this.rd.l() >> 1);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_lsr_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.p.c = (CPUCore.this.rd.w() & 1) != 0;
            CPUCore.this.rd.w(CPUCore.this.rd.w() >> 1);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_rol_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int carry = CPUCore.this.regs.p.c ? 1 : 0;
            CPUCore.this.regs.p.c = (CPUCore.this.rd.l() & 0x80) != 0;
            CPUCore.this.rd.l(CPUCore.this.rd.l() << 1 | carry);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_rol_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int carry = CPUCore.this.regs.p.c ? 1 : 0;
            CPUCore.this.regs.p.c = (CPUCore.this.rd.w() & 0x8000) != 0;
            CPUCore.this.rd.w(CPUCore.this.rd.w() << 1 | carry);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_ror_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int carry = (CPUCore.this.regs.p.c ? 1 : 0) << 7;
            CPUCore.this.regs.p.c = (CPUCore.this.rd.l() & 1) != 0;
            CPUCore.this.rd.l(carry | CPUCore.this.rd.l() >> 1);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_ror_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int carry = (CPUCore.this.regs.p.c ? 1 : 0) << 15;
            CPUCore.this.regs.p.c = (CPUCore.this.rd.w() & 1) != 0;
            CPUCore.this.rd.w(carry | CPUCore.this.rd.w() >> 1);
            CPUCore.this.regs.p.n = (CPUCore.this.rd.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.rd.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_trb_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.p.z = (CPUCore.this.rd.l() & CPUCore.this.regs.a.l()) == 0;
            CPUCore.this.rd.l(CPUCore.this.rd.l() & ~CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_trb_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.p.z = (CPUCore.this.rd.w() & CPUCore.this.regs.a.w()) == 0;
            CPUCore.this.rd.w(CPUCore.this.rd.w() & ~CPUCore.this.regs.a.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_tsb_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.p.z = (CPUCore.this.rd.l() & CPUCore.this.regs.a.l()) == 0;
            CPUCore.this.rd.l(CPUCore.this.rd.l() | CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_tsb_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.p.z = (CPUCore.this.rd.w() & CPUCore.this.regs.a.w()) == 0;
            CPUCore.this.rd.w(CPUCore.this.rd.w() | CPUCore.this.regs.a.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_const_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readpc());
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_const_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.rd.l(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readpc());
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_bit_const_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readpc());
            CPUCore.this.regs.p.z = (CPUCore.this.rd.l() & CPUCore.this.regs.a.l()) == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_bit_const_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.rd.l(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readpc());
            CPUCore.this.regs.p.z = (CPUCore.this.rd.w() & CPUCore.this.regs.a.w()) == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_addr_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_addr_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_addrx_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io_cond4(CPUCore.this.aa.w(), CPUCore.this.aa.w() + CPUCore.this.regs.x.w());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_addrx_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io_cond4(CPUCore.this.aa.w(), CPUCore.this.aa.w() + CPUCore.this.regs.x.w());
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_addry_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io_cond4(CPUCore.this.aa.w(), CPUCore.this.aa.w() + CPUCore.this.regs.y.w());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_addry_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io_cond4(CPUCore.this.aa.w(), CPUCore.this.aa.w() + CPUCore.this.regs.y.w());
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_long_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.aa.b(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readlong(CPUCore.this.aa.get()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_long_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.aa.b(CPUCore.this.op_readpc());
            CPUCore.this.rd.l(CPUCore.this.op_readlong(CPUCore.this.aa.get() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readlong(CPUCore.this.aa.get() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_longx_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.aa.b(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readlong(CPUCore.this.aa.get() + CPUCore.this.regs.x.w()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_longx_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.aa.b(CPUCore.this.op_readpc());
            CPUCore.this.rd.l(CPUCore.this.op_readlong(CPUCore.this.aa.get() + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readlong(CPUCore.this.aa.get() + CPUCore.this.regs.x.w() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_dp_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readdp(CPUCore.this.dp));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_dp_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.rd.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_dpr_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            int n = args.x;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.r[n].w()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_dpr_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            int n = args.x;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.r[n].w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.r[n].w() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_idp_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_idp_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_idpx_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_io();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 1));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_idpx_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_io();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 1));
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_idpy_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.op_io_cond4(CPUCore.this.aa.w(), CPUCore.this.aa.w() + CPUCore.this.regs.y.w());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_idpy_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.op_io_cond4(CPUCore.this.aa.w(), CPUCore.this.aa.w() + CPUCore.this.regs.y.w());
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_ildp_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.aa.b(CPUCore.this.op_readdp(CPUCore.this.dp + 2));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readlong(CPUCore.this.aa.get()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_ildp_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.aa.b(CPUCore.this.op_readdp(CPUCore.this.dp + 2));
            CPUCore.this.rd.l(CPUCore.this.op_readlong(CPUCore.this.aa.get() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readlong(CPUCore.this.aa.get() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_ildpy_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.aa.b(CPUCore.this.op_readdp(CPUCore.this.dp + 2));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readlong(CPUCore.this.aa.get() + CPUCore.this.regs.y.w()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_ildpy_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.aa.b(CPUCore.this.op_readdp(CPUCore.this.dp + 2));
            CPUCore.this.rd.l(CPUCore.this.op_readlong(CPUCore.this.aa.get() + CPUCore.this.regs.y.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readlong(CPUCore.this.aa.get() + CPUCore.this.regs.y.w() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_sr_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.sp = CPUCore.this.op_readpc();
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readsp(CPUCore.this.sp));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_sr_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.sp = CPUCore.this.op_readpc();
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readsp(CPUCore.this.sp + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readsp(CPUCore.this.sp + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_isry_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.sp = CPUCore.this.op_readpc();
            CPUCore.this.op_io();
            CPUCore.this.aa.l(CPUCore.this.op_readsp(CPUCore.this.sp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readsp(CPUCore.this.sp + 1));
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w()));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_read_isry_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.sp = CPUCore.this.op_readpc();
            CPUCore.this.op_io();
            CPUCore.this.aa.l(CPUCore.this.op_readsp(CPUCore.this.sp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readsp(CPUCore.this.sp + 1));
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w() + 1));
            op.Invoke(null);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_write_addr_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w(), CPUCore.this.regs.r[n].get());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_write_addr_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + 0, CPUCore.this.regs.r[n].get() >> 0);
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + 1, CPUCore.this.regs.r[n].get() >> 8);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_write_addrr_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            int i = args.y;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.r[i].get(), CPUCore.this.regs.r[n].get());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_write_addrr_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            int i = args.y;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.r[i].get() + 0, CPUCore.this.regs.r[n].get() >> 0);
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.r[i].get() + 1, CPUCore.this.regs.r[n].get() >> 8);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_write_longr_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int i = args.x;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.aa.b(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writelong(CPUCore.this.aa.get() + CPUCore.this.regs.r[i].get(), CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_write_longr_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int i = args.x;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.aa.b(CPUCore.this.op_readpc());
            CPUCore.this.op_writelong(CPUCore.this.aa.get() + CPUCore.this.regs.r[i].get() + 0, CPUCore.this.regs.a.l());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writelong(CPUCore.this.aa.get() + CPUCore.this.regs.r[i].get() + 1, CPUCore.this.regs.a.h());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_write_dp_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedp(CPUCore.this.dp, CPUCore.this.regs.r[n].get());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_write_dp_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_writedp(CPUCore.this.dp + 0, CPUCore.this.regs.r[n].get() >> 0);
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedp(CPUCore.this.dp + 1, CPUCore.this.regs.r[n].get() >> 8);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_write_dpr_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            int i = args.y;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedp(CPUCore.this.dp + CPUCore.this.regs.r[i].get(), CPUCore.this.regs.r[n].get());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_write_dpr_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            int i = args.y;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_io();
            CPUCore.this.op_writedp(CPUCore.this.dp + CPUCore.this.regs.r[i].get() + 0, CPUCore.this.regs.r[n].get() >> 0);
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedp(CPUCore.this.dp + CPUCore.this.regs.r[i].get() + 1, CPUCore.this.regs.r[n].get() >> 8);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_idp_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w(), CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_idp_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + 0, CPUCore.this.regs.a.l());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + 1, CPUCore.this.regs.a.h());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_ildp_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.aa.b(CPUCore.this.op_readdp(CPUCore.this.dp + 2));
            CPUCore.this.last_cycle();
            CPUCore.this.op_writelong(CPUCore.this.aa.get(), CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_ildp_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.aa.b(CPUCore.this.op_readdp(CPUCore.this.dp + 2));
            CPUCore.this.op_writelong(CPUCore.this.aa.get() + 0, CPUCore.this.regs.a.l());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writelong(CPUCore.this.aa.get() + 1, CPUCore.this.regs.a.h());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_idpx_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_io();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 1));
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w(), CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_idpx_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_io();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 1));
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + 0, CPUCore.this.regs.a.l());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + 1, CPUCore.this.regs.a.h());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_idpy_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w(), CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_idpy_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.op_io();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w() + 0, CPUCore.this.regs.a.l());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w() + 1, CPUCore.this.regs.a.h());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_ildpy_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.aa.b(CPUCore.this.op_readdp(CPUCore.this.dp + 2));
            CPUCore.this.last_cycle();
            CPUCore.this.op_writelong(CPUCore.this.aa.get() + CPUCore.this.regs.y.w(), CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_ildpy_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.aa.b(CPUCore.this.op_readdp(CPUCore.this.dp + 2));
            CPUCore.this.op_writelong(CPUCore.this.aa.get() + CPUCore.this.regs.y.w() + 0, CPUCore.this.regs.a.l());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writelong(CPUCore.this.aa.get() + CPUCore.this.regs.y.w() + 1, CPUCore.this.regs.a.h());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_sr_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.sp = CPUCore.this.op_readpc();
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.op_writesp(CPUCore.this.sp, CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_sr_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.sp = CPUCore.this.op_readpc();
            CPUCore.this.op_io();
            CPUCore.this.op_writesp(CPUCore.this.sp + 0, CPUCore.this.regs.a.l());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writesp(CPUCore.this.sp + 1, CPUCore.this.regs.a.h());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_isry_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.sp = CPUCore.this.op_readpc();
            CPUCore.this.op_io();
            CPUCore.this.aa.l(CPUCore.this.op_readsp(CPUCore.this.sp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readsp(CPUCore.this.sp + 1));
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w(), CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_sta_isry_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.sp = CPUCore.this.op_readpc();
            CPUCore.this.op_io();
            CPUCore.this.aa.l(CPUCore.this.op_readsp(CPUCore.this.sp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readsp(CPUCore.this.sp + 1));
            CPUCore.this.op_io();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w() + 0, CPUCore.this.regs.a.l());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.y.w() + 1, CPUCore.this.regs.a.h());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adjust_imm_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            int adjust = args.y;
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.r[n].l(CPUCore.this.regs.r[n].l() + (adjust & 0xFF));
            CPUCore.this.regs.p.n = (CPUCore.this.regs.r[n].l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.r[n].l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adjust_imm_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            int adjust = args.y;
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.r[n].w(CPUCore.this.regs.r[n].w() + (adjust & 0xFFFF));
            CPUCore.this.regs.p.n = (CPUCore.this.regs.r[n].w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.r[n].w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_asl_imm_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.p.c = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.a.l(CPUCore.this.regs.a.l() << 1);
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_asl_imm_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.p.c = (CPUCore.this.regs.a.w() & 0x8000) != 0;
            CPUCore.this.regs.a.w(CPUCore.this.regs.a.w() << 1);
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_lsr_imm_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.p.c = (CPUCore.this.regs.a.l() & 1) != 0;
            CPUCore.this.regs.a.l(CPUCore.this.regs.a.l() >> 1);
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_lsr_imm_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.p.c = (CPUCore.this.regs.a.w() & 1) != 0;
            CPUCore.this.regs.a.w(CPUCore.this.regs.a.w() >> 1);
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_rol_imm_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            int carry = CPUCore.this.regs.p.c ? 1 : 0;
            CPUCore.this.regs.p.c = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.a.l(CPUCore.this.regs.a.l() << 1 | carry);
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_rol_imm_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            int carry = CPUCore.this.regs.p.c ? 1 : 0;
            CPUCore.this.regs.p.c = (CPUCore.this.regs.a.w() & 0x8000) != 0;
            CPUCore.this.regs.a.w(CPUCore.this.regs.a.w() << 1 | carry);
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_ror_imm_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            int carry = CPUCore.this.regs.p.c ? 1 : 0;
            CPUCore.this.regs.p.c = (CPUCore.this.regs.a.l() & 1) != 0;
            CPUCore.this.regs.a.l(carry << 7 | CPUCore.this.regs.a.l() >> 1);
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_ror_imm_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            int carry = CPUCore.this.regs.p.c ? 1 : 0;
            CPUCore.this.regs.p.c = (CPUCore.this.regs.a.w() & 1) != 0;
            CPUCore.this.regs.a.w(carry << 15 | CPUCore.this.regs.a.w() >> 1);
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adjust_addr_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w()));
            CPUCore.this.op_io();
            op.Invoke(null);
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w(), CPUCore.this.rd.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adjust_addr_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + 0));
            CPUCore.this.rd.h(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + 1));
            CPUCore.this.op_io();
            op.Invoke(null);
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + 1, CPUCore.this.rd.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + 0, CPUCore.this.rd.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adjust_addrx_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w()));
            CPUCore.this.op_io();
            op.Invoke(null);
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w(), CPUCore.this.rd.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adjust_addrx_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.rd.h(CPUCore.this.op_readdbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 1));
            CPUCore.this.op_io();
            op.Invoke(null);
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 1, CPUCore.this.rd.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 0, CPUCore.this.rd.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adjust_dp_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.rd.l(CPUCore.this.op_readdp(CPUCore.this.dp));
            CPUCore.this.op_io();
            op.Invoke(null);
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedp(CPUCore.this.dp, CPUCore.this.rd.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adjust_dp_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.rd.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.rd.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.op_io();
            op.Invoke(null);
            CPUCore.this.op_writedp(CPUCore.this.dp + 1, CPUCore.this.rd.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedp(CPUCore.this.dp + 0, CPUCore.this.rd.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adjust_dpx_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w()));
            CPUCore.this.op_io();
            op.Invoke(null);
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedp(CPUCore.this.dp + CPUCore.this.regs.x.w(), CPUCore.this.rd.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_adjust_dpx_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCoreOperation.CPUCoreOp op = args.op;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.rd.h(CPUCore.this.op_readdp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 1));
            CPUCore.this.op_io();
            op.Invoke(null);
            CPUCore.this.op_writedp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 1, CPUCore.this.rd.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writedp(CPUCore.this.dp + CPUCore.this.regs.x.w() + 0, CPUCore.this.rd.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_branch = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int bit = args.x;
            int val = args.y;
            if (((CPUCore.this.regs.p.get() & bit) != 0 ? 1 : 0) != val) {
                CPUCore.this.last_cycle();
                CPUCore.this.rd.l(CPUCore.this.op_readpc());
            } else {
                CPUCore.this.rd.l(CPUCore.this.op_readpc());
                CPUCore.this.aa.w(CPUCore.this.regs.pc.get() + (byte)CPUCore.this.rd.l());
                CPUCore.this.op_io_cond6(CPUCore.this.aa.w());
                CPUCore.this.last_cycle();
                CPUCore.this.op_io();
                CPUCore.this.regs.pc.w(CPUCore.this.aa.w());
            }
        }
    };
    public CPUCoreOperation.CPUCoreOp op_bra = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.rd.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.w(CPUCore.this.regs.pc.get() + (byte)CPUCore.this.rd.l());
            CPUCore.this.op_io_cond6(CPUCore.this.aa.w());
            CPUCore.this.last_cycle();
            CPUCore.this.op_io();
            CPUCore.this.regs.pc.w(CPUCore.this.aa.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_brl = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.rd.l(CPUCore.this.op_readpc());
            CPUCore.this.rd.h(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.op_io();
            CPUCore.this.regs.pc.w(CPUCore.this.regs.pc.get() + CPUCore.this.rd.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_jmp_addr = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.rd.l(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readpc());
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_jmp_long = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.rd.l(CPUCore.this.op_readpc());
            CPUCore.this.rd.h(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.b(CPUCore.this.op_readpc());
            CPUCore.this.regs.pc.set(CPUCore.this.rd.get());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_jmp_iaddr = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.rd.l(CPUCore.this.op_readaddr(CPUCore.this.aa.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readaddr(CPUCore.this.aa.w() + 1));
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_jmp_iaddrx = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readpbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readpbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 1));
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_jmp_iladdr = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.rd.l(CPUCore.this.op_readaddr(CPUCore.this.aa.w() + 0));
            CPUCore.this.rd.h(CPUCore.this.op_readaddr(CPUCore.this.aa.w() + 1));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.b(CPUCore.this.op_readaddr(CPUCore.this.aa.w() + 2));
            CPUCore.this.regs.pc.set(CPUCore.this.rd.get());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_jsr_addr = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io();
            CPUCore.this.regs.pc.w(CPUCore.this.regs.pc.w() - 1);
            CPUCore.this.op_writestack(CPUCore.this.regs.pc.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestack(CPUCore.this.regs.pc.l());
            CPUCore.this.regs.pc.w(CPUCore.this.aa.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_jsr_long_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_writestackn(CPUCore.this.regs.pc.b());
            CPUCore.this.op_io();
            CPUCore.this.aa.b(CPUCore.this.op_readpc());
            CPUCore.this.regs.pc.w(CPUCore.this.regs.pc.w() - 1);
            CPUCore.this.op_writestackn(CPUCore.this.regs.pc.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestackn(CPUCore.this.regs.pc.l());
            CPUCore.this.regs.pc.set(CPUCore.this.aa.get());
            CPUCore.this.regs.s.h(1);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_jsr_long_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_writestackn(CPUCore.this.regs.pc.b());
            CPUCore.this.op_io();
            CPUCore.this.aa.b(CPUCore.this.op_readpc());
            CPUCore.this.regs.pc.w(CPUCore.this.regs.pc.w() - 1);
            CPUCore.this.op_writestackn(CPUCore.this.regs.pc.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestackn(CPUCore.this.regs.pc.l());
            CPUCore.this.regs.pc.set(CPUCore.this.aa.get());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_jsr_iaddrx_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.op_writestackn(CPUCore.this.regs.pc.h());
            CPUCore.this.op_writestackn(CPUCore.this.regs.pc.l());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readpbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readpbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 1));
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
            CPUCore.this.regs.s.h(1);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_jsr_iaddrx_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.op_writestackn(CPUCore.this.regs.pc.h());
            CPUCore.this.op_writestackn(CPUCore.this.regs.pc.l());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readpbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 0));
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readpbr(CPUCore.this.aa.w() + CPUCore.this.regs.x.w() + 1));
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_rti_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.regs.p.set(CPUCore.this.op_readstack() | 0x30);
            CPUCore.this.rd.l(CPUCore.this.op_readstack());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readstack());
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_rti_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.regs.p.set(CPUCore.this.op_readstack());
            if (CPUCore.this.regs.p.x) {
                CPUCore.this.regs.x.h(0);
                CPUCore.this.regs.y.h(0);
            }
            CPUCore.this.rd.l(CPUCore.this.op_readstack());
            CPUCore.this.rd.h(CPUCore.this.op_readstack());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.b(CPUCore.this.op_readstack());
            CPUCore.this.regs.pc.set(CPUCore.this.rd.get());
            CPUCore.this.update_table();
        }
    };
    public CPUCoreOperation.CPUCoreOp op_rts = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readstack());
            CPUCore.this.rd.h(CPUCore.this.op_readstack());
            CPUCore.this.last_cycle();
            CPUCore.this.op_io();
            CPUCore.this.rd.w(CPUCore.this.rd.w() + 1);
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_rtl_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readstackn());
            CPUCore.this.rd.h(CPUCore.this.op_readstackn());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.b(CPUCore.this.op_readstackn());
            CPUCore.this.regs.pc.b(CPUCore.this.rd.b());
            CPUCore.this.rd.w(CPUCore.this.rd.w() + 1);
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
            CPUCore.this.regs.s.h(1);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_rtl_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.rd.l(CPUCore.this.op_readstackn());
            CPUCore.this.rd.h(CPUCore.this.op_readstackn());
            CPUCore.this.last_cycle();
            CPUCore.this.rd.b(CPUCore.this.op_readstackn());
            CPUCore.this.regs.pc.b(CPUCore.this.rd.b());
            CPUCore.this.rd.w(CPUCore.this.rd.w() + 1);
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_nop = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
        }
    };
    public CPUCoreOperation.CPUCoreOp op_wdm = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_readpc();
        }
    };
    public CPUCoreOperation.CPUCoreOp op_xba = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.op_io();
            CPUCore.this.regs.a.l(CPUCore.this.regs.a.l() ^ CPUCore.this.regs.a.h());
            CPUCore.this.regs.a.h(CPUCore.this.regs.a.h() ^ CPUCore.this.regs.a.l());
            CPUCore.this.regs.a.l(CPUCore.this.regs.a.l() ^ CPUCore.this.regs.a.h());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.a.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.a.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_move_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int adjust = args.x;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.sp = CPUCore.this.op_readpc();
            CPUCore.this.regs.db = (byte)CPUCore.this.dp;
            CPUCore.this.rd.l(CPUCore.this.op_readlong(CPUCore.this.sp << 16 | CPUCore.this.regs.x.w()));
            CPUCore.this.op_writelong(CPUCore.this.dp << 16 | CPUCore.this.regs.y.w(), CPUCore.this.rd.l());
            CPUCore.this.op_io();
            CPUCore.this.regs.x.l(CPUCore.this.regs.x.l() + (adjust & 0xFF));
            CPUCore.this.regs.y.l(CPUCore.this.regs.y.l() + (adjust & 0xFF));
            CPUCore.this.last_cycle();
            CPUCore.this.op_io();
            if (CPUCore.this.regs.a.w() != 0) {
                CPUCore.this.regs.pc.w(CPUCore.this.regs.pc.w() - 3);
            }
            CPUCore.this.regs.a.w(CPUCore.this.regs.a.w() - 1);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_move_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int adjust = args.x;
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.sp = CPUCore.this.op_readpc();
            CPUCore.this.regs.db = (byte)CPUCore.this.dp;
            CPUCore.this.rd.l(CPUCore.this.op_readlong(CPUCore.this.sp << 16 | CPUCore.this.regs.x.w()));
            CPUCore.this.op_writelong(CPUCore.this.dp << 16 | CPUCore.this.regs.y.w(), CPUCore.this.rd.l());
            CPUCore.this.op_io();
            CPUCore.this.regs.x.w(CPUCore.this.regs.x.w() + (short)adjust);
            CPUCore.this.regs.y.w(CPUCore.this.regs.y.w() + (short)adjust);
            CPUCore.this.last_cycle();
            CPUCore.this.op_io();
            if (CPUCore.this.regs.a.w() != 0) {
                CPUCore.this.regs.pc.w(CPUCore.this.regs.pc.w() - 3);
            }
            CPUCore.this.regs.a.w(CPUCore.this.regs.a.w() - 1);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_interrupt_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int vectorE = args.x;
            CPUCore.this.op_readpc();
            CPUCore.this.op_writestack(CPUCore.this.regs.pc.h());
            CPUCore.this.op_writestack(CPUCore.this.regs.pc.l());
            CPUCore.this.op_writestack(CPUCore.this.regs.p.get());
            CPUCore.this.rd.l(CPUCore.this.op_readlong(vectorE + 0));
            CPUCore.this.regs.pc.b(0);
            CPUCore.this.regs.p.i = true;
            CPUCore.this.regs.p.d = false;
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readlong(vectorE + 1));
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_interrupt_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int vectorN = args.y;
            CPUCore.this.op_readpc();
            CPUCore.this.op_writestack(CPUCore.this.regs.pc.b());
            CPUCore.this.op_writestack(CPUCore.this.regs.pc.h());
            CPUCore.this.op_writestack(CPUCore.this.regs.pc.l());
            CPUCore.this.op_writestack(CPUCore.this.regs.p.get());
            CPUCore.this.rd.l(CPUCore.this.op_readlong(vectorN + 0));
            CPUCore.this.regs.pc.b(0);
            CPUCore.this.regs.p.i = true;
            CPUCore.this.regs.p.d = false;
            CPUCore.this.last_cycle();
            CPUCore.this.rd.h(CPUCore.this.op_readlong(vectorN + 1));
            CPUCore.this.regs.pc.w(CPUCore.this.rd.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_stp = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.wai = true;
            while (CPUCore.this.regs.wai) {
                CPUCore.this.last_cycle();
                CPUCore.this.op_io();
            }
        }
    };
    public CPUCoreOperation.CPUCoreOp op_wai = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.regs.wai = true;
            while (CPUCore.this.regs.wai) {
                CPUCore.this.last_cycle();
                CPUCore.this.op_io();
            }
            CPUCore.this.op_io();
        }
    };
    public CPUCoreOperation.CPUCoreOp op_xce = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            boolean carry = CPUCore.this.regs.p.c;
            CPUCore.this.regs.p.c = CPUCore.this.regs.e;
            CPUCore.this.regs.e = carry;
            if (CPUCore.this.regs.e) {
                CPUCore.this.regs.p.set(CPUCore.this.regs.p.get() | 0x30);
                CPUCore.this.regs.s.h(1);
            }
            if (CPUCore.this.regs.p.x) {
                CPUCore.this.regs.x.h(0);
                CPUCore.this.regs.y.h(0);
            }
            CPUCore.this.update_table();
        }
    };
    public CPUCoreOperation.CPUCoreOp op_flag = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int mask = args.x;
            int value = args.y;
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.p.set(CPUCore.this.regs.p.get() & ~mask | value);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_pflag_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            boolean mode = args.x != 0;
            CPUCore.this.rd.l(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.op_io();
            CPUCore.this.regs.p.set(mode ? CPUCore.this.regs.p.get() | CPUCore.this.rd.l() : CPUCore.this.regs.p.get() & ~CPUCore.this.rd.l());
            CPUCore.this.regs.p.set(CPUCore.this.regs.p.get() | 0x30);
            if (CPUCore.this.regs.p.x) {
                CPUCore.this.regs.x.h(0);
                CPUCore.this.regs.y.h(0);
            }
            CPUCore.this.update_table();
        }
    };
    public CPUCoreOperation.CPUCoreOp op_pflag_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            boolean mode = args.x != 0;
            CPUCore.this.rd.l(CPUCore.this.op_readpc());
            CPUCore.this.last_cycle();
            CPUCore.this.op_io();
            CPUCore.this.regs.p.set(mode ? CPUCore.this.regs.p.get() | CPUCore.this.rd.l() : CPUCore.this.regs.p.get() & ~CPUCore.this.rd.l());
            if (CPUCore.this.regs.p.x) {
                CPUCore.this.regs.x.h(0);
                CPUCore.this.regs.y.h(0);
            }
            CPUCore.this.update_table();
        }
    };
    public CPUCoreOperation.CPUCoreOp op_transfer_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int from = args.x;
            int to = args.y;
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.r[to].l(CPUCore.this.regs.r[from].l());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.r[to].l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.r[to].l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_transfer_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int from = args.x;
            int to = args.y;
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.r[to].w(CPUCore.this.regs.r[from].w());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.r[to].w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.r[to].w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_tcs_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.s.l(CPUCore.this.regs.a.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_tcs_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.s.w(CPUCore.this.regs.a.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_tsx_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.x.l(CPUCore.this.regs.s.l());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.x.l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.x.l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_tsx_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.x.w(CPUCore.this.regs.s.w());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.x.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.x.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_txs_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.s.l(CPUCore.this.regs.x.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_txs_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.last_cycle();
            CPUCore.this.op_io_irq();
            CPUCore.this.regs.s.w(CPUCore.this.regs.x.w());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_push_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestack(CPUCore.this.regs.r[n].l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_push_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            CPUCore.this.op_io();
            CPUCore.this.op_writestack(CPUCore.this.regs.r[n].h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestack(CPUCore.this.regs.r[n].l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_phd_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_writestackn(CPUCore.this.regs.d.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestackn(CPUCore.this.regs.d.l());
            CPUCore.this.regs.s.h(1);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_phd_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_writestackn(CPUCore.this.regs.d.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestackn(CPUCore.this.regs.d.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_phb = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestack(CPUCore.this.regs.db);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_phk = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestack(CPUCore.this.regs.pc.b());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_php = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestack(CPUCore.this.regs.p.get());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_pull_b = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.regs.r[n].l(CPUCore.this.op_readstack());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.r[n].l() & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.r[n].l() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_pull_w = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            int n = args.x;
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.regs.r[n].l(CPUCore.this.op_readstack());
            CPUCore.this.last_cycle();
            CPUCore.this.regs.r[n].h(CPUCore.this.op_readstack());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.r[n].w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.r[n].w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_pld_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.regs.d.l(CPUCore.this.op_readstackn());
            CPUCore.this.last_cycle();
            CPUCore.this.regs.d.h(CPUCore.this.op_readstackn());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.d.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.d.w() == 0;
            CPUCore.this.regs.s.h(1);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_pld_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.regs.d.l(CPUCore.this.op_readstackn());
            CPUCore.this.last_cycle();
            CPUCore.this.regs.d.h(CPUCore.this.op_readstackn());
            CPUCore.this.regs.p.n = (CPUCore.this.regs.d.w() & 0x8000) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.d.w() == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_plb = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.regs.db = (byte)CPUCore.this.op_readstack();
            CPUCore.this.regs.p.n = (CPUCore.this.regs.db & 0x80) != 0;
            CPUCore.this.regs.p.z = CPUCore.this.regs.db == 0;
        }
    };
    public CPUCoreOperation.CPUCoreOp op_plp_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.regs.p.set(CPUCore.this.op_readstack() | 0x30);
            if (CPUCore.this.regs.p.x) {
                CPUCore.this.regs.x.h(0);
                CPUCore.this.regs.y.h(0);
            }
            CPUCore.this.update_table();
        }
    };
    public CPUCoreOperation.CPUCoreOp op_plp_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.op_io();
            CPUCore.this.op_io();
            CPUCore.this.last_cycle();
            CPUCore.this.regs.p.set(CPUCore.this.op_readstack());
            if (CPUCore.this.regs.p.x) {
                CPUCore.this.regs.x.h(0);
                CPUCore.this.regs.y.h(0);
            }
            CPUCore.this.update_table();
        }
    };
    public CPUCoreOperation.CPUCoreOp op_pea_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_writestackn(CPUCore.this.aa.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestackn(CPUCore.this.aa.l());
            CPUCore.this.regs.s.h(1);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_pea_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_writestackn(CPUCore.this.aa.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestackn(CPUCore.this.aa.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_pei_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.op_writestackn(CPUCore.this.aa.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestackn(CPUCore.this.aa.l());
            CPUCore.this.regs.s.h(1);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_pei_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.dp = CPUCore.this.op_readpc();
            CPUCore.this.op_io_cond2();
            CPUCore.this.aa.l(CPUCore.this.op_readdp(CPUCore.this.dp + 0));
            CPUCore.this.aa.h(CPUCore.this.op_readdp(CPUCore.this.dp + 1));
            CPUCore.this.op_writestackn(CPUCore.this.aa.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestackn(CPUCore.this.aa.l());
        }
    };
    public CPUCoreOperation.CPUCoreOp op_per_e = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io();
            CPUCore.this.rd.w(CPUCore.this.regs.pc.get() + CPUCore.this.aa.w());
            CPUCore.this.op_writestackn(CPUCore.this.rd.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestackn(CPUCore.this.rd.l());
            CPUCore.this.regs.s.h(1);
        }
    };
    public CPUCoreOperation.CPUCoreOp op_per_n = new CPUCoreOperation.CPUCoreOp(){

        @Override
        public void Invoke(CPUCoreOpArgument args) {
            CPUCore.this.aa.l(CPUCore.this.op_readpc());
            CPUCore.this.aa.h(CPUCore.this.op_readpc());
            CPUCore.this.op_io();
            CPUCore.this.rd.w(CPUCore.this.regs.pc.get() + CPUCore.this.aa.w());
            CPUCore.this.op_writestackn(CPUCore.this.rd.h());
            CPUCore.this.last_cycle();
            CPUCore.this.op_writestackn(CPUCore.this.rd.l());
        }
    };
    List<CPUCoreOperation> opcode_table;
    public CPUCoreOperation[] op_table = new CPUCoreOperation[1280];
    public static final int Table_EM = 0;
    public static final int Table_MX = 256;
    public static final int Table_Mx = 512;
    public static final int Table_mX = 768;
    public static final int Table_mx = 1024;
    private static final int OpCode_A = 0;
    private static final int OpCode_X = 1;
    private static final int OpCode_Y = 2;
    private static final int OpCode_Z = 3;
    private static final int OpCode_S = 4;
    private static final int OpCode_D = 5;

    protected int op_readpc() {
        int addr = (this.regs.pc.b() << 16) + this.regs.pc.w();
        this.regs.pc.w(this.regs.pc.w() + 1);
        return this.op_read(addr) & 0xFF;
    }

    private int op_readstack() {
        if (this.regs.e) {
            this.regs.s.l(this.regs.s.l() + 1);
        } else {
            this.regs.s.w(this.regs.s.w() + 1);
        }
        return this.op_read(this.regs.s.w()) & 0xFF;
    }

    private int op_readstackn() {
        this.regs.s.w(this.regs.s.w() + 1);
        return this.op_read(this.regs.s.w()) & 0xFF;
    }

    private int op_readaddr(int addr) {
        return this.op_read(addr & 0xFFFF) & 0xFF;
    }

    private int op_readlong(int addr) {
        return this.op_read(addr & 0xFFFFFF) & 0xFF;
    }

    private int op_readdbr(int addr) {
        return this.op_read(((this.regs.db & 0xFF) << 16) + addr & 0xFFFFFF) & 0xFF;
    }

    private int op_readpbr(int addr) {
        return this.op_read((this.regs.pc.b() << 16) + (addr & 0xFFFF)) & 0xFF;
    }

    private int op_readdp(int addr) {
        if (this.regs.e && this.regs.d.l() == 0) {
            return this.op_read((this.regs.d.get() & 0xFF00) + (this.regs.d.get() + (addr & 0xFFFF) & 0xFF)) & 0xFF;
        }
        return this.op_read(this.regs.d.get() + (addr & 0xFFFF) & 0xFFFF) & 0xFF;
    }

    private int op_readsp(int addr) {
        return this.op_read(this.regs.s.get() + (addr & 0xFFFF) & 0xFFFF) & 0xFF;
    }

    protected void op_writestack(int data) {
        this.op_write(this.regs.s.w(), (byte)data);
        if (this.regs.e) {
            this.regs.s.l(this.regs.s.l() - 1);
        } else {
            this.regs.s.w(this.regs.s.w() - 1);
        }
    }

    private void op_writestackn(int data) {
        this.op_write(this.regs.s.w(), (byte)data);
        this.regs.s.w(this.regs.s.w() - 1);
    }

    private void op_writelong(int addr, int data) {
        this.op_write(addr & 0xFFFFFF, (byte)data);
    }

    private void op_writedbr(int addr, int data) {
        this.op_write(((this.regs.db & 0xFF) << 16) + addr & 0xFFFFFF, (byte)data);
    }

    private void op_writedp(int addr, int data) {
        if (this.regs.e && this.regs.d.l() == 0) {
            this.op_write((this.regs.d.get() & 0xFF00) + (this.regs.d.get() + (addr & 0xFFFF) & 0xFF), (byte)data);
        } else {
            this.op_write(this.regs.d.get() + (addr & 0xFFFF) & 0xFFFF, (byte)data);
        }
    }

    private void op_writesp(int addr, int data) {
        this.op_write(this.regs.s.get() + (addr & 0xFFFF) & 0xFFFF, (byte)data);
    }

    public abstract void op_io();

    public abstract byte op_read(int var1);

    public abstract void op_write(int var1, byte var2);

    public abstract void last_cycle();

    public abstract boolean interrupt_pending();

    private void op_io_irq() {
        if (this.interrupt_pending()) {
            this.op_read(this.regs.pc.get());
        } else {
            this.op_io();
        }
    }

    private void op_io_cond2() {
        if (this.regs.d.l() != 0) {
            this.op_io();
        }
    }

    private void op_io_cond4(int x, int y) {
        if (!this.regs.p.x || (x & 0xFF00) != (y & 0xFF00)) {
            this.op_io();
        }
    }

    private void op_io_cond6(int addr) {
        if (this.regs.e && (this.regs.pc.w() & 0xFF00) != (addr & 0xFF00)) {
            this.op_io();
        }
    }

    private CPUCoreOperation.CPUCoreOp GetCoreOp(String name) {
        return this.GetCoreOp(name, "");
    }

    private CPUCoreOperation.CPUCoreOp GetCoreOp(String name, String modifier) {
        try {
            return (CPUCoreOperation.CPUCoreOp)CPUCore.class.getDeclaredField("op_" + name + modifier).get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void opA(int id, String name) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name), null);
        this.op_table[1024 + id] = cPUCoreOperation;
        this.op_table[768 + id] = cPUCoreOperation;
        this.op_table[512 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
    }

    private void opAII(int id, String name, int x, int y) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name), new CPUCoreOpArgument(x, y));
        this.op_table[1024 + id] = cPUCoreOperation;
        this.op_table[768 + id] = cPUCoreOperation;
        this.op_table[512 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
    }

    private void opE(int id, String name) {
        this.op_table[0 + id] = new CPUCoreOperation(this.GetCoreOp(name, "_e"), null);
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_n"), null);
        this.op_table[1024 + id] = cPUCoreOperation;
        this.op_table[768 + id] = cPUCoreOperation;
        this.op_table[512 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
    }

    private void opEI(int id, String name, int x) {
        this.op_table[0 + id] = new CPUCoreOperation(this.GetCoreOp(name, "_e"), new CPUCoreOpArgument(x));
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_n"), new CPUCoreOpArgument(x));
        this.op_table[1024 + id] = cPUCoreOperation;
        this.op_table[768 + id] = cPUCoreOperation;
        this.op_table[512 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
    }

    private void opEII(int id, String name, int x, int y) {
        this.op_table[0 + id] = new CPUCoreOperation(this.GetCoreOp(name, "_e"), new CPUCoreOpArgument(x, y));
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_n"), new CPUCoreOpArgument(x, y));
        this.op_table[1024 + id] = cPUCoreOperation;
        this.op_table[768 + id] = cPUCoreOperation;
        this.op_table[512 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
    }

    private void opM(int id, String name) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_b"), null);
        this.op_table[512 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
        CPUCoreOperation cPUCoreOperation2 = new CPUCoreOperation(this.GetCoreOp(name, "_w"), null);
        this.op_table[1024 + id] = cPUCoreOperation2;
        this.op_table[768 + id] = cPUCoreOperation2;
    }

    private void opMI(int id, String name, int x) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_b"), new CPUCoreOpArgument(x));
        this.op_table[512 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
        CPUCoreOperation cPUCoreOperation2 = new CPUCoreOperation(this.GetCoreOp(name, "_w"), new CPUCoreOpArgument(x));
        this.op_table[1024 + id] = cPUCoreOperation2;
        this.op_table[768 + id] = cPUCoreOperation2;
    }

    private void opMII(int id, String name, int x, int y) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_b"), new CPUCoreOpArgument(x, y));
        this.op_table[512 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
        CPUCoreOperation cPUCoreOperation2 = new CPUCoreOperation(this.GetCoreOp(name, "_w"), new CPUCoreOpArgument(x, y));
        this.op_table[1024 + id] = cPUCoreOperation2;
        this.op_table[768 + id] = cPUCoreOperation2;
    }

    private void opMF(int id, String name, String fn) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_b"), new CPUCoreOpArgument(this.GetCoreOp(fn, "_b")));
        this.op_table[512 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
        CPUCoreOperation cPUCoreOperation2 = new CPUCoreOperation(this.GetCoreOp(name, "_w"), new CPUCoreOpArgument(this.GetCoreOp(fn, "_w")));
        this.op_table[1024 + id] = cPUCoreOperation2;
        this.op_table[768 + id] = cPUCoreOperation2;
    }

    private void opMFI(int id, String name, String fn, int x) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_b"), new CPUCoreOpArgument(this.GetCoreOp(fn, "_b"), x));
        this.op_table[512 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
        CPUCoreOperation cPUCoreOperation2 = new CPUCoreOperation(this.GetCoreOp(name, "_w"), new CPUCoreOpArgument(this.GetCoreOp(fn, "_w"), x));
        this.op_table[1024 + id] = cPUCoreOperation2;
        this.op_table[768 + id] = cPUCoreOperation2;
    }

    private void opX(int id, String name) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_b"), null);
        this.op_table[768 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
        CPUCoreOperation cPUCoreOperation2 = new CPUCoreOperation(this.GetCoreOp(name, "_w"), null);
        this.op_table[1024 + id] = cPUCoreOperation2;
        this.op_table[512 + id] = cPUCoreOperation2;
    }

    private void opXI(int id, String name, int x) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_b"), new CPUCoreOpArgument(x));
        this.op_table[768 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
        CPUCoreOperation cPUCoreOperation2 = new CPUCoreOperation(this.GetCoreOp(name, "_w"), new CPUCoreOpArgument(x));
        this.op_table[1024 + id] = cPUCoreOperation2;
        this.op_table[512 + id] = cPUCoreOperation2;
    }

    private void opXII(int id, String name, int x, int y) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_b"), new CPUCoreOpArgument(x, y));
        this.op_table[768 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
        CPUCoreOperation cPUCoreOperation2 = new CPUCoreOperation(this.GetCoreOp(name, "_w"), new CPUCoreOpArgument(x, y));
        this.op_table[1024 + id] = cPUCoreOperation2;
        this.op_table[512 + id] = cPUCoreOperation2;
    }

    private void opXF(int id, String name, String fn) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_b"), new CPUCoreOpArgument(this.GetCoreOp(fn, "_b")));
        this.op_table[768 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
        CPUCoreOperation cPUCoreOperation2 = new CPUCoreOperation(this.GetCoreOp(name, "_w"), new CPUCoreOpArgument(this.GetCoreOp(fn, "_w")));
        this.op_table[1024 + id] = cPUCoreOperation2;
        this.op_table[512 + id] = cPUCoreOperation2;
    }

    private void opXFI(int id, String name, String fn, int x) {
        CPUCoreOperation cPUCoreOperation = new CPUCoreOperation(this.GetCoreOp(name, "_b"), new CPUCoreOpArgument(this.GetCoreOp(fn, "_b"), x));
        this.op_table[768 + id] = cPUCoreOperation;
        this.op_table[256 + id] = cPUCoreOperation;
        this.op_table[0 + id] = cPUCoreOperation;
        CPUCoreOperation cPUCoreOperation2 = new CPUCoreOperation(this.GetCoreOp(name, "_w"), new CPUCoreOpArgument(this.GetCoreOp(fn, "_w"), x));
        this.op_table[1024 + id] = cPUCoreOperation2;
        this.op_table[512 + id] = cPUCoreOperation2;
    }

    protected void initialize_opcode_table() {
        this.opEII(0, "interrupt", 65534, 65510);
        this.opMF(1, "read_idpx", "ora");
        this.opEII(2, "interrupt", 65524, 65508);
        this.opMF(3, "read_sr", "ora");
        this.opMF(4, "adjust_dp", "tsb");
        this.opMF(5, "read_dp", "ora");
        this.opMF(6, "adjust_dp", "asl");
        this.opMF(7, "read_ildp", "ora");
        this.opA(8, "php");
        this.opMF(9, "read_const", "ora");
        this.opM(10, "asl_imm");
        this.opE(11, "phd");
        this.opMF(12, "adjust_addr", "tsb");
        this.opMF(13, "read_addr", "ora");
        this.opMF(14, "adjust_addr", "asl");
        this.opMF(15, "read_long", "ora");
        this.opAII(16, "branch", 128, 0);
        this.opMF(17, "read_idpy", "ora");
        this.opMF(18, "read_idp", "ora");
        this.opMF(19, "read_isry", "ora");
        this.opMF(20, "adjust_dp", "trb");
        this.opMFI(21, "read_dpr", "ora", 1);
        this.opMF(22, "adjust_dpx", "asl");
        this.opMF(23, "read_ildpy", "ora");
        this.opAII(24, "flag", 1, 0);
        this.opMF(25, "read_addry", "ora");
        this.opMII(26, "adjust_imm", 0, 1);
        this.opE(27, "tcs");
        this.opMF(28, "adjust_addr", "trb");
        this.opMF(29, "read_addrx", "ora");
        this.opMF(30, "adjust_addrx", "asl");
        this.opMF(31, "read_longx", "ora");
        this.opA(32, "jsr_addr");
        this.opMF(33, "read_idpx", "and");
        this.opE(34, "jsr_long");
        this.opMF(35, "read_sr", "and");
        this.opMF(36, "read_dp", "bit");
        this.opMF(37, "read_dp", "and");
        this.opMF(38, "adjust_dp", "rol");
        this.opMF(39, "read_ildp", "and");
        this.opE(40, "plp");
        this.opMF(41, "read_const", "and");
        this.opM(42, "rol_imm");
        this.opE(43, "pld");
        this.opMF(44, "read_addr", "bit");
        this.opMF(45, "read_addr", "and");
        this.opMF(46, "adjust_addr", "rol");
        this.opMF(47, "read_long", "and");
        this.opAII(48, "branch", 128, 1);
        this.opMF(49, "read_idpy", "and");
        this.opMF(50, "read_idp", "and");
        this.opMF(51, "read_isry", "and");
        this.opMFI(52, "read_dpr", "bit", 1);
        this.opMFI(53, "read_dpr", "and", 1);
        this.opMF(54, "adjust_dpx", "rol");
        this.opMF(55, "read_ildpy", "and");
        this.opAII(56, "flag", 1, 1);
        this.opMF(57, "read_addry", "and");
        this.opMII(58, "adjust_imm", 0, -1);
        this.opAII(59, "transfer_w", 4, 0);
        this.opMF(60, "read_addrx", "bit");
        this.opMF(61, "read_addrx", "and");
        this.opMF(62, "adjust_addrx", "rol");
        this.opMF(63, "read_longx", "and");
        this.opE(64, "rti");
        this.opMF(65, "read_idpx", "eor");
        this.opA(66, "wdm");
        this.opMF(67, "read_sr", "eor");
        this.opXI(68, "move", -1);
        this.opMF(69, "read_dp", "eor");
        this.opMF(70, "adjust_dp", "lsr");
        this.opMF(71, "read_ildp", "eor");
        this.opMI(72, "push", 0);
        this.opMF(73, "read_const", "eor");
        this.opM(74, "lsr_imm");
        this.opA(75, "phk");
        this.opA(76, "jmp_addr");
        this.opMF(77, "read_addr", "eor");
        this.opMF(78, "adjust_addr", "lsr");
        this.opMF(79, "read_long", "eor");
        this.opAII(80, "branch", 64, 0);
        this.opMF(81, "read_idpy", "eor");
        this.opMF(82, "read_idp", "eor");
        this.opMF(83, "read_isry", "eor");
        this.opXI(84, "move", 1);
        this.opMFI(85, "read_dpr", "eor", 1);
        this.opMF(86, "adjust_dpx", "lsr");
        this.opMF(87, "read_ildpy", "eor");
        this.opAII(88, "flag", 4, 0);
        this.opMF(89, "read_addry", "eor");
        this.opXI(90, "push", 2);
        this.opAII(91, "transfer_w", 0, 5);
        this.opA(92, "jmp_long");
        this.opMF(93, "read_addrx", "eor");
        this.opMF(94, "adjust_addrx", "lsr");
        this.opMF(95, "read_longx", "eor");
        this.opA(96, "rts");
        this.opMF(97, "read_idpx", "adc");
        this.opE(98, "per");
        this.opMF(99, "read_sr", "adc");
        this.opMI(100, "write_dp", 3);
        this.opMF(101, "read_dp", "adc");
        this.opMF(102, "adjust_dp", "ror");
        this.opMF(103, "read_ildp", "adc");
        this.opMI(104, "pull", 0);
        this.opMF(105, "read_const", "adc");
        this.opM(106, "ror_imm");
        this.opE(107, "rtl");
        this.opA(108, "jmp_iaddr");
        this.opMF(109, "read_addr", "adc");
        this.opMF(110, "adjust_addr", "ror");
        this.opMF(111, "read_long", "adc");
        this.opAII(112, "branch", 64, 1);
        this.opMF(113, "read_idpy", "adc");
        this.opMF(114, "read_idp", "adc");
        this.opMF(115, "read_isry", "adc");
        this.opMII(116, "write_dpr", 3, 1);
        this.opMFI(117, "read_dpr", "adc", 1);
        this.opMF(118, "adjust_dpx", "ror");
        this.opMF(119, "read_ildpy", "adc");
        this.opAII(120, "flag", 4, 4);
        this.opMF(121, "read_addry", "adc");
        this.opXI(122, "pull", 2);
        this.opAII(123, "transfer_w", 5, 0);
        this.opA(124, "jmp_iaddrx");
        this.opMF(125, "read_addrx", "adc");
        this.opMF(126, "adjust_addrx", "ror");
        this.opMF(127, "read_longx", "adc");
        this.opA(128, "bra");
        this.opM(129, "sta_idpx");
        this.opA(130, "brl");
        this.opM(131, "sta_sr");
        this.opXI(132, "write_dp", 2);
        this.opMI(133, "write_dp", 0);
        this.opXI(134, "write_dp", 1);
        this.opM(135, "sta_ildp");
        this.opXII(136, "adjust_imm", 2, -1);
        this.opM(137, "read_bit_const");
        this.opMII(138, "transfer", 1, 0);
        this.opA(139, "phb");
        this.opXI(140, "write_addr", 2);
        this.opMI(141, "write_addr", 0);
        this.opXI(142, "write_addr", 1);
        this.opMI(143, "write_longr", 3);
        this.opAII(144, "branch", 1, 0);
        this.opM(145, "sta_idpy");
        this.opM(146, "sta_idp");
        this.opM(147, "sta_isry");
        this.opXII(148, "write_dpr", 2, 1);
        this.opMII(149, "write_dpr", 0, 1);
        this.opXII(150, "write_dpr", 1, 2);
        this.opM(151, "sta_ildpy");
        this.opMII(152, "transfer", 2, 0);
        this.opMII(153, "write_addrr", 0, 2);
        this.opE(154, "txs");
        this.opXII(155, "transfer", 1, 2);
        this.opMI(156, "write_addr", 3);
        this.opMII(157, "write_addrr", 0, 1);
        this.opMII(158, "write_addrr", 3, 1);
        this.opMI(159, "write_longr", 1);
        this.opXF(160, "read_const", "ldy");
        this.opMF(161, "read_idpx", "lda");
        this.opXF(162, "read_const", "ldx");
        this.opMF(163, "read_sr", "lda");
        this.opXF(164, "read_dp", "ldy");
        this.opMF(165, "read_dp", "lda");
        this.opXF(166, "read_dp", "ldx");
        this.opMF(167, "read_ildp", "lda");
        this.opXII(168, "transfer", 0, 2);
        this.opMF(169, "read_const", "lda");
        this.opXII(170, "transfer", 0, 1);
        this.opA(171, "plb");
        this.opXF(172, "read_addr", "ldy");
        this.opMF(173, "read_addr", "lda");
        this.opXF(174, "read_addr", "ldx");
        this.opMF(175, "read_long", "lda");
        this.opAII(176, "branch", 1, 1);
        this.opMF(177, "read_idpy", "lda");
        this.opMF(178, "read_idp", "lda");
        this.opMF(179, "read_isry", "lda");
        this.opXFI(180, "read_dpr", "ldy", 1);
        this.opMFI(181, "read_dpr", "lda", 1);
        this.opXFI(182, "read_dpr", "ldx", 2);
        this.opMF(183, "read_ildpy", "lda");
        this.opAII(184, "flag", 64, 0);
        this.opMF(185, "read_addry", "lda");
        this.opX(186, "tsx");
        this.opXII(187, "transfer", 2, 1);
        this.opXF(188, "read_addrx", "ldy");
        this.opMF(189, "read_addrx", "lda");
        this.opXF(190, "read_addry", "ldx");
        this.opMF(191, "read_longx", "lda");
        this.opXF(192, "read_const", "cpy");
        this.opMF(193, "read_idpx", "cmp");
        this.opEI(194, "pflag", 0);
        this.opMF(195, "read_sr", "cmp");
        this.opXF(196, "read_dp", "cpy");
        this.opMF(197, "read_dp", "cmp");
        this.opMF(198, "adjust_dp", "dec");
        this.opMF(199, "read_ildp", "cmp");
        this.opXII(200, "adjust_imm", 2, 1);
        this.opMF(201, "read_const", "cmp");
        this.opXII(202, "adjust_imm", 1, -1);
        this.opA(203, "wai");
        this.opXF(204, "read_addr", "cpy");
        this.opMF(205, "read_addr", "cmp");
        this.opMF(206, "adjust_addr", "dec");
        this.opMF(207, "read_long", "cmp");
        this.opAII(208, "branch", 2, 0);
        this.opMF(209, "read_idpy", "cmp");
        this.opMF(210, "read_idp", "cmp");
        this.opMF(211, "read_isry", "cmp");
        this.opE(212, "pei");
        this.opMFI(213, "read_dpr", "cmp", 1);
        this.opMF(214, "adjust_dpx", "dec");
        this.opMF(215, "read_ildpy", "cmp");
        this.opAII(216, "flag", 8, 0);
        this.opMF(217, "read_addry", "cmp");
        this.opXI(218, "push", 1);
        this.opA(219, "stp");
        this.opA(220, "jmp_iladdr");
        this.opMF(221, "read_addrx", "cmp");
        this.opMF(222, "adjust_addrx", "dec");
        this.opMF(223, "read_longx", "cmp");
        this.opXF(224, "read_const", "cpx");
        this.opMF(225, "read_idpx", "sbc");
        this.opEI(226, "pflag", 1);
        this.opMF(227, "read_sr", "sbc");
        this.opXF(228, "read_dp", "cpx");
        this.opMF(229, "read_dp", "sbc");
        this.opMF(230, "adjust_dp", "inc");
        this.opMF(231, "read_ildp", "sbc");
        this.opXII(232, "adjust_imm", 1, 1);
        this.opMF(233, "read_const", "sbc");
        this.opA(234, "nop");
        this.opA(235, "xba");
        this.opXF(236, "read_addr", "cpx");
        this.opMF(237, "read_addr", "sbc");
        this.opMF(238, "adjust_addr", "inc");
        this.opMF(239, "read_long", "sbc");
        this.opAII(240, "branch", 2, 1);
        this.opMF(241, "read_idpy", "sbc");
        this.opMF(242, "read_idp", "sbc");
        this.opMF(243, "read_isry", "sbc");
        this.opE(244, "pea");
        this.opMFI(245, "read_dpr", "sbc", 1);
        this.opMF(246, "adjust_dpx", "inc");
        this.opMF(247, "read_ildpy", "sbc");
        this.opAII(248, "flag", 8, 8);
        this.opMF(249, "read_addry", "sbc");
        this.opXI(250, "pull", 1);
        this.opA(251, "xce");
        this.opE(252, "jsr_iaddrx");
        this.opMF(253, "read_addrx", "sbc");
        this.opMF(254, "adjust_addrx", "inc");
        this.opMF(255, "read_longx", "sbc");
    }

    protected void update_table() {
        this.opcode_table = this.regs.e ? Arrays.asList(this.op_table).subList(0, 0 + (this.op_table.length - 0)) : (this.regs.p.m ? (this.regs.p.x ? Arrays.asList(this.op_table).subList(256, 256 + (this.op_table.length - 256)) : Arrays.asList(this.op_table).subList(512, 512 + (this.op_table.length - 512))) : (this.regs.p.x ? Arrays.asList(this.op_table).subList(768, 768 + (this.op_table.length - 768)) : Arrays.asList(this.op_table).subList(1024, 1024 + (this.op_table.length - 1024))));
    }

    public CPUCore() {
        this.initialize_opcode_table();
    }
}

