/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.accessories;

import jario.hardware.Bus16bit;
import jario.hardware.Hardware;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;

public class Rumblepad2
implements Hardware,
Bus16bit {
    private static final int Joypad_B = 1;
    private static final int Joypad_Y = 2;
    private static final int Joypad_Select = 4;
    private static final int Joypad_Start = 8;
    private static final int Joypad_Up = 16;
    private static final int Joypad_Down = 32;
    private static final int Joypad_Left = 64;
    private static final int Joypad_Right = 128;
    private static final int Joypad_A = 256;
    private static final int Joypad_X = 512;
    private static final int Joypad_L = 1024;
    private static final int Joypad_R = 2048;
    private static final int Joypad_LeftRight = 192;
    private static final int Joypad_UpDown = 48;
    Runnable poll = new Runnable(){

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Controllers.poll();
                Rumblepad2.this.update();
            }
        }
    };
    private int keyboardState;
    private int[] inputButtons = new int[8];
    private Key[] keys = new Key[]{new Key(1, 1), new Key(2, 0), new Key(4, 8), new Key(8, 9), new Key(16, -1), new Key(32, -1), new Key(64, -1), new Key(128, -1), new Key(256, 2), new Key(512, 3), new Key(1024, 4), new Key(2048, 5)};
    Controller controller;
    int buttonCount;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public Rumblepad2() {
        try {
            Controllers.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int count = Controllers.getControllerCount();
        int i = 0;
        while (i < count) {
            this.controller = Controllers.getController((int)i);
            if (this.controller.getAxisCount() == 4 && this.controller.getButtonCount() >= 8) {
                this.buttonCount = this.controller.getButtonCount();
                break;
            }
            ++i;
        }
        this.executor.execute(this.poll);
    }

    private void update() {
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].vkey >= 0) {
                this.keyboardState = this.controller.isButtonPressed(this.keys[i].vkey) ? (this.keyboardState |= this.keys[i].value) : (this.keyboardState &= ~this.keys[i].value);
            }
            ++i;
        }
        i = this.buttonCount;
        while (i < this.buttonCount + this.controller.getAxisCount()) {
            float value;
            if (this.controller.getAxisName(i - this.buttonCount).equals("X Axis")) {
                value = this.controller.getAxisValue(i - this.buttonCount);
                if (value > 0.2f && value <= 1.0f) {
                    this.keyboardState |= 0x80;
                } else if (value < -0.2f && value >= -1.0f) {
                    this.keyboardState |= 0x40;
                } else {
                    this.keyboardState &= 0xFFFFFF7F;
                    this.keyboardState &= 0xFFFFFFBF;
                }
            }
            if (this.controller.getAxisName(i - this.buttonCount).equals("Y Axis")) {
                value = this.controller.getAxisValue(i - this.buttonCount);
                if (value > 0.2f && value <= 1.0f) {
                    this.keyboardState |= 0x20;
                } else if (value < -0.2f && value >= -1.0f) {
                    this.keyboardState |= 0x10;
                } else {
                    this.keyboardState &= 0xFFFFFFDF;
                    this.keyboardState &= 0xFFFFFFEF;
                }
            }
            ++i;
        }
    }

    public void connect(int port, Hardware hw) {
    }

    public void reset() {
    }

    public short read16bit(int address) {
        this.SetInputState(0, 0, this.ParseInput(0), 0, 0);
        return (short)this.inputButtons[address];
    }

    public void write16bit(int address, short data) {
    }

    private void SetInputState(int port, int index, int buttonStates, int x, int y) {
        if ((buttonStates & 0xC0) == 192) {
            buttonStates &= 0xFFFFFF3F;
        }
        if ((buttonStates & 0x30) == 48) {
            buttonStates &= 0xFFFFFFCF;
        }
        int i = port * 4 + index;
        this.inputButtons[i] = buttonStates;
    }

    private int ParseInput(int playerIndex) {
        int snesButtonStates = 0;
        int i = 0;
        while (i < this.keys.length) {
            if ((this.keyboardState & this.keys[i].value) != 0) {
                snesButtonStates |= this.keys[i].value;
            }
            ++i;
        }
        return snesButtonStates;
    }

    private class Key {
        public int vkey;
        public int value;

        public Key(int value, int vkey) {
            this.value = value;
            this.vkey = vkey;
        }
    }
}

