/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.system;

import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class SnesSystem
implements Hardware {
    private Canvas canvas;
    private JFrame window;
    private Hardware video;
    private Hardware audio;
    private Hardware controller;
    private Map<String, Hardware> controllers = new HashMap<String, Hardware>();
    private Hardware console;
    private Hardware cartridge;
    private WindowAdapter winListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            SnesSystem.this.exit();
        }
    };

    public SnesSystem() {
        try {
            File dir = new File("components" + File.separator);
            File file = new File("components.properties");
            ClassLoader loader = this.getClass().getClassLoader();
            Properties prop = new Properties();
            try {
                URL url;
                if (dir.exists() && dir.listFiles().length > 0) {
                    File[] files = dir.listFiles();
                    URL[] urls = new URL[files.length];
                    int i = 0;
                    while (i < files.length) {
                        urls[i] = files[i].toURI().toURL();
                        ++i;
                    }
                    loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                }
                URL uRL = url = file.exists() ? file.toURI().toURL() : loader.getResource("resources" + File.separator + "components.properties");
                if (url != null) {
                    prop.load(url.openStream());
                }
            }
            catch (IOException url) {
                // empty catch block
            }
            ServiceLoader<Hardware> sl = ServiceLoader.load(Hardware.class, loader);
            for (Hardware hardware : sl) {
                this.controllers.put(hardware.getClass().getSimpleName(), hardware);
                if (!prop.getProperty("CONTROLLER", "CONTROLLER").equals(hardware.getClass().getName())) continue;
                this.controller = hardware;
            }
            this.video = (Hardware)Class.forName(prop.getProperty("VIDEO_PLAYER", "VIDEO_PLAYER"), true, loader).newInstance();
            this.audio = (Hardware)Class.forName(prop.getProperty("AUDIO_PLAYER", "AUDIO_PLAYER"), true, loader).newInstance();
            if (this.controller == null) {
                this.controller = (Hardware)Class.forName(prop.getProperty("CONTROLLER", "CONTROLLER"), true, loader).newInstance();
            }
            this.console = (Hardware)Class.forName(prop.getProperty("CONSOLE", "CONSOLE"), true, loader).newInstance();
            this.cartridge = (Hardware)Class.forName(prop.getProperty("CARTRIDGE", "CARTRIDGE"), true, loader).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.window = new JFrame("Super Jario ES");
        this.window.addWindowListener(this.winListener);
        this.window.setJMenuBar(new Jario64MenuBar());
        this.canvas = new Canvas();
        this.canvas.setPreferredSize(new Dimension(512, 448));
        this.window.getContentPane().add(this.canvas);
        this.window.pack();
        this.window.setVisible(true);
        ((Configurable)this.video).writeConfig("window", (Object)this.window);
        this.console.connect(3, this.video);
        this.console.connect(4, this.audio);
        this.console.connect(0, this.controller);
        this.console.connect(1, null);
    }

    public void connect(int port, Hardware hw) {
    }

    public void reset() {
    }

    private void LoadCartridge(String cartridgeName) {
        this.console.reset();
        this.cartridge.reset();
        ((Configurable)this.cartridge).writeConfig("romfile", (Object)cartridgeName);
        System.out.println("opened: " + cartridgeName);
        this.console.connect(2, this.cartridge);
        ((Clockable)this.console).clock(1L);
    }

    private void exit() {
        this.console.connect(2, null);
        this.console.reset();
        if (this.cartridge != null) {
            this.cartridge.reset();
        }
        System.exit(0);
    }

    private class Jario64MenuBar
    extends JMenuBar {
        public Jario64MenuBar() {
            this.add(this.makeFileMenu());
            this.add(this.makeControllerMenu());
            this.add(this.makeSettingsMenu());
        }

        private JMenu makeFileMenu() {
            JMenu fileMenu = new JMenu();
            fileMenu.setText("File");
            JMenuItem loadRom = new JMenuItem("Insert Game Cartridge");
            loadRom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    File romFile = null;
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setDialogTitle("Open ROM");
                    fileChooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.getName().endsWith(".smc") || f.getName().endsWith(".sfc");
                        }

                        @Override
                        public String getDescription() {
                            return "ROM files (.smc, .sfc)";
                        }
                    });
                    int returnVal = fileChooser.showOpenDialog(null);
                    if (returnVal != 0) {
                        return;
                    }
                    romFile = fileChooser.getSelectedFile();
                    SnesSystem.this.LoadCartridge(romFile.getAbsolutePath());
                }
            });
            fileMenu.add(loadRom);
            JMenuItem exit = new JMenuItem("Exit");
            exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SnesSystem.this.exit();
                }
            });
            fileMenu.add(exit);
            return fileMenu;
        }

        private JMenu makeSettingsMenu() {
            JMenu settingsMenu = new JMenu();
            settingsMenu.setText("Settings");
            JCheckBoxMenuItem audioToggle = new JCheckBoxMenuItem("Enable Audio");
            audioToggle.setState((Boolean)((Configurable)SnesSystem.this.audio).readConfig("enable"));
            audioToggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JCheckBoxMenuItem i = (JCheckBoxMenuItem)evt.getSource();
                    ((Configurable)SnesSystem.this.audio).writeConfig("enable", (Object)i.isSelected());
                }
            });
            settingsMenu.add(audioToggle);
            JCheckBoxMenuItem fps30 = new JCheckBoxMenuItem("30fps");
            fps30.setState((Integer)((Configurable)SnesSystem.this.console).readConfig("fps") == 30);
            fps30.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JCheckBoxMenuItem i = (JCheckBoxMenuItem)evt.getSource();
                    if (i.isSelected()) {
                        ((Configurable)SnesSystem.this.console).writeConfig("fps", (Object)30);
                        ((Configurable)SnesSystem.this.audio).writeConfig("samplerate", (Object)16160);
                    } else {
                        ((Configurable)SnesSystem.this.console).writeConfig("fps", (Object)60);
                        ((Configurable)SnesSystem.this.audio).writeConfig("samplerate", (Object)33334);
                    }
                }
            });
            settingsMenu.add(fps30);
            return settingsMenu;
        }

        private JMenu makeControllerMenu() {
            JMenu controllerMenu = new JMenu();
            controllerMenu.setText("Controller");
            ButtonGroup group = new ButtonGroup();
            for (Hardware hardware : SnesSystem.this.controllers.values()) {
                JRadioButtonMenuItem controllerOption = new JRadioButtonMenuItem(hardware.getClass().getSimpleName());
                if (SnesSystem.this.controller != null && hardware.getClass().getName().equals(SnesSystem.this.controller.getClass().getName())) {
                    controllerOption.setSelected(true);
                }
                controllerOption.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        JRadioButtonMenuItem i = (JRadioButtonMenuItem)evt.getSource();
                        if (i.isSelected()) {
                            SnesSystem.this.controller = (Hardware)SnesSystem.this.controllers.get(i.getText());
                            SnesSystem.this.console.connect(0, SnesSystem.this.controller);
                        }
                    }
                });
                group.add(controllerOption);
                controllerMenu.add(controllerOption);
            }
            return controllerMenu;
        }
    }
}

