/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.ppu;

import jario.snes.performance.ppu.LayerWindow;
import jario.snes.performance.ppu.PPU;
import java.nio.ByteBuffer;

public class Background {
    public static final int ID_BG1 = 0;
    public static final int ID_BG2 = 1;
    public static final int ID_BG3 = 2;
    public static final int ID_BG4 = 3;
    public static final int Mode_BPP2 = 0;
    public static final int Mode_BPP4 = 1;
    public static final int Mode_BPP8 = 2;
    public static final int Mode_Mode7 = 3;
    public static final int Mode_Inactive = 4;
    public boolean priority0_enable;
    public boolean priority1_enable;
    public Regs regs = new Regs();
    public int[][] mosaic_table;
    public int id;
    public int opt_valid_bit;
    public boolean hires;
    public int width;
    public int tile_width;
    public int tile_height;
    public int mask_x;
    public int mask_y;
    public int scx;
    public int scy;
    public int hscroll;
    public int vscroll;
    public int mosaic_vcounter;
    public int mosaic_voffset;
    public LayerWindow window = new LayerWindow();
    int[] hoffset = new int[1];
    int[] voffset = new int[1];
    public PPU self;

    public int get_tile(int hoffset, int voffset) {
        int tile_x = (hoffset & this.mask_x) >> this.tile_width;
        int tile_y = (voffset & this.mask_y) >> this.tile_height;
        int tile_pos = ((tile_y & 0x1F) << 5) + (tile_x & 0x1F);
        if ((tile_y & 0x20) != 0) {
            tile_pos += this.scy;
        }
        if ((tile_x & 0x20) != 0) {
            tile_pos += this.scx;
        }
        int tiledata_addr = this.regs.screen_addr + (tile_pos << 1) & 0xFFFF;
        return (this.self.vram[tiledata_addr + 0] << 0) + (this.self.vram[tiledata_addr + 1] << 8);
    }

    public void offset_per_tile(int x, int y, int[] hoffset, int[] voffset) {
        int opt_x = x + (this.hscroll & 7);
        int vval = 0;
        if (opt_x >= 8) {
            int hval = this.self.bg3.get_tile(opt_x - 8 + (this.self.bg3.regs.hoffset & 0xFFFFFFF8), this.self.bg3.regs.voffset + 0);
            if (this.self.regs.bgmode != 4) {
                vval = this.self.bg3.get_tile(opt_x - 8 + (this.self.bg3.regs.hoffset & 0xFFFFFFF8), this.self.bg3.regs.voffset + 8);
            }
            if (this.self.regs.bgmode == 4) {
                if ((hval & this.opt_valid_bit) != 0) {
                    if ((hval & 0x8000) == 0) {
                        hoffset[0] = opt_x + (hval & 0xFFFFFFF8);
                    } else {
                        voffset[0] = y + hval;
                    }
                }
            } else {
                if ((hval & this.opt_valid_bit) != 0) {
                    hoffset[0] = opt_x + (hval & 0xFFFFFFF8);
                }
                if ((vval & this.opt_valid_bit) != 0) {
                    voffset[0] = y + vval;
                }
            }
        }
    }

    public void scanline() {
        if (this.self.ppuCounter.vcounter() == 1) {
            this.mosaic_vcounter = this.regs.mosaic + 1;
            this.mosaic_voffset = 1;
        } else if (--this.mosaic_vcounter == 0) {
            this.mosaic_vcounter = this.regs.mosaic + 1;
            this.mosaic_voffset += this.regs.mosaic + 1;
        }
        if (this.self.regs.display_disable) {
            return;
        }
        this.hires = this.self.regs.bgmode == 5 || this.self.regs.bgmode == 6;
        this.width = !this.hires ? 256 : 512;
        this.tile_height = this.regs.tile_size ? 4 : 3;
        this.tile_width = this.hires ? 4 : this.tile_height;
        this.mask_y = this.mask_x = this.tile_height == 4 ? this.width << 1 : this.width;
        if ((this.regs.screen_size & 1) != 0) {
            this.mask_x <<= 1;
        }
        if ((this.regs.screen_size & 2) != 0) {
            this.mask_y <<= 1;
        }
        --this.mask_x;
        --this.mask_y;
        this.scy = (this.regs.screen_size & 2) != 0 ? 1024 : 0;
        int n = this.scx = (this.regs.screen_size & 1) != 0 ? 1024 : 0;
        if (this.regs.screen_size == 3) {
            this.scy <<= 1;
        }
    }

    public void render() {
        int y;
        int priority1;
        if (this.regs.mode == 4) {
            return;
        }
        if (!this.regs.main_enable && !this.regs.sub_enable) {
            return;
        }
        if (this.regs.main_enable) {
            this.window.render(false);
        }
        if (this.regs.sub_enable) {
            this.window.render(true);
        }
        if (this.regs.mode == 3) {
            this.render_mode7();
            return;
        }
        int priority0 = this.priority0_enable ? this.regs.priority0 : 0;
        int n = priority1 = this.priority1_enable ? this.regs.priority1 : 0;
        if (priority0 + priority1 == 0) {
            return;
        }
        int mosaic_hcounter = 1;
        int mosaic_palette = 0;
        int mosaic_priority = 0;
        int mosaic_color = 0;
        int bgpal_index = this.self.regs.bgmode == 0 ? this.id << 5 : 0;
        int pal_size = 2 << this.regs.mode;
        int tile_mask = 4095 >> this.regs.mode;
        int tiledata_index = this.regs.tiledata_addr >> 4 + this.regs.mode;
        this.hscroll = this.regs.hoffset;
        this.vscroll = this.regs.voffset;
        int n2 = y = this.regs.mosaic == 0 ? this.self.ppuCounter.vcounter() : this.mosaic_voffset;
        if (this.hires) {
            this.hscroll <<= 1;
            if (this.self.regs.interlace) {
                y = (y << 1) + (this.self.ppuCounter.field() ? 1 : 0);
            }
        }
        boolean is_opt_mode = this.self.regs.bgmode == 2 || this.self.regs.bgmode == 4 || this.self.regs.bgmode == 6;
        boolean is_direct_color_mode = this.self.screen.regs.direct_color && this.id == 0 && (this.self.regs.bgmode == 3 || this.self.regs.bgmode == 4);
        int x = 0 - (this.hscroll & 7);
        while (x < this.width) {
            this.hoffset[0] = x + this.hscroll;
            this.voffset[0] = y + this.vscroll;
            if (is_opt_mode) {
                this.offset_per_tile(x, y, this.hoffset, this.voffset);
            }
            this.hoffset[0] = this.hoffset[0] & this.mask_x;
            this.voffset[0] = this.voffset[0] & this.mask_y;
            int tile_num = this.get_tile(this.hoffset[0], this.voffset[0]);
            boolean mirror_y = (tile_num & 0x8000) != 0;
            boolean mirror_x = (tile_num & 0x4000) != 0;
            int tile_pri = (tile_num & 0x2000) != 0 ? priority1 : priority0;
            int pal_num = tile_num >> 10 & 7;
            int pal_index = bgpal_index + (pal_num << pal_size) & 0xFF;
            if (this.tile_width == 4 && (this.hoffset[0] & 8) != 0 != mirror_x) {
                ++tile_num;
            }
            if (this.tile_height == 4 && (this.voffset[0] & 8) != 0 != mirror_y) {
                tile_num += 16;
            }
            tile_num = (tile_num & 0x3FF) + tiledata_index & tile_mask;
            if (mirror_y) {
                this.voffset[0] = this.voffset[0] ^ 7;
            }
            int mirror_xmask = !mirror_x ? 0 : 7;
            ByteBuffer tiledata = this.self.cache.tile(this.regs.mode, tile_num);
            int tiledata_offset = tiledata.position() + (this.voffset[0] & 7) * 8;
            int n3 = 0;
            while (n3 < 8) {
                if ((x & this.width) == 0) {
                    if (--mosaic_hcounter == 0) {
                        mosaic_hcounter = this.regs.mosaic + 1;
                        mosaic_palette = tiledata.array()[tiledata_offset + (n3 ^ mirror_xmask)] & 0xFF;
                        mosaic_priority = tile_pri;
                        mosaic_color = is_direct_color_mode ? this.self.screen.get_direct_color(pal_num, mosaic_palette) : this.self.screen.get_palette(pal_index + mosaic_palette);
                    }
                    if (mosaic_palette != 0) {
                        if (!this.hires) {
                            if (this.regs.main_enable && this.window.main[x] == 0) {
                                this.self.screen.output.plot_main(x, mosaic_color, mosaic_priority, this.id);
                            }
                            if (this.regs.sub_enable && this.window.sub[x] == 0) {
                                this.self.screen.output.plot_sub(x, mosaic_color, mosaic_priority, this.id);
                            }
                        } else {
                            int half_x = x >> 1;
                            if ((x & 1) != 0) {
                                if (this.regs.main_enable && this.window.main[half_x] == 0) {
                                    this.self.screen.output.plot_main(half_x, mosaic_color, mosaic_priority, this.id);
                                }
                            } else if (this.regs.sub_enable && this.window.sub[half_x] == 0) {
                                this.self.screen.output.plot_sub(half_x, mosaic_color, mosaic_priority, this.id);
                            }
                        }
                    }
                }
                ++n3;
                ++x;
            }
        }
    }

    private static final int Clip(int x) {
        return (x & 0x2000) != 0 ? x | 0xFFFFFC00 : x & 0x3FF;
    }

    public void render_mode7() {
        int priority1;
        int[] mosaic_y;
        int[] mosaic_x;
        int y;
        int palette = 0;
        int a = Background.sclip(16, this.self.regs.m7a);
        int b = Background.sclip(16, this.self.regs.m7b);
        int c = Background.sclip(16, this.self.regs.m7c);
        int d = Background.sclip(16, this.self.regs.m7d);
        int cx = Background.sclip(13, this.self.regs.m7x);
        int cy = Background.sclip(13, this.self.regs.m7y);
        int hofs = Background.sclip(13, this.self.regs.mode7_hoffset);
        int vofs = Background.sclip(13, this.self.regs.mode7_voffset);
        int n = y = !this.self.regs.mode7_vflip ? this.self.ppuCounter.vcounter() : 255 - this.self.ppuCounter.vcounter();
        if (this.id == 0) {
            mosaic_x = this.mosaic_table[this.self.bg1.regs.mosaic];
            mosaic_y = this.mosaic_table[this.self.bg1.regs.mosaic];
        } else {
            mosaic_x = this.mosaic_table[this.self.bg2.regs.mosaic];
            mosaic_y = this.mosaic_table[this.self.bg1.regs.mosaic];
        }
        int priority0 = this.priority0_enable ? this.regs.priority0 : 0;
        int n2 = priority1 = this.priority1_enable ? this.regs.priority1 : 0;
        if (priority0 + priority1 == 0) {
            return;
        }
        int psx = (a * Background.Clip(hofs - cx) & 0xFFFFFFC0) + (b * Background.Clip(vofs - cy) & 0xFFFFFFC0) + (b * mosaic_y[y] & 0xFFFFFFC0) + (cx << 8);
        int psy = (c * Background.Clip(hofs - cx) & 0xFFFFFFC0) + (d * Background.Clip(vofs - cy) & 0xFFFFFFC0) + (d * mosaic_y[y] & 0xFFFFFFC0) + (cy << 8);
        int x = 0;
        while (x < 256) {
            int priority;
            int px = psx + a * mosaic_x[x] >> 8;
            int py = psy + c * mosaic_x[x] >> 8;
            switch (this.self.regs.mode7_repeat) {
                case 0: 
                case 1: {
                    int tx = (px &= 0x3FF) >> 3 & 0x7F;
                    int ty = (py &= 0x3FF) >> 3 & 0x7F;
                    int tile = this.self.vram[ty * 128 + tx << 1];
                    palette = this.self.vram[((tile << 6) + ((py & 7) << 3) + (px & 7) << 1) + 1];
                    break;
                }
                case 2: {
                    if (((px | py) & 0xFFFFFC00) != 0) {
                        palette = 0;
                        break;
                    }
                    int tx = (px &= 0x3FF) >> 3 & 0x7F;
                    int ty = (py &= 0x3FF) >> 3 & 0x7F;
                    int tile = this.self.vram[ty * 128 + tx << 1];
                    palette = this.self.vram[((tile << 6) + ((py & 7) << 3) + (px & 7) << 1) + 1];
                    break;
                }
                case 3: {
                    int tile;
                    int ty;
                    int tx;
                    if (((px | py) & 0xFFFFFC00) != 0) {
                        tile = 0;
                    } else {
                        tx = (px &= 0x3FF) >> 3 & 0x7F;
                        ty = (py &= 0x3FF) >> 3 & 0x7F;
                        tile = this.self.vram[ty * 128 + tx << 1];
                    }
                    palette = this.self.vram[((tile << 6) + ((py & 7) << 3) + (px & 7) << 1) + 1];
                }
            }
            if (this.id == 0) {
                priority = priority0;
            } else {
                priority = (palette & 0x80) != 0 ? priority1 : priority0;
                palette &= 0x7F;
            }
            if (palette != 0) {
                int plot_x = !this.self.regs.mode7_hflip ? x : 255 - x;
                int color = this.self.screen.regs.direct_color && this.id == 0 ? this.self.screen.get_direct_color(0, palette) : this.self.screen.get_palette(palette);
                if (this.regs.main_enable && this.window.main[plot_x] == 0) {
                    this.self.screen.output.plot_main(plot_x, color, priority, this.id);
                }
                if (this.regs.sub_enable && this.window.sub[plot_x] == 0) {
                    this.self.screen.output.plot_sub(plot_x, color, priority, this.id);
                }
            }
            ++x;
        }
    }

    public Background(PPU self, int id) {
        this.self = self;
        this.id = id;
        this.priority0_enable = true;
        this.priority1_enable = true;
        this.opt_valid_bit = id == 0 ? 8192 : (id == 1 ? 16384 : 0);
        this.mosaic_table = new int[16][];
        int m = 0;
        while (m < 16) {
            this.mosaic_table[m] = new int[4096];
            int x = 0;
            while (x < 4096) {
                this.mosaic_table[m][x] = x / (m + 1) * (m + 1) & 0xFFFF;
                ++x;
            }
            ++m;
        }
    }

    private static final int sclip(int bits, int x) {
        int b = 1 << bits - 1;
        int m = (1 << bits) - 1;
        return (x & m ^ b) - b;
    }

    class Regs {
        public int mode;
        public int priority0;
        public int priority1;
        public boolean tile_size;
        public int mosaic;
        public int screen_addr;
        public int screen_size;
        public int tiledata_addr;
        public int hoffset;
        public int voffset;
        public boolean main_enable;
        public boolean sub_enable;

        Regs() {
        }
    }

    public static enum ScreenSize {
        Size32x32,
        Size32x64,
        Size64x32,
        Size64x64;

    }

    public static enum TileSize {
        Size8x8,
        Size16x16;

    }
}

