/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.ppu;

import jario.snes.performance.ppu.PPU;

public class HVCounter {
    private PPU ppu;
    private Status status = new Status();
    int region;

    public HVCounter(PPU ppu) {
        this.ppu = ppu;
    }

    final void tick(int clocks) {
        this.status.hcounter += clocks;
        if (this.status.hcounter >= this.lineclocks()) {
            this.status.hcounter -= this.lineclocks();
            this.vcounter_tick();
        }
    }

    final boolean field() {
        return this.status.field;
    }

    final int vcounter() {
        return this.status.vcounter;
    }

    final int hcounter() {
        return this.status.hcounter;
    }

    final int hdot() {
        if (this.region == 0 && !this.status.interlace && this.status.vcounter == 240 && this.status.field) {
            return this.status.hcounter >> 2;
        }
        return this.status.hcounter - ((this.status.hcounter > 1292 ? 1 : 0) << 1) - ((this.status.hcounter > 1310 ? 1 : 0) << 1) >> 2;
    }

    final int lineclocks() {
        if (this.region == 0 && !this.status.interlace && this.status.vcounter == 240 && this.status.field) {
            return 1360;
        }
        return 1364;
    }

    void reset() {
        this.status.interlace = false;
        this.status.field = false;
        this.status.vcounter = 0;
        this.status.hcounter = 0;
    }

    private void vcounter_tick() {
        if (++this.status.vcounter == 128) {
            this.status.interlace = this.ppu.display.interlace;
        }
        if (this.region == 0 && !this.status.interlace && this.status.vcounter == 262 || this.region == 0 && this.status.interlace && this.status.vcounter == 263 || this.region == 0 && this.status.interlace && this.status.vcounter == 262 && this.status.field || this.region == 1 && !this.status.interlace && this.status.vcounter == 312 || this.region == 1 && this.status.interlace && this.status.vcounter == 313 || this.region == 1 && this.status.interlace && this.status.vcounter == 312 && this.status.field) {
            this.status.vcounter = 0;
            this.status.field = !this.status.field;
        }
    }

    class Status {
        public boolean interlace;
        public boolean field;
        public int vcounter;
        public int hcounter;

        Status() {
        }
    }
}

