/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.ppu;

import jario.snes.performance.ppu.ColorWindow;
import jario.snes.performance.ppu.PPU;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class Screen {
    public Regs regs = new Regs();
    public Output output = new Output();
    public ColorWindow window = new ColorWindow();
    public short[][] light_table;
    private PPU self;

    public int get_palette(int color) {
        return this.self.cgram[color * 2 + 0] + (this.self.cgram[color * 2 + 1] << 8) & 0xFFFF;
    }

    public int get_direct_color(int palette, int tile) {
        return (tile & 7) << 2 | (palette & 1) << 1 | (tile >> 3 & 7) << 7 | (palette >> 1 & 1) << 6 | tile >> 6 << 13 | palette >> 2 << 12;
    }

    public int addsub(int x, int y, boolean halve) {
        if (!this.regs.color_mode) {
            if (!halve) {
                int sum = x + y;
                int carry = sum - ((x ^ y) & 0x421) & 0x8420;
                return (sum - carry | carry - (carry >> 5)) & 0xFFFF;
            }
            return x + y - ((x ^ y) & 0x421) >> 1 & 0xFFFF;
        }
        int diff = x - y + 33824;
        int borrow = diff - ((x ^ y) & 0x8420) & 0x8420;
        if (!halve) {
            return diff - borrow & borrow - (borrow >> 5) & 0xFFFF;
        }
        return (diff - borrow & borrow - (borrow >> 5) & 0x7BDE) >> 1 & 0xFFFF;
    }

    public void scanline() {
        int main_color = this.get_palette(0);
        int sub_color = !this.self.regs.pseudo_hires && this.self.regs.bgmode != 5 && this.self.regs.bgmode != 6 ? this.regs.color : main_color;
        int x = 0;
        while (x < 256) {
            this.output.main[x].color = main_color;
            this.output.main[x].priority = 0;
            this.output.main[x].source = 6;
            this.output.sub[x].color = sub_color;
            this.output.sub[x].priority = 0;
            this.output.sub[x].source = 6;
            ++x;
        }
        this.window.render(false);
        this.window.render(true);
    }

    public void render_black() {
        byte[] data = this.self.output.array();
        int data_offset = this.self.ppuCounter.vcounter() * 1024 << 1;
        if (this.self.interlace() && this.self.ppuCounter.field()) {
            data_offset += 1024;
        }
        Arrays.fill(data, data_offset, data_offset + (this.self.display.width << 2), (byte)0);
    }

    public int get_pixel_main(int x) {
        Output.Pixel main = this.output.main[x];
        Output.Pixel sub = this.output.sub[x];
        if (!this.regs.addsub_mode) {
            sub.source = 6;
            sub.color = this.regs.color;
        }
        if (this.window.main[x] == 0) {
            if (this.window.sub[x] == 0) {
                return 0;
            }
            main.color = 0;
        }
        if (main.source != 5 && this.regs.color_enable[main.source] && this.window.sub[x] != 0) {
            boolean halve = false;
            if (this.regs.color_halve && this.window.main[x] != 0 && (!this.regs.addsub_mode || sub.source != 6)) {
                halve = true;
            }
            return this.addsub(main.color, sub.color, halve);
        }
        return main.color & 0xFFFF;
    }

    public int get_pixel_sub(int x) {
        Output.Pixel main = this.output.sub[x];
        Output.Pixel sub = this.output.main[x];
        if (!this.regs.addsub_mode) {
            sub.source = 6;
            sub.color = this.regs.color;
        }
        if (this.window.main[x] == 0) {
            if (this.window.sub[x] == 0) {
                return 0;
            }
            main.color = 0;
        }
        if (main.source != 5 && this.regs.color_enable[main.source] && this.window.sub[x] != 0) {
            boolean halve = false;
            if (this.regs.color_halve && this.window.main[x] != 0 && (!this.regs.addsub_mode || sub.source != 6)) {
                halve = true;
            }
            return this.addsub(main.color, sub.color, halve);
        }
        return main.color & 0xFFFF;
    }

    public void render() {
        ShortBuffer data = this.self.output.asShortBuffer();
        int data_offset = this.self.ppuCounter.vcounter() * 1024;
        if (this.self.interlace() && this.self.ppuCounter.field()) {
            data_offset += 512;
        }
        short[] light = this.light_table[this.self.regs.display_brightness];
        if (!this.self.regs.pseudo_hires && this.self.regs.bgmode != 5 && this.self.regs.bgmode != 6) {
            int i = 0;
            while (i < 256) {
                data.put(data_offset + i, light[this.get_pixel_main(i)]);
                ++i;
            }
        } else {
            int arrayIndex = 0;
            int i = 0;
            while (i < 256) {
                data.put(data_offset + arrayIndex++, light[this.get_pixel_sub(i)]);
                data.put(data_offset + arrayIndex++, light[this.get_pixel_main(i)]);
                ++i;
            }
        }
    }

    public Screen(PPU self) {
        this.self = self;
        this.light_table = new short[16][];
        int l = 0;
        while (l < 16) {
            this.light_table[l] = new short[32768];
            int r = 0;
            while (r < 32) {
                int g = 0;
                while (g < 32) {
                    int b = 0;
                    while (b < 32) {
                        double luma = (double)l / 15.0;
                        int ar = (int)(luma * (double)r + 0.5);
                        int ag = (int)(luma * (double)g + 0.5);
                        int ab = (int)(luma * (double)b + 0.5);
                        this.light_table[l][(r << 10) + (g << 5) + (b << 0)] = (short)((ab << 10) + (ag << 5) + (ar << 0));
                        ++b;
                    }
                    ++g;
                }
                ++r;
            }
            ++l;
        }
    }

    class Output {
        public Pixel[] main = new Pixel[256];
        public Pixel[] sub = new Pixel[256];

        public Output() {
            int i = 0;
            while (i < this.main.length) {
                this.main[i] = new Pixel();
                ++i;
            }
            i = 0;
            while (i < this.sub.length) {
                this.sub[i] = new Pixel();
                ++i;
            }
        }

        public void plot_main(int x, int color, int priority, int source) {
            if (priority > this.main[x].priority) {
                this.main[x].color = color;
                this.main[x].priority = priority;
                this.main[x].source = source;
            }
        }

        public void plot_sub(int x, int color, int priority, int source) {
            if (priority > this.sub[x].priority) {
                this.sub[x].color = color;
                this.sub[x].priority = priority;
                this.sub[x].source = source;
            }
        }

        public class Pixel {
            public int color;
            public int priority;
            public int source;
        }
    }

    class Regs {
        public boolean addsub_mode;
        public boolean direct_color;
        public boolean color_mode;
        public boolean color_halve;
        public boolean[] color_enable = new boolean[7];
        public int color_b;
        public int color_g;
        public int color_r;
        public int color;

        Regs() {
        }
    }
}

