/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.ppu;

import jario.snes.ppu.PPU;

public class Background {
    public int tiledata_addr;
    public int screen_addr;
    public int screen_size;
    public int mosaic;
    public boolean tile_size;
    public int mode;
    public int priority0;
    public int priority1;
    public boolean main_enable;
    public boolean sub_enable;
    public int hoffset;
    public int voffset;
    private PPU self;
    private int[] vram;
    public static final int ID_BG1 = 0;
    public static final int ID_BG2 = 1;
    public static final int ID_BG3 = 2;
    public static final int ID_BG4 = 3;
    public int id;
    public static final int Mode_BPP2 = 0;
    public static final int Mode_BPP4 = 1;
    public static final int Mode_BPP8 = 2;
    public static final int Mode_Mode7 = 3;
    public static final int Mode_Inactive = 4;
    public static final int ScreenSize_Size32x32 = 0;
    public static final int ScreenSize_Size32x64 = 1;
    public static final int ScreenSize_Size64x32 = 2;
    public static final int ScreenSize_Size64x64 = 3;
    public static final int TileSize_Size8x8 = 0;
    public static final int TileSize_Size16x16 = 1;
    public static final int Screen_Main = 0;
    public static final int Screen_Sub = 1;
    public PPU.Output output;
    public int x;
    public int y;
    public int mosaic_vcounter;
    public int mosaic_voffset;
    public int mosaic_hcounter;
    public int mosaic_hoffset;
    public int mosaic_priority;
    public int mosaic_palette;
    public int mosaic_tile;
    public int tile_counter;
    public int tile;
    public int priority;
    public int palette_number;
    public int palette_index;
    public int[] data = new int[8];

    public final void frame() {
    }

    public final void scanline() {
        boolean hires = this.self.regs.bgmode == 5 || this.self.regs.bgmode == 6;
        this.x = -7;
        this.y = this.self.counter.vcounter();
        this.tile_counter = 7 - (this.hoffset & 7) << (hires ? 1 : 0);
        int n = 0;
        while (n < 8) {
            this.data[n] = 0;
            ++n;
        }
        if (this.self.counter.vcounter() == 1) {
            this.mosaic_vcounter = this.mosaic + 1;
            this.mosaic_voffset = 1;
        } else if (--this.mosaic_vcounter == 0) {
            this.mosaic_vcounter = this.mosaic + 1;
            this.mosaic_voffset += this.mosaic + 1;
        }
        this.mosaic_hcounter = this.mosaic + 1;
        this.mosaic_hoffset = 0;
    }

    public final void run(boolean screen) {
        boolean hires;
        boolean bl = hires = this.self.regs.bgmode == 5 || this.self.regs.bgmode == 6;
        if (screen) {
            this.output.main.priority = 0;
            this.output.sub.priority = 0;
            if (!hires) {
                return;
            }
        }
        if (this.mode == 4) {
            return;
        }
        if (!this.main_enable && !this.sub_enable) {
            return;
        }
        if (this.mode == 3) {
            this.run_mode7();
            return;
        }
        if (this.tile_counter-- == 0) {
            this.tile_counter = 7;
            this.get_tile();
        }
        int palette = this.get_tile_color() & 0xFF;
        if (this.x == 0) {
            this.mosaic_hcounter = 1;
        }
        if (this.x >= 0 && --this.mosaic_hcounter == 0) {
            this.mosaic_hcounter = this.mosaic + 1;
            this.mosaic_priority = this.priority;
            this.mosaic_palette = palette != 0 ? this.palette_index + palette : 0;
            this.mosaic_tile = this.tile & 0xFFFF;
        }
        if (!screen) {
            ++this.x;
        }
        if (this.mosaic_palette == 0) {
            return;
        }
        if (!hires) {
            if (this.main_enable) {
                this.output.main.priority = this.mosaic_priority;
                this.output.main.palette = this.mosaic_palette;
                this.output.main.tile = this.mosaic_tile;
            }
            if (this.sub_enable) {
                this.output.sub.priority = this.mosaic_priority;
                this.output.sub.palette = this.mosaic_palette;
                this.output.sub.tile = this.mosaic_tile;
            }
        } else if (!screen) {
            if (this.main_enable) {
                this.output.main.priority = this.mosaic_priority;
                this.output.main.palette = this.mosaic_palette;
                this.output.main.tile = this.mosaic_tile;
            }
        } else if (screen && this.sub_enable) {
            this.output.sub.priority = this.mosaic_priority;
            this.output.sub.palette = this.mosaic_palette;
            this.output.sub.tile = this.mosaic_tile;
        }
    }

    private final void get_tile() {
        int screen_y;
        int offset_x;
        int mask_x;
        boolean hires;
        boolean bl = hires = this.self.regs.bgmode == 5 || this.self.regs.bgmode == 6;
        int color_depth = this.mode == 0 ? 0 : (this.mode == 1 ? 1 : 2);
        int palette_offset = this.self.regs.bgmode == 0 ? this.id << 5 : 0;
        int palette_size = 2 << color_depth;
        int tile_mask = 4095 >> color_depth;
        int tiledata_index = this.tiledata_addr >> 4 + color_depth;
        int tile_height = !this.tile_size ? 3 : 4;
        int tile_width = !hires ? tile_height : 4;
        int width = 256 << (hires ? 1 : 0);
        int mask_y = mask_x = tile_height == 3 ? width : width << 1;
        if ((this.screen_size & 1) != 0) {
            mask_x <<= 1;
        }
        if ((this.screen_size & 2) != 0) {
            mask_y <<= 1;
        }
        --mask_x;
        --mask_y;
        int px = this.x << (hires ? 1 : 0);
        int py = this.mosaic == 0 ? this.y : this.mosaic_voffset;
        int hscroll = this.hoffset;
        int vscroll = this.voffset;
        if (hires) {
            hscroll <<= 1;
            if (this.self.regs.interlace) {
                py = (py << 1) + (this.self.counter.field() ? 1 : 0);
            }
        }
        int hoffset = hscroll + px;
        int voffset = vscroll + py;
        if ((this.self.regs.bgmode == 2 || this.self.regs.bgmode == 4 || this.self.regs.bgmode == 6) && (offset_x = this.x + (hscroll & 7) & 0xFFFF) >= 8) {
            int valid_mask;
            int hval = this.self.bg3.get_tile(offset_x - 8 + (this.self.bg3.hoffset & 0xFFFFFFF8), this.self.bg3.voffset + 0);
            int vval = this.self.bg3.get_tile(offset_x - 8 + (this.self.bg3.hoffset & 0xFFFFFFF8), this.self.bg3.voffset + 8);
            int n = valid_mask = this.id == 0 ? 8192 : 16384;
            if (this.self.regs.bgmode == 4) {
                if ((hval & valid_mask) != 0) {
                    if ((hval & 0x8000) == 0) {
                        hoffset = offset_x + (hval & 0xFFFFFFF8);
                    } else {
                        voffset = this.y + hval;
                    }
                }
            } else {
                if ((hval & valid_mask) != 0) {
                    hoffset = offset_x + (hval & 0xFFFFFFF8);
                }
                if ((vval & valid_mask) != 0) {
                    voffset = this.y + vval;
                }
            }
        }
        hoffset &= mask_x;
        voffset &= mask_y;
        int screen_x = (this.screen_size & 1) != 0 ? 1024 : 0;
        int n = screen_y = (this.screen_size & 2) != 0 ? 1024 : 0;
        if (this.screen_size == 3) {
            screen_y <<= 1;
        }
        int tx = hoffset >> tile_width;
        int ty = voffset >> tile_height;
        int offset = ((ty & 0x1F) << 5) + (tx & 0x1F);
        if ((tx & 0x20) != 0) {
            offset += screen_x;
        }
        if ((ty & 0x20) != 0) {
            offset += screen_y;
        }
        int addr = this.screen_addr + (offset << 1) & 0xFFFF;
        this.tile = this.vram[addr + 0] + (this.vram[addr + 1] << 8);
        boolean mirror_y = (this.tile & 0x8000) != 0;
        boolean mirror_x = (this.tile & 0x4000) != 0;
        this.priority = (this.tile & 0x2000) != 0 ? this.priority1 : this.priority0;
        this.palette_number = this.tile >> 10 & 7;
        this.palette_index = palette_offset + (this.palette_number << palette_size);
        if (tile_width == 4 && (hoffset & 8) != 0 != mirror_x) {
            ++this.tile;
        }
        if (tile_height == 4 && (voffset & 8) != 0 != mirror_y) {
            this.tile += 16;
        }
        int character = (this.tile & 0x3FF) + tiledata_index & tile_mask;
        if (mirror_y) {
            voffset ^= 7;
        }
        offset = (character << 4 + color_depth) + ((voffset & 7) << 1) & 0xFFFF;
        if (this.mode >= 0) {
            this.data[0] = this.vram[offset + 0];
            this.data[1] = this.vram[offset + 1];
        }
        if (this.mode >= 1) {
            this.data[2] = this.vram[offset + 16];
            this.data[3] = this.vram[offset + 17];
        }
        if (this.mode >= 2) {
            this.data[4] = this.vram[offset + 32];
            this.data[5] = this.vram[offset + 33];
            this.data[6] = this.vram[offset + 48];
            this.data[7] = this.vram[offset + 49];
        }
        if (mirror_x) {
            int n2 = 0;
            while (n2 < 8) {
                this.data[n2] = this.data[n2] >> 4 & 0xF | this.data[n2] << 4 & 0xF0;
                this.data[n2] = this.data[n2] >> 2 & 0x33 | this.data[n2] << 2 & 0xCC;
                this.data[n2] = this.data[n2] >> 1 & 0x55 | this.data[n2] << 1 & 0xAA;
                ++n2;
            }
        }
    }

    private final int get_tile_color() {
        int color = 0;
        switch (this.mode) {
            case 2: {
                color += this.data[7] >> 0 & 0x80;
                this.data[7] = this.data[7] << 1;
                color += this.data[6] >> 1 & 0x40;
                this.data[6] = this.data[6] << 1;
                color += this.data[5] >> 2 & 0x20;
                this.data[5] = this.data[5] << 1;
                color += this.data[4] >> 3 & 0x10;
                this.data[4] = this.data[4] << 1;
            }
            case 1: {
                color += this.data[3] >> 4 & 8;
                this.data[3] = this.data[3] << 1;
                color += this.data[2] >> 5 & 4;
                this.data[2] = this.data[2] << 1;
            }
            case 0: {
                color += this.data[1] >> 6 & 2;
                this.data[1] = this.data[1] << 1;
                color += this.data[0] >> 7 & 1;
                this.data[0] = this.data[0] << 1;
            }
        }
        return color;
    }

    private final int get_tile(int x, int y) {
        int screen_y;
        int mask_x;
        boolean hires = this.self.regs.bgmode == 5 || this.self.regs.bgmode == 6;
        int tile_height = !this.tile_size ? 3 : 4;
        int tile_width = !hires ? tile_height : 4;
        int width = !hires ? 256 : 512;
        int mask_y = mask_x = tile_height == 3 ? width : width << 1;
        if ((this.screen_size & 1) != 0) {
            mask_x <<= 1;
        }
        if ((this.screen_size & 2) != 0) {
            mask_y <<= 1;
        }
        --mask_x;
        --mask_y;
        int screen_x = (this.screen_size & 1) != 0 ? 1024 : 0;
        int n = screen_y = (this.screen_size & 2) != 0 ? 1024 : 0;
        if (this.screen_size == 3) {
            screen_y <<= 1;
        }
        x = (x & mask_x) >> tile_width;
        y = (y & mask_y) >> tile_height;
        int offset = ((y & 0x1F) << 5) + (x & 0x1F);
        if ((x & 0x20) != 0) {
            offset += screen_x;
        }
        if ((y & 0x20) != 0) {
            offset += screen_y;
        }
        int addr = this.screen_addr + (offset << 1) & 0xFFFF;
        return this.vram[addr + 0] + (this.vram[addr + 1] << 8);
    }

    public void reset() {
        this.tiledata_addr = 0;
        this.screen_addr = 0;
        this.screen_size = 0;
        this.mosaic = 0;
        this.tile_size = false;
        this.mode = 0;
        this.priority0 = 0;
        this.priority1 = 0;
        this.main_enable = false;
        this.sub_enable = false;
        this.hoffset = 0;
        this.voffset = 0;
        this.output.main.palette = 0;
        this.output.main.priority = 0;
        this.output.sub.palette = 0;
        this.output.sub.priority = 0;
        this.x = 0;
        this.y = 0;
        this.mosaic_vcounter = 0;
        this.mosaic_voffset = 0;
        this.mosaic_hcounter = 0;
        this.mosaic_hoffset = 0;
        this.mosaic_priority = 0;
        this.mosaic_palette = 0;
        this.mosaic_tile = 0;
        this.tile_counter = 0;
        this.tile = 0;
        this.priority = 0;
        this.palette_number = 0;
        this.palette_index = 0;
        int n = 0;
        while (n < 8) {
            this.data[n] = 0;
            ++n;
        }
    }

    public Background(PPU self_, int id_) {
        this.self = self_;
        this.id = id_;
        this.output = new PPU.Output(id_);
        this.vram = this.self.vram;
    }

    private final int clip(int n) {
        return (n & 0x2000) != 0 ? n | 0xFFFFFC00 : n & 0x3FF;
    }

    private final void run_mode7() {
        int a = Background.sclip(16, this.self.regs.m7a);
        int b = Background.sclip(16, this.self.regs.m7b);
        int c = Background.sclip(16, this.self.regs.m7c);
        int d = Background.sclip(16, this.self.regs.m7d);
        int cx = Background.sclip(13, this.self.regs.m7x);
        int cy = Background.sclip(13, this.self.regs.m7y);
        int hoffset = Background.sclip(13, this.self.regs.mode7_hoffset);
        int voffset = Background.sclip(13, this.self.regs.mode7_voffset);
        if ((this.x++ & 0xFFFFFF00) != 0) {
            return;
        }
        int x = this.mosaic_hoffset;
        int y = this.self.bg1.mosaic_voffset;
        if (--this.mosaic_hcounter == 0) {
            this.mosaic_hcounter = this.mosaic + 1;
            this.mosaic_hoffset += this.mosaic + 1;
        }
        if (this.self.regs.mode7_hflip) {
            x = 255 - x;
        }
        if (this.self.regs.mode7_vflip) {
            y = 255 - y;
        }
        int psx = (a * this.clip(hoffset - cx) & 0xFFFFFFC0) + (b * this.clip(voffset - cy) & 0xFFFFFFC0) + (b * y & 0xFFFFFFC0) + (cx << 8);
        int psy = (c * this.clip(hoffset - cx) & 0xFFFFFFC0) + (d * this.clip(voffset - cy) & 0xFFFFFFC0) + (d * y & 0xFFFFFFC0) + (cy << 8);
        int px = psx + a * x;
        int py = psy + c * x;
        px >>= 8;
        py >>= 8;
        int palette = 0;
        switch (this.self.regs.mode7_repeat) {
            case 0: 
            case 1: {
                int tile = this.vram[((py &= 0x3FF) >> 3) * 128 + ((px &= 0x3FF) >> 3) << 1];
                palette = this.vram[((tile << 6) + ((py & 7) << 3) + (px & 7) << 1) + 1];
                break;
            }
            case 2: {
                if (((px | py) & 0xFFFFFC00) != 0) {
                    palette = 0;
                    break;
                }
                int tile = this.vram[((py &= 0x3FF) >> 3) * 128 + ((px &= 0x3FF) >> 3) << 1];
                palette = this.vram[((tile << 6) + ((py & 7) << 3) + (px & 7) << 1) + 1];
                break;
            }
            case 3: {
                int tile = ((px | py) & 0xFFFFFC00) != 0 ? 0 : this.vram[((py &= 0x3FF) >> 3) * 128 + ((px &= 0x3FF) >> 3) << 1];
                palette = this.vram[((tile << 6) + ((py & 7) << 3) + (px & 7) << 1) + 1];
            }
        }
        int priority = 0;
        if (this.id == 0) {
            priority = this.priority0;
        } else if (this.id == 1) {
            priority = (palette & 0x80) != 0 ? this.priority1 : this.priority0;
            palette &= 0x7F;
        }
        if (palette == 0) {
            return;
        }
        if (this.main_enable) {
            this.output.main.palette = palette;
            this.output.main.priority = priority;
            this.output.main.tile = 0;
        }
        if (this.sub_enable) {
            this.output.sub.palette = palette;
            this.output.sub.priority = priority;
            this.output.main.tile = 0;
        }
    }

    private static final int sclip(int bits, int x) {
        int b = 1 << bits - 1;
        int m = (1 << bits) - 1;
        return (x & m ^ b) - b;
    }
}

