/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.ppu;

import jario.snes.ppu.PPU;
import java.nio.ShortBuffer;

public class Screen {
    public boolean addsub_mode;
    public boolean direct_color;
    public boolean color_mode;
    public boolean color_halve;
    public boolean bg1_color_enable;
    public boolean bg2_color_enable;
    public boolean bg3_color_enable;
    public boolean bg4_color_enable;
    public boolean oam_color_enable;
    public boolean back_color_enable;
    public int color_b;
    public int color_g;
    public int color_r;
    private PPU self;
    private int[] cgram;
    private ShortBuffer output_data;
    private int output_offset;
    private short[][] light_table = new short[16][32768];
    static final int Source_BG1 = 0;
    static final int Source_BG2 = 1;
    static final int Source_BG3 = 2;
    static final int Source_BG4 = 3;
    static final int Source_OAM = 4;
    static final int Source_BACK = 5;

    public final void scanline() {
        this.output_data = this.self.output.asShortBuffer();
        this.output_offset = this.self.counter.vcounter() * 1024;
        if (this.self.display.interlace && this.self.counter.field()) {
            this.output_offset += 512;
        }
    }

    public final void run() {
        if (!this.self.regs.pseudo_hires && this.self.regs.bgmode != 5 && this.self.regs.bgmode != 6) {
            int color = this.get_pixel(false);
            this.output_data.put(this.output_offset, (short)color);
            this.output_data.put(this.output_offset + 1, (short)color);
        } else {
            int color = this.get_pixel(true);
            this.output_data.put(this.output_offset, (short)color);
            color = this.get_pixel(false);
            this.output_data.put(this.output_offset + 1, (short)color);
        }
        this.output_offset += 2;
    }

    public void reset() {
        this.addsub_mode = false;
        this.direct_color = false;
        this.color_mode = false;
        this.color_halve = false;
        this.bg1_color_enable = false;
        this.bg2_color_enable = false;
        this.bg3_color_enable = false;
        this.bg4_color_enable = false;
        this.oam_color_enable = false;
        this.back_color_enable = false;
        this.color_r = 0;
        this.color_g = 0;
        this.color_b = 0;
    }

    public Screen(PPU self) {
        this.self = self;
        this.cgram = self.cgram;
        int l = 0;
        while (l < 16) {
            int r = 0;
            while (r < 32) {
                int g = 0;
                while (g < 32) {
                    int b = 0;
                    while (b < 32) {
                        double luma = (double)l / 15.0;
                        int ar = (int)(luma * (double)r + 0.5);
                        int ag = (int)(luma * (double)g + 0.5);
                        int ab = (int)(luma * (double)b + 0.5);
                        this.light_table[l][(r << 10) + (g << 5) + b] = (short)((ab << 10) + (ag << 5) + ar);
                        ++b;
                    }
                    ++g;
                }
                ++r;
            }
            ++l;
        }
    }

    private final int get_pixel(boolean swap) {
        int output;
        boolean color_exempt;
        boolean[] color_enable = new boolean[]{this.bg1_color_enable, this.bg2_color_enable, this.bg3_color_enable, this.bg4_color_enable, this.oam_color_enable, this.back_color_enable};
        int priority_main = 0;
        int color_main = 0;
        int source_main = 0;
        if (this.self.bg1.output.main.priority != 0) {
            priority_main = this.self.bg1.output.main.priority;
            color_main = this.direct_color && (this.self.regs.bgmode == 3 || this.self.regs.bgmode == 4 || this.self.regs.bgmode == 7) ? this.get_direct_color(this.self.bg1.output.main.palette, this.self.bg1.output.main.tile) : this.get_color(this.self.bg1.output.main.palette);
            source_main = 0;
        }
        if (this.self.bg2.output.main.priority > priority_main) {
            priority_main = this.self.bg2.output.main.priority;
            color_main = this.get_color(this.self.bg2.output.main.palette);
            source_main = 1;
        }
        if (this.self.bg3.output.main.priority > priority_main) {
            priority_main = this.self.bg3.output.main.priority;
            color_main = this.get_color(this.self.bg3.output.main.palette);
            source_main = 2;
        }
        if (this.self.bg4.output.main.priority > priority_main) {
            priority_main = this.self.bg4.output.main.priority;
            color_main = this.get_color(this.self.bg4.output.main.palette);
            source_main = 3;
        }
        if (this.self.sprite.output_main_priority > priority_main) {
            priority_main = this.self.sprite.output_main_priority;
            color_main = this.get_color(this.self.sprite.output_main_palette);
            source_main = 4;
        }
        if (priority_main == 0) {
            color_main = this.get_color(0);
            source_main = 5;
        }
        int priority_sub = 0;
        int color_sub = 0;
        int source_sub = 0;
        if (this.self.bg1.output.sub.priority != 0) {
            priority_sub = this.self.bg1.output.sub.priority;
            color_sub = this.direct_color && (this.self.regs.bgmode == 3 || this.self.regs.bgmode == 4 || this.self.regs.bgmode == 7) ? this.get_direct_color(this.self.bg1.output.sub.palette, this.self.bg1.output.sub.tile) : this.get_color(this.self.bg1.output.sub.palette);
            source_sub = 0;
        }
        if (this.self.bg2.output.sub.priority > priority_sub) {
            priority_sub = this.self.bg2.output.sub.priority;
            color_sub = this.get_color(this.self.bg2.output.sub.palette);
            source_sub = 1;
        }
        if (this.self.bg3.output.sub.priority > priority_sub) {
            priority_sub = this.self.bg3.output.sub.priority;
            color_sub = this.get_color(this.self.bg3.output.sub.palette);
            source_sub = 2;
        }
        if (this.self.bg4.output.sub.priority > priority_sub) {
            priority_sub = this.self.bg4.output.sub.priority;
            color_sub = this.get_color(this.self.bg4.output.sub.palette);
            source_sub = 3;
        }
        if (this.self.sprite.output_sub_priority > priority_sub) {
            priority_sub = this.self.sprite.output_sub_priority;
            color_sub = this.get_color(this.self.sprite.output_sub_palette);
            source_sub = 4;
        }
        if (priority_sub == 0) {
            color_sub = this.self.regs.pseudo_hires || this.self.regs.bgmode == 5 || this.self.regs.bgmode == 6 ? this.get_color(0) : (this.color_b << 10) + (this.color_g << 5) + (this.color_r << 0);
            source_sub = 5;
        }
        if (swap) {
            int temp = priority_main;
            priority_main = priority_sub;
            priority_sub = temp;
            temp = color_main;
            color_main = color_sub;
            color_sub = temp;
            temp = source_main;
            source_main = source_sub;
            source_sub = temp;
        }
        if (!this.addsub_mode) {
            source_sub = 5;
            color_sub = (this.color_b << 10) + (this.color_g << 5) + (this.color_r << 0);
        }
        if (!this.self.window.output_main_color_enable) {
            if (!this.self.window.output_sub_color_enable) {
                return 0;
            }
            color_main = 0;
        }
        boolean bl = color_exempt = source_main == 4 && this.self.sprite.output_main_palette < 192;
        if (!color_exempt && color_enable[source_main] && this.self.window.output_sub_color_enable) {
            boolean halve = false;
            if (this.color_halve && this.self.window.output_main_color_enable && (!this.addsub_mode || source_sub != 5)) {
                halve = true;
            }
            output = this.addsub(color_main & 0xFFFF, color_sub & 0xFFFF, halve);
        } else {
            output = color_main;
        }
        output = this.light_table[this.self.regs.display_brightness][output & 0xFFFF];
        if (this.self.regs.display_disable) {
            output = 0;
        }
        return output;
    }

    private final int addsub(int x, int y, boolean halve) {
        if (!this.color_mode) {
            if (!halve) {
                int sum = x + y;
                int carry = sum - ((x ^ y) & 0x421) & 0x8420;
                return sum - carry | carry - (carry >> 5);
            }
            return x + y - ((x ^ y) & 0x421) >> 1;
        }
        int diff = x - y + 33824;
        int borrow = diff - ((x ^ y) & 0x8420) & 0x8420;
        if (!halve) {
            return diff - borrow & borrow - (borrow >> 5);
        }
        return (diff - borrow & borrow - (borrow >> 5) & 0x7BDE) >> 1;
    }

    private final int get_color(int palette) {
        this.self.regs.cgram_iaddr = (palette <<= 1) & 0x1FF;
        return this.cgram[palette + 0] + (this.cgram[palette + 1] << 8);
    }

    private final int get_direct_color(int palette, int tile) {
        return (palette << 7 & 0x6000) + (tile >> 0 & 0x1000) + (palette << 4 & 0x380) + (tile >> 5 & 0x40) + (palette << 2 & 0x1C) + (tile >> 9 & 2);
    }
}

