/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.ppu;

import jario.snes.ppu.PPU;

public class Window {
    public boolean bg1_one_enable;
    public boolean bg1_one_invert;
    public boolean bg1_two_enable;
    public boolean bg1_two_invert;
    public boolean bg2_one_enable;
    public boolean bg2_one_invert;
    public boolean bg2_two_enable;
    public boolean bg2_two_invert;
    public boolean bg3_one_enable;
    public boolean bg3_one_invert;
    public boolean bg3_two_enable;
    public boolean bg3_two_invert;
    public boolean bg4_one_enable;
    public boolean bg4_one_invert;
    public boolean bg4_two_enable;
    public boolean bg4_two_invert;
    public boolean oam_one_enable;
    public boolean oam_one_invert;
    public boolean oam_two_enable;
    public boolean oam_two_invert;
    public boolean col_one_enable;
    public boolean col_one_invert;
    public boolean col_two_enable;
    public boolean col_two_invert;
    public int one_left;
    public int one_right;
    public int two_left;
    public int two_right;
    public int bg1_mask;
    public int bg2_mask;
    public int bg3_mask;
    public int bg4_mask;
    public int oam_mask;
    public int col_mask;
    public boolean bg1_main_enable;
    public boolean bg1_sub_enable;
    public boolean bg2_main_enable;
    public boolean bg2_sub_enable;
    public boolean bg3_main_enable;
    public boolean bg3_sub_enable;
    public boolean bg4_main_enable;
    public boolean bg4_sub_enable;
    public boolean oam_main_enable;
    public boolean oam_sub_enable;
    public int col_main_mask;
    public int col_sub_mask;
    public boolean output_main_color_enable;
    public boolean output_sub_color_enable;
    private PPU self;
    private int x;
    private boolean one;
    private boolean two;
    private boolean main;
    private boolean sub;

    public final void scanline() {
        this.x = 0;
    }

    public final void run() {
        this.one = this.x >= this.one_left && this.x <= this.one_right;
        this.two = this.x >= this.two_left && this.x <= this.two_right;
        ++this.x;
        this.test(this.bg1_one_enable, this.bg1_one_invert, this.bg1_two_enable, this.bg1_two_invert, this.bg1_mask, this.bg1_main_enable, this.bg1_sub_enable);
        if (this.main) {
            this.self.bg1.output.main.priority = 0;
        }
        if (this.sub) {
            this.self.bg1.output.sub.priority = 0;
        }
        this.test(this.bg2_one_enable, this.bg2_one_invert, this.bg2_two_enable, this.bg2_two_invert, this.bg2_mask, this.bg2_main_enable, this.bg2_sub_enable);
        if (this.main) {
            this.self.bg2.output.main.priority = 0;
        }
        if (this.sub) {
            this.self.bg2.output.sub.priority = 0;
        }
        this.test(this.bg3_one_enable, this.bg3_one_invert, this.bg3_two_enable, this.bg3_two_invert, this.bg3_mask, this.bg3_main_enable, this.bg3_sub_enable);
        if (this.main) {
            this.self.bg3.output.main.priority = 0;
        }
        if (this.sub) {
            this.self.bg3.output.sub.priority = 0;
        }
        this.test(this.bg4_one_enable, this.bg4_one_invert, this.bg4_two_enable, this.bg4_two_invert, this.bg4_mask, this.bg4_main_enable, this.bg4_sub_enable);
        if (this.main) {
            this.self.bg4.output.main.priority = 0;
        }
        if (this.sub) {
            this.self.bg4.output.sub.priority = 0;
        }
        this.test(this.oam_one_enable, this.oam_one_invert, this.oam_two_enable, this.oam_two_invert, this.oam_mask, this.oam_main_enable, this.oam_sub_enable);
        if (this.main) {
            this.self.sprite.output_main_priority = 0;
        }
        if (this.sub) {
            this.self.sprite.output_sub_priority = 0;
        }
        this.test(this.col_one_enable, this.col_one_invert, this.col_two_enable, this.col_two_invert, this.col_mask, true, true);
        switch (this.col_main_mask) {
            case 0: {
                this.main = true;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.main = !this.main;
                break;
            }
            case 3: {
                this.main = false;
            }
        }
        switch (this.col_sub_mask) {
            case 0: {
                this.sub = true;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.sub = !this.sub;
                break;
            }
            case 3: {
                this.sub = false;
            }
        }
        this.output_main_color_enable = this.main;
        this.output_sub_color_enable = this.sub;
    }

    public void reset() {
        this.bg1_one_enable = false;
        this.bg1_one_invert = false;
        this.bg1_two_enable = false;
        this.bg1_two_invert = false;
        this.bg2_one_enable = false;
        this.bg2_one_invert = false;
        this.bg2_two_enable = false;
        this.bg2_two_invert = false;
        this.bg3_one_enable = false;
        this.bg3_one_invert = false;
        this.bg3_two_enable = false;
        this.bg3_two_invert = false;
        this.bg4_one_enable = false;
        this.bg4_one_invert = false;
        this.bg4_two_enable = false;
        this.bg4_two_invert = false;
        this.oam_one_enable = false;
        this.oam_one_invert = false;
        this.oam_two_enable = false;
        this.oam_two_invert = false;
        this.col_one_enable = false;
        this.col_one_invert = false;
        this.col_two_enable = false;
        this.col_two_invert = false;
        this.one_left = 0;
        this.one_right = 0;
        this.two_left = 0;
        this.two_right = 0;
        this.bg1_mask = 0;
        this.bg2_mask = 0;
        this.bg3_mask = 0;
        this.bg4_mask = 0;
        this.oam_mask = 0;
        this.col_mask = 0;
        this.bg1_main_enable = false;
        this.bg1_sub_enable = false;
        this.bg2_main_enable = false;
        this.bg2_sub_enable = false;
        this.bg3_main_enable = false;
        this.bg3_sub_enable = false;
        this.bg4_main_enable = false;
        this.bg4_sub_enable = false;
        this.oam_main_enable = false;
        this.oam_sub_enable = false;
        this.col_main_mask = 0;
        this.col_sub_mask = 0;
        this.output_main_color_enable = false;
        this.output_sub_color_enable = false;
        this.x = 0;
        this.one = false;
        this.two = false;
    }

    public Window(PPU self) {
        this.self = self;
    }

    private final void test(boolean one_enable, boolean one_invert, boolean two_enable, boolean two_invert, int mask, boolean main_enable, boolean sub_enable) {
        boolean one = this.one ^ one_invert;
        boolean two = this.two ^ two_invert;
        boolean output = false;
        if (!one_enable && !two_enable) {
            output = false;
        } else if (one_enable && !two_enable) {
            output = one;
        } else if (!one_enable && two_enable) {
            output = two;
        } else {
            switch (mask) {
                case 0: {
                    output = one | two;
                    break;
                }
                case 1: {
                    output = one & two;
                    break;
                }
                case 2: {
                    output = one ^ two;
                    break;
                }
                case 3: {
                    output = !(one ^ two);
                }
            }
        }
        this.main = main_enable ? output : false;
        this.sub = sub_enable ? output : false;
    }
}

