/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.accessories;

import jario.hardware.Bus16bit;
import jario.hardware.Hardware;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;

public class Keyboard
implements Hardware,
Bus16bit {
    private static final int Joypad_B = 1;
    private static final int Joypad_Y = 2;
    private static final int Joypad_Select = 4;
    private static final int Joypad_Start = 8;
    private static final int Joypad_Up = 16;
    private static final int Joypad_Down = 32;
    private static final int Joypad_Left = 64;
    private static final int Joypad_Right = 128;
    private static final int Joypad_A = 256;
    private static final int Joypad_X = 512;
    private static final int Joypad_L = 1024;
    private static final int Joypad_R = 2048;
    private static final int Joypad_LeftRight = 192;
    private static final int Joypad_UpDown = 48;
    private int keyboardState;
    private int[] inputButtons = new int[8];
    private Key[] keys = new Key[]{new Key(1, 90), new Key(2, 65), new Key(4, 222), new Key(8, 10), new Key(16, 38), new Key(32, 40), new Key(64, 37), new Key(128, 39), new Key(256, 88), new Key(512, 83), new Key(1024, 68), new Key(2048, 67)};

    public Keyboard() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new ControllerListener(), 8L);
    }

    public void connect(int port, Hardware hw) {
    }

    public void reset() {
    }

    public short read16bit(int address) {
        this.SetInputState(0, 0, this.ParseInput(0), 0, 0);
        return (short)this.inputButtons[address];
    }

    public void write16bit(int address, short data) {
    }

    private void SetInputState(int port, int index, int buttonStates, int x, int y) {
        if ((buttonStates & 0xC0) == 192) {
            buttonStates &= 0xFFFFFF3F;
        }
        if ((buttonStates & 0x30) == 48) {
            buttonStates &= 0xFFFFFFCF;
        }
        int i = port * 4 + index;
        this.inputButtons[i] = buttonStates;
    }

    private int ParseInput(int playerIndex) {
        int snesButtonStates = 0;
        int i = 0;
        while (i < this.keys.length) {
            if ((this.keyboardState & this.keys[i].value) != 0) {
                snesButtonStates |= this.keys[i].value;
            }
            ++i;
        }
        return snesButtonStates;
    }

    private class ControllerListener
    implements AWTEventListener {
        private ControllerListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            block5: {
                KeyEvent kevt;
                block4: {
                    kevt = (KeyEvent)event;
                    if (kevt.getID() != 401) break block4;
                    int i = 0;
                    while (i < Keyboard.this.keys.length) {
                        if (((Keyboard)Keyboard.this).keys[i].vkey == kevt.getKeyCode()) {
                            Keyboard keyboard = Keyboard.this;
                            keyboard.keyboardState = keyboard.keyboardState | ((Keyboard)Keyboard.this).keys[i].value;
                            return;
                        }
                        ++i;
                    }
                    break block5;
                }
                if (kevt.getID() != 402) break block5;
                int i = 0;
                while (i < Keyboard.this.keys.length) {
                    if (((Keyboard)Keyboard.this).keys[i].vkey == kevt.getKeyCode()) {
                        Keyboard keyboard = Keyboard.this;
                        keyboard.keyboardState = keyboard.keyboardState & ~((Keyboard)Keyboard.this).keys[i].value;
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private class Key {
        public int vkey;
        public int value;

        public Key(int value, int vkey) {
            this.value = value;
            this.vkey = vkey;
        }
    }
}

