/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.cartridge;

import jario.hardware.Bus8bit;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.snes.cartridge.MappedRAM;
import jario.snes.cartridge.Mapping;
import jario.snes.cartridge.SnesInformation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Cartridge
implements Hardware,
Bus8bit,
Configurable {
    UnmappedMemory memory_unmapped = new UnmappedMemory();
    public String basename;
    private String cartridgeName;
    private boolean loaded;
    private Region region;
    private int ram_size;
    private Collection<Mapping> mapping = new ArrayList<Mapping>();
    private Page[] page = new Page[65536];
    private MappedRAM cartrom = new MappedRAM();
    private MappedRAM cartram = new MappedRAM();

    public Cartridge() {
        int i = 0;
        while (i < this.page.length) {
            this.page[i] = new Page();
            ++i;
        }
        this.loaded = false;
        this.reset();
    }

    public void connect(int port, Hardware hw) {
    }

    public void reset() {
        this.save();
        this.unload();
    }

    public byte read8bit(int addr) {
        Page p = this.page[(addr & 0xFFFFFF) >> 8];
        return p.access.read8bit(p.offset + (addr & 0xFFFFFF));
    }

    public void write8bit(int addr, byte data) {
        Page p = this.page[(addr & 0xFFFFFF) >> 8];
        p.access.write8bit(p.offset + (addr & 0xFFFFFF), data);
    }

    public Object readConfig(String key) {
        if (key.equals("region")) {
            return this.region.name().toLowerCase();
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("romfile")) {
            this.cartridgeName = value.toString();
            this.loadDataFromRomFile();
        }
    }

    private void load(Mode cartridge_mode, String[] xml_list) {
        this.region = Region.NTSC;
        this.ram_size = 0;
        this.parse_xml(xml_list);
        if (this.ram_size > 0) {
            byte[] repeat = new byte[this.ram_size];
            Arrays.fill(repeat, (byte)-1);
            this.cartram.map(repeat, this.ram_size);
        }
        this.cartrom.write_protect(true);
        this.cartram.write_protect(false);
        if (!this.loaded) {
            this.map_reset();
            this.map_xml();
        }
        this.loaded = true;
    }

    private void unload() {
        this.cartridgeName = null;
        this.cartrom.reset();
        this.cartram.reset();
        if (!this.loaded) {
            return;
        }
        this.loaded = false;
    }

    private void loadNormal(byte[] rom_data) {
        if (rom_data != null) {
            this.cartrom.copy(rom_data, rom_data.length);
        }
        String xmlrom = new SnesInformation((byte[])rom_data, (int)rom_data.length).xml_memory_map;
        System.out.println(xmlrom);
        this.load(Mode.Normal, new String[]{xmlrom});
    }

    private void loadDataFromRomFile() {
        try {
            RandomAccessFile fs = new RandomAccessFile(new File(this.cartridgeName), "r");
            byte[] rom = new byte[(int)fs.length()];
            if (rom.length % 1024 != 0) {
                fs.skipBytes(512);
            }
            fs.read(rom);
            fs.close();
            this.loadNormal(rom);
            File save = new File("save" + File.separator + this.cartridgeName.substring(this.cartridgeName.lastIndexOf(File.separator) + 1, this.cartridgeName.lastIndexOf(".")) + ".save");
            if (save.exists()) {
                fs = new RandomAccessFile(save, "r");
                byte[] ram = new byte[(int)fs.length()];
                fs.read(ram);
                fs.close();
                this.cartram.copy(ram, ram.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void save() {
        if (this.cartridgeName != null) {
            File save = new File("save" + File.separator + this.cartridgeName.substring(this.cartridgeName.lastIndexOf(File.separator) + 1, this.cartridgeName.lastIndexOf(".")) + ".save");
            try {
                RandomAccessFile fs = new RandomAccessFile(save, "rw");
                byte[] ram = this.cartram.data();
                if (ram != null) {
                    fs.write(ram);
                }
                fs.close();
                System.out.println("saved: " + save.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void map_reset() {
        int i = 0;
        while (i < this.page.length) {
            this.page[i].access = this.memory_unmapped;
            this.page[i].offset = 0;
            ++i;
        }
    }

    private void map_xml() {
        for (Mapping m : this.mapping) {
            if (m.memory == null) continue;
            this.map(m.mode, m.banklo & 0xFF, m.bankhi & 0xFF, m.addrlo & 0xFFFF, m.addrhi & 0xFFFF, m.memory, m.offset, m.size);
        }
    }

    private void parse_xml(String[] list) {
        this.mapping.clear();
        this.parse_xml_cartridge(list[0]);
    }

    private void parse_xml_cartridge(String data) {
        Element node;
        Document document;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = db.parse(new InputSource(new ByteArrayInputStream(data.getBytes("utf-8"))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (!document.hasChildNodes()) {
            return;
        }
        if (document.getElementsByTagName("cartridge").getLength() != 0 && ((Element)document.getElementsByTagName("cartridge").item(0)).hasAttribute("region")) {
            this.region = ((Element)document.getElementsByTagName("cartridge").item(0)).getAttribute("region").equals("NTSC") ? Region.NTSC : Region.PAL;
        }
        NodeList nl = document.getElementsByTagName("rom");
        int i = 0;
        while (i < nl.getLength()) {
            node = (Element)nl.item(i);
            this.xml_parse_rom(node);
            ++i;
        }
        nl = document.getElementsByTagName("ram");
        i = 0;
        while (i < nl.getLength()) {
            node = (Element)nl.item(i);
            this.xml_parse_ram(node);
            ++i;
        }
    }

    private void xml_parse_rom(Element root) {
        NodeList nl = root.getElementsByTagName("map");
        int i = 0;
        while (i < nl.getLength()) {
            Element leaf = (Element)nl.item(i);
            Mapping m = new Mapping(this.cartrom);
            if (leaf.hasAttribute("address")) {
                this.xml_parse_address(m, leaf.getAttribute("address"));
            }
            if (leaf.hasAttribute("mode")) {
                this.xml_parse_mode(m, leaf.getAttribute("mode"));
            }
            if (leaf.hasAttribute("offset")) {
                m.offset = Integer.parseInt(leaf.getAttribute("offset"), 16);
            }
            if (leaf.hasAttribute("size")) {
                m.size = Integer.parseInt(leaf.getAttribute("size"), 16);
            }
            this.mapping.add(m);
            ++i;
        }
    }

    private void xml_parse_ram(Element root) {
        if (root.hasAttribute("size")) {
            this.ram_size = Integer.parseInt(root.getAttribute("size"), 16);
        }
        NodeList nl = root.getElementsByTagName("map");
        int i = 0;
        while (i < nl.getLength()) {
            Element leaf = (Element)nl.item(i);
            Mapping m = new Mapping(this.cartram);
            if (leaf.hasAttribute("address")) {
                this.xml_parse_address(m, leaf.getAttribute("address"));
            }
            if (leaf.hasAttribute("mode")) {
                this.xml_parse_mode(m, leaf.getAttribute("mode"));
            }
            if (leaf.hasAttribute("offset")) {
                m.offset = Integer.parseInt(leaf.getAttribute("offset"), 16);
            }
            if (leaf.hasAttribute("size")) {
                m.size = Integer.parseInt(leaf.getAttribute("size"), 16);
            }
            this.mapping.add(m);
            ++i;
        }
    }

    private void xml_parse_address(Mapping m, String data) {
        String[] part = data.split(":");
        if (part.length != 2) {
            return;
        }
        String[] subpart = part[0].split("-");
        if (subpart.length == 1) {
            m.bankhi = m.banklo = Integer.parseInt(subpart[0], 16);
        } else if (subpart.length == 2) {
            m.banklo = Integer.parseInt(subpart[0], 16);
            m.bankhi = Integer.parseInt(subpart[1], 16);
        }
        subpart = part[1].split("-");
        if (subpart.length == 1) {
            m.addrhi = m.addrlo = Integer.parseInt(subpart[0], 16);
        } else if (subpart.length == 2) {
            m.addrlo = Integer.parseInt(subpart[0], 16);
            m.addrhi = Integer.parseInt(subpart[1], 16);
        }
    }

    private void xml_parse_mode(Mapping m, String data) {
        if (data.equals("direct")) {
            m.mode = MapMode.Direct;
        } else if (data.equals("linear")) {
            m.mode = MapMode.Linear;
        } else if (data.equals("shadow")) {
            m.mode = MapMode.Shadow;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int mirror(int addr, int size) {
        block3: {
            base_ = 0;
            if (size == 0) break block3;
            mask = 0x800000;
            ** GOTO lbl13
            {
                mask >>= 1;
                do {
                    if ((addr & mask) == 0) continue block0;
                    addr -= mask;
                    if (size > mask) {
                        size -= mask;
                        base_ += mask;
                    }
                    mask >>= 1;
lbl13:
                    // 2 sources

                } while (addr >= size);
            }
            base_ += addr;
        }
        return base_;
    }

    private void map(int addr, Bus8bit access, int offset) {
        Page p = this.page[addr >> 8];
        p.access = access;
        p.offset = offset - addr;
    }

    private void map(MapMode mode, int bank_lo, int bank_hi, int addr_lo, int addr_hi, MappedRAM access, int offset, int size) {
        assert (bank_lo <= bank_hi);
        assert (addr_lo <= addr_hi);
        if (access.size() == -1) {
            return;
        }
        int page_lo = addr_lo >> 8 & 0xFF;
        int page_hi = addr_hi >> 8 & 0xFF;
        int index = 0;
        switch (mode) {
            case Direct: {
                int bank = bank_lo;
                while (bank <= bank_hi) {
                    int page = page_lo;
                    while (page <= page_hi) {
                        this.map((bank << 16) + (page << 8), access, (bank << 16) + (page << 8));
                        ++page;
                    }
                    ++bank;
                }
                break;
            }
            case Linear: {
                int bank = bank_lo;
                while (bank <= bank_hi) {
                    int page = page_lo;
                    while (page <= page_hi) {
                        this.map((bank << 16) + (page << 8), access, this.mirror(offset + index, access.size()));
                        index += 256;
                        if (size != 0) {
                            index %= size;
                        }
                        ++page;
                    }
                    ++bank;
                }
                break;
            }
            case Shadow: {
                int bank = bank_lo;
                while (bank <= bank_hi) {
                    index += page_lo * 256;
                    if (size != 0) {
                        index %= size;
                    }
                    int page = page_lo;
                    while (page <= page_hi) {
                        this.map((bank << 16) + (page << 8), access, this.mirror(offset + index, access.size()));
                        index += 256;
                        if (size != 0) {
                            index %= size;
                        }
                        ++page;
                    }
                    index += (255 - page_hi) * 256;
                    if (size != 0) {
                        index %= size;
                    }
                    ++bank;
                }
                break;
            }
        }
    }

    public static enum MapMode {
        Direct,
        Linear,
        Shadow;

    }

    public static enum Mode {
        Normal,
        BsxSlotted,
        Bsx,
        SufamiTurbo,
        SuperGameBoy;

    }

    class Page {
        public Bus8bit access;
        public int offset;

        Page() {
            this.access = Cartridge.this.memory_unmapped;
        }
    }

    public static enum Region {
        NTSC,
        PAL;

    }

    class UnmappedMemory
    implements Bus8bit {
        UnmappedMemory() {
        }

        public byte read8bit(int addr) {
            return 0;
        }

        public void write8bit(int addr, byte data) {
        }
    }
}

