/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.input;

import jario.hardware.Bus16bit;
import jario.hardware.Bus8bit;
import jario.hardware.Clockable;
import jario.hardware.Hardware;
import jario.snes.input.Port;

public class Input
implements Hardware,
Clockable,
Bus8bit {
    private Bus16bit input0;
    public static final int MouseID_X = 0;
    public static final int MouseID_Y = 1;
    public static final int MouseID_Left = 2;
    public static final int MouseID_Right = 3;
    public static final int SuperScopeID_X = 0;
    public static final int SuperScopeID_Y = 1;
    public static final int SuperScopeID_Trigger = 2;
    public static final int SuperScopeID_Cursor = 3;
    public static final int SuperScopeID_Turbo = 4;
    public static final int SuperScopeID_Pause = 5;
    public static final int JustifierID_X = 0;
    public static final int JustifierID_Y = 1;
    public static final int JustifierID_Trigger = 2;
    public static final int JustifierID_Start = 3;
    private boolean joypad_strobe_latch;
    private Port[] port = new Port[2];

    public void connect(int port, Hardware hw) {
        switch (port) {
            case 0: {
                this.input0 = (Bus16bit)hw;
                this.port_set_device(0, Device.Joypad);
                break;
            }
            case 1: {
                this.port_set_device(1, Device.Joypad);
            }
        }
    }

    public void reset() {
        this.joypad_strobe_latch = false;
    }

    public byte read8bit(int portnumber) {
        Port p = this.port[portnumber];
        switch (p.device) {
            case Joypad: {
                if (!this.joypad_strobe_latch) {
                    if (p.counter0 >= 16) {
                        return 1;
                    }
                    return (byte)((this.input0.read16bit(portnumber * 4) & 1 << p.counter0++) != 0 ? 1 : 0);
                }
                return (byte)((this.input0.read16bit(portnumber * 4) & 1) != 0 ? 1 : 0);
            }
            case Multitap: 
            case Mouse: {
                return 0;
            }
            case SuperScope: {
                return 0;
            }
            case Justifier: 
            case Justifiers: {
                return 0;
            }
            case None: {
                return 0;
            }
        }
        return 0;
    }

    public void write8bit(int port, byte data) {
        if (port == 0) {
            boolean new_latch;
            boolean old_latch = this.joypad_strobe_latch;
            this.joypad_strobe_latch = new_latch = (data & 1) != 0;
            if (old_latch != new_latch) {
                this.poll();
            }
        } else {
            this.poll();
        }
    }

    private void port_set_device(int portnumber, Device device) {
        Port p = this.port[portnumber];
        p.device = device;
        p.counter0 = 0;
        p.counter1 = 0;
    }

    private void init() {
    }

    private void poll() {
        this.port[0].counter0 = 0;
        this.port[0].counter1 = 0;
        this.port[1].counter0 = 0;
        this.port[1].counter1 = 0;
        this.port[1].justifier.active = !this.port[1].justifier.active;
    }

    public void clock(long clocks) {
    }

    public Input() {
        int i = 0;
        while (i < this.port.length) {
            this.port[i] = new Port();
            ++i;
        }
        this.init();
    }

    public static enum Device {
        None,
        Joypad,
        Multitap,
        Mouse,
        SuperScope,
        Justifier,
        Justifiers;

    }
}

