/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.cartridge;

import jario.hardware.Bus8bit;
import jario.hardware.Hardware;

public class MappedRAM
implements Hardware,
Bus8bit {
    private byte[] data_;
    private int size_;
    private boolean write_protect_;

    public MappedRAM() {
        this.reset();
    }

    public void connect(int port, Hardware hw) {
    }

    public void reset() {
        if (this.data_ != null) {
            this.data_ = null;
        }
        this.size_ = -1;
        this.write_protect_ = false;
    }

    public byte read8bit(int addr) {
        return this.data_[addr];
    }

    public void write8bit(int addr, byte n) {
        if (!this.write_protect_) {
            this.data_[addr] = n;
        }
    }

    void map(byte[] source, int length) {
        this.reset();
        this.data_ = source;
        this.size_ = this.data_ != null && length > 0 ? length : -1;
    }

    void copy(byte[] data, int size) {
        if (this.data_ == null) {
            this.size_ = (size & 0xFFFFFF00) + (((size & 0xFF) != 0 ? 1 : 0) << 8);
            this.data_ = new byte[this.size_];
        }
        System.arraycopy(data, 0, this.data_, 0, Math.min(this.size_, size));
    }

    void write_protect(boolean status) {
        this.write_protect_ = status;
    }

    byte[] data() {
        return this.data_;
    }

    int size() {
        return this.size_;
    }
}

