/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.cartridge;

public class SnesInformation {
    public String xml_memory_map;
    public static final int HeaderField_CartName = 0;
    public static final int HeaderField_Mapper = 21;
    public static final int HeaderField_RomType = 22;
    public static final int HeaderField_RomSize = 23;
    public static final int HeaderField_RamSize = 24;
    public static final int HeaderField_CartRegion = 25;
    public static final int HeaderField_Company = 26;
    public static final int HeaderField_Version = 27;
    public static final int HeaderField_Complement = 28;
    public static final int HeaderField_Checksum = 30;
    public static final int HeaderField_ResetVector = 60;
    private int rom_size;
    private int ram_size;
    private Region region;
    private MemoryMapper mapper;

    public SnesInformation(byte[] data, int size) {
        this.read_header(data, size);
        String xml = "<?xml version='1.0' encoding='UTF-8'?>\n";
        xml = String.valueOf(xml) + "<cartridge";
        xml = this.region == Region.NTSC ? String.valueOf(xml) + " region='NTSC'" : String.valueOf(xml) + " region='PAL'";
        xml = String.valueOf(xml) + ">\n";
        if (this.mapper == MemoryMapper.LoROM) {
            xml = String.valueOf(xml) + "  <rom>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='00-7f:8000-ffff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='80-ff:8000-ffff'/>\n";
            xml = String.valueOf(xml) + "  </rom>\n";
            if (this.ram_size > 0) {
                xml = String.valueOf(xml) + "  <ram size='" + Integer.toHexString(this.ram_size) + "'>\n";
                xml = String.valueOf(xml) + "    <map mode='linear' address='20-3f:6000-7fff'/>\n";
                xml = String.valueOf(xml) + "    <map mode='linear' address='a0-bf:6000-7fff'/>\n";
                if (this.rom_size > 0x200000 || this.ram_size > 32768) {
                    xml = String.valueOf(xml) + "    <map mode='linear' address='70-7f:0000-7fff'/>\n";
                    xml = String.valueOf(xml) + "    <map mode='linear' address='f0-ff:0000-7fff'/>\n";
                } else {
                    xml = String.valueOf(xml) + "    <map mode='linear' address='70-7f:0000-ffff'/>\n";
                    xml = String.valueOf(xml) + "    <map mode='linear' address='f0-ff:0000-ffff'/>\n";
                }
                xml = String.valueOf(xml) + "  </ram>\n";
            }
        } else if (this.mapper == MemoryMapper.HiROM) {
            xml = String.valueOf(xml) + "  <rom>\n";
            xml = String.valueOf(xml) + "    <map mode='shadow' address='00-3f:8000-ffff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='40-7f:0000-ffff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='shadow' address='80-bf:8000-ffff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='c0-ff:0000-ffff'/>\n";
            xml = String.valueOf(xml) + "  </rom>\n";
            if (this.ram_size > 0) {
                xml = String.valueOf(xml) + "  <ram size='" + Integer.toHexString(this.ram_size) + "'>\n";
                xml = String.valueOf(xml) + "    <map mode='linear' address='20-3f:6000-7fff'/>\n";
                xml = String.valueOf(xml) + "    <map mode='linear' address='a0-bf:6000-7fff'/>\n";
                xml = this.rom_size > 0x200000 || this.ram_size > 32768 ? String.valueOf(xml) + "    <map mode='linear' address='70-7f:0000-7fff'/>\n" : String.valueOf(xml) + "    <map mode='linear' address='70-7f:0000-ffff'/>\n";
                xml = String.valueOf(xml) + "  </ram>\n";
            }
        } else if (this.mapper == MemoryMapper.ExLoROM) {
            xml = String.valueOf(xml) + "  <rom>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='00-3f:8000-ffff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='40-7f:0000-ffff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='80-bf:8000-ffff'/>\n";
            xml = String.valueOf(xml) + "  </rom>\n";
            if (this.ram_size > 0) {
                xml = String.valueOf(xml) + "  <ram size='" + Integer.toHexString(this.ram_size) + "'>\n";
                xml = String.valueOf(xml) + "    <map mode='linear' address='20-3f:6000-7fff'/>\n";
                xml = String.valueOf(xml) + "    <map mode='linear' address='a0-bf:6000-7fff'/>\n";
                xml = String.valueOf(xml) + "    <map mode='linear' address='70-7f:0000-7fff'/>\n";
                xml = String.valueOf(xml) + "  </ram>\n";
            }
        } else if (this.mapper == MemoryMapper.ExHiROM) {
            xml = String.valueOf(xml) + "  <rom>\n";
            xml = String.valueOf(xml) + "    <map mode='shadow' address='00-3f:8000-ffff' offset='400000'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='40-7f:0000-ffff' offset='400000'/>\n";
            xml = String.valueOf(xml) + "    <map mode='shadow' address='80-bf:8000-ffff' offset='000000'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='c0-ff:0000-ffff' offset='000000'/>\n";
            xml = String.valueOf(xml) + "  </rom>\n";
            if (this.ram_size > 0) {
                xml = String.valueOf(xml) + "  <ram size='" + Integer.toHexString(this.ram_size) + "'>\n";
                xml = String.valueOf(xml) + "    <map mode='linear' address='20-3f:6000-7fff'/>\n";
                xml = String.valueOf(xml) + "    <map mode='linear' address='a0-bf:6000-7fff'/>\n";
                xml = this.rom_size > 0x200000 || this.ram_size > 32768 ? String.valueOf(xml) + "    <map mode='linear' address='70-7f:0000-7fff'/>\n" : String.valueOf(xml) + "    <map mode='linear' address='70-7f:0000-ffff'/>\n";
                xml = String.valueOf(xml) + "  </ram>\n";
            }
        } else if (this.mapper == MemoryMapper.BSCLoROM) {
            xml = String.valueOf(xml) + "  <rom>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='00-1f:8000-ffff' offset='000000'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='20-3f:8000-ffff' offset='100000'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='80-9f:8000-ffff' offset='200000'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='a0-bf:8000-ffff' offset='100000'/>\n";
            xml = String.valueOf(xml) + "  </rom>\n";
            xml = String.valueOf(xml) + "  <ram size='" + Integer.toHexString(this.ram_size) + "'>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='70-7f:0000-7fff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='f0-ff:0000-7fff'/>\n";
            xml = String.valueOf(xml) + "  </ram>\n";
            xml = String.valueOf(xml) + "  <bsx>\n";
            xml = String.valueOf(xml) + "    <slot>\n";
            xml = String.valueOf(xml) + "      <map mode='linear' address='c0-ef:0000-ffff'/>\n";
            xml = String.valueOf(xml) + "    </slot>\n";
            xml = String.valueOf(xml) + "  </bsx>\n";
        } else if (this.mapper == MemoryMapper.BSCHiROM) {
            xml = String.valueOf(xml) + "  <rom>\n";
            xml = String.valueOf(xml) + "    <map mode='shadow' address='00-1f:8000-ffff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='40-5f:0000-ffff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='shadow' address='80-9f:8000-ffff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='c0-df:0000-ffff'/>\n";
            xml = String.valueOf(xml) + "  </rom>\n";
            xml = String.valueOf(xml) + "  <ram size='" + Integer.toHexString(this.ram_size) + "'>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='20-3f:6000-7fff'/>\n";
            xml = String.valueOf(xml) + "    <map mode='linear' address='a0-bf:6000-7fff'/>\n";
            xml = String.valueOf(xml) + "  </ram>\n";
            xml = String.valueOf(xml) + "  <bsx>\n";
            xml = String.valueOf(xml) + "    <slot>\n";
            xml = String.valueOf(xml) + "      <map mode='shadow' address='20-3f:8000-ffff'/>\n";
            xml = String.valueOf(xml) + "      <map mode='linear' address='60-7f:0000-ffff'/>\n";
            xml = String.valueOf(xml) + "      <map mode='shadow' address='a0-bf:8000-ffff'/>\n";
            xml = String.valueOf(xml) + "      <map mode='linear' address='e0-ff:0000-ffff'/>\n";
            xml = String.valueOf(xml) + "    </slot>\n";
            xml = String.valueOf(xml) + "  </bsx>\n";
        }
        this.xml_memory_map = xml = String.valueOf(xml) + "</cartridge>\n";
    }

    private void read_header(byte[] data, int size) {
        this.mapper = MemoryMapper.LoROM;
        this.region = Region.NTSC;
        this.rom_size = size;
        this.ram_size = 0;
        int index = this.find_header(data, size);
        int mapperid = data[index + 21] & 0xFF;
        this.rom_size = data[index + 23];
        int regionid = data[index + 25] & 0x7F;
        this.ram_size = 1024 << (data[index + 24] & 7);
        if (this.ram_size == 1024) {
            this.ram_size = 0;
        }
        Region region = this.region = regionid <= 1 || regionid >= 13 ? Region.NTSC : Region.PAL;
        this.mapper = index == 32704 && size >= 0x401000 ? MemoryMapper.ExLoROM : (index == 32704 && mapperid == 50 ? MemoryMapper.ExLoROM : (index == 32704 ? MemoryMapper.LoROM : (index == 65472 ? MemoryMapper.HiROM : MemoryMapper.ExHiROM)));
    }

    private int find_header(byte[] data, int size) {
        int score_lo = this.score_header(data, size, 32704);
        int score_hi = this.score_header(data, size, 65472);
        int score_ex = this.score_header(data, size, 4259776);
        if (score_ex != 0) {
            score_ex += 4;
        }
        if (score_lo >= score_hi && score_lo >= score_ex) {
            return 32704;
        }
        if (score_hi >= score_ex) {
            return 65472;
        }
        return 4259776;
    }

    private int score_header(byte[] data, int size, int addr) {
        if (size < addr + 64) {
            return 0;
        }
        int score = 0;
        int resetvector = data[addr + 60] & 0xFF | (data[addr + 60 + 1] & 0xFF) << 8;
        int checksum = data[addr + 30] & 0xFF | (data[addr + 30 + 1] & 0xFF) << 8;
        int complement = data[addr + 28] & 0xFF | (data[addr + 28 + 1] & 0xFF) << 8;
        int resetop = data[addr & 0xFFFF & Short.MIN_VALUE | resetvector & Short.MAX_VALUE] & 0xFF;
        int mapper = data[addr + 21] & 0xFFFFFFEF & 0xFF;
        if (resetvector < 32768) {
            return 0;
        }
        if (resetop == 120 || resetop == 24 || resetop == 56 || resetop == 156 || resetop == 76 || resetop == 92) {
            score += 8;
        }
        if (resetop == 194 || resetop == 226 || resetop == 173 || resetop == 174 || resetop == 172 || resetop == 175 || resetop == 169 || resetop == 162 || resetop == 160 || resetop == 32 || resetop == 34) {
            score += 4;
        }
        if (resetop == 64 || resetop == 96 || resetop == 107 || resetop == 205 || resetop == 236 || resetop == 204) {
            score -= 4;
        }
        if (resetop == 0 || resetop == 2 || resetop == 219 || resetop == 66 || resetop == 255) {
            score -= 8;
        }
        if (checksum + complement == 65535 && checksum != 0 && complement != 0) {
            score += 4;
        }
        if (addr == 32704 && mapper == 32) {
            score += 2;
        }
        if (addr == 65472 && mapper == 33) {
            score += 2;
        }
        if (addr == 32704 && mapper == 34) {
            score += 2;
        }
        if (addr == 4259776 && mapper == 37) {
            score += 2;
        }
        if (data[addr + 26] == 51) {
            score += 2;
        }
        if (data[addr + 22] < 8) {
            ++score;
        }
        if (data[addr + 23] < 16) {
            ++score;
        }
        if (data[addr + 24] < 8) {
            ++score;
        }
        if (data[addr + 25] < 14) {
            ++score;
        }
        if (score < 0) {
            score = 0;
        }
        return score;
    }

    private static enum MemoryMapper {
        LoROM,
        HiROM,
        ExLoROM,
        ExHiROM,
        SuperFXROM,
        SA1ROM,
        SPC7110ROM,
        BSCLoROM,
        BSCHiROM,
        BSXROM,
        STROM;

    }

    private static enum Region {
        NTSC,
        PAL;

    }
}

