/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.ppu;

import jario.snes.performance.ppu.PPU;
import java.nio.ByteBuffer;

public class Cache {
    private ByteBuffer tiledata0;
    private ByteBuffer tiledata1;
    private ByteBuffer tiledata2;
    byte[][] tilevalid = new byte[3][];
    private PPU self;

    private static final void render_line_2(byte[] output, int output_offset, int d0, int d1, int mask) {
        int color = ((d0 & mask) != 0 ? 1 : 0) << 0;
        output[output_offset] = (byte)(color |= ((d1 & mask) != 0 ? 1 : 0) << 1);
    }

    private static final void render_line_4(byte[] output, int output_offset, int d0, int d1, int d2, int d3, int mask) {
        int color = ((d0 & mask) != 0 ? 1 : 0) << 0;
        color |= ((d1 & mask) != 0 ? 1 : 0) << 1;
        color |= ((d2 & mask) != 0 ? 1 : 0) << 2;
        output[output_offset] = (byte)(color |= ((d3 & mask) != 0 ? 1 : 0) << 3);
    }

    private static final void render_line_8(byte[] output, int output_offset, int d0, int d1, int d2, int d3, int d4, int d5, int d6, int d7, int mask) {
        int color = ((d0 & mask) != 0 ? 1 : 0) << 0;
        color |= ((d1 & mask) != 0 ? 1 : 0) << 1;
        color |= ((d2 & mask) != 0 ? 1 : 0) << 2;
        color |= ((d3 & mask) != 0 ? 1 : 0) << 3;
        color |= ((d4 & mask) != 0 ? 1 : 0) << 4;
        color |= ((d5 & mask) != 0 ? 1 : 0) << 5;
        color |= ((d6 & mask) != 0 ? 1 : 0) << 6;
        output[output_offset] = (byte)(color |= ((d7 & mask) != 0 ? 1 : 0) << 7);
    }

    ByteBuffer tile_2bpp(int tile) {
        if (this.tilevalid[0][tile] == 0) {
            this.tilevalid[0][tile] = 1;
            byte[] output = this.tiledata0.array();
            int output_offset = tile << 6;
            int offset = tile << 4;
            int y = 8;
            while (y-- != 0) {
                int d0 = this.self.vram[offset + 0];
                int d1 = this.self.vram[offset + 1];
                Cache.render_line_2(output, output_offset++, d0, d1, 128);
                Cache.render_line_2(output, output_offset++, d0, d1, 64);
                Cache.render_line_2(output, output_offset++, d0, d1, 32);
                Cache.render_line_2(output, output_offset++, d0, d1, 16);
                Cache.render_line_2(output, output_offset++, d0, d1, 8);
                Cache.render_line_2(output, output_offset++, d0, d1, 4);
                Cache.render_line_2(output, output_offset++, d0, d1, 2);
                Cache.render_line_2(output, output_offset++, d0, d1, 1);
                offset += 2;
            }
        }
        this.tiledata0.position(tile << 6);
        return this.tiledata0;
    }

    ByteBuffer tile_4bpp(int tile) {
        if (this.tilevalid[1][tile] == 0) {
            this.tilevalid[1][tile] = 1;
            byte[] output = this.tiledata1.array();
            int output_offset = tile << 6;
            int offset = tile << 5;
            int y = 8;
            while (y-- != 0) {
                int d0 = this.self.vram[offset + 0];
                int d1 = this.self.vram[offset + 1];
                int d2 = this.self.vram[offset + 16];
                int d3 = this.self.vram[offset + 17];
                Cache.render_line_4(output, output_offset++, d0, d1, d2, d3, 128);
                Cache.render_line_4(output, output_offset++, d0, d1, d2, d3, 64);
                Cache.render_line_4(output, output_offset++, d0, d1, d2, d3, 32);
                Cache.render_line_4(output, output_offset++, d0, d1, d2, d3, 16);
                Cache.render_line_4(output, output_offset++, d0, d1, d2, d3, 8);
                Cache.render_line_4(output, output_offset++, d0, d1, d2, d3, 4);
                Cache.render_line_4(output, output_offset++, d0, d1, d2, d3, 2);
                Cache.render_line_4(output, output_offset++, d0, d1, d2, d3, 1);
                offset += 2;
            }
        }
        this.tiledata1.position(tile << 6);
        return this.tiledata1;
    }

    ByteBuffer tile_8bpp(int tile) {
        if (this.tilevalid[2][tile] == 0) {
            this.tilevalid[2][tile] = 1;
            byte[] output = this.tiledata2.array();
            int output_offset = tile << 6;
            int offset = tile << 6;
            int y = 8;
            while (y-- != 0) {
                int d0 = this.self.vram[offset + 0];
                int d1 = this.self.vram[offset + 1];
                int d2 = this.self.vram[offset + 16];
                int d3 = this.self.vram[offset + 17];
                int d4 = this.self.vram[offset + 32];
                int d5 = this.self.vram[offset + 33];
                int d6 = this.self.vram[offset + 48];
                int d7 = this.self.vram[offset + 49];
                Cache.render_line_8(output, output_offset++, d0, d1, d2, d3, d4, d5, d6, d7, 128);
                Cache.render_line_8(output, output_offset++, d0, d1, d2, d3, d4, d5, d6, d7, 64);
                Cache.render_line_8(output, output_offset++, d0, d1, d2, d3, d4, d5, d6, d7, 32);
                Cache.render_line_8(output, output_offset++, d0, d1, d2, d3, d4, d5, d6, d7, 16);
                Cache.render_line_8(output, output_offset++, d0, d1, d2, d3, d4, d5, d6, d7, 8);
                Cache.render_line_8(output, output_offset++, d0, d1, d2, d3, d4, d5, d6, d7, 4);
                Cache.render_line_8(output, output_offset++, d0, d1, d2, d3, d4, d5, d6, d7, 2);
                Cache.render_line_8(output, output_offset++, d0, d1, d2, d3, d4, d5, d6, d7, 1);
                offset += 2;
            }
        }
        this.tiledata2.position(tile << 6);
        return this.tiledata2;
    }

    ByteBuffer tile(int bpp, int tile) {
        switch (bpp) {
            case 0: {
                return this.tile_2bpp(tile);
            }
            case 1: {
                return this.tile_4bpp(tile);
            }
        }
        return this.tile_8bpp(tile);
    }

    public Cache(PPU self) {
        this.self = self;
        this.tiledata0 = ByteBuffer.allocate(262144);
        this.tiledata1 = ByteBuffer.allocate(131072);
        this.tiledata2 = ByteBuffer.allocate(65536);
        this.tilevalid[0] = new byte[4096];
        this.tilevalid[1] = new byte[2048];
        this.tilevalid[2] = new byte[1024];
    }
}

