/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.ppu;

import jario.snes.performance.ppu.PPU;
import java.util.Arrays;

public class ColorWindow {
    public boolean one_enable;
    public boolean one_invert;
    public boolean two_enable;
    public boolean two_invert;
    public int mask;
    public int main_mask;
    public int sub_mask;
    public int[] main = new int[256];
    public int[] sub = new int[256];

    public void render(boolean screen) {
        int[] output = !screen ? this.main : this.sub;
        boolean set = true;
        boolean clr = false;
        switch (!screen ? this.main_mask : this.sub_mask) {
            case 0: {
                Arrays.fill(output, 1);
                return;
            }
            case 1: {
                set = true;
                clr = false;
                break;
            }
            case 2: {
                set = false;
                clr = true;
                break;
            }
            case 3: {
                Arrays.fill(output, 0);
                return;
            }
        }
        if (!this.one_enable && !this.two_enable) {
            Arrays.fill(output, clr ? 1 : 0);
            return;
        }
        if (this.one_enable && !this.two_enable) {
            if (this.one_invert) {
                set ^= true;
                clr ^= true;
            }
            int x = 0;
            while (x < 256) {
                output[x] = (x >= PPU.ppu.regs.window_one_left && x <= PPU.ppu.regs.window_one_right ? set : clr) ? 1 : 0;
                ++x;
            }
            return;
        }
        if (!this.one_enable && this.two_enable) {
            if (this.two_invert) {
                set ^= true;
                clr ^= true;
            }
            int x = 0;
            while (x < 256) {
                output[x] = (x >= PPU.ppu.regs.window_two_left && x <= PPU.ppu.regs.window_two_right ? set : clr) ? 1 : 0;
                ++x;
            }
            return;
        }
        int x = 0;
        while (x < 256) {
            boolean one_mask = (x >= PPU.ppu.regs.window_one_left && x <= PPU.ppu.regs.window_one_right) ^ this.one_invert;
            boolean two_mask = (x >= PPU.ppu.regs.window_two_left && x <= PPU.ppu.regs.window_two_right) ^ this.two_invert;
            switch (this.mask) {
                case 0: {
                    output[x] = (one_mask | two_mask ? set : clr) ? 1 : 0;
                    break;
                }
                case 1: {
                    output[x] = (one_mask & two_mask ? set : clr) ? 1 : 0;
                    break;
                }
                case 2: {
                    output[x] = (one_mask ^ two_mask ? set : clr) ? 1 : 0;
                    break;
                }
                case 3: {
                    output[x] = (one_mask ^ !two_mask ? set : clr) ? 1 : 0;
                }
            }
            ++x;
        }
    }
}

