/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.ppu;

import jario.snes.performance.ppu.PPU;
import java.util.Arrays;

public class LayerWindow {
    public boolean one_enable;
    public boolean one_invert;
    public boolean two_enable;
    public boolean two_invert;
    public int mask;
    public boolean main_enable;
    public boolean sub_enable;
    public int[] main = new int[256];
    public int[] sub = new int[256];

    public void render(boolean screen) {
        int[] output;
        if (!screen) {
            output = this.main;
            if (!this.main_enable) {
                Arrays.fill(output, 0);
                return;
            }
        } else {
            output = this.sub;
            if (!this.sub_enable) {
                Arrays.fill(output, 0);
                return;
            }
        }
        if (!this.one_enable && !this.two_enable) {
            Arrays.fill(output, 0);
            return;
        }
        if (this.one_enable && !this.two_enable) {
            boolean set = true ^ this.one_invert;
            boolean clr = !set;
            int x = 0;
            while (x < 256) {
                output[x] = (x >= PPU.ppu.regs.window_one_left && x <= PPU.ppu.regs.window_one_right ? set : clr) ? 1 : 0;
                ++x;
            }
            return;
        }
        if (!this.one_enable && this.two_enable) {
            boolean set = true ^ this.two_invert;
            boolean clr = !set;
            int x = 0;
            while (x < 256) {
                output[x] = (x >= PPU.ppu.regs.window_two_left && x <= PPU.ppu.regs.window_two_right ? set : clr) ? 1 : 0;
                ++x;
            }
            return;
        }
        int x = 0;
        while (x < 256) {
            boolean one_mask = (x >= PPU.ppu.regs.window_one_left && x <= PPU.ppu.regs.window_one_right) ^ this.one_invert;
            boolean two_mask = (x >= PPU.ppu.regs.window_two_left && x <= PPU.ppu.regs.window_two_right) ^ this.two_invert;
            switch (this.mask) {
                case 0: {
                    output[x] = one_mask | two_mask ? 1 : 0;
                    break;
                }
                case 1: {
                    output[x] = one_mask & two_mask ? 1 : 0;
                    break;
                }
                case 2: {
                    output[x] = one_mask ^ two_mask ? 1 : 0;
                    break;
                }
                case 3: {
                    output[x] = one_mask ^ !two_mask ? 1 : 0;
                }
            }
            ++x;
        }
    }
}

