/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.ppu;

import jario.hardware.Bus1bit;
import jario.hardware.Bus8bit;
import jario.hardware.BusDMA;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.snes.performance.ppu.Background;
import jario.snes.performance.ppu.Cache;
import jario.snes.performance.ppu.Display;
import jario.snes.performance.ppu.HVCounter;
import jario.snes.performance.ppu.Regs;
import jario.snes.performance.ppu.Screen;
import jario.snes.performance.ppu.Sprite;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PPU
implements Hardware,
Clockable,
Bus1bit,
Bus8bit,
BusDMA,
Configurable {
    public static final int NTSC = 0;
    public static final int PAL = 1;
    static PPU ppu;
    private long clock;
    private int region;
    int[] vram;
    int[] oam;
    int[] cgram;
    ByteBuffer output;
    Regs regs = new Regs();
    Cache cache;
    Background bg1;
    Background bg2;
    Background bg3;
    Background bg4;
    Sprite sprite;
    Screen screen;
    Display display;
    private HVCounter cpuCounter;
    HVCounter ppuCounter;

    public void connect(int port, Hardware hw) {
    }

    private void step(int clocks) {
        this.clock += (long)clocks;
    }

    private void synchronize_cpu() {
    }

    private void latch_counters() {
        this.regs.hcounter = this.cpuCounter.hdot() & 0xFFFF;
        this.regs.vcounter = this.cpuCounter.vcounter() & 0xFFFF;
        this.regs.counters_latched = true;
    }

    public boolean read1bit(int address) {
        switch (address) {
            case 0: {
                return this.interlace();
            }
            case 1: {
                return this.overscan();
            }
            case 2: {
                return this.hires();
            }
            case 3: {
                return this.ppuCounter.field();
            }
        }
        return false;
    }

    public void write1bit(int address, boolean data) {
        switch (address) {
            case 29: {
                if (this.display.latch != 0 && !data) {
                    this.latch_counters();
                }
                this.display.latch = data ? 1 : 0;
            }
        }
    }

    boolean interlace() {
        return this.display.interlace;
    }

    boolean overscan() {
        return this.display.overscan;
    }

    boolean hires() {
        return this.regs.pseudo_hires || this.regs.bgmode == 5 || this.regs.bgmode == 6;
    }

    public void clock(long clocks) {
        this.clock -= clocks;
        this.cpuCounter.tick((int)clocks);
        while (this.clock < 0L) {
            this.scanline();
            if (this.ppuCounter.vcounter() < this.display.height && this.ppuCounter.vcounter() != 0) {
                this.add_clocks(512);
                this.render_scanline();
                this.add_clocks(this.ppuCounter.lineclocks() - 512);
                continue;
            }
            this.add_clocks(this.ppuCounter.lineclocks());
        }
    }

    private void power() {
        Arrays.fill(this.vram, 0);
        Arrays.fill(this.oam, 0);
        Arrays.fill(this.cgram, 0);
        this.reset();
    }

    public void reset() {
        this.clock = 0L;
        this.ppuCounter.reset();
        this.cpuCounter.reset();
        Arrays.fill(this.output.array(), (byte)0);
        this.mmio_reset();
        if (this.display != null) {
            this.display.interlace = false;
            this.display.overscan = false;
            this.display.latch = 1;
        }
    }

    private void scanline() {
        this.display.width = !this.hires() ? 256 : 512;
        int n = this.display.height = !this.overscan() ? 225 : 240;
        if (this.ppuCounter.vcounter() == 0) {
            this.frame();
        }
        if (this.ppuCounter.vcounter() == this.display.height && !this.regs.display_disable) {
            this.sprite.address_reset();
        }
    }

    private void frame() {
        this.sprite.frame();
        this.display.interlace = this.regs.interlace;
        this.display.overscan = this.regs.overscan;
    }

    public PPU() {
        ppu = this;
        this.vram = new int[65536];
        this.oam = new int[544];
        this.cgram = new int[512];
        this.cache = new Cache(this);
        this.bg1 = new Background(this, 0);
        this.bg2 = new Background(this, 1);
        this.bg3 = new Background(this, 2);
        this.bg4 = new Background(this, 3);
        this.sprite = new Sprite(this);
        this.screen = new Screen(this);
        this.output = ByteBuffer.allocate(0x200000);
        this.display = new Display();
        this.display.width = 256;
        this.display.height = 224;
        this.display.interlace = false;
        this.display.overscan = false;
        this.display.latch = 1;
        this.cpuCounter = new HVCounter(this);
        this.ppuCounter = new HVCounter(this);
        this.power();
    }

    private int get_vram_addr() {
        int addr = this.regs.vram_addr;
        switch (this.regs.vram_mapping) {
            case 0: {
                break;
            }
            case 1: {
                addr = addr & 0xFF00 | (addr & 0x1F) << 3 | addr >> 5 & 7;
                break;
            }
            case 2: {
                addr = addr & 0xFE00 | (addr & 0x3F) << 3 | addr >> 6 & 7;
                break;
            }
            case 3: {
                addr = addr & 0xFC00 | (addr & 0x7F) << 3 | addr >> 7 & 7;
            }
        }
        return addr << 1 & 0xFFFF;
    }

    private int vram_read(int addr) {
        if (this.regs.display_disable) {
            return this.vram[addr] & 0xFF;
        }
        if (this.cpuCounter.vcounter() >= this.display.height) {
            return this.vram[addr] & 0xFF;
        }
        return 0;
    }

    private void vram_write(int addr, int data) {
        if (this.regs.display_disable || this.cpuCounter.vcounter() >= this.display.height) {
            this.vram[addr] = data & 0xFF;
            this.cache.tilevalid[0][addr >> 4] = 0;
            this.cache.tilevalid[1][addr >> 5] = 0;
            this.cache.tilevalid[2][addr >> 6] = 0;
            return;
        }
    }

    private int oam_read(int addr) {
        if ((addr & 0x200) != 0) {
            addr &= 0x21F;
        }
        if (this.regs.display_disable) {
            return this.oam[addr] & 0xFF;
        }
        if (this.cpuCounter.vcounter() >= this.display.height) {
            return this.oam[addr] & 0xFF;
        }
        return this.oam[536] & 0xFF;
    }

    private void oam_write(int addr, int data) {
        if ((addr & 0x200) != 0) {
            addr &= 0x21F;
        }
        if (!this.regs.display_disable && this.cpuCounter.vcounter() < this.display.height) {
            addr = 536;
        }
        this.oam[addr] = data & 0xFF;
        this.sprite.update_list(addr, data & 0xFF);
    }

    private int cgram_read(int addr) {
        return this.cgram[addr] & 0xFF;
    }

    private void cgram_write(int addr, int data) {
        this.cgram[addr] = data & 0xFF;
    }

    private void mmio_update_video_mode() {
        switch (this.regs.bgmode) {
            case 0: {
                this.bg1.regs.mode = 0;
                this.bg1.regs.priority0 = 8;
                this.bg1.regs.priority1 = 11;
                this.bg2.regs.mode = 0;
                this.bg2.regs.priority0 = 7;
                this.bg2.regs.priority1 = 10;
                this.bg3.regs.mode = 0;
                this.bg3.regs.priority0 = 2;
                this.bg3.regs.priority1 = 5;
                this.bg4.regs.mode = 0;
                this.bg4.regs.priority0 = 1;
                this.bg4.regs.priority1 = 4;
                this.sprite.regs.priority0 = 3;
                this.sprite.regs.priority1 = 6;
                this.sprite.regs.priority2 = 9;
                this.sprite.regs.priority3 = 12;
                break;
            }
            case 1: {
                this.bg1.regs.mode = 1;
                this.bg2.regs.mode = 1;
                this.bg3.regs.mode = 0;
                this.bg4.regs.mode = 4;
                if (this.regs.bg3_priority) {
                    this.bg1.regs.priority0 = 5;
                    this.bg1.regs.priority1 = 8;
                    this.bg2.regs.priority0 = 4;
                    this.bg2.regs.priority1 = 7;
                    this.bg3.regs.priority0 = 1;
                    this.bg3.regs.priority1 = 10;
                    this.sprite.regs.priority0 = 2;
                    this.sprite.regs.priority1 = 3;
                    this.sprite.regs.priority2 = 6;
                    this.sprite.regs.priority3 = 9;
                    break;
                }
                this.bg1.regs.priority0 = 6;
                this.bg1.regs.priority1 = 9;
                this.bg2.regs.priority0 = 5;
                this.bg2.regs.priority1 = 8;
                this.bg3.regs.priority0 = 1;
                this.bg3.regs.priority1 = 3;
                this.sprite.regs.priority0 = 2;
                this.sprite.regs.priority1 = 4;
                this.sprite.regs.priority2 = 7;
                this.sprite.regs.priority3 = 10;
                break;
            }
            case 2: {
                this.bg1.regs.mode = 1;
                this.bg2.regs.mode = 1;
                this.bg3.regs.mode = 4;
                this.bg4.regs.mode = 4;
                this.bg1.regs.priority0 = 3;
                this.bg1.regs.priority1 = 7;
                this.bg2.regs.priority0 = 1;
                this.bg2.regs.priority1 = 5;
                this.sprite.regs.priority0 = 2;
                this.sprite.regs.priority1 = 4;
                this.sprite.regs.priority2 = 6;
                this.sprite.regs.priority3 = 8;
                break;
            }
            case 3: {
                this.bg1.regs.mode = 2;
                this.bg2.regs.mode = 1;
                this.bg3.regs.mode = 4;
                this.bg4.regs.mode = 4;
                this.bg1.regs.priority0 = 3;
                this.bg1.regs.priority1 = 7;
                this.bg2.regs.priority0 = 1;
                this.bg2.regs.priority1 = 5;
                this.sprite.regs.priority0 = 2;
                this.sprite.regs.priority1 = 4;
                this.sprite.regs.priority2 = 6;
                this.sprite.regs.priority3 = 8;
                break;
            }
            case 4: {
                this.bg1.regs.mode = 2;
                this.bg2.regs.mode = 0;
                this.bg3.regs.mode = 4;
                this.bg4.regs.mode = 4;
                this.bg1.regs.priority0 = 3;
                this.bg1.regs.priority1 = 7;
                this.bg2.regs.priority0 = 1;
                this.bg2.regs.priority1 = 5;
                this.sprite.regs.priority0 = 2;
                this.sprite.regs.priority1 = 4;
                this.sprite.regs.priority2 = 6;
                this.sprite.regs.priority3 = 8;
                break;
            }
            case 5: {
                this.bg1.regs.mode = 1;
                this.bg2.regs.mode = 0;
                this.bg3.regs.mode = 4;
                this.bg4.regs.mode = 4;
                this.bg1.regs.priority0 = 3;
                this.bg1.regs.priority1 = 7;
                this.bg2.regs.priority0 = 1;
                this.bg2.regs.priority1 = 5;
                this.sprite.regs.priority0 = 2;
                this.sprite.regs.priority1 = 4;
                this.sprite.regs.priority2 = 6;
                this.sprite.regs.priority3 = 8;
                break;
            }
            case 6: {
                this.bg1.regs.mode = 1;
                this.bg2.regs.mode = 4;
                this.bg3.regs.mode = 4;
                this.bg4.regs.mode = 4;
                this.bg1.regs.priority0 = 2;
                this.bg1.regs.priority1 = 5;
                this.sprite.regs.priority0 = 1;
                this.sprite.regs.priority1 = 3;
                this.sprite.regs.priority2 = 4;
                this.sprite.regs.priority3 = 6;
                break;
            }
            case 7: {
                if (!this.regs.mode7_extbg) {
                    this.bg1.regs.mode = 3;
                    this.bg2.regs.mode = 4;
                    this.bg3.regs.mode = 4;
                    this.bg4.regs.mode = 4;
                    this.bg1.regs.priority0 = 2;
                    this.bg1.regs.priority1 = 2;
                    this.sprite.regs.priority0 = 1;
                    this.sprite.regs.priority1 = 3;
                    this.sprite.regs.priority2 = 4;
                    this.sprite.regs.priority3 = 5;
                    break;
                }
                this.bg1.regs.mode = 3;
                this.bg2.regs.mode = 3;
                this.bg3.regs.mode = 4;
                this.bg4.regs.mode = 4;
                this.bg1.regs.priority0 = 3;
                this.bg1.regs.priority1 = 3;
                this.bg2.regs.priority0 = 1;
                this.bg2.regs.priority1 = 5;
                this.sprite.regs.priority0 = 2;
                this.sprite.regs.priority1 = 4;
                this.sprite.regs.priority2 = 6;
                this.sprite.regs.priority3 = 7;
            }
        }
    }

    public byte read8bit(int addr) {
        switch (addr & 0xFFFF) {
            case 8500: {
                int result = (short)this.regs.m7a * (byte)(this.regs.m7b >> 8);
                this.regs.ppu1_mdr = result >> 0 & 0xFF;
                return (byte)this.regs.ppu1_mdr;
            }
            case 8501: {
                int result = (short)this.regs.m7a * (byte)(this.regs.m7b >> 8);
                this.regs.ppu1_mdr = result >> 8 & 0xFF;
                return (byte)this.regs.ppu1_mdr;
            }
            case 8502: {
                int result = (short)this.regs.m7a * (byte)(this.regs.m7b >> 8);
                this.regs.ppu1_mdr = result >> 16 & 0xFF;
                return (byte)this.regs.ppu1_mdr;
            }
            case 8503: {
                if (this.display.latch != 0) {
                    this.latch_counters();
                }
                return (byte)this.regs.ppu1_mdr;
            }
            case 8504: {
                this.regs.ppu1_mdr = this.oam_read(this.regs.oam_addr) & 0xFF;
                this.regs.oam_addr = this.regs.oam_addr + 1 & 0x3FF;
                this.sprite.set_first();
                return (byte)this.regs.ppu1_mdr;
            }
            case 8505: {
                this.regs.ppu1_mdr = this.regs.vram_readbuffer >> 0 & 0xFF;
                if (!this.regs.vram_incmode) {
                    addr = this.get_vram_addr();
                    this.regs.vram_readbuffer = this.vram_read(addr + 0) << 0;
                    this.regs.vram_readbuffer |= this.vram_read(addr + 1) << 8;
                    this.regs.vram_addr = this.regs.vram_addr + this.regs.vram_incsize & 0xFFFF;
                }
                return (byte)this.regs.ppu1_mdr;
            }
            case 8506: {
                this.regs.ppu1_mdr = this.regs.vram_readbuffer >> 8 & 0xFF;
                if (this.regs.vram_incmode) {
                    addr = this.get_vram_addr();
                    this.regs.vram_readbuffer = this.vram_read(addr + 0) << 0;
                    this.regs.vram_readbuffer |= this.vram_read(addr + 1) << 8;
                    this.regs.vram_addr = this.regs.vram_addr + this.regs.vram_incsize & 0xFFFF;
                }
                return (byte)this.regs.ppu1_mdr;
            }
            case 8507: {
                this.regs.ppu2_mdr = (this.regs.cgram_addr & 1) == 0 ? this.cgram_read(this.regs.cgram_addr) & 0xFF : this.regs.ppu2_mdr & 0x80 | this.cgram_read(this.regs.cgram_addr) & 0x7F;
                this.regs.cgram_addr = this.regs.cgram_addr + 1 & 0x1FF;
                return (byte)this.regs.ppu2_mdr;
            }
            case 8508: {
                this.regs.ppu2_mdr = !this.regs.latch_hcounter ? this.regs.hcounter & 0xFF : (this.regs.ppu2_mdr & 0xFE | this.regs.hcounter >> 8) & 0xFF;
                this.regs.latch_hcounter ^= true;
                return (byte)this.regs.ppu2_mdr;
            }
            case 8509: {
                this.regs.ppu2_mdr = !this.regs.latch_vcounter ? this.regs.vcounter & 0xFF : (this.regs.ppu2_mdr & 0xFE | this.regs.vcounter >> 8) & 0xFF;
                this.regs.latch_vcounter ^= true;
                return (byte)this.regs.ppu2_mdr;
            }
            case 8510: {
                this.regs.ppu1_mdr &= 0x10;
                this.regs.ppu1_mdr = this.regs.ppu1_mdr | (this.sprite.regs.time_over ? 1 : 0) << 7;
                this.regs.ppu1_mdr = this.regs.ppu1_mdr | (this.sprite.regs.range_over ? 1 : 0) << 6;
                this.regs.ppu1_mdr |= 1;
                return (byte)this.regs.ppu1_mdr;
            }
            case 8511: {
                this.regs.latch_hcounter = false;
                this.regs.latch_vcounter = false;
                this.regs.ppu2_mdr &= 0x20;
                this.regs.ppu2_mdr = this.regs.ppu2_mdr | (this.cpuCounter.field() ? 1 : 0) << 7;
                if (this.display.latch == 0) {
                    this.regs.ppu2_mdr |= 0x40;
                } else if (this.regs.counters_latched) {
                    this.regs.ppu2_mdr |= 0x40;
                    this.regs.counters_latched = false;
                }
                this.regs.ppu2_mdr = this.regs.ppu2_mdr | (this.region == 0 ? 0 : 1) << 4;
                this.regs.ppu2_mdr |= 3;
                return (byte)this.regs.ppu2_mdr;
            }
        }
        return (byte)this.regs.ppu1_mdr;
    }

    public void write8bit(int addr, byte data_) {
        int data = data_ & 0xFF;
        switch (addr & 0xFFFF) {
            case 8448: {
                if (this.regs.display_disable && this.cpuCounter.vcounter() == this.display.height) {
                    this.sprite.address_reset();
                }
                this.regs.display_disable = (data & 0x80) != 0;
                this.regs.display_brightness = data & 0xF;
                return;
            }
            case 8449: {
                this.sprite.regs.base_size = data >> 5 & 7;
                this.sprite.regs.nameselect = data >> 3 & 3;
                this.sprite.regs.tiledata_addr = (data & 3) << 14;
                this.sprite.list_valid = false;
                return;
            }
            case 8450: {
                this.regs.oam_baseaddr = this.regs.oam_baseaddr & 0x100 | data << 0;
                this.sprite.address_reset();
                return;
            }
            case 8451: {
                this.regs.oam_priority = (data & 0x80) != 0;
                this.regs.oam_baseaddr = (data & 1) << 8 | this.regs.oam_baseaddr & 0xFF;
                this.sprite.address_reset();
                return;
            }
            case 8452: {
                if ((this.regs.oam_addr & 1) == 0) {
                    this.regs.oam_latchdata = data;
                }
                if ((this.regs.oam_addr & 0x200) != 0) {
                    this.oam_write(this.regs.oam_addr, data);
                } else if ((this.regs.oam_addr & 1) == 1) {
                    this.oam_write((this.regs.oam_addr & 0xFFFFFFFE) + 0, this.regs.oam_latchdata);
                    this.oam_write((this.regs.oam_addr & 0xFFFFFFFE) + 1, data);
                }
                this.regs.oam_addr = this.regs.oam_addr + 1 & 0x3FF;
                this.sprite.set_first();
                return;
            }
            case 8453: {
                this.bg4.regs.tile_size = (data & 0x80) != 0;
                this.bg3.regs.tile_size = (data & 0x40) != 0;
                this.bg2.regs.tile_size = (data & 0x20) != 0;
                this.bg1.regs.tile_size = (data & 0x10) != 0;
                this.regs.bg3_priority = (data & 8) != 0;
                this.regs.bgmode = data & 7;
                this.mmio_update_video_mode();
                return;
            }
            case 8454: {
                int mosaic_size = data >> 4 & 0xF;
                this.bg4.regs.mosaic = (data & 8) != 0 ? mosaic_size : 0;
                this.bg3.regs.mosaic = (data & 4) != 0 ? mosaic_size : 0;
                this.bg2.regs.mosaic = (data & 2) != 0 ? mosaic_size : 0;
                this.bg1.regs.mosaic = (data & 1) != 0 ? mosaic_size : 0;
                return;
            }
            case 8455: {
                this.bg1.regs.screen_addr = (data & 0x7C) << 9;
                this.bg1.regs.screen_size = data & 3;
                return;
            }
            case 8456: {
                this.bg2.regs.screen_addr = (data & 0x7C) << 9;
                this.bg2.regs.screen_size = data & 3;
                return;
            }
            case 8457: {
                this.bg3.regs.screen_addr = (data & 0x7C) << 9;
                this.bg3.regs.screen_size = data & 3;
                return;
            }
            case 8458: {
                this.bg4.regs.screen_addr = (data & 0x7C) << 9;
                this.bg4.regs.screen_size = data & 3;
                return;
            }
            case 8459: {
                this.bg1.regs.tiledata_addr = (data & 7) << 13;
                this.bg2.regs.tiledata_addr = (data & 0x70) << 9;
                return;
            }
            case 8460: {
                this.bg3.regs.tiledata_addr = (data & 7) << 13;
                this.bg4.regs.tiledata_addr = (data & 0x70) << 9;
                return;
            }
            case 8461: {
                this.regs.mode7_hoffset = (data << 8 | this.regs.mode7_latchdata) & 0xFFFF;
                this.regs.mode7_latchdata = data;
                this.bg1.regs.hoffset = data << 8 | this.regs.bgofs_latchdata & 0xFFFFFFF8 | this.bg1.regs.hoffset >> 8 & 7;
                this.regs.bgofs_latchdata = data;
                return;
            }
            case 8462: {
                this.regs.mode7_voffset = (data << 8 | this.regs.mode7_latchdata) & 0xFFFF;
                this.regs.mode7_latchdata = data;
                this.bg1.regs.voffset = data << 8 | this.regs.bgofs_latchdata;
                this.regs.bgofs_latchdata = data;
                return;
            }
            case 8463: {
                this.bg2.regs.hoffset = data << 8 | this.regs.bgofs_latchdata & 0xFFFFFFF8 | this.bg2.regs.hoffset >> 8 & 7;
                this.regs.bgofs_latchdata = data;
                return;
            }
            case 8464: {
                this.bg2.regs.voffset = data << 8 | this.regs.bgofs_latchdata;
                this.regs.bgofs_latchdata = data;
                return;
            }
            case 8465: {
                this.bg3.regs.hoffset = data << 8 | this.regs.bgofs_latchdata & 0xFFFFFFF8 | this.bg3.regs.hoffset >> 8 & 7;
                this.regs.bgofs_latchdata = data;
                return;
            }
            case 8466: {
                this.bg3.regs.voffset = data << 8 | this.regs.bgofs_latchdata;
                this.regs.bgofs_latchdata = data;
                return;
            }
            case 8467: {
                this.bg4.regs.hoffset = data << 8 | this.regs.bgofs_latchdata & 0xFFFFFFF8 | this.bg4.regs.hoffset >> 8 & 7;
                this.regs.bgofs_latchdata = data;
                return;
            }
            case 8468: {
                this.bg4.regs.voffset = data << 8 | this.regs.bgofs_latchdata;
                this.regs.bgofs_latchdata = data;
                return;
            }
            case 8469: {
                this.regs.vram_incmode = (data & 0x80) != 0;
                this.regs.vram_mapping = data >> 2 & 3;
                switch (data & 3) {
                    case 0: {
                        this.regs.vram_incsize = 1;
                        break;
                    }
                    case 1: {
                        this.regs.vram_incsize = 32;
                        break;
                    }
                    case 2: {
                        this.regs.vram_incsize = 128;
                        break;
                    }
                    case 3: {
                        this.regs.vram_incsize = 128;
                    }
                }
                return;
            }
            case 8470: {
                this.regs.vram_addr = this.regs.vram_addr & 0xFF00 | data << 0;
                addr = this.get_vram_addr();
                this.regs.vram_readbuffer = this.vram_read(addr + 0) << 0;
                this.regs.vram_readbuffer |= this.vram_read(addr + 1) << 8;
                return;
            }
            case 8471: {
                this.regs.vram_addr = data << 8 | this.regs.vram_addr & 0xFF;
                addr = this.get_vram_addr();
                this.regs.vram_readbuffer = this.vram_read(addr + 0) << 0;
                this.regs.vram_readbuffer |= this.vram_read(addr + 1) << 8;
                return;
            }
            case 8472: {
                this.vram_write(this.get_vram_addr() + 0, data);
                if (!this.regs.vram_incmode) {
                    this.regs.vram_addr = this.regs.vram_addr + this.regs.vram_incsize & 0xFFFF;
                }
                return;
            }
            case 8473: {
                this.vram_write(this.get_vram_addr() + 1, data);
                if (this.regs.vram_incmode) {
                    this.regs.vram_addr = this.regs.vram_addr + this.regs.vram_incsize & 0xFFFF;
                }
                return;
            }
            case 8474: {
                this.regs.mode7_repeat = data >> 6 & 3;
                this.regs.mode7_vflip = (data & 2) != 0;
                this.regs.mode7_hflip = (data & 1) != 0;
                return;
            }
            case 8475: {
                this.regs.m7a = (data << 8 | this.regs.mode7_latchdata) & 0xFFFF;
                this.regs.mode7_latchdata = data;
                return;
            }
            case 8476: {
                this.regs.m7b = (data << 8 | this.regs.mode7_latchdata) & 0xFFFF;
                this.regs.mode7_latchdata = data;
                return;
            }
            case 8477: {
                this.regs.m7c = (data << 8 | this.regs.mode7_latchdata) & 0xFFFF;
                this.regs.mode7_latchdata = data;
                return;
            }
            case 8478: {
                this.regs.m7d = (data << 8 | this.regs.mode7_latchdata) & 0xFFFF;
                this.regs.mode7_latchdata = data;
                return;
            }
            case 8479: {
                this.regs.m7x = (data << 8 | this.regs.mode7_latchdata) & 0xFFFF;
                this.regs.mode7_latchdata = data;
                return;
            }
            case 8480: {
                this.regs.m7y = (data << 8 | this.regs.mode7_latchdata) & 0xFFFF;
                this.regs.mode7_latchdata = data;
                return;
            }
            case 8481: {
                this.regs.cgram_addr = data << 1;
                return;
            }
            case 8482: {
                if ((this.regs.cgram_addr & 1) == 0) {
                    this.regs.cgram_latchdata = data;
                } else {
                    this.cgram_write((this.regs.cgram_addr & 0xFFFFFFFE) + 0, this.regs.cgram_latchdata);
                    this.cgram_write((this.regs.cgram_addr & 0xFFFFFFFE) + 1, data & 0x7F);
                }
                this.regs.cgram_addr = this.regs.cgram_addr + 1 & 0x1FF;
                return;
            }
            case 8483: {
                this.bg2.window.two_enable = (data & 0x80) != 0;
                this.bg2.window.two_invert = (data & 0x40) != 0;
                this.bg2.window.one_enable = (data & 0x20) != 0;
                this.bg2.window.one_invert = (data & 0x10) != 0;
                this.bg1.window.two_enable = (data & 8) != 0;
                this.bg1.window.two_invert = (data & 4) != 0;
                this.bg1.window.one_enable = (data & 2) != 0;
                this.bg1.window.one_invert = (data & 1) != 0;
                return;
            }
            case 8484: {
                this.bg4.window.two_enable = (data & 0x80) != 0;
                this.bg4.window.two_invert = (data & 0x40) != 0;
                this.bg4.window.one_enable = (data & 0x20) != 0;
                this.bg4.window.one_invert = (data & 0x10) != 0;
                this.bg3.window.two_enable = (data & 8) != 0;
                this.bg3.window.two_invert = (data & 4) != 0;
                this.bg3.window.one_enable = (data & 2) != 0;
                this.bg3.window.one_invert = (data & 1) != 0;
                return;
            }
            case 8485: {
                this.screen.window.two_enable = (data & 0x80) != 0;
                this.screen.window.two_invert = (data & 0x40) != 0;
                this.screen.window.one_enable = (data & 0x20) != 0;
                this.screen.window.one_invert = (data & 0x10) != 0;
                this.sprite.window.two_enable = (data & 8) != 0;
                this.sprite.window.two_invert = (data & 4) != 0;
                this.sprite.window.one_enable = (data & 2) != 0;
                this.sprite.window.one_invert = (data & 1) != 0;
                return;
            }
            case 8486: {
                this.regs.window_one_left = data;
                return;
            }
            case 8487: {
                this.regs.window_one_right = data;
                return;
            }
            case 8488: {
                this.regs.window_two_left = data;
                return;
            }
            case 8489: {
                this.regs.window_two_right = data;
                return;
            }
            case 8490: {
                this.bg4.window.mask = data >> 6 & 3;
                this.bg3.window.mask = data >> 4 & 3;
                this.bg2.window.mask = data >> 2 & 3;
                this.bg1.window.mask = data >> 0 & 3;
                return;
            }
            case 8491: {
                this.screen.window.mask = data >> 2 & 3;
                this.sprite.window.mask = data >> 0 & 3;
                return;
            }
            case 8492: {
                this.sprite.regs.main_enable = (data & 0x10) != 0;
                this.bg4.regs.main_enable = (data & 8) != 0;
                this.bg3.regs.main_enable = (data & 4) != 0;
                this.bg2.regs.main_enable = (data & 2) != 0;
                this.bg1.regs.main_enable = (data & 1) != 0;
                return;
            }
            case 8493: {
                this.sprite.regs.sub_enable = (data & 0x10) != 0;
                this.bg4.regs.sub_enable = (data & 8) != 0;
                this.bg3.regs.sub_enable = (data & 4) != 0;
                this.bg2.regs.sub_enable = (data & 2) != 0;
                this.bg1.regs.sub_enable = (data & 1) != 0;
                return;
            }
            case 8494: {
                this.sprite.window.main_enable = (data & 0x10) != 0;
                this.bg4.window.main_enable = (data & 8) != 0;
                this.bg3.window.main_enable = (data & 4) != 0;
                this.bg2.window.main_enable = (data & 2) != 0;
                this.bg1.window.main_enable = (data & 1) != 0;
                return;
            }
            case 8495: {
                this.sprite.window.sub_enable = (data & 0x10) != 0;
                this.bg4.window.sub_enable = (data & 8) != 0;
                this.bg3.window.sub_enable = (data & 4) != 0;
                this.bg2.window.sub_enable = (data & 2) != 0;
                this.bg1.window.sub_enable = (data & 1) != 0;
                return;
            }
            case 8496: {
                this.screen.window.main_mask = data >> 6 & 3;
                this.screen.window.sub_mask = data >> 4 & 3;
                this.screen.regs.addsub_mode = (data & 2) != 0;
                this.screen.regs.direct_color = (data & 1) != 0;
                return;
            }
            case 8497: {
                this.screen.regs.color_mode = (data & 0x80) != 0;
                this.screen.regs.color_halve = (data & 0x40) != 0;
                this.screen.regs.color_enable[6] = (data & 0x20) != 0;
                this.screen.regs.color_enable[5] = (data & 0x10) != 0;
                this.screen.regs.color_enable[4] = (data & 0x10) != 0;
                this.screen.regs.color_enable[3] = (data & 8) != 0;
                this.screen.regs.color_enable[2] = (data & 4) != 0;
                this.screen.regs.color_enable[1] = (data & 2) != 0;
                this.screen.regs.color_enable[0] = (data & 1) != 0;
                return;
            }
            case 8498: {
                if ((data & 0x80) != 0) {
                    this.screen.regs.color_b = data & 0x1F;
                }
                if ((data & 0x40) != 0) {
                    this.screen.regs.color_g = data & 0x1F;
                }
                if ((data & 0x20) != 0) {
                    this.screen.regs.color_r = data & 0x1F;
                }
                this.screen.regs.color = this.screen.regs.color_b << 10 | this.screen.regs.color_g << 5 | this.screen.regs.color_r << 0;
                return;
            }
            case 8499: {
                this.regs.mode7_extbg = (data & 0x40) != 0;
                this.regs.pseudo_hires = (data & 8) != 0;
                this.regs.overscan = (data & 4) != 0;
                this.sprite.regs.interlace = (data & 2) != 0;
                this.regs.interlace = (data & 1) != 0;
                this.mmio_update_video_mode();
                this.sprite.list_valid = false;
                return;
            }
        }
    }

    private void mmio_reset() {
        this.regs.ppu1_mdr = 0;
        this.regs.ppu2_mdr = 0;
        this.regs.vram_readbuffer = 0;
        this.regs.oam_latchdata = 0;
        this.regs.cgram_latchdata = 0;
        this.regs.bgofs_latchdata = 0;
        this.regs.mode7_latchdata = 0;
        this.regs.counters_latched = false;
        this.regs.latch_hcounter = false;
        this.regs.latch_vcounter = false;
        this.sprite.regs.first_sprite = 0;
        this.sprite.list_valid = false;
        this.regs.display_disable = true;
        this.regs.display_brightness = 0;
        this.sprite.regs.base_size = 0;
        this.sprite.regs.nameselect = 0;
        this.sprite.regs.tiledata_addr = 0;
        this.regs.oam_baseaddr = 0;
        this.regs.oam_addr = 0;
        this.regs.oam_priority = false;
        this.bg4.regs.tile_size = false;
        this.bg3.regs.tile_size = false;
        this.bg2.regs.tile_size = false;
        this.bg1.regs.tile_size = false;
        this.regs.bg3_priority = false;
        this.regs.bgmode = 0;
        this.bg4.regs.mosaic = 0;
        this.bg3.regs.mosaic = 0;
        this.bg2.regs.mosaic = 0;
        this.bg1.regs.mosaic = 0;
        this.bg1.regs.screen_addr = 0;
        this.bg1.regs.screen_size = 0;
        this.bg2.regs.screen_addr = 0;
        this.bg2.regs.screen_size = 0;
        this.bg3.regs.screen_addr = 0;
        this.bg3.regs.screen_size = 0;
        this.bg4.regs.screen_addr = 0;
        this.bg4.regs.screen_size = 0;
        this.bg1.regs.tiledata_addr = 0;
        this.bg2.regs.tiledata_addr = 0;
        this.bg3.regs.tiledata_addr = 0;
        this.bg4.regs.tiledata_addr = 0;
        this.regs.mode7_hoffset = 0;
        this.regs.mode7_voffset = 0;
        this.bg1.regs.hoffset = 0;
        this.bg1.regs.voffset = 0;
        this.bg2.regs.hoffset = 0;
        this.bg2.regs.voffset = 0;
        this.bg3.regs.hoffset = 0;
        this.bg3.regs.voffset = 0;
        this.bg4.regs.hoffset = 0;
        this.bg4.regs.voffset = 0;
        this.regs.vram_incmode = false;
        this.regs.vram_mapping = 0;
        this.regs.vram_incsize = 1;
        this.regs.vram_addr = 0;
        this.regs.mode7_repeat = 0;
        this.regs.mode7_vflip = false;
        this.regs.mode7_hflip = false;
        this.regs.m7a = 0;
        this.regs.m7b = 0;
        this.regs.m7c = 0;
        this.regs.m7d = 0;
        this.regs.m7x = 0;
        this.regs.m7y = 0;
        this.regs.cgram_addr = 0;
        this.bg1.window.one_enable = false;
        this.bg1.window.one_invert = false;
        this.bg1.window.two_enable = false;
        this.bg1.window.two_invert = false;
        this.bg2.window.one_enable = false;
        this.bg2.window.one_invert = false;
        this.bg2.window.two_enable = false;
        this.bg2.window.two_invert = false;
        this.bg3.window.one_enable = false;
        this.bg3.window.one_invert = false;
        this.bg3.window.two_enable = false;
        this.bg3.window.two_invert = false;
        this.bg4.window.one_enable = false;
        this.bg4.window.one_invert = false;
        this.bg4.window.two_enable = false;
        this.bg4.window.two_invert = false;
        this.sprite.window.one_enable = false;
        this.sprite.window.one_invert = false;
        this.sprite.window.two_enable = false;
        this.sprite.window.two_invert = false;
        this.screen.window.one_enable = false;
        this.screen.window.one_invert = false;
        this.screen.window.two_enable = false;
        this.screen.window.two_invert = false;
        this.regs.window_one_left = 0;
        this.regs.window_one_right = 0;
        this.regs.window_two_left = 0;
        this.regs.window_two_right = 0;
        this.bg1.window.mask = 0;
        this.bg2.window.mask = 0;
        this.bg3.window.mask = 0;
        this.bg4.window.mask = 0;
        this.sprite.window.mask = 0;
        this.screen.window.mask = 0;
        this.bg1.regs.main_enable = false;
        this.bg2.regs.main_enable = false;
        this.bg3.regs.main_enable = false;
        this.bg4.regs.main_enable = false;
        this.sprite.regs.main_enable = false;
        this.bg1.regs.sub_enable = false;
        this.bg2.regs.sub_enable = false;
        this.bg3.regs.sub_enable = false;
        this.bg4.regs.sub_enable = false;
        this.sprite.regs.sub_enable = false;
        this.bg1.window.main_enable = false;
        this.bg2.window.main_enable = false;
        this.bg3.window.main_enable = false;
        this.bg4.window.main_enable = false;
        this.sprite.window.main_enable = false;
        this.bg1.window.sub_enable = false;
        this.bg2.window.sub_enable = false;
        this.bg3.window.sub_enable = false;
        this.bg4.window.sub_enable = false;
        this.sprite.window.sub_enable = false;
        this.screen.window.main_mask = 0;
        this.screen.window.sub_mask = 0;
        this.screen.regs.addsub_mode = false;
        this.screen.regs.direct_color = false;
        this.screen.regs.color_mode = false;
        this.screen.regs.color_halve = false;
        this.screen.regs.color_enable[6] = false;
        this.screen.regs.color_enable[5] = false;
        this.screen.regs.color_enable[4] = false;
        this.screen.regs.color_enable[3] = false;
        this.screen.regs.color_enable[2] = false;
        this.screen.regs.color_enable[1] = false;
        this.screen.regs.color_enable[0] = false;
        this.screen.regs.color_b = 0;
        this.screen.regs.color_g = 0;
        this.screen.regs.color_r = 0;
        this.screen.regs.color = 0;
        this.regs.mode7_extbg = false;
        this.regs.pseudo_hires = false;
        this.regs.overscan = false;
        this.sprite.regs.interlace = false;
        this.regs.interlace = false;
        this.sprite.regs.time_over = false;
        this.sprite.regs.range_over = false;
        this.mmio_update_video_mode();
    }

    private final void add_clocks(int clocks) {
        this.ppuCounter.tick(clocks);
        this.step(clocks);
        this.synchronize_cpu();
    }

    private final void render_scanline() {
        this.bg1.scanline();
        this.bg2.scanline();
        this.bg3.scanline();
        this.bg4.scanline();
        if (this.regs.display_disable) {
            this.screen.render_black();
            return;
        }
        this.screen.scanline();
        this.bg1.render();
        this.bg2.render();
        this.bg3.render();
        this.bg4.render();
        this.sprite.render();
        this.screen.render();
    }

    public void readDMA(int address, ByteBuffer data, int offset, int length) {
        System.arraycopy(this.output.array(), 0, data.array(), offset, length);
    }

    public void writeDMA(int address, ByteBuffer data, int offset, int length) {
    }

    public Object readConfig(String key) {
        if (key.equals("accuracy")) {
            return false;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("region")) {
            this.cpuCounter.region = this.region = value.toString().equals("ntsc") ? 0 : 1;
            this.ppuCounter.region = this.region;
        }
    }
}

