/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.ppu;

import jario.snes.performance.ppu.LayerWindow;
import jario.snes.performance.ppu.List;
import jario.snes.performance.ppu.PPU;
import jario.snes.performance.ppu.TileList;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Sprite {
    public boolean priority0_enable;
    public boolean priority1_enable;
    public boolean priority2_enable;
    public boolean priority3_enable;
    public Regs regs = new Regs();
    public List[] list = new List[128];
    public boolean list_valid;
    public int[] itemlist = new int[32];
    public TileList[] tilelist = new TileList[34];
    public Output output = new Output();
    public LayerWindow window = new LayerWindow();
    private static int[] width1 = new int[]{8, 8, 8, 16, 16, 32, 16, 16};
    private static int[] height1 = new int[]{8, 8, 8, 16, 16, 32, 32, 32};
    private static int[] width2 = new int[]{16, 32, 64, 32, 64, 64, 32, 32};
    private static int[] height2 = new int[]{16, 32, 64, 32, 64, 64, 64, 32};
    private int[] priority_table = new int[4];
    public PPU self;

    public void frame() {
        this.regs.time_over = false;
        this.regs.range_over = false;
    }

    public void update_list(int addr, int data) {
        if (addr < 512) {
            int i = addr >> 2;
            switch (addr & 3) {
                case 0: {
                    this.list[i].x = this.list[i].x & 0x100 | data;
                    break;
                }
                case 1: {
                    this.list[i].y = data + 1 & 0xFF;
                    break;
                }
                case 2: {
                    this.list[i].character = data;
                    break;
                }
                case 3: {
                    this.list[i].vflip = (data & 0x80) != 0;
                    this.list[i].hflip = (data & 0x40) != 0;
                    this.list[i].priority = data >> 4 & 3;
                    this.list[i].palette = data >> 1 & 7;
                    this.list[i].use_nameselect = (data & 1) != 0;
                }
            }
        } else {
            int i = (addr & 0x1F) << 2;
            this.list[i + 0].x = (data & 1) << 8 | this.list[i + 0].x & 0xFF;
            this.list[i + 0].size = (data & 2) != 0;
            this.list[i + 1].x = (data & 4) << 6 | this.list[i + 1].x & 0xFF;
            this.list[i + 1].size = (data & 8) != 0;
            this.list[i + 2].x = (data & 0x10) << 4 | this.list[i + 2].x & 0xFF;
            this.list[i + 2].size = (data & 0x20) != 0;
            this.list[i + 3].x = (data & 0x40) << 2 | this.list[i + 3].x & 0xFF;
            this.list[i + 3].size = (data & 0x80) != 0;
            this.list_valid = false;
        }
    }

    public void address_reset() {
        this.self.regs.oam_addr = this.self.regs.oam_baseaddr << 1 & 0xFFFF;
        this.set_first();
    }

    public void set_first() {
        this.regs.first_sprite = !this.self.regs.oam_priority ? 0 : this.self.regs.oam_addr >> 2 & 0x7F;
    }

    public boolean on_scanline(int sprite) {
        int height;
        List s = this.list[sprite];
        if (s.x > 256 && s.x + s.width - 1 < 512) {
            return false;
        }
        int n = height = !this.regs.interlace ? s.height : s.height >> 1;
        if (this.self.ppuCounter.vcounter() >= s.y && this.self.ppuCounter.vcounter() < s.y + height) {
            return true;
        }
        return s.y + height >= 256 && this.self.ppuCounter.vcounter() < (s.y + height & 0xFF);
    }

    public void render() {
        if (!this.list_valid) {
            this.list_valid = true;
            int i = 0;
            while (i < 128) {
                if (!this.list[i].size) {
                    this.list[i].width = width1[this.regs.base_size];
                    this.list[i].height = height1[this.regs.base_size];
                } else {
                    this.list[i].width = width2[this.regs.base_size];
                    this.list[i].height = height2[this.regs.base_size];
                    if (this.regs.interlace && this.regs.base_size >= 6) {
                        this.list[i].height = 16;
                    }
                }
                ++i;
            }
        }
        int itemcount = 0;
        int tilecount = 0;
        Arrays.fill(this.output.priority, 255);
        Arrays.fill(this.itemlist, 255);
        int i = 0;
        while (i < 34) {
            this.tilelist[i].tile = 65535;
            ++i;
        }
        i = 0;
        while (i < 128) {
            int s = this.regs.first_sprite + i & 0x7F;
            if (this.on_scanline(s)) {
                if (itemcount++ >= 32) break;
                this.itemlist[itemcount - 1] = s;
            }
            ++i;
        }
        i = 31;
        while (i >= 0) {
            if (this.itemlist[i] != 255) {
                List s = this.list[this.itemlist[i]];
                int tile_width = s.width >> 3;
                int x = s.x;
                int y = this.self.ppuCounter.vcounter() - s.y & 0xFF;
                if (this.regs.interlace) {
                    y <<= 1;
                }
                if (s.vflip) {
                    if (s.width == s.height) {
                        y = s.height - 1 - y;
                    } else {
                        int n = y = y < s.width ? s.width - 1 - y : s.width + (s.width - 1 - (y - s.width));
                    }
                }
                if (this.regs.interlace) {
                    y = !s.vflip ? y + (this.self.ppuCounter.field() ? 1 : 0) : y - (this.self.ppuCounter.field() ? 1 : 0);
                }
                x &= 0x1FF;
                y &= 0xFF;
                int tdaddr = this.regs.tiledata_addr & 0xFFFF;
                int chrx = s.character >> 0 & 0xF;
                int chry = s.character >> 4 & 0xF;
                if (s.use_nameselect) {
                    tdaddr = tdaddr + (8192 + (this.regs.nameselect << 13)) & 0xFFFF;
                }
                chry = chry + (y >> 3) & 0xFFFF;
                chry &= 0xF;
                chry <<= 4;
                int tx = 0;
                while (tx < tile_width) {
                    int sx = x + (tx << 3) & 0x1FF;
                    if (x == 256 || sx < 256 || sx + 7 >= 512) {
                        if (tilecount++ >= 34) break;
                        int n = tilecount - 1;
                        this.tilelist[n].x = sx;
                        this.tilelist[n].y = y;
                        this.tilelist[n].priority = s.priority;
                        this.tilelist[n].palette = 128 + (s.palette << 4);
                        this.tilelist[n].hflip = s.hflip;
                        int mx = !s.hflip ? tx : tile_width - 1 - tx;
                        int pos = tdaddr + (chry + (chrx + mx & 0xF) << 5);
                        this.tilelist[n].tile = pos >> 5 & 0x7FF;
                    }
                    ++tx;
                }
            }
            --i;
        }
        this.regs.time_over = this.regs.time_over | tilecount > 34;
        this.regs.range_over = this.regs.range_over | itemcount > 32;
        if (!this.regs.main_enable && !this.regs.sub_enable) {
            return;
        }
        i = 0;
        while (i < 34) {
            if (this.tilelist[i].tile != 65535) {
                TileList t = this.tilelist[i];
                ByteBuffer tiledata = this.self.cache.tile_4bpp(t.tile);
                int tiledata_offset = tiledata.position() + ((t.y & 7) << 3);
                int sx = t.x;
                int x = 0;
                while (x < 8) {
                    int color;
                    if ((sx &= 0x1FF) < 256 && (color = tiledata.array()[tiledata_offset + (!t.hflip ? x : 7 - x)] & 0xFF) != 0) {
                        this.output.palette[sx] = (color += t.palette) & 0xFF;
                        this.output.priority[sx] = t.priority;
                    }
                    ++sx;
                    ++x;
                }
            }
            ++i;
        }
        if (this.regs.main_enable) {
            this.window.render(false);
        }
        if (this.regs.sub_enable) {
            this.window.render(true);
        }
        this.priority_table[0] = this.priority0_enable ? this.regs.priority0 : 0;
        this.priority_table[1] = this.priority1_enable ? this.regs.priority1 : 0;
        this.priority_table[2] = this.priority2_enable ? this.regs.priority2 : 0;
        int n = this.priority_table[3] = this.priority3_enable ? this.regs.priority3 : 0;
        if (this.priority_table[0] + this.priority_table[1] + this.priority_table[2] + this.priority_table[3] == 0) {
            return;
        }
        int x = 0;
        while (x < 256) {
            if (this.output.priority[x] != 255) {
                int priority = this.priority_table[this.output.priority[x]];
                int palette = this.output.palette[x];
                int color = this.self.screen.get_palette(this.output.palette[x]);
                if (this.regs.main_enable && this.window.main[x] == 0) {
                    this.self.screen.output.plot_main(x, color, priority, 4 + (palette < 192 ? 1 : 0));
                }
                if (this.regs.sub_enable && this.window.sub[x] == 0) {
                    this.self.screen.output.plot_sub(x, color, priority, 4 + (palette < 192 ? 1 : 0));
                }
            }
            ++x;
        }
    }

    public Sprite(PPU self) {
        this.self = self;
        this.priority0_enable = true;
        this.priority1_enable = true;
        this.priority2_enable = true;
        this.priority3_enable = true;
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = new List();
            ++i;
        }
        i = 0;
        while (i < this.tilelist.length) {
            this.tilelist[i] = new TileList();
            ++i;
        }
    }

    class Output {
        public int[] palette = new int[256];
        public int[] priority = new int[256];

        Output() {
        }
    }

    class Regs {
        public int priority0;
        public int priority1;
        public int priority2;
        public int priority3;
        public int base_size;
        public int nameselect;
        public int tiledata_addr;
        public int first_sprite;
        public boolean main_enable;
        public boolean sub_enable;
        public boolean interlace;
        public boolean time_over;
        public boolean range_over;

        Regs() {
        }
    }
}

