/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.accessories;

import jario.hardware.BusDMA;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class AudioPlayer
implements Hardware,
BusDMA,
Configurable {
    private AudioFormat audioFormat;
    private SourceDataLine audioDataLine;
    private boolean enable = true;
    private float sampleRate = 33334.0f;

    public AudioPlayer() {
        this.initAudio(this.sampleRate);
    }

    public void connect(int port, Hardware hw) {
    }

    public void reset() {
    }

    public void readDMA(int address, ByteBuffer b, int offset, int length) {
    }

    public void writeDMA(int address, ByteBuffer buffer, int offset, int length) {
        if (this.enable && this.audioDataLine == null) {
            this.initAudio(this.sampleRate);
        }
        if (!this.enable && this.audioDataLine != null) {
            this.closeAudio();
        }
        if (this.audioDataLine != null) {
            this.audioDataLine.write(buffer.array(), offset, length);
        }
    }

    public Object readConfig(String key) {
        if (key.equals("enable")) {
            return this.enable;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("enable")) {
            this.enable = (Boolean)value;
        } else if (key.equals("samplerate")) {
            this.sampleRate = ((Integer)value).intValue();
            this.initAudio(this.sampleRate);
        }
    }

    private boolean initAudio(float sampleRate) {
        this.closeAudio();
        this.audioFormat = new AudioFormat(sampleRate, 16, 2, true, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
        try {
            this.audioDataLine = (SourceDataLine)AudioSystem.getLine(info);
            this.audioDataLine.open(this.audioFormat);
            this.audioDataLine.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void closeAudio() {
        if (this.audioDataLine != null) {
            this.audioDataLine.flush();
            this.audioDataLine.stop();
            this.audioDataLine.close();
            this.audioDataLine = null;
        }
    }
}

