/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.video;

import jario.hardware.Bus1bit;
import jario.hardware.Bus32bit;
import jario.hardware.BusDMA;
import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Video
implements Hardware,
Clockable,
Bus32bit,
Configurable {
    private int FRAMES_PER_SECOND = 60;
    private int SKIP_TICKS = 1000 / this.FRAMES_PER_SECOND;
    private BusDMA output;
    private BusDMA ppuDma;
    private Bus1bit ppu1bit;
    private Bus32bit audio;
    private ExecutorService executor;
    private long currentTime;
    private long next_game_tick;
    private long sleep_time;
    private boolean limit = true;
    private boolean frame_hires = false;
    private boolean frame_interlace = false;
    private int[] line_width = new int[240];
    ByteBuffer data_output = ByteBuffer.allocate(0x200000);

    public Video() {
        this.executor = Executors.newSingleThreadExecutor();
        int i = 0;
        while (i < 240) {
            this.line_width[i] = 256;
            ++i;
        }
        this.next_game_tick = System.currentTimeMillis();
    }

    public void connect(int port, Hardware hw) {
        switch (port) {
            case 0: {
                this.output = (BusDMA)hw;
                break;
            }
            case 1: {
                this.ppuDma = (BusDMA)hw;
                this.ppu1bit = (Bus1bit)hw;
                break;
            }
            case 2: {
                this.audio = (Bus32bit)hw;
            }
        }
    }

    public void reset() {
    }

    public void clock(long clocks) {
        int height;
        this.ppuDma.readDMA(0, this.data_output, 0, 489472);
        ShortBuffer data = this.data_output.asShortBuffer();
        int data_offset = 0;
        if (this.ppu1bit.read1bit(0) && this.ppu1bit.read1bit(3)) {
            data_offset += 512;
        }
        int width = 256;
        int n = height = !this.ppu1bit.read1bit(1) ? 224 : 239;
        if (this.frame_hires) {
            width <<= 1;
            int y = 0;
            while (y < 240) {
                if (this.line_width[y] != 512) {
                    ShortBuffer buffer = data;
                    int buffer_offset = data_offset + y * 1024;
                    int x = 255;
                    while (x >= 0) {
                        short s = buffer.get(buffer_offset + x);
                        buffer.put(buffer_offset + (x * 2 + 1), s);
                        buffer.put(buffer_offset + (x * 2 + 0), s);
                        --x;
                    }
                }
                ++y;
            }
        }
        if (this.frame_interlace) {
            height <<= 1;
        }
        this.executor.execute(new AudioVideoThread(width, height));
        this.audio.read32bit(0);
        this.frame_hires = false;
        this.frame_interlace = false;
        this.currentTime = System.currentTimeMillis();
        if (this.limit) {
            this.next_game_tick += (long)this.SKIP_TICKS;
            this.sleep_time = this.next_game_tick - this.currentTime;
            if (this.sleep_time >= 0L) {
                try {
                    Thread.sleep(this.sleep_time);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.next_game_tick = System.currentTimeMillis();
    }

    public int read32bit(int address) {
        return 0;
    }

    public void write32bit(int address, int data) {
        int width;
        int y = data;
        if (y >= 240) {
            return;
        }
        this.frame_hires |= this.ppu1bit.read1bit(2);
        this.frame_interlace |= this.ppu1bit.read1bit(0);
        this.line_width[y] = width = !this.ppu1bit.read1bit(2) ? 256 : 512;
    }

    public Object readConfig(String key) {
        if (key.equals("fps")) {
            return this.FRAMES_PER_SECOND;
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("fps")) {
            this.FRAMES_PER_SECOND = (Integer)value;
            this.SKIP_TICKS = 1000 / this.FRAMES_PER_SECOND;
        }
    }

    class AudioVideoThread
    implements Runnable {
        private int width;
        private int height;

        public AudioVideoThread(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public void run() {
            Video.this.output.writeDMA(0, Video.this.data_output, 2048, (this.width & 0xFFFF) << 16 | this.height & 0xFFFF);
        }
    }
}

