/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.console;

import jario.hardware.Clockable;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.snes.configuration.Configuration;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Console
implements Hardware,
Clockable,
Configurable {
    ExecutorService executor;
    private boolean done;
    Hardware bus;
    Hardware cpu;
    Hardware ppu;
    Hardware dsp;
    Hardware smp;
    Hardware cartridge;
    Hardware video;
    Hardware audio;
    Hardware input;
    private Region region = Region.Autodetect;

    public Console() {
        this.executor = Executors.newSingleThreadExecutor();
        try {
            File dir = new File("components" + File.separator);
            File file = new File("components.properties");
            ClassLoader loader = this.getClass().getClassLoader();
            Properties prop = new Properties();
            try {
                URL url;
                if (dir.exists() && dir.listFiles().length > 0) {
                    File[] files = dir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.getPath().toLowerCase().endsWith(".jar");
                        }
                    });
                    URL[] urls = new URL[files.length];
                    int i = 0;
                    while (i < files.length) {
                        urls[i] = files[i].toURI().toURL();
                        ++i;
                    }
                    loader = new URLClassLoader(urls, this.getClass().getClassLoader());
                }
                URL uRL = url = file.exists() ? file.toURI().toURL() : loader.getResource("resources" + File.separator + "components.properties");
                if (url != null) {
                    prop.load(url.openStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bus = (Hardware)Class.forName(prop.getProperty("MEMORY", "MEMORY"), true, loader).newInstance();
            this.cpu = (Hardware)Class.forName(prop.getProperty("CPU", "CPU"), true, loader).newInstance();
            this.ppu = (Hardware)Class.forName(prop.getProperty("PPU", "PPU"), true, loader).newInstance();
            this.smp = (Hardware)Class.forName(prop.getProperty("SMP", "SMP"), true, loader).newInstance();
            this.dsp = (Hardware)Class.forName(prop.getProperty("DSP", "DSP"), true, loader).newInstance();
            this.video = (Hardware)Class.forName(prop.getProperty("ENC", "ENC"), true, loader).newInstance();
            this.audio = (Hardware)Class.forName(prop.getProperty("DAC", "DAC"), true, loader).newInstance();
            this.input = (Hardware)Class.forName(prop.getProperty("INPUT", "INPUT"), true, loader).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.bus.connect(0, this.cpu);
        this.bus.connect(1, this.ppu);
        ((Configurable)this.bus).writeConfig("wram init value", (Object)((byte)Configuration.config.cpu.wram_init_value));
        this.cpu.connect(0, this.bus);
        this.cpu.connect(1, this.smp);
        this.cpu.connect(2, this.input);
        this.cpu.connect(3, this.video);
        this.cpu.connect(4, this.ppu);
        ((Configurable)this.cpu).writeConfig("cpu version", (Object)Configuration.config.cpu.version);
        ((Configurable)this.ppu).writeConfig("ppu1 version", (Object)Configuration.config.ppu1.version);
        ((Configurable)this.ppu).writeConfig("ppu2 version", (Object)Configuration.config.ppu2.version);
        this.smp.connect(0, this.dsp);
        this.smp.connect(1, this.cpu);
        this.dsp.connect(0, this.audio);
        this.video.connect(1, this.ppu);
        this.video.connect(2, this.audio);
    }

    public void connect(int port, Hardware hw) {
        switch (port) {
            case 0: {
                this.input.connect(0, hw);
                break;
            }
            case 1: {
                this.input.connect(1, hw);
                break;
            }
            case 2: {
                this.cartridge = hw;
                this.bus.connect(2, this.cartridge);
                if (this.cartridge == null) break;
                this.insertCartridge();
                break;
            }
            case 3: {
                this.video.connect(0, hw);
                break;
            }
            case 4: {
                this.audio.connect(0, hw);
            }
        }
    }

    public void clock(long clocks) {
        final Clockable cpu_clk = (Clockable)this.cpu;
        this.done = false;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!Console.this.done) {
                    cpu_clk.clock(50000L);
                }
            }
        });
    }

    public void reset() {
        this.done = true;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.cpu.reset();
        this.smp.reset();
        this.dsp.reset();
        this.ppu.reset();
        this.audio.reset();
        this.video.reset();
        ((Clockable)this.input).clock(1L);
    }

    public Object readConfig(String key) {
        if (key.equals("accuracy")) {
            return ((Configurable)this.ppu).readConfig("accuracy");
        }
        if (key.equals("fps")) {
            return ((Configurable)this.video).readConfig("fps");
        }
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("accuracy")) {
            ((Configurable)this.ppu).writeConfig("accuracy", value);
        } else if (key.equals("fps")) {
            ((Configurable)this.video).writeConfig("fps", value);
        }
    }

    private void insertCartridge() {
        this.region = Configuration.config.region;
        if (this.region == Region.Autodetect) {
            this.region = ((Configurable)this.cartridge).readConfig("region").equals("ntsc") ? Region.NTSC : Region.PAL;
        }
        ((Configurable)this.smp).writeConfig("region", (Object)(this.region == Region.NTSC ? "ntsc" : "pal"));
        ((Configurable)this.ppu).writeConfig("region", (Object)(this.region == Region.NTSC ? "ntsc" : "pal"));
        ((Configurable)this.cpu).writeConfig("region", (Object)(this.region == Region.NTSC ? "ntsc" : "pal"));
        ((Clockable)this.input).clock(1L);
        this.reset();
    }

    public static enum Region {
        NTSC,
        PAL,
        Autodetect;

    }
}

