/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.performance.cpu;

import jario.snes.performance.cpu.CPU;

public class DMA {
    private CPU self;
    private static int[] transfer_length = new int[]{1, 2, 2, 4, 4, 4, 2, 4};

    public DMA(CPU self) {
        this.self = self;
    }

    private boolean dma_transfer_valid(int bbus, int abus) {
        return bbus != 128 || (abus & 0xFE0000) != 0x7E0000 && (abus & 0x40E000) != 0;
    }

    private boolean dma_addr_valid(int abus) {
        if ((abus & 0x40FF00) == 8448) {
            return false;
        }
        if ((abus & 0x40FE00) == 16384) {
            return false;
        }
        if ((abus & 0x40FFE0) == 16896) {
            return false;
        }
        return (abus & 0x40FF80) != 17152;
    }

    private byte dma_read(int abus) {
        if (!this.dma_addr_valid(abus)) {
            return 0;
        }
        return this.self.bus.read8bit(abus);
    }

    private void dma_write(boolean valid, int addr, byte data) {
        if (valid) {
            this.self.bus.write8bit(addr, data);
        }
    }

    private void dma_transfer(boolean direction, int bbus, int abus) {
        if (!direction) {
            byte data = this.dma_read(abus);
            this.self.add_clocks(8);
            this.dma_write(this.dma_transfer_valid(bbus, abus), 0x2100 | bbus, data);
        } else {
            byte data = this.dma_transfer_valid(bbus, abus) ? this.self.bus.read8bit(0x2100 | bbus & 0xFF) : (byte)0;
            this.self.add_clocks(8);
            this.dma_write(this.dma_addr_valid(abus), abus, data);
        }
    }

    private int dma_bbus(int i, int index) {
        switch (this.self.channel[i].transfer_mode) {
            default: {
                return this.self.channel[i].dest_addr;
            }
            case 1: {
                return this.self.channel[i].dest_addr + (index & 1);
            }
            case 2: {
                return this.self.channel[i].dest_addr;
            }
            case 3: {
                return this.self.channel[i].dest_addr + (index >> 1 & 1);
            }
            case 4: {
                return this.self.channel[i].dest_addr + (index & 3);
            }
            case 5: {
                return this.self.channel[i].dest_addr + (index & 1);
            }
            case 6: {
                return this.self.channel[i].dest_addr;
            }
            case 7: 
        }
        return this.self.channel[i].dest_addr + (index >> 1 & 1);
    }

    private int dma_addr(int i) {
        int result = (this.self.channel[i].source_bank & 0xFF) << 16 | this.self.channel[i].source_addr & 0xFFFF;
        if (!this.self.channel[i].fixed_transfer) {
            this.self.channel[i].source_addr = !this.self.channel[i].reverse_transfer ? ++this.self.channel[i].source_addr : --this.self.channel[i].source_addr;
        }
        return result;
    }

    private int hdma_addr(int i) {
        return (this.self.channel[i].source_bank & 0xFF) << 16 | this.self.channel[i].hdma_addr++ & 0xFFFF;
    }

    private int hdma_iaddr(int i) {
        return (this.self.channel[i].indirect_bank & 0xFF) << 16 | this.self.channel[i].indirect_addr++ & 0xFFFF;
    }

    void dma_run() {
        this.self.add_clocks(16);
        int i = 0;
        while (i < 8) {
            if (this.self.channel[i].dma_enabled) {
                this.self.add_clocks(8);
                int index = 0;
                do {
                    this.dma_transfer(this.self.channel[i].direction, this.dma_bbus(i, index++), this.dma_addr(i));
                } while (this.self.channel[i].dma_enabled && (this.self.channel[i].transfer_size_decremented() & 0xFFFF) != 0);
                this.self.channel[i].dma_enabled = false;
            }
            ++i;
        }
        this.self.status.irq_lock = true;
    }

    private void hdma_update(int i) {
        if ((this.self.channel[i].line_counter & 0x7F) == 0) {
            this.self.channel[i].line_counter = this.dma_read(this.hdma_addr(i)) & 0xFF;
            this.self.channel[i].hdma_completed = (this.self.channel[i].line_counter & 0xFF) == 0;
            this.self.channel[i].hdma_do_transfer = !this.self.channel[i].hdma_completed;
            this.self.add_clocks(8);
            if (this.self.channel[i].indirect) {
                this.self.channel[i].indirect_addr = (this.dma_read(this.hdma_addr(i)) & 0xFF) << 8 & 0xFFFF;
                this.self.add_clocks(8);
                this.self.channel[i].indirect_addr >>= 8;
                this.self.channel[i].indirect_addr |= (this.dma_read(this.hdma_addr(i)) & 0xFF) << 8 & 0xFFFF;
                this.self.add_clocks(8);
            }
        }
    }

    void hdma_run() {
        int channels = 0;
        int i = 0;
        while (i < 8) {
            if (this.self.channel[i].hdma_enabled) {
                ++channels;
            }
            ++i;
        }
        if (channels == 0) {
            return;
        }
        this.self.add_clocks(16);
        i = 0;
        while (i < 8) {
            if (this.self.channel[i].hdma_enabled && !this.self.channel[i].hdma_completed) {
                this.self.channel[i].dma_enabled = false;
                if (this.self.channel[i].hdma_do_transfer) {
                    int length = transfer_length[this.self.channel[i].transfer_mode];
                    int index = 0;
                    while (index < length) {
                        int addr = !this.self.channel[i].indirect ? this.hdma_addr(i) : this.hdma_iaddr(i);
                        this.dma_transfer(this.self.channel[i].direction, this.dma_bbus(i, index), addr);
                        ++index;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < 8) {
            if (this.self.channel[i].hdma_enabled && !this.self.channel[i].hdma_completed) {
                --this.self.channel[i].line_counter;
                this.self.channel[i].hdma_do_transfer = (this.self.channel[i].line_counter & 0x80) != 0;
                this.hdma_update(i);
            }
            ++i;
        }
        this.self.status.irq_lock = true;
    }

    void hdma_init() {
        int channels = 0;
        int i = 0;
        while (i < 8) {
            this.self.channel[i].hdma_completed = false;
            this.self.channel[i].hdma_do_transfer = false;
            if (this.self.channel[i].hdma_enabled) {
                ++channels;
            }
            ++i;
        }
        if (channels == 0) {
            return;
        }
        this.self.add_clocks(16);
        i = 0;
        while (i < 8) {
            if (this.self.channel[i].hdma_enabled) {
                this.self.channel[i].dma_enabled = false;
                this.self.channel[i].hdma_addr = this.self.channel[i].source_addr & 0xFFFF;
                this.self.channel[i].line_counter = 0;
                this.hdma_update(i);
            }
            ++i;
        }
        this.self.status.irq_lock = true;
    }

    void dma_reset() {
        int i = 0;
        while (i < 8) {
            this.self.channel[i].dma_enabled = false;
            this.self.channel[i].hdma_enabled = false;
            this.self.channel[i].direction = true;
            this.self.channel[i].indirect = true;
            this.self.channel[i].unused = true;
            this.self.channel[i].reverse_transfer = true;
            this.self.channel[i].fixed_transfer = true;
            this.self.channel[i].transfer_mode = 7;
            this.self.channel[i].dest_addr = 255;
            this.self.channel[i].source_addr = 65535;
            this.self.channel[i].source_bank = 255;
            this.self.channel[i].transfer_size(65535);
            this.self.channel[i].indirect_addr = 65535;
            this.self.channel[i].indirect_bank = 255;
            this.self.channel[i].hdma_addr = 255;
            this.self.channel[i].line_counter = 255;
            this.self.channel[i].unknown = 255;
            this.self.channel[i].hdma_completed = false;
            this.self.channel[i].hdma_do_transfer = false;
            ++i;
        }
    }
}

