/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.memory;

import jario.hardware.Bus8bit;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import jario.snes.memory.MMIOAccess;
import jario.snes.memory.Memory;
import jario.snes.memory.Page;
import jario.snes.memory.StaticRAM;
import jario.snes.memory.UnmappedMMIO;
import jario.snes.memory.UnmappedMemory;

public class Bus
implements Hardware,
Bus8bit,
Configurable {
    private StaticRAM wram;
    private MMIOAccess mmio;
    private UnmappedMemory memory_unmapped;
    private UnmappedMMIO mmio_unmapped;
    static Bus8bit cpu;
    private Bus8bit ppu;
    private Bus8bit cartridge;
    public Page[] page = new Page[65536];
    private byte wram_init_value;

    public Bus() {
        int i = 0;
        while (i < this.page.length) {
            this.page[i] = new Page();
            ++i;
        }
        this.wram = new StaticRAM(131072);
        this.memory_unmapped = new UnmappedMemory();
        this.mmio_unmapped = new UnmappedMMIO();
        this.mmio = new MMIOAccess(this.mmio_unmapped);
        this.map_reset();
    }

    public void connect(int port, Hardware hw) {
        switch (port) {
            case 0: {
                cpu = (Bus8bit)hw;
                break;
            }
            case 1: {
                this.ppu = (Bus8bit)hw;
                break;
            }
            case 2: {
                this.cartridge = (Bus8bit)hw;
                this.power();
            }
        }
    }

    public void reset() {
    }

    public final byte read8bit(int addr) {
        Page p = this.page[(addr &= 0xFFFFFF) >> 8];
        return p.access.read8bit(p.offset + addr);
    }

    public final void write8bit(int addr, byte data) {
        Page p = this.page[(addr &= 0xFFFFFF) >> 8];
        p.access.write8bit(p.offset + addr, data);
    }

    public Object readConfig(String key) {
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("wram init value")) {
            this.wram_init_value = (Byte)value;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int mirror(int addr, int size) {
        block3: {
            base_ = 0;
            if (size == 0) break block3;
            mask = 0x800000;
            ** GOTO lbl13
            {
                mask >>= 1;
                do {
                    if ((addr & mask) == 0) continue block0;
                    addr -= mask;
                    if (size > mask) {
                        size -= mask;
                        base_ += mask;
                    }
                    mask >>= 1;
lbl13:
                    // 2 sources

                } while (addr >= size);
            }
            base_ += addr;
        }
        return base_;
    }

    private void map(int addr, Bus8bit access, int offset) {
        Page p = this.page[addr >> 8];
        p.access = access;
        p.offset = offset - addr;
    }

    private void map(MapMode mode, int bank_lo, int bank_hi, int addr_lo, int addr_hi, Bus8bit access) {
        this.map(mode, bank_lo, bank_hi, addr_lo, addr_hi, access, 0, 0);
    }

    private void map(MapMode mode, int bank_lo, int bank_hi, int addr_lo, int addr_hi, Bus8bit access, int offset, int size) {
        assert (bank_lo <= bank_hi);
        assert (addr_lo <= addr_hi);
        int page_lo = addr_lo >> 8 & 0xFF;
        int page_hi = addr_hi >> 8 & 0xFF;
        int index = 0;
        switch (mode) {
            case Direct: {
                int bank = bank_lo;
                while (bank <= bank_hi) {
                    int page = page_lo;
                    while (page <= page_hi) {
                        this.map((bank << 16) + (page << 8), access, (bank << 16) + (page << 8));
                        ++page;
                    }
                    ++bank;
                }
                break;
            }
            case Linear: {
                int bank = bank_lo;
                while (bank <= bank_hi) {
                    int page = page_lo;
                    while (page <= page_hi) {
                        this.map((bank << 16) + (page << 8), access, this.mirror(offset + index, ((Memory)access).size()));
                        index += 256;
                        if (size != 0) {
                            index %= size;
                        }
                        ++page;
                    }
                    ++bank;
                }
                break;
            }
            case Shadow: {
                int bank = bank_lo;
                while (bank <= bank_hi) {
                    index += page_lo * 256;
                    if (size != 0) {
                        index %= size;
                    }
                    int page = page_lo;
                    while (page <= page_hi) {
                        this.map((bank << 16) + (page << 8), access, this.mirror(offset + index, ((Memory)access).size()));
                        index += 256;
                        if (size != 0) {
                            index %= size;
                        }
                        ++page;
                    }
                    index += (255 - page_hi) * 256;
                    if (size != 0) {
                        index %= size;
                    }
                    ++bank;
                }
                break;
            }
        }
    }

    private void power() {
        this.map_reset();
        this.map_xml();
        this.map_system();
        int i = 0;
        while (i < 131072) {
            this.wram.write8bit(i, this.wram_init_value);
            ++i;
        }
        i = 8448;
        while (i <= 8451) {
            this.mmio.map(i, null, this.ppu);
            ++i;
        }
        i = 8452;
        while (i <= 8454) {
            this.mmio.map(i, this.ppu, this.ppu);
            ++i;
        }
        i = 8455;
        while (i <= 8455) {
            this.mmio.map(i, null, this.ppu);
            ++i;
        }
        i = 8456;
        while (i <= 8458) {
            this.mmio.map(i, this.ppu, this.ppu);
            ++i;
        }
        i = 8459;
        while (i <= 8467) {
            this.mmio.map(i, null, this.ppu);
            ++i;
        }
        i = 8468;
        while (i <= 8470) {
            this.mmio.map(i, this.ppu, this.ppu);
            ++i;
        }
        i = 8471;
        while (i <= 8471) {
            this.mmio.map(i, null, this.ppu);
            ++i;
        }
        i = 8472;
        while (i <= 8474) {
            this.mmio.map(i, this.ppu, this.ppu);
            ++i;
        }
        i = 8475;
        while (i <= 8483) {
            this.mmio.map(i, null, this.ppu);
            ++i;
        }
        i = 8484;
        while (i <= 8486) {
            this.mmio.map(i, this.ppu, this.ppu);
            ++i;
        }
        i = 8487;
        while (i <= 8487) {
            this.mmio.map(i, null, this.ppu);
            ++i;
        }
        i = 8488;
        while (i <= 8490) {
            this.mmio.map(i, this.ppu, this.ppu);
            ++i;
        }
        i = 8491;
        while (i <= 8499) {
            this.mmio.map(i, null, this.ppu);
            ++i;
        }
        i = 8500;
        while (i <= 8511) {
            this.mmio.map(i, this.ppu, null);
            ++i;
        }
        i = 8512;
        while (i <= 8575) {
            this.mmio.map(i, cpu, cpu);
            ++i;
        }
        i = 8576;
        while (i <= 8579) {
            this.mmio.map(i, cpu, cpu);
            ++i;
        }
        i = 16406;
        while (i <= 16407) {
            this.mmio.map(i, cpu, cpu);
            ++i;
        }
        i = 16896;
        while (i <= 16927) {
            this.mmio.map(i, cpu, cpu);
            ++i;
        }
        i = 17152;
        while (i <= 17279) {
            this.mmio.map(i, cpu, cpu);
            ++i;
        }
    }

    private void map_reset() {
        this.map(MapMode.Direct, 0, 255, 0, 65535, this.memory_unmapped);
        this.map(MapMode.Direct, 0, 63, 8192, 24575, this.mmio);
        this.map(MapMode.Direct, 128, 191, 8192, 24575, this.mmio);
        int i = 8192;
        while (i <= 24575) {
            this.mmio.map(i, this.mmio_unmapped, this.mmio_unmapped);
            ++i;
        }
    }

    private void map_xml() {
        if (this.cartridge != null) {
            this.map(MapMode.Direct, 0, 63, 24576, 65535, this.cartridge);
            this.map(MapMode.Direct, 64, 125, 0, 65535, this.cartridge);
            this.map(MapMode.Direct, 128, 191, 24576, 65535, this.cartridge);
            this.map(MapMode.Direct, 192, 254, 0, 65535, this.cartridge);
            this.map(MapMode.Direct, 255, 255, 0, 65279, this.cartridge);
        }
    }

    private void map_system() {
        this.map(MapMode.Linear, 0, 63, 0, 8191, this.wram, 0, 8192);
        this.map(MapMode.Linear, 128, 191, 0, 8191, this.wram, 0, 8192);
        this.map(MapMode.Linear, 126, 127, 0, 65535, this.wram);
    }

    public static enum MapMode {
        Direct,
        Linear,
        Shadow;

    }
}

