/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.audio;

import jario.hardware.Bus32bit;
import jario.hardware.BusDMA;
import jario.hardware.Hardware;
import java.nio.ByteBuffer;

public class Audio
implements Hardware,
Bus32bit {
    private BusDMA output;
    private byte[] buffer0 = new byte[8192];
    private ByteBuffer outputBuffer = ByteBuffer.wrap(this.buffer0);
    private int bufferIndex;

    public Audio() {
        this.reset();
    }

    public void connect(int port, Hardware hw) {
        switch (port) {
            case 0: {
                this.output = (BusDMA)hw;
            }
        }
    }

    public void reset() {
        this.bufferIndex = 0;
    }

    public int read32bit(int address) {
        switch (address) {
            case 0: {
                int index = this.bufferIndex;
                this.output.writeDMA(0, this.outputBuffer, 0, index);
                this.bufferIndex = 0;
                return index;
            }
        }
        return 0;
    }

    public void write32bit(int address, int sample) {
        if (this.bufferIndex < this.buffer0.length) {
            this.buffer0[this.bufferIndex++] = (byte)(sample >> 24);
            this.buffer0[this.bufferIndex++] = (byte)(sample >> 16);
            this.buffer0[this.bufferIndex++] = (byte)(sample >> 8);
            this.buffer0[this.bufferIndex++] = (byte)(sample >> 0);
        }
    }
}

