/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.memory;

import jario.hardware.Bus8bit;
import jario.hardware.Hardware;
import jario.snes.memory.Memory;
import jario.snes.memory.UnmappedMMIO;

public class MMIOAccess
extends Memory {
    private Bus8bit[] _mmio_read = new Bus8bit[32768];
    private Bus8bit[] _mmio_write = new Bus8bit[32768];

    public MMIOAccess(UnmappedMMIO mmio_unmapped) {
        int i = 0;
        while (i < 32768) {
            this._mmio_read[i] = mmio_unmapped;
            this._mmio_write[i] = mmio_unmapped;
            ++i;
        }
    }

    public void connect(int port, Hardware hw) {
    }

    public void reset() {
    }

    public final byte read8bit(int addr) {
        return this._mmio_read[addr & Short.MAX_VALUE].read8bit(addr);
    }

    public final void write8bit(int addr, byte data) {
        this._mmio_write[addr & Short.MAX_VALUE].write8bit(addr, data);
    }

    void map(int addr, Bus8bit access_read, Bus8bit access_write) {
        if (access_read != null) {
            this._mmio_read[addr & Short.MAX_VALUE] = access_read;
        }
        if (access_write != null) {
            this._mmio_write[addr & Short.MAX_VALUE] = access_write;
        }
    }
}

