/*
 * Decompiled with CFR 0.152.
 */
package jario.snes.accessories;

import jario.hardware.BusDMA;
import jario.hardware.Configurable;
import jario.hardware.Hardware;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.swing.JFrame;

public class VideoPlayer
implements Hardware,
BusDMA,
Configurable {
    private JFrame window;
    private Graphics2D graphics;
    private BufferedImage bufferedImage;
    private int[] colorConvert = new int[65536];
    private long currentTime;
    private long previousTime;
    private int frames;

    public VideoPlayer() {
        int color = 0;
        while (color < this.colorConvert.length) {
            this.colorConvert[color] = this.convertColor(color);
            ++color;
        }
        this.bufferedImage = new BufferedImage(512, 512, 1);
        this.previousTime = this.currentTime = System.currentTimeMillis();
    }

    public void connect(int port, Hardware hw) {
    }

    public void reset() {
    }

    public void readDMA(int address, ByteBuffer data, int offset, int length) {
    }

    public void writeDMA(int address, ByteBuffer data, int offset, int length) {
        int width = length >> 16 & 0xFFFF;
        int height = length & 0xFFFF;
        int pitch = height >= 240 ? 512 : 1024;
        ShortBuffer buffer = data.asShortBuffer();
        int y = 0;
        while (y < height) {
            int a = y * pitch;
            int x = 0;
            while (x < width) {
                this.bufferedImage.setRGB(x, y, this.colorConvert[buffer.get(a + x++) & 0xFFFF]);
                this.bufferedImage.setRGB(x, y, this.colorConvert[buffer.get(a + x++) & 0xFFFF]);
                this.bufferedImage.setRGB(x, y, this.colorConvert[buffer.get(a + x++) & 0xFFFF]);
                this.bufferedImage.setRGB(x, y, this.colorConvert[buffer.get(a + x++) & 0xFFFF]);
                this.bufferedImage.setRGB(x, y, this.colorConvert[buffer.get(a + x++) & 0xFFFF]);
                this.bufferedImage.setRGB(x, y, this.colorConvert[buffer.get(a + x++) & 0xFFFF]);
                this.bufferedImage.setRGB(x, y, this.colorConvert[buffer.get(a + x++) & 0xFFFF]);
                this.bufferedImage.setRGB(x, y, this.colorConvert[buffer.get(a + x++) & 0xFFFF]);
            }
            ++y;
        }
        this.graphics.drawImage(this.bufferedImage, 0, 0, 512, 448, 0, 0, width, height, null);
        this.currentTime = System.currentTimeMillis();
        if (++this.frames % 20 == 0) {
            this.window.setTitle("FPS " + Integer.toString((int)(20000.0f / (float)(this.currentTime - this.previousTime))));
            this.previousTime = this.currentTime;
        }
    }

    public Object readConfig(String key) {
        return null;
    }

    public void writeConfig(String key, Object value) {
        if (key.equals("window")) {
            this.window = (JFrame)value;
            this.graphics = (Graphics2D)this.window.getContentPane().getComponent(0).getGraphics();
        }
    }

    private int convertColor(int color) {
        int b = (color >> 10 & 0x1F) * 8;
        int red = b + b / 35;
        b = (color >> 5 & 0x1F) * 8;
        int green = b + b / 35;
        b = (color >> 0 & 0x1F) * 8;
        int blue = b + b / 35;
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

